/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import us.lystad.fractaltop.ColorGuideEditor;
import us.lystad.fractaltop.ColorMapOwner;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTFileChooser;
import us.lystad.fractaltop.FTIO;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.Properties;
import us.lystad.fractaltop.TransferCMap;

public class TrapFrame
extends JFrame
implements TransferCMap {
    static final int bitsPerByte = 8;
    static final int indexedColors = 256;
    static int minWidth = 100;
    static int minHeight = 100;
    static int showWidth = 600;
    static int showHeight = 400;
    static String trapDirectoryName = "Traps";
    private FTCentral fTCentral_ = null;
    private TrapCanvas canvas_ = null;
    private JPanel checkPanel_ = null;
    private BufferedImage refresher_ = null;
    private String defaultTrapPathname_ = "/resources/Traps/DefaultTrapImage.gif";
    private TrapFrame self_;
    private int width_ = 0;
    private int height_ = 0;
    private double radius_ = 0.0;
    private byte[] pixels_;
    private byte[] reds_;
    private byte[] greens_;
    private byte[] blues_;
    private IndexColorModel colorModel256_ = null;
    private byte transparentPixel_ = 0;
    private boolean transparentPixelP_ = true;
    private boolean ready_ = false;
    private boolean colorsIs256p_ = true;
    private String pathname_ = null;
    private JMenuItem trans0MI_ = null;
    private JLayeredPane layeredPane_ = null;
    private byte colorMapHit_ = 0;
    private int realCenterPix_ = 0;
    private int imagCenterPix_ = 0;
    private double realCenter_ = 0.0;
    private double imagCenter_ = 0.0;
    private double rangePerPixel_ = 1.0;
    private double rotation_ = 0.0;
    private double real2real_ = 1.0;
    private double imag2real_ = 0.0;
    private double real2imag_ = 0.0;
    private double imag2imag_ = 1.0;
    private Dimension lastCanvasPadding_ = new Dimension(19, 65);
    private int realHitPix_ = 0;
    private int imagHitPix_ = 0;

    public TrapFrame(FTCentral fTCentral) {
        super("Trap Image");
        this.self_ = this;
        this.fTCentral_ = fTCentral;
        this.setLayout(new BorderLayout(0, 0));
        this.canvas_ = new TrapCanvas();
        this.canvas_.setBounds(0, 0, 140, 26);
        this.canvas_.setOpaque(false);
        this.layeredPane_ = new JLayeredPane();
        this.checkPanel_ = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                ColorGuideEditor.createCheckerboardImage(graphics, TrapFrame.this.canvas_.getWidth(), TrapFrame.this.canvas_.getHeight());
            }
        };
        this.checkPanel_.setOpaque(true);
        this.layeredPane_.add((Component)this.checkPanel_, JLayeredPane.DEFAULT_LAYER);
        this.layeredPane_.add((Component)this.canvas_, JLayeredPane.PALETTE_LAYER);
        this.add("Center", new JScrollPane(this.layeredPane_, 20, 30));
        this.addWindowListener(new MyWindowLNR());
        this.setResizable(true);
        this.reds_ = new byte[256];
        this.greens_ = new byte[256];
        this.blues_ = new byte[256];
        JMenuBar jMenuBar = new JMenuBar();
        String string = "File";
        JMenu jMenu = new JMenu(string, true);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JMenuItem jMenuItem = new JMenuItem("Open ...");
        jMenuItem.addActionListener(new trapFileLNR("TrapFrame->Open"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save As...");
        jMenuItem.addActionListener(new saveLNR("TrapFrame->Save As"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        jMenuItem.setEnabled(true);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(new closeLNR("TrapFrame->Close"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        jMenu.add(jMenuItem);
        String string2 = this.defaultTrapPathname_;
        this.refresher_ = FTIO.loadImageFromResource(string2);
        if (this.refresher_ == null) {
            this.refresher_ = this.sampleTrap();
            string2 = "sampleTrap()";
        }
        this.prepDisplayForRefresher(string2);
    }

    public boolean readyP() {
        return this.ready_;
    }

    public int width() {
        return this.width_;
    }

    public int height() {
        return this.height_;
    }

    public double radius() {
        if (this.radius_ == 0.0) {
            this.radius_ = Math.sqrt(this.width_ * this.width_ + this.height_ * this.height_) / 2.0;
        }
        return this.radius_;
    }

    public String pathname() {
        return this.pathname_;
    }

    public void setColorAtIndex(int n, Color color, boolean bl) {
        if (n < 256) {
            this.reds_[n] = (byte)color.getRed();
            this.greens_[n] = (byte)color.getGreen();
            this.blues_[n] = (byte)color.getBlue();
            if (bl) {
                this.updateColorModel();
                this.repaint();
            }
        }
    }

    public Color getColorAt(int n) {
        int n2;
        int n3;
        int n4 = this.reds_[n];
        if (n4 < 0) {
            n4 += 256;
        }
        if ((n3 = this.greens_[n]) < 0) {
            n3 += 256;
        }
        if ((n2 = this.blues_[n]) < 0) {
            n2 += 256;
        }
        return new Color(n4, n3, n2);
    }

    @Override
    public void transferColorMapTo(ColorMapOwner colorMapOwner) {
        for (int i = 0; i < this.reds_.length; ++i) {
            colorMapOwner.setIndexAndColor(i, this.getColorAt(i), i == this.reds_.length - 1);
        }
    }

    @Override
    public Color[] getColorGuide() {
        Color[] colorArray = new Color[this.reds_.length];
        for (int i = 0; i < this.reds_.length; ++i) {
            colorArray[i] = new Color(this.reds_[i], this.greens_[i], this.blues_[i]);
        }
        return colorArray;
    }

    private void updateColorModel() {
        this.colorModel256_ = new IndexColorModel(8, 256, this.reds_, this.greens_, this.blues_);
    }

    private void swapRGBs(int n, int n2) {
        byte by = this.reds_[n];
        this.reds_[n] = this.reds_[n2];
        this.reds_[n2] = by;
        by = this.greens_[n];
        this.greens_[n] = this.greens_[n2];
        this.greens_[n2] = by;
        by = this.blues_[n];
        this.blues_[n] = this.blues_[n2];
        this.blues_[n2] = by;
    }

    public void openGIFImage(String string, boolean bl, boolean bl2) {
        try {
            BufferedImage bufferedImage = this.getBufferedImage(bl);
            if (bufferedImage == null) {
                FTCentral.message("TrapFrame.openGIFImage: No action taken.", false);
                return;
            }
            this.refresher_ = bufferedImage;
            this.prepDisplayForRefresher(string);
            this.copyImageToAppData(string);
            this.setVisible(true);
        }
        catch (Throwable throwable) {
            FTCentral.message("TrapFrame.openGIFImage ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
    }

    public void setTrapImage(BufferedImage bufferedImage, String string) {
        this.refresher_ = bufferedImage;
        this.prepDisplayForRefresher(string);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepDisplayForRefresher(String string) {
        this.ready_ = false;
        this.width_ = -1;
        this.height_ = -1;
        boolean bl = false;
        InputStream inputStream = null;
        try {
            ColorModel colorModel = this.refresher_.getColorModel();
            if (colorModel == null) {
                throw new IOException("TrapFrame.prepDisplayForRefresher: ColorModel NOT FOUND: " + this.pathname_);
            }
            if (colorModel instanceof IndexColorModel) {
                this.colorModel256_ = (IndexColorModel)colorModel;
                this.fTCentral_.showTrapFrameInColorSetEditor(true);
            } else {
                this.colorModel256_ = null;
                this.fTCentral_.showTrapFrameInColorSetEditor(false);
            }
            this.width_ = this.refresher_.getWidth();
            this.height_ = this.refresher_.getHeight();
            this.radius_ = 0.0;
            Dimension dimension = this.resizeForDraw(this.width_, this.height_);
            this.setSize(dimension);
            this.layeredPane_.setPreferredSize(new Dimension(this.width_, this.height_));
            this.repaint();
            this.ready_ = true;
        }
        catch (Throwable throwable) {
            FTCentral.message("TrapFrame.prepDisplayForRefresher ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
            this.ready_ = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String getAppDirectoryPathnameFor(String string) {
        try {
            File file = Properties.getFTAppDataDirectory();
            if (!file.exists()) {
                FTCentral.message("TrapFrame.copyImageToAppData: Trap image not copied to application data directory.  Latter could not be found.", false);
                return null;
            }
            File file2 = new File(file.getCanonicalPath() + File.separator + trapDirectoryName);
            boolean bl = true;
            if (!file2.exists()) {
                bl = file2.mkdirs();
            }
            if (!file2.exists()) {
                FTCentral.message("TrapFrame.getAppDirectoryPathnameFor PROBLEM: Unable to create app data directory for storing Traps.", false);
                return null;
            }
            Path path = Paths.get(string, new String[0]);
            String string2 = path.getFileName().toString();
            return file2.getCanonicalPath() + File.separator + string2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void copyImageToAppData(String string) {
        String string2 = this.getAppDirectoryPathnameFor(string);
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                Path path = file.toPath();
                Path path2 = Paths.get(string, new String[0]);
                Files.copy(path2, path, new CopyOption[0]);
                FTCentral.message("TrapFrame.copyImageToAppData: Trap image " + string + " was copied to " + file.getCanonicalPath(), false);
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("TrapFrame.copyImageToAppData ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
    }

    private BufferedImage getBufferedImage(boolean bl) {
        FTIO fTIO = new FTIO(this);
        try {
            if (bl) {
                String string = fTIO.urlStringFromDialog(this.pathname_);
                if (string == null || !string.toLowerCase().trim().endsWith(".gif")) {
                    this.pathname_ = null;
                    FTCentral.message("No action taken.  URL is " + (this.pathname_ == null ? "null" : this.pathname_), false);
                    return null;
                }
                URL uRL = new URL(string);
                return ImageIO.read(uRL);
            }
            FTFileChooser fTFileChooser = new FTFileChooser(this);
            String string = fTFileChooser.getReadFilename("gif", true);
            if (string == null || !string.toLowerCase().trim().endsWith(".gif")) {
                this.pathname_ = null;
                FTCentral.message("No action taken.  File is " + (this.pathname_ == null ? "null" : this.pathname_), false);
                return null;
            }
            File file = new File(string);
            return ImageIO.read(file);
        }
        catch (Throwable throwable) {
            FTCentral.message("TrapFrame.getBufferedImage ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
            return null;
        }
    }

    public Dimension resizeForDraw(int n, int n2) {
        Cloneable cloneable;
        int n3 = 2;
        this.checkPanel_.setBounds(0, 0, n, n2);
        this.checkPanel_.setPreferredSize(new Dimension(n, n2));
        this.canvas_.setBounds(0, 0, n, n2);
        this.canvas_.setPreferredSize(new Dimension(n, n2));
        if (this.self_.isVisible()) {
            Point point = this.self_.getLocationOnScreen();
            Point point2 = this.canvas_.getLocationOnScreen();
            cloneable = this.self_.getInsets();
            this.lastCanvasPadding_ = new Dimension(((Insets)cloneable).right + n3 + (int)(point2.getX() - point.getX()), ((Insets)cloneable).bottom + n3 + (int)(point2.getY() - point.getY()));
        }
        int n4 = n + (int)this.lastCanvasPadding_.getWidth();
        int n5 = n2 + (int)this.lastCanvasPadding_.getHeight();
        cloneable = FTWindow.getGraphicsDeviceSizeForFrame(this.self_);
        n4 = (int)Math.round(Math.min(((Rectangle)cloneable).getWidth() - 50.0, (double)Math.max(minWidth, n4)));
        n5 = (int)Math.round(Math.min(((Rectangle)cloneable).getHeight() - 50.0, (double)Math.max(minHeight, n5)));
        Dimension dimension = new Dimension(n4, n5);
        if (this.self_.isVisible()) {
            this.self_.setSize(dimension);
        }
        this.canvas_.revalidate();
        return dimension;
    }

    public Color[] getColors() {
        Color[] colorArray = null;
        if (this.colorModel256_ != null) {
            int n = this.colorModel256_.getMapSize();
            int[] nArray = new int[n];
            colorArray = new Color[n];
            this.colorModel256_.getRGBs(nArray);
            for (int i = 0; i < n; ++i) {
                colorArray[i] = new Color(nArray[i], true);
            }
            return colorArray;
        }
        return null;
    }

    public void setColors(Color[] colorArray) {
        if (this.colorModel256_ != null) {
            int n;
            int n2 = this.colorModel256_.getMapSize();
            int n3 = colorArray.length;
            int n4 = this.colorModel256_.getTransparentPixel();
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            int n5 = Math.min(n2, n3);
            for (n = 0; n < n5; ++n) {
                byArray[n] = (byte)colorArray[n].getRed();
                byArray2[n] = (byte)colorArray[n].getGreen();
                byArray3[n] = (byte)colorArray[n].getBlue();
            }
            if (n3 < n2) {
                for (n = n3; n < n2; ++n) {
                    byArray[n] = this.reds_[n];
                    byArray2[n] = this.greens_[n];
                    byArray3[n] = this.blues_[n];
                }
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, n2, byArray, byArray2, byArray3, n4);
            BufferedImage bufferedImage = new BufferedImage(indexColorModel, this.refresher_.getRaster(), indexColorModel.isAlphaPremultiplied(), null);
            this.colorModel256_ = indexColorModel;
            this.reds_ = byArray;
            this.greens_ = byArray2;
            this.blues_ = byArray3;
            this.refresher_ = bufferedImage;
            this.repaint();
        }
    }

    private boolean writeGIF() {
        boolean bl = false;
        double d = 2.0;
        FTIO fTIO = new FTIO(this);
        Object var5_4 = null;
        String string = "";
        String string2 = fTIO.pathFromDialog(false);
        if (string2 == null || string2.length() == 0) {
            FTCentral.message("Write Trap GIF image - No action taken.", false);
            return false;
        }
        try {
            FTIO.writeImageToFile(this.refresher_, string2, "gif");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private BufferedImage sampleTrap() {
        int n = 300;
        int n2 = 300;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 13);
        byte[] byArray = new byte[]{0, 127, -1, 0};
        byte[] byArray2 = new byte[]{0, 127, 0, -1};
        byte[] byArray3 = new byte[]{0, 0, 127, -1};
        byte[] byArray4 = new byte[]{0, -1, -1, -1};
        IndexColorModel indexColorModel = new IndexColorModel(8, 4, byArray, byArray2, byArray3, 3);
        bufferedImage = new BufferedImage(n, n2, 13, indexColorModel);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(byArray[0], byArray2[0], byArray3[0], byArray4[0]));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(new Color(byArray[1], byArray2[1], byArray3[1], byArray4[1]));
        graphics2D.fillOval(10, 10, 80, 80);
        graphics2D.setColor(new Color(byArray[2] & 0xFF, byArray2[2] & 0xFF, byArray3[2] & 0xFF, 255));
        graphics2D.fillOval(30, 30, 40, 40);
        graphics2D.setColor(new Color(byArray[3] & 0xFF, byArray2[3] & 0xFF, byArray3[3] & 0xFF, 255));
        graphics2D.fillOval(45, 45, 10, 10);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setCenter(double d, double d2) {
        this.realCenter_ = d;
        this.imagCenter_ = d2;
        this.realCenterPix_ = (int)((double)this.width_ / 2.0);
        this.imagCenterPix_ = (int)((double)this.height_ / 2.0);
    }

    public boolean setRange(double d) {
        if (d != 0.0 && this.ready_ && this.width_ > 0) {
            this.rangePerPixel_ = d / (double)this.width_;
            return true;
        }
        if (d == 0.0) {
            FTCentral.message("Error setting range for trap GIF.  Given range is 0.", true);
        }
        if (!this.ready_) {
            FTCentral.message("Error setting range for trap GIF.  Trap GIF not ready.", true);
        }
        if (this.width_ <= 0) {
            FTCentral.message("Error setting range for trap GIF.  Trap GIF width is " + this.width_, true);
        }
        return false;
    }

    public void setRotation(double d) {
        this.rotation_ = d;
        if (d != 0.0) {
            double d2 = Math.PI * d / 180.0;
            this.real2real_ = Math.cos(d2);
            this.imag2real_ = -Math.sin(d2);
            this.real2imag_ = Math.sin(d2);
            this.imag2imag_ = Math.cos(d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer hitP(double d, double d2) {
        int n;
        int n2;
        int n3 = -16777216;
        if (this.rotation_ == 0.0) {
            n2 = (int)((d - this.realCenter_) / this.rangePerPixel_);
            n = (int)((this.imagCenter_ - d2) / this.rangePerPixel_);
        } else {
            double d3 = d - this.realCenter_;
            double d4 = this.imagCenter_ - d2;
            n2 = (int)((d3 * this.real2real_ + d4 * this.imag2real_) / this.rangePerPixel_);
            n = (int)((d3 * this.real2imag_ + d4 * this.imag2imag_) / this.rangePerPixel_);
        }
        int n4 = this.realCenterPix_ + n2;
        if (n4 < 0 || n4 >= this.width_) {
            return null;
        }
        int n5 = this.imagCenterPix_ + n;
        if (n5 < 0 || n5 >= this.height_) {
            return null;
        }
        try {
            int n6 = this.refresher_.getRGB(n4, n5);
            if ((n6 & n3) == 0) {
                return null;
            }
            return n6;
        }
        catch (Throwable throwable) {
            TrapFrame trapFrame = this;
            synchronized (trapFrame) {
                FTCentral.message("Cpx2TrapGIF.hitP ERROR refresher_.wd=" + this.refresher_.getWidth() + ", width_=" + this.width_ + ", refresher_.ht=" + this.refresher_.getHeight() + ", height_=" + this.height_, false);
                FTCentral.message("Cpx2TrapGIF.hitP ERROR realHitPix_=" + this.realHitPix_ + ", imagHitPix_=" + this.imagHitPix_, false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hitColorMapIndex() {
        int n = this.realHitPix_;
        int n2 = this.imagHitPix_;
        try {
            return this.refresher_.getRGB(this.realHitPix_, this.imagHitPix_);
        }
        catch (Throwable throwable) {
            TrapFrame trapFrame = this;
            synchronized (trapFrame) {
                FTCentral.message("Cpx2TrapGIF.hitColor...1 rHitPix=" + n + ", iHitPix=" + n2 + ", width=" + this.refresher_.getWidth() + ", height=" + this.refresher_.getHeight(), false);
                FTCentral.message("Cpx2TrapGIF.hitColorMapIndex2 ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
            }
            return 0;
        }
    }

    class TrapCanvas
    extends JPanel
    implements ImageObserver,
    MouseListener {
        private int width_;
        private int height_;

        TrapCanvas() {
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            graphics.drawImage(TrapFrame.this.refresher_, 0, 0, this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TrapFrame.this.colorModel256_ != null) {
                DataBufferByte dataBufferByte = (DataBufferByte)TrapFrame.this.refresher_.getRaster().getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                int n = mouseEvent.getY() * TrapFrame.this.refresher_.getWidth() + mouseEvent.getX();
                int n2 = byArray[n] & 0xFF;
                TrapFrame.this.fTCentral_.boxCountInColorMapEditor(n2);
            }
        }
    }

    class MyWindowLNR
    implements WindowListener {
        MyWindowLNR() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(true);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            TrapFrame.this.self_.setVisible(false);
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(false);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(false);
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(false);
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(true);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            TrapFrame.this.fTCentral_.setTrapFrameIsTargetP(false);
        }
    }

    class trapFileLNR
    extends DocuActionListener {
        public trapFileLNR(String string) {
            super(TrapFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            TrapFrame.this.fTCentral_.openTrapImage();
        }
    }

    class saveLNR
    extends DocuActionListener {
        public saveLNR(String string) {
            super(TrapFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            TrapFrame.this.writeGIF();
        }
    }

    class closeLNR
    extends DocuActionListener {
        public closeLNR(String string) {
            super(TrapFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            TrapFrame.this.setVisible(false);
        }
    }
}

