/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.OrbitReporter;
import us.lystad.fractaltop.OrbitXYListener;
import us.lystad.fractaltop.QtoPixelPoint;
import us.lystad.fractaltop.SeqDialog;

public class TraceOrbitDialog
extends Dialog
implements OrbitXYListener {
    private final int WIDTH = 0;
    private final int HEIGHT = 1;
    private final int START = 2;
    private final int END = 3;
    private final String saveTraceString_ = "Save orbit to:";
    private final String numFromString_ = "From Iteration";
    private final String numToString_ = "To Iteration";
    private TextField line1_pathnameText_;
    private TextField fromLoopText_;
    private TextField toLoopText_;
    private TextField pixels_right_;
    private TextField pixels_up_;
    private Button mark_image_button_;
    private Button runButton_;
    private FTWindow fTWindow_;
    private FTCentral fTCentral_;
    private int tempInt_ = 0;
    private TraceOrbitDialog self_;

    public TraceOrbitDialog(FTWindow fTWindow, FTCentral fTCentral) {
        super(fTWindow, "Save Orbit to File for Window " + fTWindow.frameNumber(), false);
        this.fTCentral_ = fTCentral;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.fTWindow_ = fTWindow;
        this.addWindowListener(new MyWindowActionListener());
        this.self_ = this;
        this.setLayout(new GridLayout(5, 1, 0, 5));
        Panel panel = new Panel();
        this.line1_pathnameText_ = new TextField();
        PathLNR pathLNR = new PathLNR();
        this.line1_pathnameText_.addTextListener(pathLNR);
        this.line1_pathnameText_.addFocusListener(pathLNR);
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        this.add(panel);
        this.add(this.line1_pathnameText_);
        this.add(panel2);
        this.add(panel3);
        this.add(panel4);
        panel.setLayout(new BorderLayout(0, 0));
        Label label = new Label("Save orbit to:", 0);
        arrayList.add(label);
        Button button = new Button("Browse...");
        button.addActionListener(new BrowseLNR());
        arrayList.add(button);
        panel.add("East", button);
        panel.add("Center", label);
        arrayList.add(this.line1_pathnameText_);
        panel2.setLayout(new GridLayout(1, 4));
        Label label2 = new Label("Pixel X");
        label2.setAlignment(1);
        panel2.add(label2);
        arrayList.add(label2);
        Label label3 = new Label("Pixel Y");
        label3.setAlignment(1);
        panel2.add(label3);
        arrayList.add(label3);
        Label label4 = new Label("From Iteration");
        label4.setAlignment(1);
        panel2.add(label4);
        arrayList.add(label4);
        Label label5 = new Label("To Iteration");
        label5.setAlignment(1);
        panel2.add(label5);
        arrayList.add(label5);
        panel3.setLayout(new GridLayout(1, 4, 2, 0));
        this.pixels_right_ = new TextField("1");
        this.pixels_right_.addTextListener(new IntWindowLNR(0));
        panel3.add(this.pixels_right_);
        arrayList.add(this.pixels_right_);
        this.pixels_up_ = new TextField("1");
        this.pixels_up_.addTextListener(new IntWindowLNR(1));
        panel3.add(this.pixels_up_);
        arrayList.add(this.pixels_up_);
        this.fromLoopText_ = new TextField("1");
        this.fromLoopText_.addTextListener(new IntWindowLNR(2));
        panel3.add(this.fromLoopText_);
        arrayList.add(this.fromLoopText_);
        this.toLoopText_ = new TextField("1");
        this.toLoopText_.addTextListener(new IntWindowLNR(3));
        panel3.add(this.toLoopText_);
        arrayList.add(this.toLoopText_);
        panel4.setLayout(new GridLayout(1, 4, 2, 0));
        this.mark_image_button_ = new Button("Mark Pixel");
        this.mark_image_button_.addActionListener(new markPtLNR());
        panel4.add(this.mark_image_button_);
        arrayList.add(this.mark_image_button_);
        Button button2 = new Button("Click pix\nfor X,Y");
        button2.addActionListener(new click4XYLNR());
        panel4.add(button2);
        arrayList.add(button2);
        Button button3 = new Button("CANCEL");
        button3.addActionListener(new CancelLNR());
        arrayList.add(button3);
        panel4.add(button3);
        this.runButton_ = new Button("Save Orbit");
        this.runButton_.addActionListener(new runLNR());
        panel4.add(this.runButton_);
        arrayList.add(this.runButton_);
        this.setSize(400, 250);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 12);
        fontSetter.setComponentFonts(arrayList);
        this.checkUserEntries_disableRun();
        this.setVisible(true);
    }

    private boolean setTempInt(String string) {
        try {
            this.tempInt_ = Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    @Override
    public void setXY(int n, int n2) {
        this.pixels_right_.setText(String.valueOf(n));
        this.pixels_up_.setText(String.valueOf(n2));
    }

    int getIntValue(TextField textField) {
        String string = textField.getText();
        try {
            return Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    boolean goodWindowValueP(TextField textField, int n) {
        FractalSpec fractalSpec = this.fTWindow_.getSpec();
        int n2 = this.getIntValue(textField);
        switch (n) {
            case 0: {
                if (0 <= n2 && n2 < fractalSpec.pix_width) {
                    return true;
                }
            }
            case 1: {
                if (0 <= n2 && n2 < fractalSpec.pix_height) {
                    return true;
                }
            }
            case 2: {
                int n3 = this.getIntValue(this.toLoopText_);
                if (0 < n2 && (n3 < 0 || n2 <= n3)) {
                    return true;
                }
            }
            case 3: {
                int n4 = this.getIntValue(this.fromLoopText_);
                if (n4 >= 0 && n4 > n2 || n2 > fractalSpec.depth) break;
                return true;
            }
        }
        FTCentral.message("TraceOrbitDialog encountered an invaled boundType: " + n, true);
        return false;
    }

    private boolean checkXY_disableMark() {
        boolean bl = true;
        boolean bl2 = true;
        FractalSpec fractalSpec = this.fTWindow_.getSpec();
        int n = this.getIntValue(this.pixels_right_);
        int n2 = this.getIntValue(this.pixels_up_);
        bl = 0 <= n && n < fractalSpec.pix_width;
        this.pixels_right_.setForeground(bl ? Color.black : Color.red);
        bl2 = 0 <= n2 && n2 < fractalSpec.pix_height;
        this.pixels_up_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        this.mark_image_button_.setEnabled(bl);
        return bl;
    }

    private void checkUserEntries_disableRun() {
        boolean bl = true;
        boolean bl2 = true;
        String string = this.line1_pathnameText_.getText();
        if (string.trim().isEmpty()) {
            bl = false;
        } else {
            try {
                File file = new File(string.trim());
                File file2 = file.getParentFile();
                bl2 = file2.exists();
                this.line1_pathnameText_.setForeground(bl2 ? Color.black : Color.red);
                bl = bl && bl2;
            }
            catch (Throwable throwable) {
                this.line1_pathnameText_.setForeground(Color.red);
                bl = false;
            }
        }
        bl2 = this.goodWindowValueP(this.fromLoopText_, 2);
        this.fromLoopText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        bl2 = this.goodWindowValueP(this.toLoopText_, 3);
        this.toLoopText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        bl = this.checkXY_disableMark() && bl;
        this.runButton_.setEnabled(bl);
    }

    class MyWindowActionListener
    extends WindowAdapter {
        MyWindowActionListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                TraceOrbitDialog.this.setVisible(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class PathLNR
    implements FocusListener,
    TextListener {
        PathLNR() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            TraceOrbitDialog.this.line1_pathnameText_.setForeground(Color.black);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            TraceOrbitDialog.this.checkUserEntries_disableRun();
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TraceOrbitDialog.this.checkUserEntries_disableRun();
        }
    }

    class BrowseLNR
    implements ActionListener {
        BrowseLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = SeqDialog.pathFromDialog(TraceOrbitDialog.this.fTWindow_);
            if (object != null) {
                if (!((String)object).toLowerCase().endsWith(".text") && !((String)object).toLowerCase().endsWith(".txt")) {
                    object = (String)object + ".text";
                }
                TraceOrbitDialog.this.line1_pathnameText_.setText((String)object);
            }
        }
    }

    class IntWindowLNR
    implements TextListener {
        private int boundType_;

        public IntWindowLNR(int n) {
            this.boundType_ = n;
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TraceOrbitDialog.this.checkUserEntries_disableRun();
        }
    }

    class markPtLNR
    implements ActionListener {
        markPtLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TraceOrbitDialog.this.goodWindowValueP(TraceOrbitDialog.this.pixels_right_, 0)) {
                FTCentral cfr_ignored_0 = TraceOrbitDialog.this.fTCentral_;
                FTCentral.message("X value is not a valid number.", true);
                return;
            }
            if (!TraceOrbitDialog.this.goodWindowValueP(TraceOrbitDialog.this.pixels_up_, 1)) {
                FTCentral cfr_ignored_1 = TraceOrbitDialog.this.fTCentral_;
                FTCentral.message("Y value is not a valid number.", true);
                return;
            }
            int n = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.pixels_right_);
            int n2 = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.pixels_up_);
            int n3 = TraceOrbitDialog.this.fTWindow_.getSpec().pix_height - 1 - n2;
            TraceOrbitDialog.this.fTWindow_.canvas().drawCrossFlag(n, n3);
        }
    }

    class click4XYLNR
    implements ActionListener {
        click4XYLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TraceOrbitDialog.this.fTWindow_.canvas().addOrbitXYListener(TraceOrbitDialog.this.self_);
        }
    }

    class CancelLNR
    implements ActionListener {
        CancelLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TraceOrbitDialog.this.setVisible(false);
        }
    }

    class runLNR
    implements ActionListener {
        runLNR() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TraceOrbitDialog.this.self_.setVisible(false);
            FractalSpec fractalSpec = TraceOrbitDialog.this.fTWindow_.getSpec();
            TraceOrbitDialog.this.runButton_.setEnabled(false);
            try {
                FTLooper fTLooper = TraceOrbitDialog.this.fTCentral_.findLoopObject(fractalSpec.which);
                if (fTLooper == null || !fTLooper.traceOrbit_p()) {
                    FTCentral cfr_ignored_0 = TraceOrbitDialog.this.fTCentral_;
                    FTCentral.message("Looper does not support traceOrbit operation.", true);
                    return;
                }
                String string = TraceOrbitDialog.this.line1_pathnameText_.getText();
                int n = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.fromLoopText_);
                int n2 = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.toLoopText_);
                int n3 = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.pixels_right_);
                int n4 = TraceOrbitDialog.this.getIntValue(TraceOrbitDialog.this.pixels_up_);
                int n5 = fractalSpec.depth;
                int n6 = fractalSpec.pix_height - 1 - n4;
                QtoPixelPoint qtoPixelPoint = new QtoPixelPoint(fractalSpec);
                BigQuaternion bigQuaternion = qtoPixelPoint.getQuaternion(n3, n6);
                BigQuaternion bigQuaternion2 = new BigQuaternion(fractalSpec.coeff);
                BigQuaternion bigQuaternion3 = new BigQuaternion(fractalSpec.trans);
                WriteOrbitReporter writeOrbitReporter = new WriteOrbitReporter(string, n, n2, fractalSpec);
                fTLooper.traceOrbit(bigQuaternion, bigQuaternion2, bigQuaternion3, n5, writeOrbitReporter);
            }
            finally {
                TraceOrbitDialog.this.runButton_.setEnabled(true);
            }
        }
    }

    public class WriteOrbitReporter
    implements OrbitReporter {
        private PrintWriter out_ = null;
        private boolean functionalP_ = false;
        private int fromIter_ = 0;
        private int toIter_ = 0;
        private FractalSpec spec_ = null;

        public WriteOrbitReporter(String string, int n, int n2, FractalSpec fractalSpec) {
            try {
                this.fromIter_ = n;
                this.toIter_ = n2;
                this.spec_ = fractalSpec;
                File file = new File(string);
                this.out_ = new PrintWriter(file);
                this.out_.write("FractalTopOrbit v5.0.6\n");
                this.functionalP_ = true;
            }
            catch (Throwable throwable) {
                FTCentral cfr_ignored_0 = TraceOrbitDialog.this.fTCentral_;
                FTCentral.message("Error creating TraceOrbitDialog$WriteOrbitReporter: " + throwable.getMessage(), true);
            }
        }

        @Override
        public void alert(String string) {
            FTCentral cfr_ignored_0 = TraceOrbitDialog.this.fTCentral_;
            FTCentral.message(string, true);
        }

        @Override
        public void metaData(String string, String string2) {
            if (string.equals("LoopName")) {
                this.out_.write(this.spec_.toString(0, string2 + ".traceOrbit") + "\n");
            } else {
                this.out_.write(string + ": " + string2 + "\n");
            }
        }

        @Override
        public boolean data(int n, BigQuaternion bigQuaternion) {
            if (n == 0 || this.fromIter_ <= n && n <= this.toIter_) {
                this.out_.write("Iteration " + n + ": " + bigQuaternion.toString() + "\n");
            }
            return true;
        }

        @Override
        public void finish(int n) {
            TraceOrbitDialog.this.self_.fTWindow_.canvas().liveTraceEnded();
            this.out_.write("Finished after " + n + " iterations.");
            this.out_.flush();
            this.out_.close();
        }

        @Override
        public void stop() {
            throw new RuntimeException("User stopped");
        }
    }
}

