/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.util.ArrayList;
import java.util.Hashtable;

public class ThumbNailProducer {
    public static final int size = 20;
    private ArrayList<ImageConsumer> consumers_ = new ArrayList();
    private boolean hasPixels_p_ = false;
    private boolean ready_p_ = false;
    private byte[] pixels_;
    private ColorModel colorModel_ = null;
    private Hashtable properties_ = new Hashtable();

    public ThumbNailProducer() {
        this.pixels_ = new byte[400];
    }

    protected void produce(ImageConsumer imageConsumer) {
        if (!this.ready_p_) {
            System.err.println("ThumbNailProducer.produce but not ready.");
            imageConsumer.imageComplete(1);
            return;
        }
        imageConsumer.setDimensions(20, 20);
        imageConsumer.setProperties(this.properties_);
        imageConsumer.setColorModel(this.colorModel_);
        imageConsumer.setHints(24);
        imageConsumer.setPixels(0, 0, 20, 20, this.colorModel_, this.pixels_, 0, 20);
        imageConsumer.imageComplete(3);
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer != null) {
            this.addConsumer(imageConsumer);
            if (!this.ready_p_) {
                System.err.println("ThumbNailProducer.startProduction but not ready.");
                return;
            }
            if (this.consumers_.size() == 0) {
                return;
            }
            for (int i = this.consumers_.size(); i > 0; --i) {
                if (i - 1 >= this.consumers_.size()) continue;
                imageConsumer = this.consumers_.get(i - 1);
                this.produce(imageConsumer);
                this.consumers_.remove(imageConsumer);
            }
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        if (this.ready_p_) {
            imageConsumer.setDimensions(20, 20);
            imageConsumer.setProperties(this.properties_);
            imageConsumer.setColorModel(this.colorModel_);
            imageConsumer.setHints(26);
            imageConsumer.setPixels(0, 0, 20, 20, this.colorModel_, this.pixels_, 0, 20);
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.hasPixels_p_) {
            this.produce(imageConsumer);
        } else if (!this.consumers_.contains(imageConsumer)) {
            this.consumers_.add(imageConsumer);
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers_.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers_.remove(imageConsumer);
    }
}

