/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.Fraction;

public class SeqSpec {
    public static final int ZOOM = 0;
    public static final int PIVOT = 1;
    public static final int SHIFT = 2;
    public static final int NON_BLACKS = 254;
    public int choice = 0;
    public int whichShift = 0;
    public boolean enabled_p = false;
    public boolean pause_p = false;
    public boolean advancePanelsBackwards_p = false;
    public boolean advanceRowByRow_p = true;
    public String destination = "";
    public int frames = 1;
    public double degrees = 180.0;
    public double hShift = 0.0;
    public double vShift = 0.0;
    public double wShift = 0.0;
    private int frameNumber_ = 0;
    private int jumpToFrameNumber_ = -1;
    private boolean horiz_p_ = false;
    private int startWindowNumber_ = 1;
    private int endWindowNumber_ = 2;
    private FractalSpec startSpec_ = null;
    private FractalSpec endSpec_ = null;
    private boolean useGIF_p_ = false;
    private boolean useFTR_p_ = false;

    public SeqSpec() {
    }

    public SeqSpec(SeqSpec seqSpec, boolean bl, boolean bl2) {
        this.assignFrom(seqSpec, bl, bl2);
    }

    public void assignFrom(SeqSpec seqSpec, boolean bl, boolean bl2) {
        this.choice = seqSpec.choice;
        this.whichShift = seqSpec.whichShift;
        this.enabled_p = seqSpec.enabled_p;
        this.pause_p = seqSpec.pause_p;
        this.destination = seqSpec.destination;
        this.frames = seqSpec.frames;
        this.degrees = seqSpec.degrees;
        this.hShift = seqSpec.hShift;
        this.vShift = seqSpec.vShift;
        this.wShift = seqSpec.wShift;
        this.horiz_p_ = seqSpec.horiz_p_;
        this.frameNumber_ = seqSpec.frameNumber_;
        this.useGIF_p_ = seqSpec.useGIF_p_;
        this.useFTR_p_ = seqSpec.useFTR_p_;
        if (bl) {
            this.setStartSpec(seqSpec.startSpec());
            this.startWindowNumber_ = seqSpec.startWindowNumber_;
        }
        if (bl2) {
            this.setEndSpec(seqSpec.endSpec());
            this.endWindowNumber_ = seqSpec.endWindowNumber_;
        }
    }

    public boolean horizontalPivotP() {
        return this.horiz_p_;
    }

    public void setHorizontalPivotP(boolean bl) {
        this.horiz_p_ = bl;
    }

    public int startWindowNumber() {
        return this.startWindowNumber_;
    }

    public int endWindowNumber() {
        return this.endWindowNumber_;
    }

    public void setStartWindowNumber(int n) {
        this.startWindowNumber_ = n;
    }

    public void setEndWindowNumber(int n) {
        this.endWindowNumber_ = n;
    }

    public FractalSpec startSpec() {
        return this.startSpec_;
    }

    public FractalSpec endSpec() {
        return this.endSpec_;
    }

    public void setUseGIF_p(boolean bl) {
        this.useGIF_p_ = bl;
    }

    public void setUseFTR_p(boolean bl) {
        this.useFTR_p_ = bl;
    }

    public void setStartSpec(FractalSpec fractalSpec) {
        if (fractalSpec == null) {
            this.startSpec_ = null;
            return;
        }
        if (this.startSpec_ == null) {
            this.startSpec_ = new FractalSpec();
        }
        this.startSpec_.assignFrom(fractalSpec);
    }

    public void setEndSpec(FractalSpec fractalSpec) {
        if (fractalSpec == null) {
            this.endSpec_ = null;
            return;
        }
        if (this.endSpec_ == null) {
            this.endSpec_ = new FractalSpec();
        }
        this.endSpec_.assignFrom(fractalSpec);
    }

    public boolean readyP(boolean bl) {
        if (!this.pause_p && this.destination != null && this.destination.length() < 2) {
            if (bl) {
                FTCentral.message("SeqSpec.readyP: Need to specify destination pathname.", false);
            }
            return false;
        }
        if (!this.enabled_p) {
            if (bl) {
                FTCentral.message("Sequence is not initialized.", false);
            }
            return false;
        }
        if (this.startSpec_ == null) {
            if (bl) {
                FTCentral.message("First frame is not initialized.", false);
            }
            return false;
        }
        if (this.frames <= 1 && this.startSpec_.panels <= 1) {
            if (bl) {
                FTCentral.message("One sequence frame and one panel is not a sequence.", false);
            }
            return false;
        }
        if (this.frames == 1) {
            return true;
        }
        if (this.choice == 0) {
            if (this.endSpec_ == null && bl) {
                FTCentral.message("No final frame chosen for ZOOM sequence.", false);
            }
            return this.endSpec_ != null;
        }
        if (this.choice == 1) {
            if (this.degrees == 0.0 && bl) {
                FTCentral.message("Total degrees of PIVOT = 0, so no sequence.", false);
            }
            return this.degrees != 0.0;
        }
        if (this.choice == 2) {
            boolean bl2;
            boolean bl3 = bl2 = this.hShift == 0.0 && this.vShift == 0.0 && this.wShift == 0.0;
            if (bl2 && bl) {
                FTCentral.message("Total SHIFT = 0, so no sequence.", false);
            }
            return !bl2;
        }
        if (bl) {
            FTCentral.message("Internal error in sequence type choice.", false);
        }
        return false;
    }

    public void setFrameNumber(int n) {
        this.frameNumber_ = n;
    }

    public int getFrameNumber() {
        return this.frameNumber_;
    }

    public boolean destinationURLP() {
        String string = this.destination.toLowerCase();
        return string.startsWith("http://") || string.startsWith("ftp://") || string.startsWith("file://");
    }

    private String ZeroPaddedIntString(int n, int n2) {
        int n3 = (int)Math.ceil(Math.log10(n2 + 1));
        String string = "%0" + n3 + "d";
        return String.format(string, n);
    }

    public String pathname(FractalSpec fractalSpec) {
        StringBuffer stringBuffer = new StringBuffer(8);
        if (!this.destination.endsWith("-") && !this.destination.endsWith("_")) {
            stringBuffer.append("-");
        }
        if (this.frames > 1) {
            if (this.choice == 0) {
                stringBuffer.append("z");
            } else if (this.choice == 1) {
                stringBuffer.append("p");
            } else if (this.choice == 2) {
                stringBuffer.append("s");
            }
            stringBuffer.append(this.ZeroPaddedIntString(this.frameNumber_, this.frames - 1));
            if (fractalSpec.panels > 1) {
                stringBuffer.append("-");
            }
        }
        if (fractalSpec.panels > 1) {
            stringBuffer.append("y");
            stringBuffer.append(this.ZeroPaddedIntString(fractalSpec.panel_y, fractalSpec.panels - 1));
            stringBuffer.append("-x");
            stringBuffer.append(this.ZeroPaddedIntString(fractalSpec.panel_x, fractalSpec.panels - 1));
        }
        if (this.useGIF_p_) {
            stringBuffer.append(".gif");
        } else if (this.useFTR_p_) {
            stringBuffer.append(".ftr");
        } else {
            stringBuffer.append(".png");
        }
        return this.destination + stringBuffer.toString();
    }

    public boolean advance(FractalSpec fractalSpec, int n) {
        boolean bl = false;
        if (this.startSpec_.panels <= 1 && !this.enabled_p) {
            if (bl) {
                System.out.println("SeqSpec.advance exit 1f");
            }
            return false;
        }
        if (this.advanceThePanel(fractalSpec)) {
            if (bl) {
                System.out.println("SeqSpec.advance exit 2t");
            }
            return true;
        }
        this.frameNumber_ = n;
        if (this.frameNumber_ >= this.frames) {
            if (bl) {
                System.out.println("SeqSpec.advance exit 3f");
            }
            this.enabled_p = false;
            return false;
        }
        if (this.choice == 0 && this.endSpec_ != null) {
            if (this.endSpec_ != null) {
                if (bl) {
                    System.out.println("SeqSpec.advance exit 4");
                }
                return this.advanceTheZoom(fractalSpec);
            }
            System.err.println("No final frame given for zoom sequence.");
            return false;
        }
        if (this.choice == 1) {
            if (this.degrees != 0.0) {
                if (bl) {
                    System.out.println("SeqSpec.advance exit 5");
                }
                return this.advanceThePivot(fractalSpec);
            }
            System.err.println("Zero degrees given for pivot, stopping.");
            return false;
        }
        if (this.choice == 2) {
            boolean bl2;
            boolean bl3 = bl2 = this.hShift == 0.0 && this.vShift == 0.0 && this.wShift == 0.0;
            if (!bl2) {
                if (bl) {
                    System.out.println("SeqSpec.advance exit 6");
                }
                return this.advanceTheShift(fractalSpec);
            }
            System.err.println("Zero shift given for sequence, stopping.");
            return false;
        }
        FTCentral.message("Internal error in SeqSpec.advance: choice = " + this.choice, true);
        return false;
    }

    public boolean manualStep(FractalSpec fractalSpec, int n) {
        if (!(this.startSpec_ != null && this.startSpec_.panels > 1 || this.enabled_p)) {
            return false;
        }
        this.frameNumber_ = n;
        fractalSpec.assignFrom(this.startSpec_);
        if (this.choice == 0) {
            if (this.endSpec_ != null) {
                return this.advanceTheZoom(fractalSpec);
            }
            System.err.println("No final frame given for zoom sequence.");
            return false;
        }
        if (this.choice == 1) {
            if (this.degrees != 0.0) {
                return this.advanceThePivot(fractalSpec);
            }
            System.err.println("Zero degrees given for pivot, stopping sequence.");
            return false;
        }
        if (this.choice == 2) {
            boolean bl;
            boolean bl2 = bl = this.hShift == 0.0 && this.vShift == 0.0 && this.wShift == 0.0;
            if (!bl) {
                return this.advanceTheShift(fractalSpec);
            }
            System.err.println("Zero increment given for shift, stopping sequence.");
            return false;
        }
        FTCentral.message("Internal error in SeqSpec.advance: choice = " + this.choice, true);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean advanceThePanel(FractalSpec fractalSpec) {
        block17: {
            block18: {
                if (this.startSpec_ == null || this.startSpec_.panels <= 1) {
                    return false;
                }
                if (!this.advanceRowByRow_p) break block18;
                if (this.advancePanelsBackwards_p) {
                    if (fractalSpec.panel_x > 0) {
                        --fractalSpec.panel_x;
                        break block17;
                    } else {
                        if (fractalSpec.panel_y <= 0) {
                            fractalSpec.panel_y = this.startSpec_.panels - 1;
                            fractalSpec.panel_x = this.startSpec_.panels - 1;
                            return false;
                        }
                        --fractalSpec.panel_y;
                        fractalSpec.panel_x = this.startSpec_.panels - 1;
                    }
                    break block17;
                } else if (fractalSpec.panel_x < this.startSpec_.panels - 1) {
                    ++fractalSpec.panel_x;
                    break block17;
                } else {
                    if (fractalSpec.panel_y >= this.startSpec_.panels - 1) {
                        fractalSpec.panel_y = 0;
                        fractalSpec.panel_x = 0;
                        return false;
                    }
                    ++fractalSpec.panel_y;
                    fractalSpec.panel_x = 0;
                }
                break block17;
            }
            if (this.advancePanelsBackwards_p) {
                if (fractalSpec.panel_y > 0) {
                    --fractalSpec.panel_y;
                } else {
                    if (fractalSpec.panel_x <= 0) {
                        fractalSpec.panel_x = this.startSpec_.panels - 1;
                        fractalSpec.panel_y = this.startSpec_.panels - 1;
                        return false;
                    }
                    --fractalSpec.panel_x;
                    fractalSpec.panel_y = this.startSpec_.panels - 1;
                }
            } else if (fractalSpec.panel_y < this.startSpec_.panels - 1) {
                ++fractalSpec.panel_y;
            } else {
                if (fractalSpec.panel_x >= this.startSpec_.panels - 1) {
                    fractalSpec.panel_x = 0;
                    fractalSpec.panel_y = 0;
                    return false;
                }
                ++fractalSpec.panel_x;
                fractalSpec.panel_y = 0;
            }
        }
        FTCentral.message("Beginning panel: vert = " + fractalSpec.panel_y + " horiz = " + fractalSpec.panel_x, false);
        return true;
    }

    private boolean advanceTheZoom(FractalSpec fractalSpec) {
        BigQuaternion bigQuaternion;
        BigQuaternion bigQuaternion2;
        BigQuaternion bigQuaternion3;
        if (this.pause_p) {
            FTCentral.message("Starting frame " + this.frameNumber_ + " of " + this.frames + " complete.", false);
        } else {
            FTCentral.message("Starting frame " + this.frameNumber_ + " of " + this.frames, false);
        }
        boolean bl = false;
        if (this.startSpec_ == null) {
            bl = true;
            FTCentral.message("Sequence start frame has been lost.", true);
        }
        if (this.endSpec_ == null) {
            bl = true;
            FTCentral.message("Sequence end frame has been lost.", true);
        }
        if (bl) {
            this.enabled_p = false;
            return false;
        }
        boolean bl2 = this.startSpec_.range > this.endSpec_.range;
        long l = bl2 ? (long)this.frameNumber_ : (long)(this.frames - 1 - this.frameNumber_);
        FractalSpec fractalSpec2 = bl2 ? this.startSpec_ : this.endSpec_;
        FractalSpec fractalSpec3 = bl2 ? this.endSpec_ : this.startSpec_;
        double d = (double)l / (double)(this.frames - 1);
        if (this.startSpec_.rangeOver != 0) {
            fractalSpec.center.assign_from(fractalSpec2.center.plus(fractalSpec3.center.minus(fractalSpec2.center).times_scalar(d)));
        }
        if (this.startSpec_.rangeOver != 1) {
            fractalSpec.coeff.assign_from(fractalSpec2.coeff.plus(fractalSpec3.coeff.minus(fractalSpec2.coeff).times_scalar(d)));
        }
        if (this.startSpec_.rangeOver != 2) {
            fractalSpec.trans.assign_from(fractalSpec2.trans.plus(fractalSpec3.trans.minus(fractalSpec2.trans).times_scalar(d)));
        }
        fractalSpec.depth = (int)((double)this.startSpec_.depth + d * (double)(fractalSpec3.depth - fractalSpec2.depth));
        fractalSpec.loops_per_color = ((double)l * fractalSpec2.loops_per_color + ((double)this.frames - 1.0 - (double)l) * fractalSpec3.loops_per_color) / (double)(this.frames - 1);
        double d2 = Math.acos(fractalSpec2.vx.r);
        double d3 = d2 + d * (Math.acos(fractalSpec3.vx.r) - d2);
        fractalSpec.vx.r = Math.cos(d3);
        if (fractalSpec.vx.r == 0.0) {
            fractalSpec.vx.r = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vx.i);
        fractalSpec.vx.i = Math.cos(d2 + d * (Math.acos(fractalSpec3.vx.i) - d2));
        if (fractalSpec.vx.i == 0.0) {
            fractalSpec.vx.i = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vx.j);
        fractalSpec.vx.j = Math.cos(d2 + d * (Math.acos(fractalSpec3.vx.j) - d2));
        if (fractalSpec.vx.j == 0.0) {
            fractalSpec.vx.j = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vx.k);
        fractalSpec.vx.k = Math.cos(d2 + d * (Math.acos(fractalSpec3.vx.k) - d2));
        if (fractalSpec.vx.k == 0.0) {
            fractalSpec.vx.k = 0.0;
        }
        fractalSpec.vx.normalize_n();
        d2 = Math.acos(fractalSpec2.vy.r);
        fractalSpec.vy.r = Math.cos(d2 + d * (Math.acos(fractalSpec3.vy.r) - d2));
        if (fractalSpec.vy.r == 0.0) {
            fractalSpec.vy.r = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vy.i);
        fractalSpec.vy.i = Math.cos(d2 + d * (Math.acos(fractalSpec3.vy.i) - d2));
        if (fractalSpec.vy.i == 0.0) {
            fractalSpec.vy.i = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vy.j);
        fractalSpec.vy.j = Math.cos(d2 + d * (Math.acos(fractalSpec3.vy.j) - d2));
        if (fractalSpec.vy.j == 0.0) {
            fractalSpec.vy.j = 0.0;
        }
        d2 = Math.acos(fractalSpec2.vy.k);
        fractalSpec.vy.k = Math.cos(d2 + d * (Math.acos(fractalSpec3.vy.k) - d2));
        if (fractalSpec.vy.k == 0.0) {
            fractalSpec.vy.k = 0.0;
        }
        fractalSpec.vy.normalize_n();
        double d4 = Math.log(fractalSpec3.range / fractalSpec2.range);
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 1; i < this.frames; ++i) {
            d5 += Math.pow(Math.E, d4 * (double)i / (double)(this.frames - 1));
            if ((long)i != l) continue;
            d6 = d5;
        }
        double d7 = 1.0 / d5;
        double d8 = d6 * d7;
        double d9 = Math.sin(d8 * Math.PI / 2.0);
        Fraction fraction = new Fraction(d9);
        Fraction fraction2 = new Fraction(1.0).subtract(fraction);
        double d10 = Math.pow(Math.E, d4 * (double)l / (double)(this.frames - 1));
        fractalSpec.range = fractalSpec2.range * d10;
        if (fractalSpec2.rangeOver == 1) {
            bigQuaternion3 = fractalSpec.coeff;
            bigQuaternion2 = fractalSpec2.coeff;
            bigQuaternion = fractalSpec3.coeff;
        } else if (fractalSpec2.rangeOver == 2) {
            bigQuaternion3 = fractalSpec.trans;
            bigQuaternion2 = fractalSpec2.trans;
            bigQuaternion = fractalSpec3.trans;
        } else {
            bigQuaternion3 = fractalSpec.center;
            bigQuaternion2 = fractalSpec2.center;
            bigQuaternion = fractalSpec3.center;
        }
        bigQuaternion3.assign_from(bigQuaternion2.times_scalar(fraction2).plus(bigQuaternion.times_scalar(fraction)));
        return true;
    }

    private boolean advanceThePivot(FractalSpec fractalSpec) {
        FastQuaternion fastQuaternion = !this.horiz_p_ ? this.startSpec_.vx : this.startSpec_.vy;
        FastQuaternion fastQuaternion2 = this.startSpec_.vz;
        if (this.pause_p) {
            FTCentral.message("Frame " + this.frameNumber_ + " of " + this.frames + " complete.", false);
        } else {
            FTCentral.message("Starting frame " + this.frameNumber_ + " of " + this.frames, false);
        }
        double d = (double)this.frameNumber_ * this.degrees / (double)this.frames;
        if (!this.horiz_p_) {
            fractalSpec.vx.assign_from(FastQuaternion.rotate(d, fastQuaternion, fastQuaternion2));
        } else {
            fractalSpec.vy.assign_from(FastQuaternion.rotate(d, fastQuaternion, fastQuaternion2));
        }
        return true;
    }

    private boolean advanceTheShift(FractalSpec fractalSpec) {
        BigQuaternion bigQuaternion = this.startSpec_.vx.times_scalar((double)this.frameNumber_ * this.hShift).plus(this.startSpec_.vy.times_scalar((double)this.frameNumber_ * this.vShift)).plus(this.startSpec_.vz.times_scalar((double)this.frameNumber_ * this.wShift)).bigQuaternionValue();
        if (this.pause_p) {
            FTCentral.message("Frame " + this.frameNumber_ + " of " + this.frames + " complete.", false);
        } else {
            FTCentral.message("Starting frame " + this.frameNumber_ + " of " + this.frames, false);
        }
        if (this.whichShift == 1) {
            fractalSpec.coeff.assign_from(this.startSpec_.coeff.plus(bigQuaternion));
        } else if (this.whichShift == 2) {
            fractalSpec.trans.assign_from(this.startSpec_.trans.plus(bigQuaternion));
        } else {
            fractalSpec.center.assign_from(this.startSpec_.center.plus(bigQuaternion));
        }
        return true;
    }
}

