/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.SeqSpec;

public class SeqDialog
extends Dialog {
    private final String saveImageString_ = "save image and continue. ";
    private final String pauseSeqString_ = "pause for screen capture.";
    private final String zoomString_ = "Zoom";
    private final String pivotString_ = "Pivot";
    private final String shiftString_ = "Shift";
    private final String shiftStringQ1_ = "Shift Q1";
    private final String shiftStringQ2_ = "Shift Q2";
    private final String shiftStringQ3_ = "Shift Q3";
    private final String numFramesString_ = "No. of Frames";
    private final String firstFrameString_ = "Start at Frame";
    private final String startWindowString_ = "Start Window #";
    private final String endWindowString_ = "End Window #";
    private final String degreesString_ = "Degrees";
    private final String axisString_ = "Axis";
    private final String incrementHString_ = "Horiz. Increment";
    private final String incrementVString_ = "Vert. Increment";
    private final String incrementWString_ = "W Increment";
    private final String blankString_ = "";
    private final String pivotHString_ = "Pivot -";
    private final String pivotVString_ = "Pivot |";
    private final String FORMATgIF = "GIF when poss.";
    private final String FORMATfTR = "save as FTR";
    private final String FORMATpNG = "save as PNG";
    private TextField pathnameText_;
    private TextField framesText_;
    private TextField firstFrameText_;
    private TextField startWindowText_;
    private TextField endWindowText_;
    private TextField degreesText_;
    private TextField shiftAmtHText_;
    private TextField shiftAmtVText_;
    private TextField shiftAmtWText_;
    private Choice savePauseButton_;
    private Choice choiceDropDown_ = null;
    private Label variableLabel_1_;
    private Label variableLabel_2_;
    private Label variableLabel_3_;
    private CardLayout cardLayout2_;
    private Panel labelButtonSwap_;
    private Button axisButton_;
    private Button setNextFrame_;
    private JCheckBox gifOKp_;
    private JComboBox<String> formatSelector_;
    private FTCentral fTCentral_;
    private SeqSpec spec_;
    private FTWindow fTWindow_;
    private int tempInt_;
    private float tempFloat_;
    private boolean saveAsGIFWhenPossibleP_ = true;
    private boolean saveAsFTR_ = false;

    public SeqDialog(String string, FTWindow fTWindow, SeqSpec seqSpec, FTCentral fTCentral) {
        super(fTWindow, string, true);
        this.fTCentral_ = fTCentral;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.spec_ = new SeqSpec(seqSpec, true, true);
        this.spec_.setStartWindowNumber(fTWindow.frameNumber());
        this.spec_.setEndWindowNumber(fTWindow.frameNumber());
        this.fTWindow_ = fTWindow;
        this.spec_.enabled_p = true;
        this.addWindowListener(new MyWindowListener(this));
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.add((Component)panel, "North");
        this.add((Component)panel2, "Center");
        panel.setLayout(new GridLayout(3, 1, 0, 5));
        Panel panel3 = new Panel();
        panel.add(panel3);
        panel3.setLayout(new BorderLayout(0, 0));
        this.savePauseButton_ = new Choice();
        this.savePauseButton_.add("save image and continue. ");
        this.savePauseButton_.add("pause for screen capture.");
        this.savePauseButton_.select(0);
        this.savePauseButton_.addItemListener(new PauseLNR());
        arrayList.add(this.savePauseButton_);
        panel3.add("East", this.savePauseButton_);
        Label label = new Label("After each drawing ", 2);
        label.addMouseListener(new DocuMouseListener("After each drawing "));
        panel3.add("Center", label);
        this.formatSelector_ = new JComboBox<String>(new String[]{"GIF when poss.", "save as PNG", "save as FTR"});
        this.formatSelector_.addMouseListener(new DocuMouseListener("Sequence Format Selection"));
        panel3.add("West", this.formatSelector_);
        arrayList.add(label);
        Panel panel4 = new Panel();
        panel.add(panel4);
        panel4.setLayout(new BorderLayout(0, 0));
        Label label2 = new Label("Folder/prefix for save", 0);
        label2.addMouseListener(new DocuMouseListener("Folder/prefix for save"));
        arrayList.add(label2);
        Button button = new Button("Browse...");
        button.addActionListener(new BrowseLNR("Browse..."));
        arrayList.add(button);
        panel4.add("East", button);
        panel4.add("Center", label2);
        this.pathnameText_ = new TextField();
        panel.add(this.pathnameText_);
        arrayList.add(this.pathnameText_);
        panel2.setLayout(new GridLayout(5, 1, 0, 5));
        Panel panel5 = new Panel();
        panel2.add(panel5);
        panel5.setLayout(new GridLayout(1, 3, 5, 0));
        Label label3 = new Label("Choose", 1);
        label3.addMouseListener(new DocuMouseListener("Choose"));
        Label label4 = new Label("No. of Frames", 1);
        label4.addMouseListener(new DocuMouseListener("No. of Frames"));
        Label label5 = new Label("Start at Frame", 1);
        label5.addMouseListener(new DocuMouseListener("Start at Frame"));
        panel5.add(label3);
        panel5.add(label4);
        panel5.add(label5);
        arrayList.add(label3);
        arrayList.add(label4);
        arrayList.add(label5);
        Panel panel6 = new Panel();
        panel2.add(panel6);
        panel6.setLayout(new GridLayout(1, 3, 5, 0));
        this.choiceDropDown_ = new Choice();
        this.choiceDropDown_.add("Zoom");
        this.choiceDropDown_.add("Pivot");
        this.choiceDropDown_.add("Shift Q1");
        this.choiceDropDown_.add("Shift Q2");
        this.choiceDropDown_.add("Shift Q3");
        this.choiceDropDown_.select(0);
        panel6.add(this.choiceDropDown_);
        arrayList.add(this.choiceDropDown_);
        this.choiceDropDown_.addItemListener(new ChoiceLNR());
        this.framesText_ = new TextField();
        this.framesText_.addTextListener(new framesLNR());
        panel6.add(this.framesText_);
        this.firstFrameText_ = new TextField(String.valueOf(this.spec_.getFrameNumber()));
        this.firstFrameText_.addTextListener(new firstFrameLNR());
        panel6.add(this.firstFrameText_);
        arrayList.add(this.framesText_);
        arrayList.add(this.firstFrameText_);
        Panel panel7 = new Panel();
        panel2.add(panel7);
        panel7.setLayout(new GridLayout(1, 3, 5, 0));
        this.variableLabel_1_ = new Label("Start Window #", 1);
        this.variableLabel_2_ = new Label("End Window #", 1);
        this.variableLabel_3_ = new Label("", 1);
        this.variableLabel_1_.addMouseListener(new DocuVariedMouseListener(0));
        this.variableLabel_2_.addMouseListener(new DocuVariedMouseListener(1));
        this.variableLabel_3_.addMouseListener(new DocuVariedMouseListener(2));
        panel7.add(this.variableLabel_1_);
        panel7.add(this.variableLabel_2_);
        panel7.add(this.variableLabel_3_);
        arrayList.add(this.variableLabel_1_);
        arrayList.add(this.variableLabel_2_);
        arrayList.add(this.variableLabel_3_);
        this.labelButtonSwap_ = new Panel();
        panel2.add(this.labelButtonSwap_);
        this.cardLayout2_ = new CardLayout();
        this.labelButtonSwap_.setLayout(this.cardLayout2_);
        Panel panel8 = new Panel();
        panel8.setLayout(new GridLayout(1, 3, 5, 0));
        this.startWindowText_ = new TextField();
        this.startWindowText_.addTextListener(new startWindowLNR());
        this.startWindowText_.setText("1");
        arrayList.add(this.startWindowText_);
        panel8.add(this.startWindowText_);
        this.endWindowText_ = new TextField();
        this.endWindowText_.addTextListener(new endWindowLNR());
        this.endWindowText_.setText("1");
        arrayList.add(this.endWindowText_);
        panel8.add(this.endWindowText_);
        panel8.add(new Box.Filler(new Dimension(50, 10), new Dimension(120, 25), new Dimension(300, 100)));
        this.labelButtonSwap_.add("Zoom", panel8);
        Panel panel9 = new Panel();
        panel9.setLayout(new GridLayout(1, 3, 5, 0));
        this.degreesText_ = new TextField();
        this.degreesText_.addTextListener(new degreesLNR());
        this.degreesText_.setText("180");
        arrayList.add(this.degreesText_);
        panel9.add(this.degreesText_);
        this.axisButton_ = new Button("Pivot |");
        this.axisButton_.addActionListener(new axisLNR());
        arrayList.add(this.axisButton_);
        panel9.add(this.axisButton_);
        panel9.add(new Box.Filler(new Dimension(50, 10), new Dimension(120, 25), new Dimension(300, 100)));
        this.labelButtonSwap_.add("Pivot", panel9);
        Panel panel10 = new Panel();
        panel10.setLayout(new GridLayout(1, 3, 5, 0));
        this.shiftAmtHText_ = new TextField("0");
        this.shiftAmtHText_.addTextListener(new shiftLNR("H"));
        arrayList.add(this.shiftAmtHText_);
        panel10.add(this.shiftAmtHText_);
        this.shiftAmtVText_ = new TextField("0");
        this.shiftAmtVText_.addTextListener(new shiftLNR("V"));
        arrayList.add(this.shiftAmtVText_);
        panel10.add(this.shiftAmtVText_);
        this.shiftAmtWText_ = new TextField("0");
        this.shiftAmtWText_.addTextListener(new shiftLNR("W"));
        arrayList.add(this.shiftAmtWText_);
        panel10.add(this.shiftAmtWText_);
        this.labelButtonSwap_.add("Shift", panel10);
        Panel panel11 = new Panel();
        panel2.add(panel11);
        panel11.setLayout(new GridLayout(1, 3, 5, 0));
        Button button2 = new Button("OK");
        arrayList.add(button2);
        button2.addActionListener(new OKLNR("Seq:OK"));
        Button button3 = new Button("CANCEL");
        arrayList.add(button3);
        button3.addActionListener(new CancelLNR("Seq:CANCEL"));
        this.setNextFrame_ = new Button("Set Next Frame");
        this.setNextFrame_.addMouseListener(new DocuMouseListener("Set Next Frame"));
        arrayList.add(this.setNextFrame_);
        this.setNextFrame_.addActionListener(new setNextFrameLNR());
        panel11.add(this.setNextFrame_);
        panel11.add(button3);
        panel11.add(button2);
        this.setSize(400, 250);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 10);
        fontSetter.setComponentFonts(arrayList);
        this.setDisplay();
    }

    public String floatStringTrim(String string, int n) {
        try {
            if (string.indexOf(69) < 0 && string.indexOf(101) < 0) {
                int n2 = Math.min(n, string.length());
                return string.substring(0, n2);
            }
            int n3 = Math.max(string.indexOf(69), string.indexOf(101));
            int n4 = Math.min(n - (string.length() - n3), n3);
            return string.substring(0, n4) + string.substring(n3, string.length());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int tryForStartFrameNumber(int n) {
        return this.fTCentral_.getFrameNumberOrNext(n);
    }

    private void setupForZoom() {
        this.variableLabel_1_.setText("Start Window #");
        this.variableLabel_1_.setAlignment(1);
        this.variableLabel_2_.setText("End Window #");
        this.variableLabel_2_.setAlignment(1);
        this.variableLabel_3_.setText("");
        this.variableLabel_3_.setAlignment(1);
        this.spec_.setStartWindowNumber(this.tryForStartFrameNumber(this.spec_.startWindowNumber()));
        FTWindow fTWindow = this.fTCentral_.getFrame(this.spec_.startWindowNumber());
        this.spec_.setStartSpec(fTWindow.canvas().spec());
        String string = String.valueOf(this.spec_.startWindowNumber());
        this.startWindowText_.setText(this.floatStringTrim(string, 4));
        this.spec_.setEndWindowNumber(this.fTCentral_.compatibleForZoomP(this.spec_.startWindowNumber(), this.spec_.endWindowNumber()) ? this.spec_.endWindowNumber() : this.spec_.startWindowNumber());
        if (this.spec_.startWindowNumber() != this.spec_.endWindowNumber()) {
            FTWindow fTWindow2 = this.fTCentral_.getFrame(this.spec_.endWindowNumber());
            this.spec_.setEndSpec(fTWindow2.canvas().spec());
            this.endWindowText_.setForeground(Color.black);
        } else {
            this.spec_.setEndSpec(null);
            this.endWindowText_.setForeground(Color.red);
        }
        this.cardLayout2_.show(this.labelButtonSwap_, "Zoom");
        string = String.valueOf(this.spec_.endWindowNumber());
        this.endWindowText_.setText(this.floatStringTrim(string, 4));
        this.colorEndWindowText();
    }

    private void setupForPivot() {
        this.variableLabel_1_.setText("Degrees");
        this.variableLabel_1_.setAlignment(1);
        this.variableLabel_2_.setText("Axis");
        this.variableLabel_2_.setAlignment(1);
        this.variableLabel_3_.setText("");
        this.variableLabel_3_.setAlignment(1);
        this.spec_.setStartSpec(this.fTWindow_.canvas().spec());
        this.spec_.setEndSpec(null);
        this.spec_.startSpec().vz = this.fTCentral_.parmsDAxis();
        String string = String.valueOf(this.spec_.degrees);
        this.degreesText_.setText(this.floatStringTrim(string, 12));
        this.axisButton_.setLabel(this.spec_.horizontalPivotP() ? "Pivot -" : "Pivot |");
        this.cardLayout2_.show(this.labelButtonSwap_, "Pivot");
    }

    private void setupForShift() {
        this.variableLabel_1_.setText("Horiz. Increment");
        this.variableLabel_1_.setAlignment(1);
        this.variableLabel_2_.setText("Vert. Increment");
        this.variableLabel_2_.setAlignment(1);
        this.variableLabel_3_.setText("W Increment");
        this.variableLabel_3_.setAlignment(1);
        this.spec_.setStartSpec(this.fTWindow_.canvas().spec());
        this.spec_.setEndSpec(null);
        this.spec_.startSpec().vz = this.fTCentral_.parmsWAxis();
        double d = this.fTWindow_.canvas().spec().range / (double)this.fTWindow_.canvas().spec().pix_width;
        String string = String.valueOf((int)Math.round(this.spec_.hShift / d));
        this.shiftAmtHText_.setText(this.floatStringTrim(string, 17));
        this.shiftAmtHText_.setForeground(Color.black);
        string = String.valueOf((int)Math.round(this.spec_.vShift / d));
        this.shiftAmtVText_.setText(this.floatStringTrim(string, 17));
        this.shiftAmtVText_.setForeground(Color.black);
        string = String.valueOf((int)Math.round(this.spec_.wShift / d));
        this.shiftAmtWText_.setText(this.floatStringTrim(string, 17));
        this.shiftAmtWText_.setForeground(Color.black);
        this.cardLayout2_.show(this.labelButtonSwap_, "Shift");
    }

    public void setDisplay() {
        this.pathnameText_.setText(this.spec_.destination);
        this.framesText_.setText(String.valueOf(this.spec_.frames));
        if (this.spec_.choice == 0) {
            this.setupForZoom();
        } else if (this.spec_.choice == 1) {
            this.setupForPivot();
        } else if (this.spec_.choice == 2) {
            this.setupForShift();
        } else {
            FTCentral.message("Error in choice in SeqDialog.setDisplay", true);
        }
    }

    public static String pathFromDialog(Frame frame) {
        FileDialog fileDialog = new FileDialog(frame, null, 1);
        try {
            fileDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            return null;
        }
        String string = fileDialog.getDirectory();
        if (string == null) {
            return null;
        }
        boolean bl = string.charAt(string.length() - 1) == File.separator.charAt(0);
        return string + (bl ? "" : File.separator) + fileDialog.getFile();
    }

    private boolean setTempInt(String string) {
        try {
            this.tempInt_ = Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private boolean setTempFloat(String string) {
        try {
            this.tempFloat_ = Float.valueOf(string).floatValue();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    protected void colorEndWindowText() {
        boolean bl = false;
        FTWindow fTWindow = null;
        int n = 1;
        try {
            if (this.setTempInt(this.framesText_.getText()) && this.tempInt_ == 1) {
                bl = true;
            }
            if (this.setTempInt(this.endWindowText_.getText()) && (fTWindow = this.fTCentral_.getFrame(n = this.tempInt_)) != null && this.spec_.startWindowNumber() != n && this.fTCentral_.compatibleForZoomP(this.spec_.startWindowNumber(), n)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            this.endWindowText_.setForeground(Color.black);
            if (fTWindow != null) {
                this.spec_.setEndSpec(fTWindow.spec());
                this.spec_.setEndWindowNumber(n);
            }
        } else {
            this.endWindowText_.setForeground(Color.red);
            this.spec_.setEndSpec(null);
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        private Dialog parent_;

        public MyWindowListener(Dialog dialog) {
            this.parent_ = dialog;
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            SeqDialog.this.setNextFrame_.setEnabled(SeqDialog.this.fTWindow_.doingSequenceP());
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.parent_.setVisible(false);
        }
    }

    class PauseLNR
    implements ItemListener {
        PauseLNR() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (SeqDialog.this.savePauseButton_.getSelectedItem().equals("save image and continue. ")) {
                SeqDialog.this.spec_.pause_p = false;
                FTCentral cfr_ignored_0 = SeqDialog.this.fTCentral_;
                FTCentral.message("SeqDialog$PauseLNR spec_.pause_p = false", false);
            } else if (SeqDialog.this.savePauseButton_.getSelectedItem().equals("pause for screen capture.")) {
                SeqDialog.this.spec_.pause_p = true;
                FTCentral cfr_ignored_1 = SeqDialog.this.fTCentral_;
                FTCentral.message("SeqDialog$PauseLNR spec_.pause_p = true", false);
            } else {
                System.err.println("SeqDialog$PauseLNR received illegal value: " + SeqDialog.this.savePauseButton_.getSelectedItem());
            }
        }
    }

    class BrowseLNR
    extends DocuActionListener {
        public BrowseLNR(String string) {
            super(SeqDialog.this.fTWindow_, string);
        }

        @Override
        public void leftClickAction() {
            String string = SeqDialog.pathFromDialog(SeqDialog.this.fTWindow_);
            if (string != null) {
                SeqDialog.this.pathnameText_.setText(string);
                SeqDialog.this.spec_.destination = string;
            }
        }
    }

    class ChoiceLNR
    implements ItemListener {
        ChoiceLNR() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = SeqDialog.this.choiceDropDown_.getSelectedItem();
            if (string.equals("Zoom")) {
                SeqDialog.this.spec_.choice = 0;
            } else if (string.equals("Pivot")) {
                SeqDialog.this.spec_.choice = 1;
            } else if (string.startsWith("Shift")) {
                SeqDialog.this.spec_.choice = 2;
                if (string.equals("Shift Q1")) {
                    SeqDialog.this.spec_.whichShift = 0;
                } else if (string.equals("Shift Q2")) {
                    SeqDialog.this.spec_.whichShift = 1;
                } else if (string.equals("Shift Q3")) {
                    SeqDialog.this.spec_.whichShift = 2;
                }
            } else {
                FTCentral cfr_ignored_0 = SeqDialog.this.fTCentral_;
                FTCentral.message("Error in choice in SeqDialog$ChoiceLNR.actionPerformed", true);
                SeqDialog.this.choiceDropDown_.select(0);
                SeqDialog.this.spec_.choice = 0;
            }
            SeqDialog.this.setDisplay();
        }
    }

    class framesLNR
    implements TextListener {
        framesLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (SeqDialog.this.setTempInt(SeqDialog.this.framesText_.getText())) {
                SeqDialog.this.framesText_.setForeground(Color.black);
                SeqDialog.this.spec_.frames = SeqDialog.this.tempInt_;
                SeqDialog.this.colorEndWindowText();
            } else {
                SeqDialog.this.framesText_.setForeground(Color.red);
            }
        }
    }

    class firstFrameLNR
    implements TextListener {
        firstFrameLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            int n = -1;
            if (SeqDialog.this.setTempInt(SeqDialog.this.framesText_.getText())) {
                n = SeqDialog.this.tempInt_;
            }
            if (SeqDialog.this.setTempInt(SeqDialog.this.firstFrameText_.getText()) && 0 <= SeqDialog.this.tempInt_ && SeqDialog.this.tempInt_ < n) {
                SeqDialog.this.firstFrameText_.setForeground(Color.black);
                SeqDialog.this.spec_.setFrameNumber(SeqDialog.this.tempInt_);
            } else {
                SeqDialog.this.firstFrameText_.setForeground(Color.red);
            }
        }
    }

    public class DocuVariedMouseListener
    extends MouseAdapter {
        int labelNumber_;

        public DocuVariedMouseListener(int n) {
            this.labelNumber_ = n;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown()) {
                int n = SeqDialog.this.choiceDropDown_.getSelectedIndex();
                String string = null;
                block0 : switch (n) {
                    case 0: {
                        switch (this.labelNumber_) {
                            case 0: {
                                string = "Start Window #";
                                break block0;
                            }
                            case 1: {
                                string = "End Window #";
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.labelNumber_) {
                            case 0: {
                                string = "Degrees";
                                break block0;
                            }
                            case 1: {
                                string = "Axis";
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        switch (this.labelNumber_) {
                            case 0: {
                                string = "Horiz. Increment";
                                break block0;
                            }
                            case 1: {
                                string = "Vert. Increment";
                                break block0;
                            }
                            case 2: {
                                string = "W Increment";
                                break block0;
                            }
                        }
                        break;
                    }
                }
                if (string != null) {
                    Object object = FTCentral.findDocString(string);
                    if (object == null || ((String)object).length() == 0) {
                        object = "\"" + string + "\" is not documented.";
                    }
                    JOptionPane.showMessageDialog(mouseEvent.getComponent(), object);
                    mouseEvent.consume();
                }
            }
        }
    }

    class startWindowLNR
    implements TextListener {
        startWindowLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (SeqDialog.this.spec_.choice == 0) {
                boolean bl = false;
                if (SeqDialog.this.setTempInt(SeqDialog.this.startWindowText_.getText())) {
                    FTWindow fTWindow = SeqDialog.this.fTCentral_.getFrame(SeqDialog.this.tempInt_);
                    if (fTWindow != null) {
                        SeqDialog.this.startWindowText_.setForeground(Color.black);
                        SeqDialog.this.spec_.setStartWindowNumber(SeqDialog.this.tempInt_);
                        SeqDialog.this.spec_.setStartSpec(fTWindow.spec());
                        SeqDialog.this.colorEndWindowText();
                    } else {
                        SeqDialog.this.startWindowText_.setForeground(Color.red);
                    }
                } else {
                    SeqDialog.this.startWindowText_.setForeground(Color.red);
                }
            }
        }
    }

    class endWindowLNR
    implements TextListener {
        endWindowLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (SeqDialog.this.spec_.choice == 0) {
                SeqDialog.this.colorEndWindowText();
            }
        }
    }

    class degreesLNR
    implements TextListener {
        degreesLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (SeqDialog.this.setTempFloat(SeqDialog.this.degreesText_.getText())) {
                SeqDialog.this.degreesText_.setForeground(Color.black);
                SeqDialog.this.spec_.degrees = SeqDialog.this.tempFloat_;
            } else {
                SeqDialog.this.degreesText_.setForeground(Color.red);
            }
        }
    }

    class axisLNR
    implements ActionListener {
        axisLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SeqDialog.this.spec_.setHorizontalPivotP(!SeqDialog.this.spec_.horizontalPivotP());
            SeqDialog.this.axisButton_.setLabel(SeqDialog.this.spec_.horizontalPivotP() ? "Pivot -" : "Pivot |");
            if (SeqDialog.this.spec_.frames <= 1) {
                SeqDialog.this.spec_.frames = 90;
                SeqDialog.this.framesText_.setText(String.valueOf(SeqDialog.this.spec_.frames));
            }
        }
    }

    class shiftLNR
    implements TextListener {
        String axisID_;

        public shiftLNR(String string) {
            this.axisID_ = string;
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            TextField textField = this.axisID_.equals("H") ? SeqDialog.this.shiftAmtHText_ : (this.axisID_.equals("V") ? SeqDialog.this.shiftAmtVText_ : (this.axisID_.equals("W") ? SeqDialog.this.shiftAmtWText_ : null));
            String string = textField.getText().trim();
            boolean bl = false;
            boolean bl2 = true;
            if (string.endsWith("p") || string.endsWith("P")) {
                string = string.substring(0, string.length() - 1).trim();
                bl = true;
            }
            double d = 0.0;
            double d2 = SeqDialog.this.fTWindow_.canvas().spec().range / (double)SeqDialog.this.fTWindow_.canvas().spec().pix_width;
            if (SeqDialog.this.setTempFloat(string)) {
                d = bl ? d2 * (double)SeqDialog.this.tempFloat_ : (double)SeqDialog.this.tempFloat_;
                textField.setForeground(Color.black);
            } else {
                textField.setForeground(Color.red);
                bl2 = false;
            }
            if (this.axisID_.equals("H")) {
                SeqDialog.this.spec_.hShift = d;
            } else if (this.axisID_.equals("V")) {
                SeqDialog.this.spec_.vShift = d;
            } else if (this.axisID_.equals("W")) {
                SeqDialog.this.spec_.wShift = d;
            } else {
                FTCentral cfr_ignored_0 = SeqDialog.this.fTCentral_;
                FTCentral.message(String.format("shiftLNR.actionPerformed(%s) is illegal.", this.axisID_), true);
            }
        }
    }

    class OKLNR
    extends DocuActionListener {
        public OKLNR(String string) {
            super(SeqDialog.this.fTWindow_, string);
        }

        @Override
        public void leftClickAction() {
            Object object;
            SeqDialog.this.setVisible(false);
            SeqDialog.this.saveAsFTR_ = false;
            SeqDialog.this.saveAsGIFWhenPossibleP_ = false;
            if ("GIF when poss.".equals((String)SeqDialog.this.formatSelector_.getSelectedItem())) {
                SeqDialog.this.saveAsGIFWhenPossibleP_ = true;
            } else if ("save as FTR".equals((String)SeqDialog.this.formatSelector_.getSelectedItem())) {
                SeqDialog.this.saveAsFTR_ = true;
            }
            SeqDialog.this.spec_.enabled_p = true;
            SeqDialog.this.spec_.destination = SeqDialog.this.pathnameText_.getText();
            if (SeqDialog.this.spec_.destination != null && SeqDialog.this.spec_.destination.trim().length() == 0) {
                SeqDialog.this.spec_.destination = null;
            }
            if (SeqDialog.this.spec_.destination == null) {
                if (SeqDialog.this.savePauseButton_.getSelectedItem().equals("save image and continue. ")) {
                    SeqDialog.this.spec_.enabled_p = false;
                    FTCentral.message("Invalid Sequence Specification: No destination path was given.", true);
                }
            } else {
                object = new File(SeqDialog.this.spec_.destination);
                if (((File)object).isDirectory()) {
                    SeqDialog.this.spec_.enabled_p = false;
                    FTCentral.message("Invalid Sequence Specification: No destination base filename was given.", true);
                }
            }
            if (SeqDialog.this.choiceDropDown_.getSelectedItem().equals("Pivot")) {
                if (SeqDialog.this.setTempFloat(SeqDialog.this.degreesText_.getText())) {
                    SeqDialog.this.spec_.degrees = SeqDialog.this.tempFloat_;
                    SeqDialog.this.spec_.enabled_p = (double)SeqDialog.this.tempFloat_ != 0.0;
                } else {
                    SeqDialog.this.spec_.enabled_p = false;
                }
                SeqDialog.this.spec_.setEndSpec(null);
            } else if (SeqDialog.this.choiceDropDown_.getSelectedItem().startsWith("Shift")) {
                boolean bl = true;
                boolean bl2 = false;
                double d = SeqDialog.this.fTWindow_.canvas().spec().range / (double)SeqDialog.this.fTWindow_.canvas().spec().pix_width;
                String string = SeqDialog.this.choiceDropDown_.getSelectedItem();
                if (string.equals("Shift Q1")) {
                    SeqDialog.this.spec_.whichShift = 0;
                } else if (string.equals("Shift Q2")) {
                    SeqDialog.this.spec_.whichShift = 1;
                } else if (string.equals("Shift Q3")) {
                    SeqDialog.this.spec_.whichShift = 2;
                }
                if (SeqDialog.this.setTempInt(SeqDialog.this.shiftAmtHText_.getText())) {
                    SeqDialog.this.spec_.hShift = (double)SeqDialog.this.tempInt_ * d;
                    if (SeqDialog.this.tempInt_ != 0) {
                        bl2 = true;
                    }
                } else {
                    bl = false;
                }
                if (SeqDialog.this.setTempInt(SeqDialog.this.shiftAmtVText_.getText())) {
                    SeqDialog.this.spec_.vShift = (double)SeqDialog.this.tempInt_ * d;
                    if (SeqDialog.this.tempInt_ != 0) {
                        bl2 = true;
                    }
                } else {
                    bl = false;
                }
                if (SeqDialog.this.setTempInt(SeqDialog.this.shiftAmtWText_.getText())) {
                    SeqDialog.this.spec_.wShift = (double)SeqDialog.this.tempInt_ * d;
                    if (SeqDialog.this.tempInt_ != 0) {
                        bl2 = true;
                    }
                } else {
                    bl = false;
                }
                SeqDialog.this.spec_.enabled_p = bl && bl2;
                SeqDialog.this.spec_.setEndSpec(null);
            } else if (SeqDialog.this.setTempInt(SeqDialog.this.framesText_.getText())) {
                if (SeqDialog.this.spec_.startSpec() == null || SeqDialog.this.tempInt_ != 1 && (SeqDialog.this.spec_.endSpec() == null || SeqDialog.this.spec_.startSpec().equal_p(SeqDialog.this.spec_.endSpec()) || !SeqDialog.this.spec_.startSpec().which.equals(SeqDialog.this.spec_.endSpec().which))) {
                    if (SeqDialog.this.spec_.startSpec() == null) {
                        FTCentral.message("Invalid Sequence Specification: There is no starting image.", true);
                    }
                    if (SeqDialog.this.tempInt_ != 1) {
                        if (SeqDialog.this.spec_.endSpec() == null) {
                            FTCentral.message("Invalid Sequence Specification: There is no ending image.", true);
                        }
                        if (SeqDialog.this.spec_.startSpec().equal_p(SeqDialog.this.spec_.endSpec())) {
                            FTCentral.message("Invalid Sequence Specification: The start and end images are the same.", true);
                        }
                        if (!SeqDialog.this.spec_.startSpec().which.equals(SeqDialog.this.spec_.endSpec().which)) {
                            FTCentral.message("Invalid Sequence Specification: You can't start in fractal " + SeqDialog.this.spec_.startSpec().which + " and end in " + SeqDialog.this.spec_.endSpec().which + ".", true);
                        }
                    }
                    SeqDialog.this.spec_.setStartSpec(null);
                    SeqDialog.this.spec_.enabled_p = false;
                }
            } else {
                SeqDialog.this.spec_.setStartSpec(null);
                SeqDialog.this.spec_.enabled_p = false;
            }
            if (SeqDialog.this.setTempInt(SeqDialog.this.firstFrameText_.getText())) {
                SeqDialog.this.spec_.setFrameNumber(SeqDialog.this.tempInt_);
            }
            if (SeqDialog.this.spec_.startSpec() != null && SeqDialog.this.fTCentral_.parmsToSpec((FractalSpec)(object = new FractalSpec()))) {
                FractalSpec fractalSpec = SeqDialog.this.spec_.startSpec();
                fractalSpec.panels = ((FractalSpec)object).panels;
                fractalSpec.panel_x = ((FractalSpec)object).panel_x;
                fractalSpec.panel_y = ((FractalSpec)object).panel_y;
                if (((FractalSpec)object).panels > 1) {
                    fractalSpec.pix_width = ((FractalSpec)object).pix_width;
                    fractalSpec.pix_height = ((FractalSpec)object).pix_height;
                }
            }
            if (SeqDialog.this.spec_.enabled_p) {
                SeqDialog.this.spec_.setUseFTR_p(false);
                SeqDialog.this.spec_.setUseFTR_p(false);
                if (SeqDialog.this.saveAsGIFWhenPossibleP_) {
                    try {
                        int n = SeqDialog.this.spec_.startWindowNumber();
                        FTWindow fTWindow = SeqDialog.this.fTCentral_.getFrame(n);
                        FTCanvas fTCanvas = fTWindow.canvas();
                        boolean bl = fTCanvas.imageHas256ColorsP();
                        SeqDialog.this.spec_.setUseGIF_p(bl);
                    }
                    catch (Throwable throwable) {
                        FTCentral.message("SeqDialog.OKLNR - unable to set useGIF_p, which may be just fine.", false);
                    }
                } else if (SeqDialog.this.saveAsFTR_) {
                    SeqDialog.this.spec_.setUseFTR_p(true);
                }
            }
            SeqDialog.this.fTWindow_.setSeqSpec(SeqDialog.this.spec_);
            SeqDialog.this.fTWindow_.setEnableSeqStartMenu(SeqDialog.this.spec_.enabled_p);
        }
    }

    class CancelLNR
    extends DocuActionListener {
        public CancelLNR(String string) {
            super(SeqDialog.this.fTWindow_, string);
        }

        @Override
        public void leftClickAction() {
            SeqDialog.this.spec_.enabled_p = false;
            SeqDialog.this.spec_.setStartSpec(null);
            SeqDialog.this.setVisible(false);
        }
    }

    class setNextFrameLNR
    implements ActionListener {
        setNextFrameLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (SeqDialog.this.setTempInt(SeqDialog.this.firstFrameText_.getText())) {
                int n = SeqDialog.this.tempInt_;
                if (SeqDialog.this.setTempInt(SeqDialog.this.framesText_.getText()) && 0 <= n && n < SeqDialog.this.tempInt_) {
                    SeqDialog.this.fTWindow_.setSeqSpecNextFrame(n);
                    SeqDialog.this.setVisible(false);
                    bl = true;
                }
            }
            if (!bl) {
                FTCentral cfr_ignored_0 = SeqDialog.this.fTCentral_;
                FTCentral.message("Invalid next frame number.", true);
            }
        }
    }
}

