/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.LabeledTextField;

public class RatioDialog
extends Dialog {
    private LabeledTextField widthField_;
    private LabeledTextField heightField_;
    private static Dimension oldValue_ = new Dimension(1, 1);
    private Button offButton_;
    private boolean enabled_p_ = false;
    private boolean cancelled_p_ = false;
    private Frame parent_;

    public RatioDialog(String string, Frame frame, Dimension dimension) {
        super(frame, string, true);
        this.parent_ = frame;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.setLayout(new GridLayout(2, 1, 0, 10));
        this.widthField_ = new LabeledTextField("Width", 0, 1);
        arrayList.add(this.widthField_);
        this.heightField_ = new LabeledTextField("Height", 0, 1);
        arrayList.add(this.heightField_);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 4, 4));
        panel.add(this.widthField_);
        panel.add(this.heightField_);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 4, 4, 4));
        this.offButton_ = new Button();
        arrayList.add(this.offButton_);
        this.offButton_.addActionListener(new OffLNR("Enabled/Disabled"));
        panel2.add(this.offButton_);
        panel2.add(new Label());
        Button button = new Button("OK");
        arrayList.add(button);
        button.addActionListener(new OKLNR());
        panel2.add(button);
        Button button2 = new Button("CANCEL");
        arrayList.add(button2);
        button2.addActionListener(new CancelLNR());
        panel2.add(button2);
        this.add(panel);
        this.add(panel2);
        this.setSize(300, 90);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 9);
        fontSetter.setComponentFonts(arrayList);
        this.loadValues(dimension);
        this.validate();
        FTCentral.setLocationRelativeToActiveFrame(this);
        this.setVisible(true);
    }

    public Dimension getDimension() {
        if (this.cancelled_p_) {
            return oldValue_;
        }
        if (this.enabled_p_ && this.widthField_.valueOk_p() && this.heightField_.valueOk_p()) {
            int n;
            int n2 = this.widthField_.intValue();
            if (n2 == 0) {
                n2 = -1;
            }
            if ((n = this.heightField_.intValue()) == 0) {
                n = -1;
            }
            return new Dimension(n2, n);
        }
        return new Dimension(-1, -1);
    }

    private void loadValues(Dimension dimension) {
        oldValue_ = new Dimension(dimension);
        this.cancelled_p_ = false;
        this.enabled_p_ = !RatioDialog.offP(dimension);
        this.offButton_.setLabel(this.enabled_p_ ? "Enabled" : "Disabled");
        this.offButton_.setBackground(this.enabled_p_ ? Color.green : Color.red);
        int n = dimension.width < 0 ? -dimension.width : (dimension.width == 0 ? 1 : dimension.width);
        int n2 = dimension.height < 0 ? -dimension.height : (dimension.height == 0 ? 1 : dimension.height);
        this.widthField_.setText(Integer.toString(n));
        this.heightField_.setText(Integer.toString(n2));
    }

    public static boolean offP(Dimension dimension) {
        return dimension.width <= 0 || dimension.height <= 0;
    }

    class OffLNR
    extends DocuActionListener {
        public OffLNR(String string) {
            super(RatioDialog.this.parent_, string);
        }

        @Override
        public void leftClickAction() {
            RatioDialog.this.enabled_p_ = !RatioDialog.this.enabled_p_;
            RatioDialog.this.offButton_.setLabel(!RatioDialog.this.enabled_p_ ? "Disabled" : "Enabled");
            RatioDialog.this.offButton_.setBackground(RatioDialog.this.enabled_p_ ? Color.green : Color.red);
        }
    }

    class OKLNR
    implements ActionListener {
        OKLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RatioDialog.this.setVisible(false);
        }
    }

    class CancelLNR
    implements ActionListener {
        CancelLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RatioDialog.this.setVisible(false);
            RatioDialog.this.cancelled_p_ = true;
        }
    }
}

