/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Point;
import java.math.BigInteger;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.Fraction;

public class QtoPixelPoint {
    private FractalSpec spec_;
    private BigQuaternion loX_ = null;
    private BigQuaternion hiY_ = null;
    private BigQuaternion incX_ = null;
    private BigQuaternion incY_ = null;

    public QtoPixelPoint(FractalSpec fractalSpec) {
        this.spec_ = new FractalSpec(fractalSpec);
    }

    public BigQuaternion get_lox() {
        if (this.loX_ == null) {
            this.compute_loX_hiy();
        }
        return this.loX_;
    }

    public BigQuaternion get_hiy() {
        if (this.hiY_ == null) {
            this.compute_loX_hiy();
        }
        return this.hiY_;
    }

    public BigQuaternion get_incX() {
        if (this.incX_ == null) {
            this.compute_loX_hiy();
        }
        return this.incX_;
    }

    public BigQuaternion get_incY() {
        if (this.incY_ == null) {
            this.compute_loX_hiy();
        }
        return this.incY_;
    }

    private void compute_loX_hiy() {
        if (this.loX_ == null) {
            this.loX_ = new BigQuaternion();
            this.hiY_ = new BigQuaternion();
            this.incX_ = new BigQuaternion();
            this.incY_ = new BigQuaternion();
            int n = this.spec_.pix_width * this.spec_.panels - 1;
            int n2 = this.spec_.pix_height * this.spec_.panels - 1;
            this.incX_.assign_from(this.spec_.vx.times_scalar(this.spec_.range / (double)n).bigQuaternionValue());
            this.incY_.assign_from(this.spec_.vy.times_scalar(this.spec_.range / (double)n).bigQuaternionValue());
            int n3 = n / -2 + this.spec_.panel_x * this.spec_.pix_width;
            if (this.spec_.rangeOver == 0) {
                this.loX_.assign_from(this.spec_.center.plus(this.incX_.times_scalar(n3)));
            } else if (this.spec_.rangeOver == 1) {
                this.loX_.assign_from(this.spec_.coeff.plus(this.incX_.times_scalar(n3)));
            } else {
                this.loX_.assign_from(this.spec_.trans.plus(this.incX_.times_scalar(n3)));
            }
            int n4 = n2 / 2 - this.spec_.panel_y * this.spec_.pix_height;
            this.hiY_.assign_from(this.incY_.times_scalar(n4));
            if (this.spec_.rangeOver == 0) {
                BigQuaternion.setCommonDenominator(this.loX_, this.incX_, this.hiY_, this.incY_, this.spec_.coeff, this.spec_.trans);
            } else if (this.spec_.rangeOver == 1) {
                BigQuaternion.setCommonDenominator(this.loX_, this.incX_, this.hiY_, this.incY_, this.spec_.center, this.spec_.trans);
            } else {
                BigQuaternion.setCommonDenominator(this.loX_, this.incX_, this.hiY_, this.incY_, this.spec_.coeff, this.spec_.center);
            }
        }
    }

    public Point getPixelPoint(BigQuaternion bigQuaternion) {
        if (this.loX_ == null) {
            this.compute_loX_hiy();
        }
        BigQuaternion bigQuaternion2 = this.get_lox().plus(this.get_hiy());
        BigQuaternion bigQuaternion3 = bigQuaternion.minus(bigQuaternion2);
        BigQuaternion bigQuaternion4 = new BigQuaternion(this.spec_.vx);
        Fraction fraction = bigQuaternion3.dot(bigQuaternion4);
        Fraction fraction2 = this.incX_.magnitude();
        Fraction fraction3 = fraction.divide(fraction2);
        BigQuaternion bigQuaternion5 = new BigQuaternion(this.spec_.vy);
        Fraction fraction4 = bigQuaternion3.dot(bigQuaternion5);
        Fraction fraction5 = this.incY_.magnitude();
        Fraction fraction6 = fraction4.divide(fraction5);
        BigInteger bigInteger = fraction3.bigIntegerValue();
        BigInteger bigInteger2 = fraction6.bigIntegerValue();
        Point point = new Point(bigInteger.intValue(), bigInteger2.intValue() + this.spec_.pix_height);
        return new Point(fraction3.intValue(), -fraction6.intValue());
    }

    public BigQuaternion getQuaternion(int n, int n2) {
        if (this.loX_ == null) {
            this.compute_loX_hiy();
        }
        BigQuaternion bigQuaternion = this.get_lox().plus(this.get_hiy().minus(this.get_incY().times_scalar(n2)));
        return bigQuaternion.plus(this.get_incX().times_scalar(n));
    }

    public BigQuaternion getQuaternion(Point point) {
        return this.getQuaternion((int)point.getX(), (int)point.getY());
    }
}

