/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ImageConsumer;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.DrawResults;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.QtoPixelPoint;

class Q1ImageProducer {
    int NON_BLACKS = 255;
    FTCanvas parent_;
    ArrayList<ImageConsumer> consumers = new ArrayList();
    int width;
    int height;
    protected boolean stop_p_ = false;
    boolean drawing_p_ = false;
    boolean parameter_change_p_ = false;
    boolean[] rowsDone_;
    DrawResults drawResults_;
    int max_hours_per_row_ = 48;
    protected FractalSpec spec_;
    BigQuaternion lox_;
    BigQuaternion hiy_;
    BigQuaternion incx_;
    BigQuaternion incy_;
    double clump;
    FTLooper loop_function;
    FastQuaternion loxFast = null;
    FastQuaternion hiyFast = null;
    FastQuaternion incxFast = null;
    FastQuaternion incyFast = null;
    FastQuaternion centerFast;
    FastQuaternion coeffFast;
    FastQuaternion transFast;

    Q1ImageProducer(FractalSpec fractalSpec, FTCanvas fTCanvas) {
        this.parent_ = fTCanvas;
        this.spec_ = new FractalSpec(fractalSpec);
        this.drawResults_ = new DrawResults(this.spec_, this.parent_.getColorGuide(), this.rowsDone_, this.parent_);
        this.width = this.spec_.pix_width;
        this.height = this.spec_.pix_height;
        this.centerFast = new FastQuaternion(this.spec_.center);
        this.coeffFast = new FastQuaternion(this.spec_.coeff);
        this.transFast = new FastQuaternion(this.spec_.trans);
        this.lox_ = new BigQuaternion();
        this.hiy_ = new BigQuaternion();
        this.incx_ = new BigQuaternion();
        this.incy_ = new BigQuaternion();
        this.computeLoxEtc();
    }

    Q1ImageProducer(BufferedImage bufferedImage, FractalSpec fractalSpec, FTCanvas fTCanvas) {
        this.parent_ = fTCanvas;
        this.spec_ = new FractalSpec(fractalSpec);
        this.drawResults_ = new DrawResults(this.spec_, this.parent_.getColorGuide(), this.rowsDone_, bufferedImage, this.parent_);
        this.width = this.spec_.pix_width;
        this.height = this.spec_.pix_height;
        this.centerFast = new FastQuaternion(this.spec_.center);
        this.coeffFast = new FastQuaternion(this.spec_.coeff);
        this.transFast = new FastQuaternion(this.spec_.trans);
        this.lox_ = new BigQuaternion();
        this.hiy_ = new BigQuaternion();
        this.incx_ = new BigQuaternion();
        this.incy_ = new BigQuaternion();
        this.loxFast = new FastQuaternion();
        this.hiyFast = new FastQuaternion();
        this.incxFast = new FastQuaternion();
        this.incyFast = new FastQuaternion();
        this.computeLoxEtc();
        this.setStopP(false);
        this.parameter_change_p_ = false;
        this.rowsDone_ = new boolean[0];
    }

    public FractalSpec getSpec() {
        return this.spec_;
    }

    public boolean libLoadedP() {
        return this.loop_function != null && this.loop_function.libLoadedP();
    }

    public void set_drawing_p(boolean bl) {
        this.drawing_p_ = bl;
    }

    public boolean drawing_p() {
        return this.drawing_p_;
    }

    public void setStopP(boolean bl) {
        this.stop_p_ = bl;
    }

    public boolean stoppedP() {
        return this.stop_p_;
    }

    public int call_loop_function(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        return this.loop_function.loop(fastQuaternion, fastQuaternion2, fastQuaternion3, n);
    }

    public int call_big_loop_function(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        return this.loop_function.bigLoop(bigQuaternion, bigQuaternion2, bigQuaternion3, n);
    }

    void pixout(int n, int n2, int n3) {
        Color color = this.drawResults_.setPixel(n, n2, n3);
        if (!this.parent_.keepCurrentDrawLine(n, n, n2, color) && !this.stop_p_) {
            this.setStopP(true);
        }
    }

    void frDrawline(int n, int n2, int n3, int n4) {
        Color color = this.drawResults_.setLine(n, n2, n3, n4);
        if (!this.parent_.keepCurrentDrawLine(n, n2, n3, color)) {
            this.setStopP(true);
        }
    }

    int bigLoopCall(BigQuaternion bigQuaternion, FractalSpec fractalSpec) {
        return this.loop_function.bigLoop(bigQuaternion, fractalSpec.coeff, fractalSpec.trans, fractalSpec.depth);
    }

    int fastLoopCall(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, FastQuaternion fastQuaternion4, int n) {
        return this.loop_function.loop(fastQuaternion, fastQuaternion3, fastQuaternion4, n);
    }

    void rowSimple(int n) {
        if (this.loop_function.bigLoop_p() && this.parent_.useHighPrecisionP()) {
            BigQuaternion bigQuaternion = this.lox_.plus(this.hiy_.minus(this.incy_.times_scalar(n)));
            for (int i = 0; i < this.spec_.pix_width; ++i) {
                BigQuaternion bigQuaternion2 = bigQuaternion.plus(this.incx_.times_scalar(i));
                int n2 = this.bigLoopCall(bigQuaternion2, this.spec_);
                this.pixout(i, n, n2);
                if (!this.stop_p_) continue;
                return;
            }
        } else {
            FastQuaternion fastQuaternion = this.loxFast.plus(this.hiyFast.minus(this.incyFast.times_scalar(n)));
            for (int i = 0; i < this.spec_.pix_width; ++i) {
                FastQuaternion fastQuaternion2 = fastQuaternion.plus(this.incxFast.times_scalar(i));
                int n3 = this.fastLoopCall(fastQuaternion2, this.centerFast, this.coeffFast, this.transFast, this.spec_.depth);
                this.pixout(i, n, n3);
                if (!this.stop_p_) continue;
                return;
            }
        }
        try {
            Thread.sleep(0L, 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    int guidedFillLeft(BigQuaternion bigQuaternion, int n, int n2, int n3, int n4, int n5) {
        ++n2;
        if (this.loop_function.bigLoop_p() && this.parent_.useHighPrecisionP()) {
            int n6;
            BigQuaternion bigQuaternion2 = this.lox_.plus(bigQuaternion);
            BigQuaternion bigQuaternion3 = new BigQuaternion();
            do {
                bigQuaternion3.assign_from(bigQuaternion2).plus_equal(this.incx_.times_scalar(--n2));
                n6 = this.bigLoopCall(bigQuaternion3, this.spec_);
                this.pixout(n2, n3, n6);
            } while (n2 > n && (n6 != this.drawResults_.getLoopCount(n2, n4) || n6 != this.drawResults_.getLoopCount(n2, n5)));
        } else {
            int n7;
            FastQuaternion fastQuaternion = new FastQuaternion();
            FastQuaternion fastQuaternion2 = new FastQuaternion(this.loxFast);
            fastQuaternion2.plus_equal(bigQuaternion.fastQuaternionValue());
            do {
                fastQuaternion.assign_from(fastQuaternion2).plus_equal(this.incxFast.times_scalar(--n2));
                n7 = this.fastLoopCall(fastQuaternion, this.centerFast, this.coeffFast, this.transFast, this.spec_.depth);
                this.pixout(n2, n3, n7);
            } while (n2 > n && (n7 != this.drawResults_.getLoopCount(n2, n4) || n7 != this.drawResults_.getLoopCount(n2, n5)));
        }
        return n2;
    }

    boolean checkNeighborhood(int n, int n2, int n3, int n4, int n5) {
        boolean bl = n2 == 0 || n == this.drawResults_.getLoopCount(n2 - 1, n3) && n == this.drawResults_.getLoopCount(n2 - 1, n4);
        bl = bl && n == this.drawResults_.getLoopCount(n2, n3) && n == this.drawResults_.getLoopCount(n2, n4);
        bl = bl && (n2 == n5 - 1 || n == this.drawResults_.getLoopCount(n2 + 1, n3) && n == this.drawResults_.getLoopCount(n2 + 1, n4));
        return bl;
    }

    int guidedFillRight(BigQuaternion bigQuaternion, int n, int n2, int n3, int n4, int n5) {
        --n;
        if (this.loop_function.bigLoop_p() && this.parent_.useHighPrecisionP()) {
            int n6;
            BigQuaternion bigQuaternion2 = this.lox_.plus(bigQuaternion);
            BigQuaternion bigQuaternion3 = new BigQuaternion();
            do {
                bigQuaternion3.assign_from(bigQuaternion2).plus_equal(this.incx_.times_scalar(++n));
                n6 = this.bigLoopCall(bigQuaternion3, this.spec_);
                this.pixout(n, n2, n6);
            } while (n < n5 - 1 && !this.checkNeighborhood(n6, n, n3, n4, n5));
        } else {
            int n7;
            FastQuaternion fastQuaternion = new FastQuaternion();
            FastQuaternion fastQuaternion2 = new FastQuaternion(this.loxFast);
            fastQuaternion2.plus_equal(bigQuaternion.fastQuaternionValue());
            do {
                fastQuaternion.assign_from(fastQuaternion2).plus_equal(this.incxFast.times_scalar(++n));
                n7 = this.fastLoopCall(fastQuaternion, this.centerFast, this.coeffFast, this.transFast, this.spec_.depth);
                this.pixout(n, n2, n7);
            } while (n < n5 - 1 && !this.checkNeighborhood(n7, n, n3, n4, n5));
        }
        return n + 1;
    }

    int singlePoint(BigQuaternion bigQuaternion, int n, int n2, int n3, int n4) {
        int n5;
        if (this.loop_function.bigLoop_p() && this.parent_.useHighPrecisionP()) {
            BigQuaternion bigQuaternion2 = this.lox_.plus(this.incx_.times_scalar(n)).plus(bigQuaternion);
            n5 = this.bigLoopCall(bigQuaternion2, this.spec_);
        } else {
            FastQuaternion fastQuaternion = new FastQuaternion();
            fastQuaternion.assign_from(this.incxFast).times_scalar_n(n).plus_equal(this.loxFast).plus_equal(bigQuaternion.fastQuaternionValue());
            n5 = this.fastLoopCall(fastQuaternion, this.centerFast, this.coeffFast, this.transFast, this.spec_.depth);
        }
        this.pixout(n, n2, n5);
        return n5;
    }

    int getRightMax(int n, int n2, int n3, int n4) {
        int n5 = this.drawResults_.getLoopCount(n3 - 1, n);
        while (n3 < n4 && this.drawResults_.getLoopCount(n3, n) == n5 && n5 == this.drawResults_.getLoopCount(n3, n2)) {
            ++n3;
        }
        return n3 - 1;
    }

    boolean rowFancy(int n, int n2, int n3, int n4, int n5) {
        if (this.stop_p_) {
            return false;
        }
        BigQuaternion bigQuaternion = this.hiy_.minus(this.incy_.times_scalar(n));
        int n6 = n4;
        while (n6 < n5) {
            if ((n6 = this.guidedFillRight(bigQuaternion, n6, n, n2, n3, n5)) >= n5) continue;
            int n7 = this.getRightMax(n2, n3, n6, n5);
            int n8 = this.guidedFillLeft(bigQuaternion, n6, n7, n, n2, n3);
            int n9 = this.drawResults_.getLoopCount(n6, n2);
            if (n8 - n6 < 3) {
                this.frDrawline(n6, n8 - 1, n, n9);
            } else {
                int n10 = (n6 + n8) / 2;
                int n11 = this.singlePoint(bigQuaternion, n6, n, n2, n3);
                if (n9 == n11) {
                    this.frDrawline(n6, n8 - 1, n, n9);
                } else {
                    this.rowFancy(n, n2, n3, n6, n10);
                    this.rowFancy(n, n2, n3, n10, n8);
                }
            }
            n6 = n7;
        }
        return true;
    }

    protected void computeLoxEtc() {
        QtoPixelPoint qtoPixelPoint = new QtoPixelPoint(this.spec_);
        this.lox_ = qtoPixelPoint.get_lox();
        this.hiy_ = qtoPixelPoint.get_hiy();
        this.incx_ = qtoPixelPoint.get_incX();
        this.incy_ = qtoPixelPoint.get_incY();
        BigQuaternion.setCommonDenominator(this.lox_, this.incx_, this.hiy_, this.incy_, this.spec_.center, this.spec_.coeff, this.spec_.trans);
        this.loxFast = this.lox_.fastQuaternionValue();
        this.hiyFast = this.hiy_.fastQuaternionValue();
        this.incxFast = this.incx_.fastQuaternionValue();
        this.incyFast = this.incy_.fastQuaternionValue();
        this.clump = this.spec_.loops_per_color;
        if (this.clump < 1.0) {
            FTCentral.message("Q2ImagePreducer - Setting Loops/color to 1 for this drawing.  That's the minimum value allowed.", true);
            this.clump = 1.0;
        }
    }

    protected void computeLoxEtc_old() {
        int n = this.spec_.pix_width * this.spec_.panels - 1;
        int n2 = this.spec_.pix_height * this.spec_.panels - 1;
        this.incx_.assign_from(this.spec_.vx.times_scalar(this.spec_.range / (double)n).bigQuaternionValue());
        this.incy_.assign_from(this.spec_.vy.times_scalar(this.spec_.range / (double)n).bigQuaternionValue());
        int n3 = n / -2 + this.spec_.panel_x * this.spec_.pix_width;
        this.lox_.assign_from(this.spec_.center.plus(this.incx_.times_scalar(n3)));
        int n4 = n2 / 2 - this.spec_.panel_y * this.spec_.pix_height;
        this.hiy_.assign_from(this.incy_.times_scalar(n4));
        this.parent_.spec().setCache(this.lox_, this.hiy_, this.incx_, this.incy_);
        this.parent_.spec().cache_is_current = true;
        BigQuaternion.setCommonDenominator(this.lox_, this.incx_, this.hiy_, this.incy_, this.spec_.coeff, this.spec_.trans);
        this.loxFast = this.lox_.fastQuaternionValue();
        this.hiyFast = this.hiy_.fastQuaternionValue();
        this.incxFast = this.incx_.fastQuaternionValue();
        this.incyFast = this.incy_.fastQuaternionValue();
        this.clump = this.spec_.loops_per_color;
        if (this.clump < 1.0) {
            this.parent_.ftCentral();
            FTCentral.message("Q1ImageProducer - clump was " + this.clump + " Setting Loops/color to 1 for this drawing.  That's the minimum value allowed.", true);
            this.clump = 1.0;
        }
    }

    protected synchronized void drawTheFractal() {
        try {
            if (this.loop_function == null) {
                FTCentral.message("Q1ImageProducer.drawTheFractal - ERROR: The fractal loop " + this.spec_.which + " cannot be found.", true);
                return;
            }
            if (this.parent_.everFinishedP()) {
                this.set_drawing_p(false);
                return;
            }
            this.parallelRun();
        }
        catch (Throwable throwable) {
            FTCentral.message("Q1ImageProducer.drawTheFractal - ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            this.parent_.setEverStartedP(true);
            this.set_drawing_p(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parallelRun() {
        int n;
        int n2;
        ThreadPoolExecutor threadPoolExecutor = null;
        try {
            int n3;
            Object object;
            if (!this.parent_.everStartedP() || this.parent_.everFinishedP()) {
                this.computeLoxEtc();
                this.rowsDone_ = new boolean[this.height];
                Arrays.fill(this.rowsDone_, false);
                this.drawResults_ = new DrawResults(this.spec_, this.parent_.getColorGuide(), this.rowsDone_, this.parent_);
            }
            this.parent_.setEverStartedP(true);
            threadPoolExecutor = this.getThreadPoolExecutor(this.loop_function);
            this.parameter_change_p_ = false;
            this.setStopP(false);
            this.parent_.repaint();
            this.loop_function.prepare(this.spec_);
            if (this.spec_.hifi_p) {
                object = new int[]{0, 4, 2, 6, 1, 3, 5, 7};
                n3 = ((int[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    for (var6_19 = n = object[n2]; var6_19 < this.height; var6_19 += n3) {
                        if (this.rowsDone_[var6_19]) continue;
                        threadPoolExecutor.execute(new DrawRowSimply(var6_19));
                        if (this.stop_p_) break;
                    }
                    if (!this.stop_p_) {
                        continue;
                    }
                    break;
                }
            } else {
                int n4 = 0;
                for (n3 = 0; n3 < this.height; n3 += 8) {
                    if (!this.rowsDone_[n3]) {
                        threadPoolExecutor.execute(new DrawRowSimply(n3));
                    }
                    n4 = n3;
                }
                if ((this.height - 1) % 2 == 1 && !this.rowsDone_[this.height - 1]) {
                    threadPoolExecutor.execute(new DrawRowSimply(this.height - 1));
                }
                n3 = n4;
                for (n2 = 4; n2 < n4; n2 += 8) {
                    if (this.rowsDone_[n2]) continue;
                    threadPoolExecutor.execute(new Draw1RowGuided(n2, n2 - 4, n2 + 4));
                }
                if (n2 < this.height && !this.rowsDone_[n2]) {
                    threadPoolExecutor.execute(new DrawRowSimply(n2));
                    n3 = n2;
                }
                for (n = 2; n < n3; n += 4) {
                    if (this.rowsDone_[n]) continue;
                    threadPoolExecutor.execute(new Draw1RowGuided(n, n - 2, n + 2));
                }
                while (n < this.height) {
                    if (!this.rowsDone_[n]) {
                        threadPoolExecutor.execute(new DrawRowSimply(n));
                    }
                    n += 4;
                }
                for (var6_19 = 1; var6_19 < this.height - 1; var6_19 += 2) {
                    if (this.rowsDone_[var6_19]) continue;
                    threadPoolExecutor.execute(new Draw1RowGuided(var6_19, var6_19 - 1, var6_19 + 1));
                }
            }
            object = Calendar.getInstance();
            for (n3 = 0; n3 < this.height; ++n3) {
                if (this.rowsDone_[n3]) continue;
                long l = ((Calendar)object).getTimeInMillis();
                while (!this.rowsDone_[n3] && !this.stop_p_ && ((Calendar)object).getTimeInMillis() < l + (long)(3600000 * this.max_hours_per_row_)) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Throwable throwable) {}
                }
                if (this.rowsDone_[n3] || this.stop_p_) continue;
                this.setStopP(true);
                FTCentral.message("Some row " + n3 + " isn't going to finish.  It's been " + this.max_hours_per_row_ + " minutes.", true);
            }
            this.parent_.setEverFinishedP(true);
            for (n3 = 0; n3 < this.height; ++n3) {
                if (this.rowsDone_[n3]) continue;
                this.parent_.setEverFinishedP(false);
                break;
            }
            if (!this.parent_.everFinishedP()) {
                FTCentral.message("Preparing to pause.  Please wait.", false);
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("Q1ImageProducer.parallelRun Error: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            int n5 = threadPoolExecutor.getPoolSize();
            boolean[] blArray = new boolean[n5];
            Arrays.fill(blArray, false);
            for (n2 = 0; n2 < n5; ++n2) {
                threadPoolExecutor.execute(new MPFRcleanUp(this.loop_function, blArray, n2));
            }
            for (n2 = 0; n2 < n5; ++n2) {
                while (!blArray[n2]) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.parent_.setEverFinishedP(true);
            for (n = 0; n < this.height; ++n) {
                if (this.rowsDone_[n]) continue;
                this.parent_.setEverFinishedP(false);
                break;
            }
            if (this.parent_.everFinishedP()) {
                this.rowsDone_ = new boolean[0];
            }
            threadPoolExecutor.shutdown();
            try {
                if (!threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    threadPoolExecutor.shutdown();
                }
            }
            catch (InterruptedException interruptedException) {
                threadPoolExecutor.shutdown();
            }
        }
    }

    public String getCountsCSV() {
        if (this.drawResults_ == null) {
            FTCentral.message("ERROR The DrawResults object was missing.", true);
            return null;
        }
        return this.drawResults_.getCountsCSV();
    }

    private ThreadPoolExecutor getThreadPoolExecutor(FTLooper fTLooper) {
        int n = this.parent_.parent().numberOfProcessors();
        ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(this.spec_.pix_height, true);
        return new ThreadPoolExecutor(n, n, this.parent_.doingSequenceP() ? 1 : 5, TimeUnit.MINUTES, arrayBlockingQueue);
    }

    public BufferedImage createRawImage() {
        int n = 0x40000000;
        int n2 = Integer.MIN_VALUE;
        if (this.drawResults_ == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.spec_.pix_width, this.spec_.pix_height, 2);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n3 = this.drawResults_.getLoopCount(j, i);
                if ((n3 & n) == 0) {
                    n3 ^= n2;
                }
                bufferedImage.setRGB(j, i, n3);
            }
        }
        return bufferedImage;
    }

    public byte[] getGIFColorIndices() {
        int[][] nArray = this.drawResults_.getLoopCounts();
        int n = nArray.length;
        int n2 = nArray[0].length;
        byte[] byArray = new byte[n2 * n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j][i];
                byArray[i * n + j] = (byte)(n3 == this.spec_.depth ? -1 : (byte)((int)((double)n3 / this.spec_.loops_per_color) % this.NON_BLACKS));
            }
        }
        return byArray;
    }

    public int getLoopCount(int n, int n2) {
        return this.drawResults_.getLoopCount(n, n2);
    }

    public void stop() {
        this.setStopP(true);
        if (this.parent_.everFinishedP()) {
            this.set_drawing_p(false);
            return;
        }
        if (this.parent_.everStartedP() && this.rowsDone_ != null) {
            for (boolean bl : this.rowsDone_) {
                if (bl) continue;
                return;
            }
        }
        this.set_drawing_p(false);
    }

    public void setParameters(FractalSpec fractalSpec, boolean bl) {
        this.spec_ = new FractalSpec(fractalSpec);
        this.centerFast = new FastQuaternion(this.spec_.center);
        this.coeffFast = new FastQuaternion(this.spec_.coeff);
        this.transFast = new FastQuaternion(this.spec_.trans);
        this.parameter_change_p_ = bl;
        this.loop_function = this.parent_.ftCentral().findLoopObject(this.spec_.which);
    }

    public BufferedImage setLoopCountsFromFTRImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(this.parent_);
        int n2 = bufferedImage.getHeight(this.parent_);
        int[] nArray = new int[n * n2];
        this.rowsDone_ = new boolean[n2];
        Arrays.fill(this.rowsDone_, false);
        this.drawResults_ = new DrawResults(this.spec_, this.parent_.getColorGuide(), this.rowsDone_, this.parent_);
        new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
        int[][] nArray2 = this.drawResults_.getLoopCounts();
        int n3 = 0x40000000;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = bufferedImage.getRGB(j, i);
                if ((n5 & n3) == 0) {
                    n5 ^= n4;
                }
                nArray2[j][i] = n5;
            }
        }
        return this.drawResults_.refreshImage();
    }

    public BufferedImage getImage() {
        return this.drawResults_.getImage();
    }

    public BufferedImage setColorGuideGetImage(Color[] colorArray) {
        return this.drawResults_.setPaletteGetImage(colorArray);
    }

    class DrawRowSimply
    implements Runnable {
        private int row_;
        private boolean record_p_;

        public DrawRowSimply(int n) {
            this.row_ = n;
        }

        @Override
        public void run() {
            try {
                Q1ImageProducer.this.rowSimple(this.row_);
                if (!Q1ImageProducer.this.stop_p_) {
                    Q1ImageProducer.this.rowsDone_[this.row_] = true;
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Q1ImageProducer$DrawRowSimply.run - ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class Draw1RowGuided
    implements Runnable {
        private int row_;
        private int rowAbove_;
        private int rowBelow_;
        private final Object davy_jones_ = new Object();

        public Draw1RowGuided(int n, int n2, int n3) {
            this.row_ = n;
            this.rowAbove_ = n2;
            this.rowBelow_ = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!Q1ImageProducer.this.stop_p_) {
                    while (!(Q1ImageProducer.this.rowsDone_[this.rowAbove_] && Q1ImageProducer.this.rowsDone_[this.rowBelow_] || Q1ImageProducer.this.stop_p_)) {
                        try {
                            Object object = this.davy_jones_;
                            synchronized (object) {
                                this.davy_jones_.wait(500L);
                            }
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                if (!Q1ImageProducer.this.stop_p_ && !Q1ImageProducer.this.rowsDone_[this.row_]) {
                    boolean bl;
                    Q1ImageProducer.this.rowsDone_[this.row_] = bl = Q1ImageProducer.this.rowFancy(this.row_, this.rowAbove_, this.rowBelow_, 0, Q1ImageProducer.this.spec_.pix_width);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Q1ImageProducer$Draw1RowGuided.run Error: " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class MPFRcleanUp
    implements Runnable {
        private FTLooper loopFunction_;
        private boolean[] flags_;
        private int myIndex_;

        public MPFRcleanUp(FTLooper fTLooper, boolean[] blArray, int n) {
            this.loopFunction_ = fTLooper;
            this.flags_ = blArray;
            this.myIndex_ = n;
        }

        @Override
        public void run() {
            try {
                this.loopFunction_.cleanMPFROnMyThread();
            }
            catch (Throwable throwable) {
                FTCentral.message("Q1ImageProducer$MPFRcleanUp.run catch " + Thread.currentThread().getName() + ",  msg=" + FTCentral.getExceptionSynopsis(throwable), true);
            }
            finally {
                this.flags_[this.myIndex_] = true;
            }
            try {
                this.wait(3600000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

