/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import us.lystad.fractaltop.BigLabeledTextField;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseCkBoxMenuItemListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTFileChooser;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.IntDialog;
import us.lystad.fractaltop.LabeledTextField;
import us.lystad.fractaltop.PanelJoiner;
import us.lystad.fractaltop.RatioDialog;
import us.lystad.fractaltop.RatioTextActionListener;

public class ParmFrame
extends JFrame {
    final FastQuaternion unitR = new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    final FastQuaternion unitI = new FastQuaternion(0.0, 1.0, 0.0, 0.0);
    final FastQuaternion unitJ = new FastQuaternion(0.0, 0.0, 1.0, 0.0);
    final FastQuaternion unitK = new FastQuaternion(0.0, 0.0, 0.0, 1.0);
    final String strH = "H";
    final String strV = "V";
    final String strD = "D";
    final String strMemH = "MemH";
    final String strMemV = "MemV";
    final String strP1 = "P1";
    final String strP2 = "P2";
    final int NEVER_VISIBLE = 0;
    final int NEWLY_VISIBLE = 1;
    final int OLDLY_VISIBLE = 2;
    FTCentral fTCentral_;
    private ParmFrame self_;
    FastQuaternion firstPerp_;
    FastQuaternion secondPerp_;
    FastQuaternion memH_;
    FastQuaternion memV_;
    double dAxisDegrees_ = 0.0;
    double wAxisDegrees_ = 0.0;
    private Dimension hVRatio_;
    static double RotateArbLNR_previousValue_ = 0.0;
    private JCheckBoxMenuItem loggingMI_;
    private JMenuItem saveAsFileMI_;
    private JMenuItem saveParamsFileMI_;
    private JMenuItem saveCountsCSVMI_;
    private JCheckBoxMenuItem userCommentMI_;
    private JCheckBoxMenuItem write2URLMI_;
    private JMenuItem trapMI_;
    private int ppp_ = 1;
    private int visibilityState_ = 0;
    private boolean dAndWUpdating_p_ = false;
    private boolean disableDMutualUpdating_p_ = false;
    private boolean disableWMutualUpdating_p_ = false;
    ArrayList<FastQuaternion> basics_ = new ArrayList<FastQuaternion>(List.of(new FastQuaternion(1.0, 0.0, 0.0, 0.0), new FastQuaternion(1.0, 1.0, 0.0, 0.0), new FastQuaternion(1.0, 1.0, 1.0, 0.0), new FastQuaternion(1.0, 1.0, 1.0, 1.0)));
    Label labelQ1_;
    Label labelQ2_;
    Label labelQ3_;
    Label formula_;
    LabeledTextField viewLTF;
    LabeledTextField widthLTF_;
    LabeledTextField heightLTF_;
    RatioTextActionListener hRatioLNR_;
    RatioTextActionListener vRatioLNR_;
    LabeledTextField depthLTF;
    LabeledTextField LoopsPerColorLTF;
    LabeledTextField panelsLTF;
    LabeledTextField hPanelLTF;
    LabeledTextField vPanelLTF;
    BigLabeledTextField Q1R;
    BigLabeledTextField Q1i;
    BigLabeledTextField Q1j;
    BigLabeledTextField Q1k;
    BigLabeledTextField Q2R;
    BigLabeledTextField Q2i;
    BigLabeledTextField Q2j;
    BigLabeledTextField Q2k;
    BigLabeledTextField Q3R;
    BigLabeledTextField Q3i;
    BigLabeledTextField Q3j;
    BigLabeledTextField Q3k;
    LabeledTextField HR;
    LabeledTextField Hi;
    LabeledTextField Hj;
    LabeledTextField Hk;
    LabeledTextField VR;
    LabeledTextField Vi;
    LabeledTextField Vj;
    LabeledTextField Vk;
    LabeledTextField DR;
    LabeledTextField Di;
    LabeledTextField Dj;
    LabeledTextField Dk;
    LabeledTextField WR;
    LabeledTextField Wi;
    LabeledTextField Wj;
    LabeledTextField Wk;
    TextField looperText_;
    LabeledTextField MHR;
    LabeledTextField MHi;
    LabeledTextField MHj;
    LabeledTextField MHk;
    LabeledTextField MVR;
    LabeledTextField MVi;
    LabeledTextField MVj;
    LabeledTextField MVk;
    Scrollbar dScrollbar_;
    TextField dText_;
    Scrollbar wScrollbar_;
    TextField wText_;
    Choice wLeft_;
    Choice wRight_;
    HVTextLNR hVAxisListener_ = null;
    JMenu windowsJMenu_ = null;
    JMenu scanOnMenu_ = null;
    private JCheckBoxMenuItem fastMI_;
    private JMenu interpolateColorsMenu_;
    private JCheckBoxMenuItem interpolOFF_;
    private JCheckBoxMenuItem interpolHSB_;
    private JCheckBoxMenuItem interpolRGB_;
    private JCheckBoxMenuItem Q1MI_;
    private JCheckBoxMenuItem Q2MI_;
    private JCheckBoxMenuItem Q3MI_;
    ButtonGroup interpolateButtonGroup_;
    ButtonGroup QButtonGroup_;

    public ParmFrame(FTCentral fTCentral) {
        super("Parameters");
        ArrayList<Component> arrayList = new ArrayList<Component>(45);
        this.fTCentral_ = fTCentral;
        this.self_ = this;
        this.addWindowListener(new MyWindowLNR());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        String string = "File";
        JMenu jMenu = new JMenu(string, true);
        JMenuItem jMenuItem = new JMenuItem("New Window");
        jMenuItem.addActionListener(new newFrameLNR("File->New Window"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Open FT Image...");
        jMenuItem2.addActionListener(new openFileLNR("File->Open FT Image..."));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Open FT Parms...");
        jMenuItem3.addActionListener(new openParmLNR("File->Open FT Parms..."));
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Open Log Entry...");
        jMenuItem4.addActionListener(new openLogLNR("File->Open Log Entry..."));
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Open Trap GIF...");
        jMenuItem5.addActionListener(new trapFileLNR("File->Open Trap GIF..."));
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        this.saveAsFileMI_ = new JMenuItem("Save Image...");
        this.saveAsFileMI_.addActionListener(new saveAsFileLNR("File->Save Image..."));
        this.saveAsFileMI_.setEnabled(false);
        jMenu.add(this.saveAsFileMI_);
        this.saveParamsFileMI_ = new JMenuItem("Save Params...");
        this.saveParamsFileMI_.addActionListener(new saveArgsFLNR("File->Save Params..."));
        this.saveParamsFileMI_.setEnabled(false);
        jMenu.add(this.saveParamsFileMI_);
        this.saveCountsCSVMI_ = new JMenuItem("Save Pixel Counts...");
        this.saveCountsCSVMI_.addActionListener(new saveCountsCSVLNR("File->Save Pixel Counts..."));
        this.saveCountsCSVMI_.setEnabled(true);
        jMenu.add(this.saveCountsCSVMI_);
        JMenuItem jMenuItem6 = new JMenuItem("Join Panels...");
        jMenuItem6.addActionListener(new JoinPanelsLNR("File->Join Panels..."));
        jMenuItem6.setEnabled(true);
        jMenu.add(jMenuItem6);
        jMenu.addSeparator();
        this.write2URLMI_ = new JCheckBoxMenuItem("IO to URL?");
        this.write2URLMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.write2URLMI_, "File->Use URL I/O?"));
        this.write2URLMI_.addActionListener(new write2URLLNR());
        this.write2URLMI_.setState(this.fTCentral_.write2URLP());
        jMenu.add(this.write2URLMI_);
        this.loggingMI_ = new JCheckBoxMenuItem("Logging?");
        this.loggingMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.loggingMI_, "Logging?"));
        this.loggingMI_.addActionListener(new loggingLNR());
        this.loggingMI_.setState(false);
        this.loggingMI_.setEnabled(true);
        jMenu.add(this.loggingMI_);
        this.userCommentMI_ = new JCheckBoxMenuItem("Comment on Save?");
        this.userCommentMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.userCommentMI_, "File->Comment on Save?"));
        this.userCommentMI_.addActionListener(new usrComLNR());
        this.userCommentMI_.setState(this.fTCentral_.userWantsToAddCOmmentP());
        this.userCommentMI_.setEnabled(true);
        jMenu.add(this.userCommentMI_);
        jMenu.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("Close");
        jMenuItem7.addActionListener(new closeLNR("File->Close"));
        jMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Quit");
        jMenuItem8.addActionListener(new quitLNR("File->Quit"));
        jMenuItem8.setEnabled(true);
        jMenu.add(jMenuItem8);
        JMenu jMenu2 = new JMenu("Draw", true);
        JMenuItem jMenuItem9 = new JMenuItem("Start");
        jMenuItem9.addActionListener(new startDrawLNR("Draw->Start"));
        jMenu2.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem("Pause");
        jMenuItem10.addActionListener(new stopDrawLNR("Draw->Pause"));
        jMenu2.add(jMenuItem10);
        JMenu jMenu3 = new JMenu("Settings", true);
        this.fastMI_ = new JCheckBoxMenuItem("Draw Fast Approximation?");
        this.fastMI_.setState(true);
        this.fastMI_.addActionListener(new DrawFastLNR());
        this.fastMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.fastMI_, "Settings->Draw Fast Approximation?"));
        jMenu3.add(this.fastMI_);
        JMenuItem jMenuItem11 = new JMenuItem("W/H Ratio...");
        jMenuItem11.addActionListener(new HVRatioLNR("Settings->W/H Ratio..."));
        jMenu3.add(jMenuItem11);
        this.interpolateColorsMenu_ = new JMenu("Interpolation OFF", false);
        jMenu3.add(this.interpolateColorsMenu_);
        this.interpolateButtonGroup_ = new ButtonGroup();
        this.interpolOFF_ = new JCheckBoxMenuItem("OFF");
        this.interpolOFF_.addActionListener(new interpolLNR("OFF"));
        this.interpolOFF_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolOFF_, "Settings->interpolOFF"));
        this.interpolateColorsMenu_.add(this.interpolOFF_);
        this.interpolHSB_ = new JCheckBoxMenuItem("HSB");
        this.interpolHSB_.addActionListener(new interpolLNR("HSB"));
        this.interpolHSB_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolHSB_, "Settings->interpolHSB"));
        this.interpolateColorsMenu_.add(this.interpolHSB_);
        this.interpolRGB_ = new JCheckBoxMenuItem("RGB");
        this.interpolRGB_.addActionListener(new interpolLNR("RGB"));
        this.interpolRGB_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolRGB_, "Settings->interpolRGB"));
        this.interpolateColorsMenu_.add(this.interpolRGB_);
        this.interpolateButtonGroup_.add(this.interpolOFF_);
        this.interpolateButtonGroup_.add(this.interpolHSB_);
        this.interpolateButtonGroup_.add(this.interpolRGB_);
        this.interpolateButtonGroup_.setSelected(this.interpolOFF_.getModel(), true);
        jMenu3.addSeparator();
        this.scanOnMenu_ = new JMenu("Scan On", true);
        jMenu3.add(this.scanOnMenu_);
        this.QButtonGroup_ = new ButtonGroup();
        this.Q1MI_ = new JCheckBoxMenuItem("Q1");
        this.Q1MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q1MI_, "Settings->Q1"));
        this.Q1MI_.addItemListener(new Q_LNR("Q1"));
        this.scanOnMenu_.add(this.Q1MI_);
        this.Q2MI_ = new JCheckBoxMenuItem("Q2");
        this.Q2MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q2MI_, "Settings->Q2"));
        this.Q2MI_.addItemListener(new Q_LNR("Q2"));
        this.scanOnMenu_.add(this.Q2MI_);
        this.Q3MI_ = new JCheckBoxMenuItem("Q3");
        this.Q3MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q3MI_, "Settings->Q3"));
        this.Q3MI_.addItemListener(new Q_LNR("Q3"));
        this.scanOnMenu_.add(this.Q3MI_);
        this.QButtonGroup_.add(this.Q1MI_);
        this.QButtonGroup_.add(this.Q2MI_);
        this.QButtonGroup_.add(this.Q3MI_);
        this.QButtonGroup_.setSelected(this.Q1MI_.getModel(), true);
        jMenu3.addSeparator();
        JMenuItem jMenuItem12 = new JMenuItem("Show Arguments");
        jMenuItem12.addActionListener(new dsplyParmsLNR("Settings->Show Arguments"));
        jMenu3.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem("Default Arguments");
        jMenuItem13.addActionListener(new defaultLNR("Loop->Default Arguments"));
        jMenu3.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem("Loop documentation");
        jMenuItem14.addActionListener(new docLNR("Loop->Loop documentation"));
        jMenu3.add(jMenuItem14);
        JMenu jMenu4 = new JMenu("Adjust", true);
        JMenuItem jMenuItem15 = new JMenuItem("Zoom...");
        jMenuItem15.addActionListener(new EnlargeLNR("Adjust->Zoom..."));
        jMenu4.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("Zoom again");
        jMenuItem16.addActionListener(new EnlrgAgnLNR("Adjust->Zoom again"));
        jMenu4.add(jMenuItem16);
        jMenu4.addSeparator();
        JMenuItem jMenuItem17 = new JMenuItem("Shift fractal LEFT (pixels)...");
        jMenuItem17.addActionListener(new RightLNR("Adjust->Shift fractal LEFT (pixels)..."));
        jMenu4.add(jMenuItem17);
        JMenuItem jMenuItem18 = new JMenuItem("Repeat LEFT shift");
        jMenuItem18.addActionListener(new RightAgnLNR("Adjust->Repeat LEFT shift"));
        jMenu4.add(jMenuItem18);
        JMenuItem jMenuItem19 = new JMenuItem("Shift fractal UP (pixels)...");
        jMenuItem19.addActionListener(new DownLNR("Adjust->Shift fractal UP (pixels)..."));
        jMenu4.add(jMenuItem19);
        JMenuItem jMenuItem20 = new JMenuItem("Repeat UP shift");
        jMenuItem20.addActionListener(new DownAgnLNR("Adjust->Repeat UP shift"));
        jMenu4.add(jMenuItem20);
        jMenu4.addSeparator();
        JMenuItem jMenuItem21 = new JMenuItem("W axis shift...");
        jMenuItem21.addActionListener(new OnWLNR("Adjust->W axis shift..."));
        jMenu4.add(jMenuItem21);
        JMenuItem jMenuItem22 = new JMenuItem("Repeat W axis shift");
        jMenuItem22.addActionListener(new OnWAgnLNR("Adjust->Repeat W axis shift"));
        jMenu4.add(jMenuItem22);
        JMenu jMenu5 = new JMenu("Axis", true);
        JMenuItem jMenuItem23 = new JMenuItem("H <=> V");
        jMenuItem23.addActionListener(new swapHVLNR("Axis->H <=> V"));
        jMenu5.add(jMenuItem23);
        JMenuItem jMenuItem24 = new JMenuItem("Rot. 90 left");
        jMenuItem24.addActionListener(new Rotate90LLNR("Axis->Rot. 90 left"));
        jMenu5.add(jMenuItem24);
        JMenuItem jMenuItem25 = new JMenuItem("Rot. 90 right");
        jMenuItem25.addActionListener(new Rotate90RLNR("Axis->Rot. 90 right"));
        jMenu5.add(jMenuItem25);
        JMenuItem jMenuItem26 = new JMenuItem("Rotate ...");
        jMenuItem26.addActionListener(new RotateArbLNR("Axis->Rotate ..."));
        jMenu5.add(jMenuItem26);
        jMenu5.addSeparator();
        JMenuItem jMenuItem27 = new JMenuItem("W => H");
        jMenuItem27.addActionListener(new W2HLNR("Axis->W => H"));
        jMenu5.add(jMenuItem27);
        JMenuItem jMenuItem28 = new JMenuItem("W => V");
        jMenuItem28.addActionListener(new W2VLNR("Axis->W => V"));
        jMenu5.add(jMenuItem28);
        jMenu5.addSeparator();
        JMenuItem jMenuItem29 = new JMenuItem("H => Mem H");
        jMenuItem29.addActionListener(new H2MemHLNR("Axis->H => Mem H"));
        jMenu5.add(jMenuItem29);
        JMenuItem jMenuItem30 = new JMenuItem("V => Mem V");
        jMenuItem30.addActionListener(new V2MemVLNR("Axis->V => Mem V"));
        jMenu5.add(jMenuItem30);
        JMenuItem jMenuItem31 = new JMenuItem("Mem H => H");
        jMenuItem31.addActionListener(new MemH2HLNR("Axis->Mem H => H"));
        jMenu5.add(jMenuItem31);
        JMenuItem jMenuItem32 = new JMenuItem("Mem V => V");
        jMenuItem32.addActionListener(new MemV2VLNR("Axis->Mem V => V"));
        jMenu5.add(jMenuItem32);
        jMenu5.addSeparator();
        JMenuItem jMenuItem33 = new JMenuItem("Mouse V-axis");
        jMenuItem33.addActionListener(new mouseV2LNR("Axis->Mouse V-axis"));
        jMenu5.add(jMenuItem33);
        JMenuItem jMenuItem34 = new JMenuItem("Mouse H-axis");
        jMenuItem34.addActionListener(new mouseH2LNR("Axis->Mouse H-axis"));
        jMenu5.add(jMenuItem34);
        this.windowsJMenu_ = new JMenu("Windows", true);
        JMenuItem jMenuItem35 = new JMenuItem("Color Set Editor");
        jMenuItem35.addActionListener(new ColorMapLNR("Windows->Color Set Editor"));
        this.windowsJMenu_.add(jMenuItem35);
        JMenuItem jMenuItem36 = new JMenuItem("Message Window");
        jMenuItem36.addActionListener(new MsgLNR("Windows->Message Window"));
        this.windowsJMenu_.add(jMenuItem36);
        this.trapMI_ = new JMenuItem("Trap GIF Window");
        this.trapMI_.addActionListener(new TrapLNR("Windows->Trap GIF Window"));
        this.windowsJMenu_.add(this.trapMI_);
        this.windowsJMenu_.addSeparator();
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        jMenuItem35.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        jMenuItem36.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.saveAsFileMI_.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        jMenuBar.add(this.windowsJMenu_);
        this.setLayout(new GridLayout(4, 1, 5, 5));
        Panel panel = new Panel();
        this.add(panel);
        panel.setLayout(new GridLayout(2, 1, 0, 0));
        Panel panel2 = new Panel();
        panel.add(panel2);
        panel2.setLayout(new GridLayout(1, 4, 0, 0));
        Panel panel3 = new Panel();
        panel.add(panel3);
        panel3.setLayout(new GridLayout(1, 4, 0, 0));
        this.depthLTF = new LabeledTextField("Depth", 0, 2);
        panel2.add(this.depthLTF);
        this.viewLTF = new LabeledTextField("Horiz. View", 1, 2);
        panel2.add(this.viewLTF);
        this.hVRatio_ = new Dimension(-1, -1);
        this.hRatioLNR_ = new RatioTextActionListener(this.hVRatio_, true, true);
        this.vRatioLNR_ = new RatioTextActionListener(this.hVRatio_, false, true);
        this.widthLTF_ = new LabeledTextField("Width in pixels", 0, 2);
        panel2.add(this.widthLTF_);
        this.heightLTF_ = new LabeledTextField("Height in pixels", 0, 2);
        panel2.add(this.heightLTF_);
        this.hRatioLNR_.setOthers(this.heightLTF_, this.vRatioLNR_);
        this.vRatioLNR_.setOthers(this.widthLTF_, this.hRatioLNR_);
        this.widthLTF_.addTextListener(this.hRatioLNR_);
        this.heightLTF_.addTextListener(this.vRatioLNR_);
        this.LoopsPerColorLTF = new LabeledTextField("Loops/Color", 1, 2);
        panel3.add(this.LoopsPerColorLTF);
        this.panelsLTF = new LabeledTextField("Panels on a side", 0, 2);
        panel3.add(this.panelsLTF);
        this.hPanelLTF = new LabeledTextField("Panel Horiz. Coord.", 0, 2);
        this.vPanelLTF = new LabeledTextField("Panel Vert. Coord.", 0, 2);
        panel3.add(this.vPanelLTF);
        panel3.add(this.hPanelLTF);
        arrayList.add(this.viewLTF);
        arrayList.add(this.widthLTF_);
        arrayList.add(this.heightLTF_);
        arrayList.add(this.depthLTF);
        arrayList.add(this.LoopsPerColorLTF);
        arrayList.add(this.panelsLTF);
        arrayList.add(this.hPanelLTF);
        arrayList.add(this.vPanelLTF);
        Panel panel4 = new Panel();
        this.add(panel4);
        panel4.setLayout(new GridLayout(4, 1, 0, 0));
        this.formula_ = new Label("*", 1);
        this.formula_.addMouseListener(new DocuMouseListener("Formula"));
        panel4.add(this.formula_);
        Panel panel5 = new Panel();
        panel4.add(panel5);
        panel5.setLayout(new GridLayout(1, 5, 0, 0));
        Panel panel6 = new Panel();
        panel4.add(panel6);
        panel6.setLayout(new GridLayout(1, 5, 0, 0));
        Panel panel7 = new Panel();
        panel4.add(panel7);
        panel7.setLayout(new GridLayout(1, 5, 0, 0));
        this.labelQ1_ = new Label("Q1", 1);
        panel5.add(this.labelQ1_);
        this.labelQ2_ = new Label("Q2", 1);
        panel6.add(this.labelQ2_);
        this.labelQ3_ = new Label("Q3", 1);
        panel7.add(this.labelQ3_);
        this.labelQ1_.addMouseListener(new DocuMouseListener("Z(0)"));
        this.labelQ2_.addMouseListener(new DocuMouseListener("Coefficient"));
        this.labelQ3_.addMouseListener(new DocuMouseListener("Translation"));
        this.Q1R = new BigLabeledTextField();
        this.Q1i = new BigLabeledTextField();
        this.Q1j = new BigLabeledTextField();
        this.Q1k = new BigLabeledTextField();
        this.Q2R = new BigLabeledTextField();
        this.Q2i = new BigLabeledTextField();
        this.Q2j = new BigLabeledTextField();
        this.Q2k = new BigLabeledTextField();
        this.Q3R = new BigLabeledTextField();
        this.Q3i = new BigLabeledTextField();
        this.Q3j = new BigLabeledTextField();
        this.Q3k = new BigLabeledTextField();
        panel5.add(this.Q1R);
        panel5.add(this.Q1i);
        panel5.add(this.Q1j);
        panel5.add(this.Q1k);
        panel6.add(this.Q2R);
        panel6.add(this.Q2i);
        panel6.add(this.Q2j);
        panel6.add(this.Q2k);
        panel7.add(this.Q3R);
        panel7.add(this.Q3i);
        panel7.add(this.Q3j);
        panel7.add(this.Q3k);
        arrayList.add(this.Q1R);
        arrayList.add(this.Q1i);
        arrayList.add(this.Q1j);
        arrayList.add(this.Q1k);
        arrayList.add(this.Q2R);
        arrayList.add(this.Q2i);
        arrayList.add(this.Q2j);
        arrayList.add(this.Q2k);
        arrayList.add(this.Q3R);
        arrayList.add(this.Q3i);
        arrayList.add(this.Q3j);
        arrayList.add(this.Q3k);
        Panel panel8 = new Panel();
        this.add(panel8);
        panel8.setLayout(new GridLayout(4, 1, 0, 0));
        Panel panel9 = new Panel();
        panel8.add(panel9);
        panel9.setLayout(new BorderLayout(0, 3));
        Label label = new Label("Loop Name", 1);
        panel9.add("West", label);
        label.addMouseListener(new DocuMouseListener("Loop Name"));
        arrayList.add(label);
        this.looperText_ = new WatchedText("Mandelbrot", 40, "looperText_");
        panel9.add("Center", this.looperText_);
        arrayList.add(this.looperText_);
        Panel panel10 = new Panel();
        panel8.add(panel10);
        panel10.setLayout(new GridLayout(1, 5, 0, 0));
        Panel panel11 = new Panel();
        panel8.add(panel11);
        panel11.setLayout(new GridLayout(1, 5, 0, 0));
        Panel panel12 = new Panel();
        panel8.add(panel12);
        panel12.setLayout(new GridLayout(1, 5, 0, 0));
        label = new Label("H Axis", 1);
        panel10.add(label);
        label.addMouseListener(new DocuMouseListener("H Axis"));
        arrayList.add(label);
        label = new Label("V Axis", 1);
        panel11.add(label);
        label.addMouseListener(new DocuMouseListener("V Axis"));
        arrayList.add(label);
        label = new Label("D Axis", 1);
        panel12.add(label);
        label.addMouseListener(new DocuMouseListener("D Axis"));
        arrayList.add(label);
        this.HR = new LabeledTextField("", 1, 3);
        this.Hi = new LabeledTextField("", 1, 3);
        this.Hj = new LabeledTextField("", 1, 3);
        this.Hk = new LabeledTextField("", 1, 3);
        this.VR = new LabeledTextField("", 1, 3);
        this.Vi = new LabeledTextField("", 1, 3);
        this.Vj = new LabeledTextField("", 1, 3);
        this.Vk = new LabeledTextField("", 1, 3);
        this.DR = new LabeledTextField("", 1, 3);
        this.Di = new LabeledTextField("", 1, 3);
        this.Dj = new LabeledTextField("", 1, 3);
        this.Dk = new LabeledTextField("", 1, 3);
        panel10.add(this.HR);
        panel10.add(this.Hi);
        panel10.add(this.Hj);
        panel10.add(this.Hk);
        panel11.add(this.VR);
        panel11.add(this.Vi);
        panel11.add(this.Vj);
        panel11.add(this.Vk);
        panel12.add(this.DR);
        panel12.add(this.Di);
        panel12.add(this.Dj);
        panel12.add(this.Dk);
        arrayList.add(this.HR);
        arrayList.add(this.Hi);
        arrayList.add(this.Hj);
        arrayList.add(this.Hk);
        arrayList.add(this.VR);
        arrayList.add(this.Vi);
        arrayList.add(this.Vj);
        arrayList.add(this.Vk);
        arrayList.add(this.DR);
        arrayList.add(this.Di);
        arrayList.add(this.Dj);
        arrayList.add(this.Dk);
        this.listenToHAndVAxes(true);
        Panel panel13 = new Panel();
        this.add(panel13);
        panel13.setLayout(new GridLayout(4, 1, 0, 0));
        Panel panel14 = new Panel();
        panel13.add(panel14);
        panel14.setLayout(new BorderLayout(0, 3));
        label = new Label(" Set D Axis  ", 1);
        panel14.add("West", label);
        label.addMouseListener(new DocuMouseListener("Set D Axis"));
        arrayList.add(label);
        this.dScrollbar_ = new Scrollbar(0, 0, 10, 0, 359);
        this.dScrollbar_.addAdjustmentListener(new ScrollLNR());
        this.dText_ = new WatchedText("0", 3, "dText_");
        this.dText_.addTextListener(new DTextLNR());
        arrayList.add(this.dText_);
        panel14.add("East", this.dText_);
        panel14.add("Center", this.dScrollbar_);
        Panel panel15 = new Panel();
        panel13.add(panel15);
        panel15.setLayout(new GridLayout(1, 5, 0, 0));
        label = new Label("W", 1);
        panel15.add(label);
        label.addMouseListener(new DocuMouseListener("W"));
        arrayList.add(label);
        this.WR = new LabeledTextField("", 1, 3);
        this.Wi = new LabeledTextField("", 1, 3);
        this.Wj = new LabeledTextField("", 1, 3);
        this.Wk = new LabeledTextField("", 1, 3);
        panel15.add(this.WR);
        panel15.add(this.Wi);
        panel15.add(this.Wj);
        panel15.add(this.Wk);
        arrayList.add(this.WR);
        arrayList.add(this.Wi);
        arrayList.add(this.Wj);
        arrayList.add(this.Wk);
        Panel panel16 = new Panel();
        panel13.add(panel16);
        panel16.setLayout(new BorderLayout(0, 3));
        label = new Label(" Set W Axis  ", 1);
        panel16.add("West", label);
        label.addMouseListener(new DocuMouseListener("Set W Axis"));
        arrayList.add(label);
        this.wScrollbar_ = new Scrollbar(0, 0, 10, 0, 359);
        this.wScrollbar_.addAdjustmentListener(new WScrollLNR());
        this.wText_ = new WatchedText("0", 3, "wText_");
        this.wText_.addTextListener(new WTextLNR());
        arrayList.add(this.wText_);
        panel16.add("East", this.wText_);
        panel16.add("Center", this.wScrollbar_);
        Panel panel17 = new Panel();
        panel13.add(panel17);
        panel17.setLayout(new GridLayout(1, 4, 0, 0));
        this.wLeft_ = new Choice();
        this.wRight_ = new Choice();
        arrayList.add(this.wLeft_);
        arrayList.add(this.wRight_);
        this.wLeft_.add("H");
        this.wRight_.add("H");
        this.wLeft_.add("V");
        this.wRight_.add("V");
        this.wLeft_.add("D");
        this.wRight_.add("D");
        this.wLeft_.add("MemH");
        this.wRight_.add("MemH");
        this.wLeft_.add("MemV");
        this.wRight_.add("MemV");
        this.wLeft_.add("P1");
        this.wRight_.add("P1");
        this.wLeft_.add("P2");
        this.wRight_.add("P2");
        this.wLeft_.select(2);
        ChoiceLNR choiceLNR = new ChoiceLNR();
        this.wLeft_.addItemListener(choiceLNR);
        this.wRight_.addItemListener(choiceLNR);
        label = new Label("W at 0", 1);
        panel17.add(label);
        label.addMouseListener(new DocuMouseListener("W at 0"));
        arrayList.add(label);
        panel17.add(this.wLeft_);
        label = new Label("W at 90", 1);
        panel17.add(label);
        label.addMouseListener(new DocuMouseListener("W at 90"));
        arrayList.add(label);
        panel17.add(this.wRight_);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 10);
        fontSetter.setComponentFonts(arrayList);
        this.firstPerp_ = new FastQuaternion();
        this.secondPerp_ = new FastQuaternion();
        this.memH_ = new FastQuaternion();
        this.memV_ = new FastQuaternion();
        FTLooper fTLooper = this.fTCentral_.findLoopObject("Mandelbrot");
        if (fTLooper != null) {
            this.setLoopersLabels(fTLooper);
            this.setLooperDefaults(fTLooper);
        }
        this.setSize(800, 355);
        this.setResizable(false);
        this.validate();
        this.wLeft_.select(5);
        this.wRight_.select(6);
        this.wText_.setText("90");
        this.wScrollbar_.setValue(90);
        this.dText_.setText("0");
        this.dScrollbar_.setValue(0);
    }

    public void addToWindowsMenu(FTWindow fTWindow) {
        MenuItemWithNumber menuItemWithNumber = new MenuItemWithNumber(fTWindow.frameNumber());
        menuItemWithNumber.addActionListener(new WindowToFrontLNR(fTWindow));
        this.windowsJMenu_.add(menuItemWithNumber);
    }

    public void removeFromWindowMenu(int n) {
        int n2 = -1;
        for (int i = 0; i < this.windowsJMenu_.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.windowsJMenu_.getItem(i);
            if (!(jMenuItem instanceof MenuItemWithNumber) || ((MenuItemWithNumber)jMenuItem).getNumber() != n) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.windowsJMenu_.remove(n2);
        } else {
            FTCentral.message("Error on ParmFrame.removeFromWindowMenu - nothing found", true);
        }
    }

    public String getParmFrameLooperName() {
        return this.looperText_.getText();
    }

    public void setDAndWUpdating(boolean bl) {
        this.dAndWUpdating_p_ = bl;
    }

    private void listenToHAndVAxes(boolean bl) {
        if (bl) {
            this.HR.addTextListener(this.hVAxisListener_);
            this.Hi.addTextListener(this.hVAxisListener_);
            this.Hj.addTextListener(this.hVAxisListener_);
            this.Hk.addTextListener(this.hVAxisListener_);
            this.VR.addTextListener(this.hVAxisListener_);
            this.Vi.addTextListener(this.hVAxisListener_);
            this.Vj.addTextListener(this.hVAxisListener_);
            this.Vk.addTextListener(this.hVAxisListener_);
        } else {
            this.HR.removeTextListener(this.hVAxisListener_);
            this.Hi.removeTextListener(this.hVAxisListener_);
            this.Hj.removeTextListener(this.hVAxisListener_);
            this.Hk.removeTextListener(this.hVAxisListener_);
            this.VR.removeTextListener(this.hVAxisListener_);
            this.Vi.removeTextListener(this.hVAxisListener_);
            this.Vj.removeTextListener(this.hVAxisListener_);
            this.Vk.removeTextListener(this.hVAxisListener_);
        }
    }

    public void setHVRatio(Dimension dimension) {
        double d;
        this.hVRatio_.setSize(dimension);
        if (!RatioDialog.offP(dimension) && (d = (double)this.widthLTF_.intValue()) > 0.0) {
            double d2 = this.hVRatio_.getWidth() / this.hVRatio_.getHeight();
            double d3 = d / d2;
            this.vRatioLNR_.setDisabled(true);
            this.heightLTF_.setText(String.valueOf((int)Math.round(d3)));
        }
    }

    public Dimension getHVRatio() {
        return new Dimension(this.hVRatio_);
    }

    public void setPanelFields(int n, int n2, int n3) {
        this.panelsLTF.setText(String.valueOf(n));
        this.hPanelLTF.setText(String.valueOf(n2));
        this.vPanelLTF.setText(String.valueOf(n3));
    }

    public void setRange(double d) {
        this.viewLTF.setText(String.valueOf(d));
    }

    public int numberOfPanels() {
        if (this.panelsLTF.valueOk_p()) {
            return this.panelsLTF.intValue();
        }
        return 0;
    }

    public int pixelsWide() {
        if (this.widthLTF_.valueOk_p()) {
            return this.widthLTF_.intValue();
        }
        return 0;
    }

    public int pixelsHigh() {
        if (this.heightLTF_.valueOk_p()) {
            return this.heightLTF_.intValue();
        }
        return 0;
    }

    public void scaleVAxis(double d) {
        if (this.vAxesOkp() && d != 0.0) {
            FastQuaternion fastQuaternion = this.vAxis();
            fastQuaternion.times_scalar_n(d);
            this.displayAsVAxis(fastQuaternion);
        }
    }

    public void setLoopersLabels(FTLooper fTLooper) {
        this.labelQ1_.setText(fTLooper.q1String());
        this.labelQ2_.setText(fTLooper.q2String());
        this.labelQ3_.setText(fTLooper.q3String());
        this.formula_.setText(fTLooper.formulaString());
    }

    public void setLooperDefaults(FTLooper fTLooper) {
        FastQuaternion fastQuaternion = fTLooper.q1Init();
        this.Q1R.setValue(fastQuaternion.r);
        this.Q1i.setValue(fastQuaternion.i);
        this.Q1j.setValue(fastQuaternion.j);
        this.Q1k.setValue(fastQuaternion.k);
        fastQuaternion = fTLooper.q2Init();
        this.Q2R.setValue(fastQuaternion.r);
        this.Q2i.setValue(fastQuaternion.i);
        this.Q2j.setValue(fastQuaternion.j);
        this.Q2k.setValue(fastQuaternion.k);
        fastQuaternion = fTLooper.q3Init();
        this.Q3R.setValue(fastQuaternion.r);
        this.Q3i.setValue(fastQuaternion.i);
        this.Q3j.setValue(fastQuaternion.j);
        this.Q3k.setValue(fastQuaternion.k);
        this.depthLTF.setText(String.valueOf(fTLooper.depthInit()));
        this.LoopsPerColorLTF.setText(String.valueOf(fTLooper.loopsPerColorInit()));
        this.viewLTF.setText(String.valueOf(fTLooper.rangeInit()));
    }

    public void importFractalSpec(FractalSpec fractalSpec) {
        fractalSpec.setNecessaryPrecision();
        this.listenToHAndVAxes(false);
        this.viewLTF.setText(String.valueOf(fractalSpec.range));
        this.widthLTF_.setText(String.valueOf(fractalSpec.pix_width));
        this.heightLTF_.setText(String.valueOf(fractalSpec.pix_height));
        this.depthLTF.setText(String.valueOf(fractalSpec.depth));
        this.LoopsPerColorLTF.setText(String.valueOf(fractalSpec.loops_per_color));
        this.panelsLTF.setText(String.valueOf(fractalSpec.panels));
        this.hPanelLTF.setText(String.valueOf(fractalSpec.panel_x));
        this.vPanelLTF.setText(String.valueOf(fractalSpec.panel_y));
        this.Q1R.setValue(fractalSpec.center.r);
        this.Q1i.setValue(fractalSpec.center.i);
        this.Q1j.setValue(fractalSpec.center.j);
        this.Q1k.setValue(fractalSpec.center.k);
        this.Q2R.setValue(fractalSpec.coeff.r);
        this.Q2i.setValue(fractalSpec.coeff.i);
        this.Q2j.setValue(fractalSpec.coeff.j);
        this.Q2k.setValue(fractalSpec.coeff.k);
        this.Q3R.setValue(fractalSpec.trans.r);
        this.Q3i.setValue(fractalSpec.trans.i);
        this.Q3j.setValue(fractalSpec.trans.j);
        this.Q3k.setValue(fractalSpec.trans.k);
        this.HR.setText(fractalSpec.vx.rToString());
        this.Hi.setText(fractalSpec.vx.iToString());
        this.Hj.setText(fractalSpec.vx.jToString());
        this.Hk.setText(fractalSpec.vx.kToString());
        this.VR.setText(fractalSpec.vy.rToString());
        this.Vi.setText(fractalSpec.vy.iToString());
        this.Vj.setText(fractalSpec.vy.jToString());
        this.Vk.setText(fractalSpec.vy.kToString());
        this.setFirstAndSecondPerpendiculars();
        this.DR.setText(fractalSpec.vz.rToString());
        this.Di.setText(fractalSpec.vz.iToString());
        this.Dj.setText(fractalSpec.vz.jToString());
        this.Dk.setText(fractalSpec.vz.kToString());
        this.importFlags(fractalSpec);
        this.importWhatsDrawn(fractalSpec);
        this.updateDandWforNewD();
        this.listenToHAndVAxes(true);
    }

    public boolean importLooper(String string) {
        this.looperText_.setText(string);
        FTLooper fTLooper = this.fTCentral_.findLoopObject(string);
        if (fTLooper != null) {
            this.setLoopersLabels(fTLooper);
            return true;
        }
        return false;
    }

    private boolean normalizeHandVAxes() {
        try {
            FastQuaternion fastQuaternion = new FastQuaternion(this.HR.doubleValue(), this.Hi.doubleValue(), this.Hj.doubleValue(), this.Hk.doubleValue());
            fastQuaternion.normalize_n();
            this.HR.setText(fastQuaternion.rToString());
            this.Hi.setText(fastQuaternion.iToString());
            this.Hj.setText(fastQuaternion.jToString());
            this.Hk.setText(fastQuaternion.kToString());
            FastQuaternion fastQuaternion2 = new FastQuaternion(this.VR.doubleValue(), this.Vi.doubleValue(), this.Vj.doubleValue(), this.Vk.doubleValue());
            fastQuaternion2.normalize_n();
            fastQuaternion2 = fastQuaternion2.orthogonal_component_to(fastQuaternion);
            if (fastQuaternion2.magnitude() == 0.0) {
                FastQuaternion fastQuaternion3;
                Iterator<FastQuaternion> iterator = this.basics_.iterator();
                while (iterator.hasNext() && (fastQuaternion2 = (fastQuaternion3 = iterator.next()).orthogonal_component_to(fastQuaternion)).magnitude() == 0.0) {
                }
            }
            this.VR.setText(fastQuaternion2.rToString());
            this.Vi.setText(fastQuaternion2.iToString());
            this.Vj.setText(fastQuaternion2.jToString());
            this.Vk.setText(fastQuaternion2.kToString());
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private boolean valuesOk_p() {
        boolean bl = this.viewLTF.valueOk_p() && this.widthLTF_.valueOk_p() && this.heightLTF_.valueOk_p() && this.depthLTF.valueOk_p() && this.LoopsPerColorLTF.valueOk_p() && this.panelsLTF.valueOk_p() && this.hPanelLTF.valueOk_p() && this.vPanelLTF.valueOk_p() && this.Q1R.valueOk_p() && this.Q1i.valueOk_p() && this.Q1j.valueOk_p() && this.Q1k.valueOk_p() && this.Q2R.valueOk_p() && this.Q2i.valueOk_p() && this.Q2j.valueOk_p() && this.Q2k.valueOk_p() && this.Q3R.valueOk_p() && this.Q3i.valueOk_p() && this.Q3j.valueOk_p() && this.Q3k.valueOk_p() && this.HR.valueOk_p() && this.Hi.valueOk_p() && this.Hj.valueOk_p() && this.Hk.valueOk_p() && this.VR.valueOk_p() && this.Vi.valueOk_p() && this.Vj.valueOk_p() && this.Vk.valueOk_p() && this.DR.valueOk_p() && this.Di.valueOk_p() && this.Dj.valueOk_p() && this.Dk.valueOk_p();
        return bl && this.normalizeHandVAxes();
    }

    private boolean hAndVAxesOkp() {
        return this.HR.valueOk_p() && this.Hi.valueOk_p() && this.Hj.valueOk_p() && this.Hk.valueOk_p() && this.VR.valueOk_p() && this.Vi.valueOk_p() && this.Vj.valueOk_p() && this.Vk.valueOk_p() && this.normalizeHandVAxes();
    }

    private boolean vAxesOkp() {
        return this.VR.valueOk_p() && this.Vi.valueOk_p() && this.Vj.valueOk_p() && this.Vk.valueOk_p();
    }

    public void setCheckBoxValues(FractalSpec fractalSpec) {
        this.importFlags(fractalSpec);
        this.importLooper(fractalSpec.which);
    }

    public void importFlags(FractalSpec fractalSpec) {
        this.setEnableSaveMenus(this.fTCentral_.activeCanvasEverFinishedP());
        this.fastMI_.setState(!fractalSpec.hifi_p);
        this.setHVRatio(fractalSpec.wHRatio_);
        if (fractalSpec.interpolateColors == 0) {
            this.interpolateButtonGroup_.setSelected(this.interpolOFF_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: OFF");
        } else if (fractalSpec.interpolateColors == 1) {
            this.interpolateButtonGroup_.setSelected(this.interpolHSB_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: HSB");
        } else if (fractalSpec.interpolateColors == 2) {
            this.interpolateButtonGroup_.setSelected(this.interpolRGB_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: RGB");
        }
    }

    public void importWhatsDrawn(FractalSpec fractalSpec) {
        if (fractalSpec.rangeOver == 0) {
            this.QButtonGroup_.setSelected(this.Q1MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q1");
        } else if (fractalSpec.rangeOver == 1) {
            this.QButtonGroup_.setSelected(this.Q2MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q2");
        } else if (fractalSpec.rangeOver == 2) {
            this.QButtonGroup_.setSelected(this.Q3MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q3");
        }
        this.importLooper(fractalSpec.which);
    }

    public Dimension exportWH() {
        return new Dimension(this.widthLTF_.intValue(), this.heightLTF_.intValue());
    }

    public void getCheckBoxValues(FractalSpec fractalSpec) {
        this.exportFlags(fractalSpec);
        String string = this.looperText_.getText();
        if (string != null && string.length() >= 1) {
            fractalSpec.which = string;
        } else {
            this.looperText_.setText(fractalSpec.which);
        }
    }

    public void exportWhatsDrawn(FractalSpec fractalSpec) {
        ButtonModel buttonModel = this.QButtonGroup_.getSelection();
        if (buttonModel == this.Q1MI_.getModel()) {
            fractalSpec.rangeOver = 0;
        } else if (buttonModel == this.Q2MI_.getModel()) {
            fractalSpec.rangeOver = 1;
        } else if (buttonModel == this.Q3MI_.getModel()) {
            fractalSpec.rangeOver = 2;
        }
        String string = this.looperText_.getText();
        if (string != null && string.length() >= 1) {
            fractalSpec.which = string;
        } else {
            this.looperText_.setText(fractalSpec.which);
        }
    }

    public void exportFlags(FractalSpec fractalSpec) {
        fractalSpec.hifi_p = !this.fastMI_.getState();
        fractalSpec.wHRatio_ = new Dimension(this.hVRatio_);
        ButtonModel buttonModel = this.interpolateButtonGroup_.getSelection();
        if (buttonModel == this.interpolOFF_.getModel()) {
            fractalSpec.interpolateColors = 0;
        } else if (buttonModel == this.interpolHSB_.getModel()) {
            fractalSpec.interpolateColors = 1;
        } else if (buttonModel == this.interpolRGB_.getModel()) {
            fractalSpec.interpolateColors = 2;
        }
    }

    public void setEnableSaveMenus(boolean bl) {
        this.saveAsFileMI_.setEnabled(bl);
        this.saveParamsFileMI_.setEnabled(bl);
    }

    public boolean exportToSpec(FractalSpec fractalSpec) {
        if (this.valuesOk_p()) {
            this.exportFlags(fractalSpec);
            this.exportWhatsDrawn(fractalSpec);
            double d = this.widthLTF_.intValue();
            double d2 = this.heightLTF_.intValue();
            if (!RatioDialog.offP(this.hVRatio_)) {
                double d3 = Math.sqrt(d * d2 / (double)((float)this.hVRatio_.width * (float)this.hVRatio_.height));
                fractalSpec.pix_width = this.hVRatio_.width * (int)Math.round(d3);
                fractalSpec.pix_height = this.hVRatio_.height * (int)Math.round(d3);
                this.widthLTF_.setText(String.valueOf(fractalSpec.pix_width));
                this.heightLTF_.setText(String.valueOf(fractalSpec.pix_height));
            } else {
                fractalSpec.pix_width = this.widthLTF_.intValue();
                fractalSpec.pix_height = this.heightLTF_.intValue();
            }
            fractalSpec.range = this.viewLTF.doubleValue();
            fractalSpec.depth = this.depthLTF.intValue();
            fractalSpec.loops_per_color = this.LoopsPerColorLTF.doubleValue();
            fractalSpec.panels = this.panelsLTF.intValue();
            fractalSpec.panel_x = this.hPanelLTF.intValue();
            fractalSpec.panel_y = this.vPanelLTF.intValue();
            fractalSpec.center.setR(this.Q1R.fractionValue());
            fractalSpec.center.setI(this.Q1i.fractionValue());
            fractalSpec.center.setJ(this.Q1j.fractionValue());
            fractalSpec.center.setK(this.Q1k.fractionValue());
            fractalSpec.coeff.setR(this.Q2R.fractionValue());
            fractalSpec.coeff.setI(this.Q2i.fractionValue());
            fractalSpec.coeff.setJ(this.Q2j.fractionValue());
            fractalSpec.coeff.setK(this.Q2k.fractionValue());
            fractalSpec.trans.setR(this.Q3R.fractionValue());
            fractalSpec.trans.setI(this.Q3i.fractionValue());
            fractalSpec.trans.setJ(this.Q3j.fractionValue());
            fractalSpec.trans.setK(this.Q3k.fractionValue());
            fractalSpec.vx.setR(this.HR.doubleValue());
            fractalSpec.vx.setI(this.Hi.doubleValue());
            fractalSpec.vx.setJ(this.Hj.doubleValue());
            fractalSpec.vx.setK(this.Hk.doubleValue());
            fractalSpec.vy.setR(this.VR.doubleValue());
            fractalSpec.vy.setI(this.Vi.doubleValue());
            fractalSpec.vy.setJ(this.Vj.doubleValue());
            fractalSpec.vy.setK(this.Vk.doubleValue());
            fractalSpec.vz.setR(this.DR.doubleValue());
            fractalSpec.vz.setI(this.Di.doubleValue());
            fractalSpec.vz.setJ(this.Dj.doubleValue());
            fractalSpec.vz.setK(this.Dk.doubleValue());
            fractalSpec.setNecessaryPrecision();
            return true;
        }
        return false;
    }

    private FastQuaternion hAxis() {
        return new FastQuaternion(this.HR.doubleValue(), this.Hi.doubleValue(), this.Hj.doubleValue(), this.Hk.doubleValue());
    }

    private FastQuaternion vAxis() {
        return new FastQuaternion(this.VR.doubleValue(), this.Vi.doubleValue(), this.Vj.doubleValue(), this.Vk.doubleValue());
    }

    private void displayAsHAxis(FastQuaternion fastQuaternion) {
        this.listenToHAndVAxes(false);
        this.HR.setText(String.valueOf(fastQuaternion.r));
        this.Hi.setText(String.valueOf(fastQuaternion.i));
        this.Hj.setText(String.valueOf(fastQuaternion.j));
        this.Hk.setText(String.valueOf(fastQuaternion.k));
        this.listenToHAndVAxes(true);
    }

    private void displayAsVAxis(FastQuaternion fastQuaternion) {
        this.listenToHAndVAxes(false);
        this.VR.setText(String.valueOf(fastQuaternion.r));
        this.Vi.setText(String.valueOf(fastQuaternion.i));
        this.Vj.setText(String.valueOf(fastQuaternion.j));
        this.Vk.setText(String.valueOf(fastQuaternion.k));
        this.listenToHAndVAxes(true);
    }

    public void setHandVAxes(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2) {
        this.listenToHAndVAxes(false);
        this.HR.setText(String.valueOf(fastQuaternion.r));
        this.Hi.setText(String.valueOf(fastQuaternion.i));
        this.Hj.setText(String.valueOf(fastQuaternion.j));
        this.Hk.setText(String.valueOf(fastQuaternion.k));
        this.VR.setText(String.valueOf(fastQuaternion2.r));
        this.Vi.setText(String.valueOf(fastQuaternion2.i));
        this.Vj.setText(String.valueOf(fastQuaternion2.j));
        this.Vk.setText(String.valueOf(fastQuaternion2.k));
        this.listenToHAndVAxes(true);
    }

    private boolean setFirstAndSecondPerpendiculars() {
        if (!this.hAndVAxesOkp()) {
            return true;
        }
        FastQuaternion fastQuaternion = this.hAxis();
        FastQuaternion fastQuaternion2 = this.vAxis();
        boolean bl = false;
        FastQuaternion fastQuaternion3 = null;
        for (FastQuaternion object : this.basics_) {
            fastQuaternion3 = object.orthogonal_component_to(fastQuaternion);
            if ((fastQuaternion3 = fastQuaternion3.orthogonal_component_to(fastQuaternion2)).magnitude() == 0.0) continue;
            break;
        }
        if (!this.firstPerp_.equals(fastQuaternion3)) {
            bl = true;
        }
        this.firstPerp_.assign_from(fastQuaternion3);
        Object object = null;
        for (FastQuaternion fastQuaternion4 : this.basics_) {
            object = fastQuaternion4.orthogonal_component_to(fastQuaternion3);
            object = ((FastQuaternion)object).orthogonal_component_to(fastQuaternion2);
            if (((FastQuaternion)(object = ((FastQuaternion)object).orthogonal_component_to(fastQuaternion))).magnitude() == 0.0) continue;
            break;
        }
        if (!this.secondPerp_.equals((FastQuaternion)object)) {
            bl = true;
        }
        this.secondPerp_.assign_from((FastQuaternion)object);
        return bl;
    }

    private boolean rotateBetweenPerpendiculars() {
        if (this.setDAxisDegrees()) {
            this.displayAsDAxis(FastQuaternion.rotate(this.dAxisDegrees_, this.firstPerp_, this.secondPerp_));
            return this.setWDisplay(null);
        }
        return true;
    }

    private boolean setDAxisDegrees() {
        try {
            this.dAxisDegrees_ = Double.valueOf(this.dText_.getText());
        }
        catch (Throwable throwable) {
            this.dText_.setForeground(Color.red);
            return false;
        }
        return true;
    }

    private void displayAsDAxis(FastQuaternion fastQuaternion) {
        this.DR.setText(String.valueOf(fastQuaternion.r));
        this.Di.setText(String.valueOf(fastQuaternion.i));
        this.Dj.setText(String.valueOf(fastQuaternion.j));
        this.Dk.setText(String.valueOf(fastQuaternion.k));
    }

    private boolean dTextOkp() {
        return this.DR.valueOk_p() && this.Di.valueOk_p() && this.Dj.valueOk_p() && this.Dk.valueOk_p();
    }

    public FastQuaternion dAxis() {
        if (this.dTextOkp()) {
            return new FastQuaternion(this.DR.doubleValue(), this.Di.doubleValue(), this.Dj.doubleValue(), this.Dk.doubleValue());
        }
        return new FastQuaternion();
    }

    private void displayAsWAxis(FastQuaternion fastQuaternion) {
        this.WR.setText(String.valueOf(fastQuaternion.r));
        this.Wi.setText(String.valueOf(fastQuaternion.i));
        this.Wj.setText(String.valueOf(fastQuaternion.j));
        this.Wk.setText(String.valueOf(fastQuaternion.k));
    }

    private boolean setWAxisDegrees() {
        try {
            this.wAxisDegrees_ = Double.valueOf(this.wText_.getText());
        }
        catch (Throwable throwable) {
            this.wText_.setForeground(Color.red);
            return false;
        }
        return true;
    }

    private boolean wTextOkp() {
        return this.WR.valueOk_p() && this.Wi.valueOk_p() && this.Wj.valueOk_p() && this.Wk.valueOk_p();
    }

    public FastQuaternion wAxis() {
        if (this.wTextOkp()) {
            return new FastQuaternion(this.WR.doubleValue(), this.Wi.doubleValue(), this.Wj.doubleValue(), this.Wk.doubleValue());
        }
        return new FastQuaternion();
    }

    private FastQuaternion getAxis(String string) {
        if (string.equals("H")) {
            if (this.hAndVAxesOkp()) {
                return this.hAxis();
            }
        } else if (string.equals("V")) {
            if (this.hAndVAxesOkp()) {
                return this.vAxis();
            }
        } else if (string.equals("D")) {
            if (this.dTextOkp()) {
                return this.dAxis();
            }
        } else {
            if (string.equals("MemH")) {
                return this.memH_;
            }
            if (string.equals("MemV")) {
                return this.memV_;
            }
            if (string.equals("P1")) {
                return this.firstPerp_;
            }
            if (string.equals("P2")) {
                return this.secondPerp_;
            }
        }
        return null;
    }

    private boolean setWDisplay(String string) {
        boolean bl;
        boolean bl2 = bl = string == null || string.equals(this.wLeft_.getSelectedItem()) || string.equals(this.wRight_.getSelectedItem());
        if (!bl) {
            return false;
        }
        FastQuaternion fastQuaternion = this.getAxis(this.wLeft_.getSelectedItem());
        FastQuaternion fastQuaternion2 = this.getAxis(this.wRight_.getSelectedItem());
        if (fastQuaternion == null || fastQuaternion2 == null) {
            return false;
        }
        if (this.setWAxisDegrees()) {
            this.displayAsWAxis(FastQuaternion.rotate(this.wAxisDegrees_, fastQuaternion, fastQuaternion2));
            return true;
        }
        return false;
    }

    public void setLogging(boolean bl) {
        if (this.loggingMI_.getState() != bl) {
            this.loggingMI_.setState(bl);
        }
    }

    public void setWrite2URLP(boolean bl) {
        this.write2URLMI_.setState(bl);
    }

    public void setUserWantsToAddCommentP(boolean bl) {
        this.userCommentMI_.setState(bl);
    }

    private void setHifi_p(boolean bl) {
        this.fastMI_.setState(!bl);
    }

    void setView4HVReversal() {
        if (this.viewLTF.valueOk_p() && this.widthLTF_.valueOk_p() && this.heightLTF_.valueOk_p()) {
            double d = this.viewLTF.doubleValue();
            int n = this.widthLTF_.intValue();
            int n2 = this.heightLTF_.intValue();
            double d2 = d * (double)n2 / (double)n;
            this.viewLTF.setText(String.valueOf(d2));
        }
    }

    public void swapHV() {
        this.listenToHAndVAxes(false);
        String string = this.HR.getText();
        this.HR.setText(this.VR.getText());
        this.VR.setText(string);
        string = this.Hi.getText();
        this.Hi.setText(this.Vi.getText());
        this.Vi.setText(string);
        string = this.Hj.getText();
        this.Hj.setText(this.Vj.getText());
        this.Vj.setText(string);
        string = this.Hk.getText();
        this.Hk.setText(this.Vk.getText());
        this.Vk.setText(string);
        this.listenToHAndVAxes(true);
        this.setView4HVReversal();
        string = this.widthLTF_.getText();
        this.widthLTF_.setText(this.heightLTF_.getText());
        this.heightLTF_.setText(string);
    }

    String negateNumberString(String string) {
        if (string.charAt(0) == '-') {
            return string.substring(1);
        }
        try {
            double d = Double.valueOf(string);
            if (d == 0.0) {
                return string;
            }
        }
        catch (Throwable throwable) {
            return string;
        }
        return "-" + string;
    }

    public void rotate90R() {
        this.listenToHAndVAxes(false);
        String string = this.HR.getText();
        this.HR.setText(this.VR.getText());
        this.VR.setText(this.negateNumberString(string));
        string = this.Hi.getText();
        this.Hi.setText(this.Vi.getText());
        this.Vi.setText(this.negateNumberString(string));
        string = this.Hj.getText();
        this.Hj.setText(this.Vj.getText());
        this.Vj.setText(this.negateNumberString(string));
        string = this.Hk.getText();
        this.Hk.setText(this.Vk.getText());
        this.Vk.setText(this.negateNumberString(string));
        this.listenToHAndVAxes(true);
        this.setView4HVReversal();
        string = this.widthLTF_.getText();
        this.widthLTF_.setText(this.heightLTF_.getText());
        this.heightLTF_.setText(string);
    }

    public void rotateClockwise(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        this.listenToHAndVAxes(false);
        try {
            d9 = Double.valueOf(this.HR.getText());
            d8 = Double.valueOf(this.Hi.getText());
            d7 = Double.valueOf(this.Hj.getText());
            d6 = Double.valueOf(this.Hk.getText());
            d5 = Double.valueOf(this.VR.getText());
            d4 = Double.valueOf(this.Vi.getText());
            d3 = Double.valueOf(this.Vj.getText());
            d2 = Double.valueOf(this.Vk.getText());
        }
        catch (Throwable throwable) {
            this.listenToHAndVAxes(true);
            FTCentral.message("Error occurred when trying to read H and V axes.", false);
            return;
        }
        double d10 = d * Math.PI / 180.0;
        double d11 = Math.cos(d10);
        double d12 = Math.sin(d10);
        FastQuaternion fastQuaternion = new FastQuaternion(d9, d8, d7, d6);
        FastQuaternion fastQuaternion2 = new FastQuaternion(d5, d4, d3, d2);
        FastQuaternion fastQuaternion3 = new FastQuaternion(fastQuaternion2).times_scalar_n(d12);
        FastQuaternion fastQuaternion4 = new FastQuaternion(fastQuaternion).times_scalar_n(-d12);
        FastQuaternion fastQuaternion5 = fastQuaternion.times_scalar_n(d11).plus_equal(fastQuaternion3);
        FastQuaternion fastQuaternion6 = fastQuaternion2.times_scalar_n(d11).plus_equal(fastQuaternion4);
        this.HR.setText(String.valueOf(fastQuaternion5.r));
        this.VR.setText(String.valueOf(fastQuaternion6.r));
        this.Hi.setText(String.valueOf(fastQuaternion5.i));
        this.Vi.setText(String.valueOf(fastQuaternion6.i));
        this.Hj.setText(String.valueOf(fastQuaternion5.j));
        this.Vj.setText(String.valueOf(fastQuaternion6.j));
        this.Hk.setText(String.valueOf(fastQuaternion5.k));
        this.Vk.setText(String.valueOf(fastQuaternion6.k));
        this.listenToHAndVAxes(true);
    }

    public void rotate90L() {
        this.listenToHAndVAxes(false);
        String string = this.HR.getText();
        this.HR.setText(this.negateNumberString(this.VR.getText()));
        this.VR.setText(string);
        string = this.Hi.getText();
        this.Hi.setText(this.negateNumberString(this.Vi.getText()));
        this.Vi.setText(string);
        string = this.Hj.getText();
        this.Hj.setText(this.negateNumberString(this.Vj.getText()));
        this.Vj.setText(string);
        string = this.Hk.getText();
        this.Hk.setText(this.negateNumberString(this.Vk.getText()));
        this.Vk.setText(string);
        this.listenToHAndVAxes(true);
        this.setView4HVReversal();
        string = this.widthLTF_.getText();
        this.widthLTF_.setText(this.heightLTF_.getText());
        this.heightLTF_.setText(string);
    }

    public void w2H() {
        if (this.wTextOkp()) {
            this.displayAsHAxis(this.wAxis());
        }
    }

    public void w2V() {
        if (this.wTextOkp()) {
            this.displayAsVAxis(this.wAxis());
        }
    }

    public void h2MemH() {
        if (this.hAndVAxesOkp()) {
            this.memH_ = this.hAxis();
        }
    }

    public void v2MemV() {
        if (this.hAndVAxesOkp()) {
            this.memV_ = this.vAxis();
            this.setWDisplay("MemV");
        }
    }

    public void memH2H() {
        this.displayAsHAxis(this.memH_);
    }

    public void memV2V() {
        this.displayAsVAxis(this.memV_);
    }

    private void updateDandWforNewD() {
        this.disableDMutualUpdating_p_ = true;
        this.setFirstAndSecondPerpendiculars();
        try {
            Double d = Double.valueOf(this.dText_.getText());
            if (0.0 <= d && d <= 360.0) {
                this.dText_.setForeground(Color.black);
                this.dScrollbar_.setValue((int)d.doubleValue());
                this.rotateBetweenPerpendiculars();
            } else {
                this.dText_.setForeground(Color.red);
            }
        }
        catch (Throwable throwable) {
            this.dText_.setForeground(Color.red);
        }
    }

    class HVTextLNR
    implements TextListener {
        HVTextLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            ParmFrame.this.self_.setFirstAndSecondPerpendiculars();
        }
    }

    class MyWindowLNR
    implements WindowListener {
        MyWindowLNR() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (ParmFrame.this.visibilityState_ == 0) {
                ParmFrame.this.visibilityState_ = 1;
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ParmFrame.this.self_.setVisible(false);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    class newFrameLNR
    extends DocuActionListener {
        public newFrameLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.makeNewFrame(null);
        }
    }

    class openFileLNR
    extends DocuActionListener {
        public openFileLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.openImage();
        }
    }

    class openParmLNR
    extends DocuActionListener {
        public openParmLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.readParms(ParmFrame.this.fTCentral_.write2URLP(), -1);
        }
    }

    class openLogLNR
    extends DocuActionListener {
        public openLogLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Enter log entry number", ParmFrame.this.self_, "-1");
            if (!intDialog.cancelled_P()) {
                try {
                    int n = intDialog.getValue();
                    ParmFrame.this.fTCentral_.readParms(ParmFrame.this.fTCentral_.write2URLP(), n);
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                    FTCentral.message("Error in reading entry number.", true);
                    FTCentral cfr_ignored_1 = ParmFrame.this.fTCentral_;
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class trapFileLNR
    extends DocuActionListener {
        public trapFileLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.openTrapImage();
        }
    }

    class saveAsFileLNR
    extends DocuActionListener {
        public saveAsFileLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.saveImage();
        }
    }

    class saveArgsFLNR
    extends DocuActionListener {
        public saveArgsFLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.writeParms(ParmFrame.this.fTCentral_.write2URLP(), null);
        }
    }

    class saveCountsCSVLNR
    extends DocuActionListener {
        public saveCountsCSVLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.saveActiveCounts();
        }
    }

    class JoinPanelsLNR
    extends DocuActionListener {
        public JoinPanelsLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            PanelJoiner panelJoiner;
            String string;
            FTFileChooser fTFileChooser = new FTFileChooser(ParmFrame.this.self_);
            File file = fTFileChooser.getDirectory();
            if (file != null && file.exists() && (string = (panelJoiner = new PanelJoiner(file.toString())).joinFiles()) != null) {
                FTCentral.message("Joined panels written to " + string, true);
            }
        }
    }

    class write2URLLNR
    implements ActionListener {
        write2URLLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                boolean bl = ParmFrame.this.write2URLMI_.getState();
                ParmFrame.this.fTCentral_.toggleWrite2URLP(bl);
            }
        }
    }

    class loggingLNR
    implements ActionListener {
        loggingLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0 && ParmFrame.this.self_.isActive()) {
                boolean bl = ParmFrame.this.loggingMI_.getState();
                ParmFrame.this.fTCentral_.toggleLogging(bl);
            }
        }
    }

    class usrComLNR
    implements ActionListener {
        usrComLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                boolean bl = ParmFrame.this.userCommentMI_.getState();
                ParmFrame.this.fTCentral_.toggleUserWantsToAddCommentP(bl);
            }
        }
    }

    class closeLNR
    extends DocuActionListener {
        public closeLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.self_.setVisible(false);
        }
    }

    class quitLNR
    extends DocuActionListener {
        public quitLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.timeToQuit();
        }
    }

    class startDrawLNR
    extends DocuActionListener {
        public startDrawLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FractalSpec fractalSpec = new FractalSpec();
            ParmFrame.this.getCheckBoxValues(fractalSpec);
            ParmFrame.this.fTCentral_.setCheckBoxValues4Frame(fractalSpec);
            ParmFrame.this.fTCentral_.drawActiveCanvas();
        }
    }

    class stopDrawLNR
    extends DocuActionListener {
        public stopDrawLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.pauseActiveCanvas();
        }
    }

    class DrawFastLNR
    implements ActionListener {
        DrawFastLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0 && ParmFrame.this.self_.isActive()) {
                ParmFrame.this.fTCentral_.flagsToActiveFrame();
            }
        }
    }

    class HVRatioLNR
    extends DocuActionListener {
        public HVRatioLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            RatioDialog ratioDialog = new RatioDialog("Width/Height Ratio", ParmFrame.this.self_, new Dimension(ParmFrame.this.hVRatio_));
            if (!ParmFrame.this.hVRatio_.equals(ratioDialog.getDimension())) {
                ParmFrame.this.hVRatio_.setSize(ratioDialog.getDimension());
                ParmFrame.this.fTCentral_.flagsToActiveFrame();
            }
        }
    }

    class interpolLNR
    implements ActionListener {
        String which_;

        public interpolLNR(String string) {
            this.which_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem;
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0 && (jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                ParmFrame.this.interpolateColorsMenu_.setText("Interpolation: " + this.which_);
                if (ParmFrame.this.self_.isActive()) {
                    ParmFrame.this.fTCentral_.flagsToActiveFrame();
                }
            }
        }
    }

    class Q_LNR
    implements ItemListener {
        String which_;

        public Q_LNR(String string) {
            this.which_ = string;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ParmFrame.this.scanOnMenu_.setText("Scan On: " + this.which_);
                if (ParmFrame.this.self_.isActive()) {
                    ParmFrame.this.fTCentral_.whatsDrawnToActiveFrame();
                }
            }
        }
    }

    class dsplyParmsLNR
    extends DocuActionListener {
        public dsplyParmsLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.setParameters(null);
        }
    }

    class defaultLNR
    extends DocuActionListener {
        public defaultLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            String string = ParmFrame.this.looperText_.getText();
            FTLooper fTLooper = ParmFrame.this.fTCentral_.findLoopObject(string);
            if (fTLooper != null) {
                ParmFrame.this.fTCentral_.setParmFramePanelFields(1, 0, 0);
                ParmFrame.this.self_.setLooperDefaults(fTLooper);
            }
        }
    }

    class docLNR
    extends DocuActionListener {
        public docLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            String string = ParmFrame.this.looperText_.getText();
            FTLooper fTLooper = ParmFrame.this.fTCentral_.findLoopObject(string);
            if (fTLooper != null) {
                FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                FTCentral.message(fTLooper.docString(), true);
            }
        }
    }

    class EnlargeLNR
    extends DocuActionListener {
        public EnlargeLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Zoom Percentage", ParmFrame.this.self_, String.valueOf(ParmFrame.this.fTCentral_.enlargePixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    ParmFrame.this.fTCentral_.setEnlargePixels(intDialog.getValue());
                    ParmFrame.this.fTCentral_.adjustEnlarge(ParmFrame.this.fTCentral_.enlargePixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                    FTCentral.message("Illegal percentage entered: " + numberFormatException, true);
                    FTCentral cfr_ignored_1 = ParmFrame.this.fTCentral_;
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class EnlrgAgnLNR
    extends DocuActionListener {
        public EnlrgAgnLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.adjustEnlarge(ParmFrame.this.fTCentral_.enlargePixels());
        }
    }

    class RightLNR
    extends DocuActionListener {
        public RightLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift Center Right (pixels)", ParmFrame.this.self_, String.valueOf(ParmFrame.this.fTCentral_.rightPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    ParmFrame.this.fTCentral_.setRightPixels(intDialog.getValue());
                    ParmFrame.this.fTCentral_.adjustCenterRight(ParmFrame.this.fTCentral_.rightPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                    FTCentral.message("Illegal # of pixels: " + numberFormatException, true);
                    FTCentral cfr_ignored_1 = ParmFrame.this.fTCentral_;
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class RightAgnLNR
    extends DocuActionListener {
        public RightAgnLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.adjustCenterRight(ParmFrame.this.fTCentral_.rightPixels());
        }
    }

    class DownLNR
    extends DocuActionListener {
        public DownLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift Center Down (pixels)", ParmFrame.this.self_, String.valueOf(ParmFrame.this.fTCentral_.downPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    ParmFrame.this.fTCentral_.setDownPixels(intDialog.getValue());
                    ParmFrame.this.fTCentral_.adjustCenterUp(-ParmFrame.this.fTCentral_.downPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                    FTCentral.message("Illegal # of pixels: " + numberFormatException, true);
                    FTCentral cfr_ignored_1 = ParmFrame.this.fTCentral_;
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class DownAgnLNR
    extends DocuActionListener {
        public DownAgnLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.adjustCenterUp(-ParmFrame.this.fTCentral_.downPixels());
        }
    }

    class OnWLNR
    extends DocuActionListener {
        public OnWLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift pixels on W", ParmFrame.this.self_, String.valueOf(ParmFrame.this.fTCentral_.onWPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    ParmFrame.this.fTCentral_.setOnWPixels(intDialog.getValue());
                    ParmFrame.this.fTCentral_.adjustCenterOnW(ParmFrame.this.fTCentral_.onWPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                    FTCentral.message("Illegal # of pixels: " + numberFormatException, true);
                    FTCentral cfr_ignored_1 = ParmFrame.this.fTCentral_;
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class OnWAgnLNR
    extends DocuActionListener {
        public OnWAgnLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.adjustCenterOnW(ParmFrame.this.fTCentral_.onWPixels());
        }
    }

    class swapHVLNR
    extends DocuActionListener {
        public swapHVLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.swapHV();
        }
    }

    class Rotate90LLNR
    extends DocuActionListener {
        public Rotate90LLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.rotate90L();
        }
    }

    class Rotate90RLNR
    extends DocuActionListener {
        public Rotate90RLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.rotate90R();
        }
    }

    class RotateArbLNR
    extends DocuActionListener {
        public RotateArbLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("", ParmFrame.this.self_, String.valueOf(RotateArbLNR_previousValue_));
            if (!intDialog.cancelled_P()) {
                try {
                    RotateArbLNR_previousValue_ = intDialog.getDoubleValue();
                    ParmFrame.this.fTCentral_.rotateClockwise(RotateArbLNR_previousValue_);
                }
                catch (Throwable throwable) {
                    FTCentral.message("Error in FTWindow.RotateArbLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
                }
            }
        }
    }

    class W2HLNR
    extends DocuActionListener {
        public W2HLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.w2H();
        }
    }

    class W2VLNR
    extends DocuActionListener {
        public W2VLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.w2V();
        }
    }

    class H2MemHLNR
    extends DocuActionListener {
        public H2MemHLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.h2MemH();
        }
    }

    class V2MemVLNR
    extends DocuActionListener {
        public V2MemVLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.v2MemV();
        }
    }

    class MemH2HLNR
    extends DocuActionListener {
        public MemH2HLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.memH2H();
        }
    }

    class MemV2VLNR
    extends DocuActionListener {
        public MemV2VLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.memV2V();
        }
    }

    class mouseV2LNR
    extends DocuActionListener {
        public mouseV2LNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.mouseNewVAxis();
        }
    }

    class mouseH2LNR
    extends DocuActionListener {
        public mouseH2LNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.mouseNewHAxis();
        }
    }

    class ColorMapLNR
    extends DocuActionListener {
        public ColorMapLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.showColorGuideEditor(null);
        }
    }

    class MsgLNR
    extends DocuActionListener {
        public MsgLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.setMessagesVisible(ParmFrame.this.self_);
        }
    }

    class TrapLNR
    extends DocuActionListener {
        public TrapLNR(String string) {
            super(ParmFrame.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            ParmFrame.this.fTCentral_.showTrapFrame();
        }
    }

    class WatchedText
    extends TextField
    implements ActionListener {
        String id_;

        WatchedText(String string, int n, String string2) {
            super(string, n);
            this.id_ = string2;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id_.equals("looperText_")) {
                String string = ParmFrame.this.looperText_.getText();
                FTLooper fTLooper = ParmFrame.this.fTCentral_.findLoopObject(string = ParmFrame.this.fTCentral_.translateLoopName(string));
                if (fTLooper == null) {
                    ParmFrame.this.looperText_.setForeground(Color.red);
                } else {
                    ParmFrame.this.looperText_.setForeground(Color.black);
                    ParmFrame.this.fTCentral_.setLoooper4ParmFrame(string);
                    ParmFrame.this.importLooper(string);
                }
            }
        }
    }

    class ScrollLNR
    implements AdjustmentListener {
        ScrollLNR() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!ParmFrame.this.disableDMutualUpdating_p_) {
                int n;
                int n2 = adjustmentEvent.getValue();
                if (n2 == (n = ParmFrame.this.dScrollbar_.getValue())) {
                    ParmFrame.this.setFirstAndSecondPerpendiculars();
                    ParmFrame.this.dText_.setText(String.valueOf(n2));
                }
            } else {
                ParmFrame.this.disableDMutualUpdating_p_ = false;
            }
        }
    }

    class DTextLNR
    implements TextListener {
        DTextLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            ParmFrame.this.updateDandWforNewD();
        }
    }

    class WScrollLNR
    implements AdjustmentListener {
        WScrollLNR() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!ParmFrame.this.disableWMutualUpdating_p_) {
                int n;
                int n2 = adjustmentEvent.getValue();
                if (n2 == (n = ParmFrame.this.wScrollbar_.getValue())) {
                    ParmFrame.this.setFirstAndSecondPerpendiculars();
                    ParmFrame.this.wText_.setText(String.valueOf(n2));
                }
            } else {
                ParmFrame.this.disableWMutualUpdating_p_ = false;
            }
        }
    }

    class WTextLNR
    implements TextListener {
        WTextLNR() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            ParmFrame.this.disableWMutualUpdating_p_ = true;
            ParmFrame.this.setFirstAndSecondPerpendiculars();
            try {
                Double d = Double.valueOf(ParmFrame.this.wText_.getText());
                if (0.0 <= d && d <= 360.0) {
                    ParmFrame.this.wText_.setForeground(Color.black);
                    ParmFrame.this.wScrollbar_.setValue((int)d.doubleValue());
                    ParmFrame.this.setWDisplay(null);
                } else {
                    ParmFrame.this.wText_.setForeground(Color.red);
                }
            }
            catch (Throwable throwable) {
                ParmFrame.this.wText_.setForeground(Color.red);
            }
        }
    }

    class ChoiceLNR
    implements ItemListener {
        ChoiceLNR() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ParmFrame.this.setWDisplay(null);
        }
    }

    public class MenuItemWithNumber
    extends JMenuItem {
        int myWindowsNumber;

        public MenuItemWithNumber(int n) {
            super("Drawing Window " + n);
            this.myWindowsNumber = n;
        }

        public int getNumber() {
            return this.myWindowsNumber;
        }
    }

    class WindowToFrontLNR
    implements ActionListener {
        FTWindow myDrawingWindow;

        public WindowToFrontLNR(FTWindow fTWindow) {
            this.myDrawingWindow = fTWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.myDrawingWindow.toFront();
            }
            catch (Throwable throwable) {
                FTCentral cfr_ignored_0 = ParmFrame.this.fTCentral_;
                FTCentral.message("Error on windowToFrontLNR.actionPerformed - Drawing Window " + (Serializable)(this.myDrawingWindow == null ? "NULL" : Integer.valueOf(this.myDrawingWindow.frameNumber())), true);
            }
        }
    }
}

