/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageOutputStream;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTIO;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.GIFDecoderPkg.GIFDecoder;
import us.lystad.fractaltop.GIFEncoderPkg.GIFEncoder;

public class PanelJoiner {
    private String directoryString_;
    private String workingPrefixString_ = null;
    private String fileTypeString_ = null;
    private int maxPanelNum_ = -1;
    private File resultFile_;
    private ArrayList<String> prefixesToIgnore = new ArrayList();

    public PanelJoiner(String string) {
        this.directoryString_ = string;
    }

    public String joinFiles() {
        if (this.findWorkingPrefixString()) {
            if (this.createAnswerFile()) {
                return this.resultFile_.toString();
            }
            return null;
        }
        if (this.resultFile_ != null) {
            FTCentral.message(this.resultFile_ + " already exists.", true);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean findWorkingPrefixString() {
        Path path = new File(this.directoryString_).toPath();
        File file = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                int n;
                String[] stringArray;
                if (!Files.isRegularFile(path2, new LinkOption[0]) || (stringArray = this.extractAll(path2.getFileName().toString())) == null) continue;
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[3];
                if (this.prefixesToIgnore.contains(string)) continue;
                file = new File(path + File.separator + string + "." + string3);
                if (file.exists()) {
                    this.prefixesToIgnore.add(string);
                    continue;
                }
                if (this.workingPrefixString_ == null) {
                    this.resultFile_ = file;
                    this.workingPrefixString_ = string;
                    this.fileTypeString_ = string3;
                } else if (!string.equals(this.workingPrefixString_)) continue;
                if ((n = Integer.parseInt(string2)) <= this.maxPanelNum_) continue;
                this.maxPanelNum_ = n;
            }
            if (this.resultFile_ == null) {
                this.resultFile_ = file;
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable3) {
            FTCentral.message("Error in PanelJoiner.findWorkingPrefixString.  " + FTCentral.getExceptionSynopsis(throwable3), true);
            return false;
        }
    }

    private String[] extractAll(String string) {
        String string2 = "(.*)y(\\d+)-x(\\d+)\\.(\\p{Alnum}+)";
        if (string.matches(string2)) {
            String[] stringArray = new String[4];
            stringArray[0] = string.replaceAll(string2, "$1");
            while (stringArray[0].endsWith("-") || stringArray[0].endsWith("_")) {
                stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 1);
            }
            stringArray[1] = string.replaceAll(string2, "$2");
            stringArray[2] = string.replaceAll(string2, "$3");
            stringArray[3] = string.replaceAll(string2, "$4");
            if (stringArray[1].length() == stringArray[2].length()) {
                return stringArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createAnswerFile() {
        Object object;
        Object object2;
        File file;
        Object object3;
        Object object4;
        Object object5;
        BufferedImage bufferedImage = null;
        Object var2_2 = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        Object object6 = null;
        FractalSpec fractalSpec = null;
        String string = null;
        boolean bl = false;
        IndexColorModel indexColorModel = null;
        Path path = new File(this.directoryString_).toPath();
        try {
            object5 = Files.newDirectoryStream(path);
            try {
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    if (!Files.isRegularFile((Path)object3, new LinkOption[0]) || !object3.getFileName().toString().startsWith(this.workingPrefixString_)) continue;
                    file = object3.toFile();
                    object2 = ImageIO.read(file);
                    if (bufferedImage == null) {
                        n2 = ((BufferedImage)object2).getWidth();
                        n3 = ((BufferedImage)object2).getHeight();
                        n = this.maxPanelNum_ + 1;
                        object = FTIO.getFileExtension((Path)object3);
                        if ("gif".equals(((String)object).toLowerCase())) {
                            bl = true;
                            var18_34 = new FileInputStream(file);
                            fractalSpec = this.getGifSpec((InputStream)var18_34);
                            object6 = fractalSpec.getComment();
                            var19_37 = ((BufferedImage)object2).getColorModel();
                            if (fractalSpec == null || !(var19_37 instanceof IndexColorModel)) {
                                FTCentral.message("PanelJoiner.createAnswerFile found a GIF without an IndexColorModel: " + (Path)object3, false);
                                continue;
                            }
                            indexColorModel = (IndexColorModel)var19_37;
                            bufferedImage = new BufferedImage(n * n2, n * n3, 13, indexColorModel);
                        } else {
                            var18_34 = ImageIO.createImageInputStream(file);
                            var19_37 = ((BufferedImage)object2).getColorModel();
                            bufferedImage = new BufferedImage(var19_37, var19_37.createCompatibleWritableRaster(n * n2, n * n3), var19_37.isAlphaPremultiplied(), null);
                            String[] stringArray = FTIO.getMetadataComment_Parms_ColorsStrings(var18_34);
                            object6 = stringArray[0];
                            String string2 = stringArray[1];
                            string = stringArray[2];
                            fractalSpec = FractalSpec.parseParmsString(string2);
                        }
                        if (fractalSpec != null) {
                            fractalSpec.panels = 1;
                            fractalSpec.panel_x = 0;
                            fractalSpec.panel_y = 0;
                            fractalSpec.pix_width = n * n2;
                            fractalSpec.pix_height = n * n3;
                        }
                    }
                    if ((object = this.extractAll(object3.toString())) == null) continue;
                    int n4 = Integer.parseInt(object[1]) * n3;
                    int n5 = Integer.parseInt((String)object[2]) * n2;
                    this.drawImage((BufferedImage)object2, n2, n3, bufferedImage, n5, n4);
                }
            }
            finally {
                if (object5 != null) {
                    object5.close();
                }
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("Error in PanelJoiner.createAnswerFile(1): " + FTCentral.getExceptionSynopsis(throwable), true);
            return false;
        }
        if (bufferedImage == null) {
            return false;
        }
        if (bl) {
            object5 = null;
            object4 = null;
            try {
                object6 = object6 + " -Joined Panels- ";
                int n6 = bufferedImage.getWidth();
                int n7 = bufferedImage.getHeight();
                object2 = new byte[n6 * n7];
                bufferedImage.getRaster().getDataElements(0, 0, n6, n7, object2);
                object5 = new File(path + File.separator + this.workingPrefixString_ + "." + this.fileTypeString_);
                object4 = new FileOutputStream((File)object5);
                object = new GIFEncoder(n6, n7, (byte[])object2, indexColorModel);
                ((GIFEncoder)object).JavaQuatWrite((OutputStream)object4, fractalSpec.toString(1, (String)object6), false, fractalSpec.version);
                boolean bl2 = true;
                return bl2;
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in PanelJoiner.createAnswerFile(2 gif): " + FTCentral.getExceptionSynopsis(throwable), true);
            }
            finally {
                try {
                    if (object4 != null) {
                        ((OutputStream)object4).close();
                    }
                }
                catch (Throwable throwable) {}
            }
            return false;
        }
        object5 = null;
        object4 = null;
        object3 = "png";
        try {
            object5 = ImageIO.getImageWritersByFormatName((String)object3).next();
            if (object5 != null && bufferedImage != null) {
                file = new File(path + File.separator + this.workingPrefixString_ + "." + this.fileTypeString_);
                object4 = new FileImageOutputStream(file);
                ((ImageWriter)object5).setOutput(object4);
                if (fractalSpec != null && string != null) {
                    object2 = FTIO.createMetadata((String)object6, fractalSpec.toString(1, ""), string);
                    ((ImageWriter)object5).write((IIOMetadata)object2, new IIOImage(bufferedImage, null, (IIOMetadata)object2), null);
                } else {
                    ((ImageWriter)object5).write(new IIOImage(bufferedImage, null, null));
                }
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        catch (Throwable throwable) {
            FTCentral.message("Error in PanelJoiner.createAnswerFile(2):  " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            try {
                if (object4 != null) {
                    object4.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (object5 != null) {
                    ((ImageWriter)object5).dispose();
                }
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    private void drawImage(BufferedImage bufferedImage, int n, int n2, BufferedImage bufferedImage2, int n3, int n4) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage2.setRGB(j + n3, i + n4, bufferedImage.getRGB(j, i));
            }
        }
    }

    private FractalSpec getGifSpec(InputStream inputStream) {
        try {
            boolean bl = true;
            GIFDecoder gIFDecoder = new GIFDecoder(inputStream, bl);
            int n = -1;
            String string = "FrctlTop";
            n = gIFDecoder.getVersionAuthCode(string);
            if (n == -2) {
                n = gIFDecoder.getVersionAuthCode("JavaQuat");
                string = "JavaQuat";
            }
            String string2 = gIFDecoder.getApplicationData(string);
            return FractalSpec.parseParmsString(string2);
        }
        catch (Throwable throwable) {
            FTCentral.message("Error in PanelJoiner.getGifSpec(2):  " + FTCentral.getExceptionSynopsis(throwable), true);
            return null;
        }
    }
}

