/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.Fraction;
import us.lystad.fractaltop.LiveOrbitReporter;

class OrbitCluster {
    private static final int NONE = -1;
    private static int MAX_SIZE = 10000;
    private static int TRIM_SIZE = 8000;
    private static int CONNECTIVITY_START = 4;
    private static int CONNECTIVITY_MAX = 12;
    private static int SAMPLE_SIZE_MIN = 250;
    private static Fraction zero = new Fraction(Fraction.zero, 0);
    private LiveOrbitReporter parent_;
    private int depth_;
    private int sampleSize_;
    private ArrayList<PointData> points_;
    private ArrayList<PDCluster> clusters_;
    private PointData[] pointsArray_;
    private PDIterationDecreasing iterationDecreasing_;
    private PDIterationIncreasing iterationIncreasing_;
    private PDIncreasingSizeComparitor clusterSizeIncreasing_;
    private HashSet<PointData> borderPoints_;
    private int nextClusterNumber_ = 0;
    private PDCluster MULTIPLE_CLUSTERS = null;
    boolean success_;
    BigQuaternion center_;
    OrbitCluster self_;

    public OrbitCluster(LiveOrbitReporter liveOrbitReporter, int n) {
        this.parent_ = liveOrbitReporter;
        this.center_ = this.parent_.getCenter();
        this.depth_ = n;
        this.points_ = new ArrayList();
        this.pointsArray_ = null;
        this.clusters_ = new ArrayList();
        this.iterationDecreasing_ = new PDIterationDecreasing();
        this.iterationIncreasing_ = new PDIterationIncreasing();
        this.clusterSizeIncreasing_ = new PDIncreasingSizeComparitor();
        this.borderPoints_ = new HashSet();
        this.success_ = false;
        this.self_ = this;
        if (this.MULTIPLE_CLUSTERS == null) {
            this.MULTIPLE_CLUSTERS = new PDCluster(-1, null);
        }
        if (this.depth_ > SAMPLE_SIZE_MIN) {
            this.sampleSize_ = (int)Math.floor((double)SAMPLE_SIZE_MIN * Math.exp(Math.log10((double)n / (double)SAMPLE_SIZE_MIN) * Math.log(2.0)));
            if (this.sampleSize_ > this.depth_) {
                this.sampleSize_ = this.depth_;
            }
        } else {
            this.sampleSize_ = this.depth_;
        }
    }

    public void add(int n, BigQuaternion bigQuaternion) {
        PointData pointData = new PointData(n, bigQuaternion);
        this.points_.add(pointData);
        if (this.points_.size() > (int)Math.round((double)this.sampleSize_ * 1.5)) {
            PointData[] pointDataArray = this.points_.toArray(new PointData[this.points_.size()]);
            pointDataArray = Arrays.copyOfRange(pointDataArray, this.points_.size() - this.sampleSize_, this.points_.size());
            this.points_ = new ArrayList<PointData>(Arrays.asList(pointDataArray));
        }
    }

    public void report() {
        FTCentral.message("---------- Beginning Attractor Analysis Attempt ----------", false);
        FTCentral.simpleMessage("   For point " + this.center_.adjustPrecision(-7).toString());
        int n = this.checkForConvergence(this.points_);
        if (n > 0) {
            PointData[] pointDataArray = this.points_.toArray(new PointData[0]);
            PDIterationDecreasing pDIterationDecreasing = new PDIterationDecreasing();
            Arrays.sort(pointDataArray, pDIterationDecreasing);
            int n2 = pointDataArray[0].getIteration() - pointDataArray[n].getIteration();
            if (n2 == 1) {
                FTCentral.message("There as 1 attractor in the sequence and it is:", false);
            } else {
                FTCentral.message("There are " + n2 + " attractors in the sequence and they are as follows:", false);
            }
            PointData[] pointDataArray2 = Arrays.copyOfRange(this.points_.toArray(new PointData[0]), this.points_.size() - n2, this.points_.size());
            Arrays.sort(pointDataArray2, new PDByRComparitor());
            for (int i = 0; i < pointDataArray2.length; ++i) {
                FTCentral.simpleMessage("   " + String.valueOf(i) + ": " + pointDataArray2[i].getPoint().adjustPrecision(-7));
            }
            FTCentral.message("--------------- End of Attractor Analysis --------------", true);
            return;
        }
        this.pointsArray_ = this.points_.toArray(new PointData[0]);
        Arrays.sort(this.pointsArray_, this.iterationDecreasing_);
        int n3 = 0;
        int n4 = this.points_.size() / 4;
        Integer n5 = null;
        while (!this.success_ && n4 < this.points_.size()) {
            int n6;
            n5 = this.setNeighbors_checkForConvergence(n3, n4);
            if (n5 != null) {
                n6 = this.createNewClustersGivenPeriod(n5, n4, true);
                this.success_ = true;
                continue;
            }
            if (n4 == this.points_.size() / 4 && this.checkForSingleAttractor(n4)) {
                this.success_ = true;
            } else {
                for (n6 = CONNECTIVITY_START; n6 <= CONNECTIVITY_MAX; n6 += 4) {
                    this.clusters_.clear();
                    for (int i = 0; i < this.pointsArray_.length; ++i) {
                        this.pointsArray_[i].setCluster(null);
                    }
                    this.formClusters(n4, n6);
                    this.success_ = this.nonConvergenceAttempt(n4);
                    if (this.success_) break;
                }
            }
            if (this.success_) continue;
            n3 = n4;
            n4 = Math.min(this.points_.size(), n4 * 2);
        }
        this.finishReport(this.success_);
        if (n5 != null) {
            FTCentral.message("----------- End of Attractor Analysis Attempt ------------", true);
        } else {
            FTCentral.message("\n    ** We didn't have convergence of the series to the attractor(s) (within current drawing precision).\n    ** If this seems wrong, try increasing Orbit Trace 'Depth' 5X or 10X for more definite result.", false);
            FTCentral.message("----------- End of Attractor Analysis Attempt ------------", true);
        }
    }

    private int checkForConvergence(ArrayList<PointData> arrayList) {
        BigQuaternion bigQuaternion;
        BigQuaternion bigQuaternion2;
        BigQuaternion bigQuaternion3;
        int n = arrayList.size();
        PointData[] pointDataArray = arrayList.toArray(new PointData[0]);
        PDIterationDecreasing pDIterationDecreasing = new PDIterationDecreasing();
        Arrays.sort(pointDataArray, pDIterationDecreasing);
        BigQuaternion bigQuaternion4 = pointDataArray[0].getPoint().adjustPrecision(-7);
        int n2 = -1;
        for (int i = 1; i < n; ++i) {
            bigQuaternion3 = pointDataArray[i].getPoint().adjustPrecision(-7);
            if (!bigQuaternion4.equals(bigQuaternion3)) continue;
            n2 = i;
            break;
        }
        if (n2 > 0 && n2 + 1 < n && !(bigQuaternion2 = pointDataArray[1].getPoint().adjustPrecision(-7)).equals(bigQuaternion3 = pointDataArray[n2 + 1].getPoint().adjustPrecision(-7))) {
            return -1;
        }
        if (n2 > 0 && n2 + 2 < n && !(bigQuaternion = pointDataArray[2].getPoint().adjustPrecision(-7)).equals(bigQuaternion3 = pointDataArray[n2 + 2].getPoint().adjustPrecision(-7))) {
            return -1;
        }
        return n2;
    }

    private Integer getPeriodAfterConvergence(PointData pointData, PointData[] pointDataArray) {
        ArrayList<PointData> arrayList = new ArrayList<PointData>();
        arrayList.add(pointData);
        arrayList.add(pointDataArray[0]);
        for (int i = 1; i < pointDataArray.length && pointData.getPoint().minus(pointDataArray[i].getPoint()).magnitude().compareTo(zero) == 0; ++i) {
            arrayList.add(pointDataArray[i]);
        }
        PointData[] pointDataArray2 = arrayList.toArray(new PointData[0]);
        Arrays.sort(pointDataArray2, this.iterationDecreasing_);
        return pointDataArray2[0].getIteration() - pointDataArray2[1].getIteration();
    }

    private boolean checkForSingleAttractor(int n) {
        boolean bl;
        PointData[] pointDataArray = Arrays.copyOfRange(this.points_.toArray(new PointData[0]), this.points_.size() - n, this.points_.size());
        PDCluster pDCluster = new PDCluster(0, null);
        for (bl = false; bl < pointDataArray.length; bl += 1) {
            PointData pointData = pointDataArray[bl];
            pointData.setCluster(pDCluster);
            pDCluster.addMember(pointData);
        }
        pDCluster.sortMembers();
        pDCluster.prepContents();
        bl = pDCluster.hasAttractorP();
        if (bl) {
            this.clusters_.clear();
            this.clusters_.add(pDCluster);
        }
        return bl;
    }

    private void formClusters(int n, int n2) {
        int n3 = this.pointsArray_.length;
        ArrayDeque<PointData> arrayDeque = new ArrayDeque<PointData>();
        PointData[] pointDataArray = Arrays.copyOfRange(this.pointsArray_, 0, n);
        for (int i = 0; i < n; ++i) {
            PointData pointData = pointDataArray[i];
            PDCluster pDCluster = pointData.getCluster();
            if (pDCluster != null) continue;
            arrayDeque.add(pointData);
            pDCluster = pointData.getNeighborClusterIfOne(n2);
            if (pDCluster == this.MULTIPLE_CLUSTERS) {
                this.borderPoints_.add(pointData);
                continue;
            }
            if (pDCluster == null) {
                pDCluster = new PDCluster(this.nextClusterNumber_++, null);
                this.clusters_.add(pDCluster);
            }
            while (!arrayDeque.isEmpty()) {
                PointData pointData2 = (PointData)arrayDeque.pop();
                PDCluster pDCluster2 = pointData2.getCluster();
                if (pDCluster2 != null) continue;
                pointData2.setCluster_addNeighborsToDeque(pDCluster, arrayDeque, n2);
            }
        }
    }

    private Integer setNeighbors_checkForConvergence(int n, int n2) {
        int n3 = this.points_.size();
        int n4 = Math.max(0, n3 - n2);
        int n5 = Math.max(0, n3 - n);
        int n6 = Math.min(CONNECTIVITY_MAX, n3 - 1);
        PointData[] pointDataArray = Arrays.copyOfRange(this.points_.toArray(new PointData[0]), n4, n5);
        PointData[] pointDataArray2 = Arrays.copyOfRange(this.points_.toArray(new PointData[0]), n4, n3);
        Arrays.sort(pointDataArray, this.iterationDecreasing_);
        for (int i = 0; i < pointDataArray.length; ++i) {
            Object object;
            PointData pointData = pointDataArray[i];
            pDDistComparitor pDDistComparitor2 = new pDDistComparitor(pointData);
            Arrays.sort(pointDataArray2, pDDistComparitor2);
            if (i < 3 && pointData.getPoint().minus(pointDataArray2[0].getPoint()).magnitude().compareTo(zero) == 0) {
                object = this.getPeriodAfterConvergence(pointData, pointDataArray2);
                return object;
            }
            object = Arrays.copyOfRange(pointDataArray2, 0, n6);
            pointData.setNeighbors((PointData[])object);
        }
        return null;
    }

    private boolean nonConvergenceAttempt(int n) {
        int n2;
        boolean bl = true;
        int n3 = 0;
        boolean bl2 = false;
        for (PDCluster object2 : this.clusters_) {
            object2.sortMembers();
            object2.prepContents();
            if (object2.hasAttractorP()) {
                n3 = 1;
                continue;
            }
            if ((n3 = object2.maybeSplitCluster(n3)) != 0) continue;
            bl2 = true;
        }
        if (bl) {
            return !bl2;
        }
        PDCluster[] pDClusterArray = this.clusters_.toArray(new PDCluster[0]);
        Arrays.sort(pDClusterArray, this.clusterSizeIncreasing_);
        int[] nArray = new int[pDClusterArray.length];
        Arrays.fill(nArray, Integer.MAX_VALUE);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = false;
        for (int objectArray = 0; objectArray < pDClusterArray.length; ++objectArray) {
            int arrayDeque;
            nArray[objectArray] = arrayDeque = pDClusterArray[objectArray].findPeriodInMembers();
            if (n4 <= arrayDeque) continue;
            n4 = arrayDeque;
            Integer n8 = arrayDeque;
            hashSet.add(n8);
            Integer n9 = (Integer)hashMap.get(n8);
            n2 = pDClusterArray[objectArray].getMembers().values().size();
            if (n9 != null && n9 <= n2) continue;
            hashMap.put(n8, n2);
        }
        if (hashSet.isEmpty()) {
            return false;
        }
        Object[] objectArray = hashSet.toArray(new Integer[0]);
        Arrays.sort(objectArray);
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>(Arrays.asList(objectArray));
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        while (!arrayDeque.isEmpty()) {
            n2 = (Integer)arrayDeque.pop();
            ArrayList<PDCluster> arrayList = new ArrayList<PDCluster>();
            for (int i = 0; i < pDClusterArray.length; ++i) {
                PDCluster pDCluster = pDClusterArray[i];
                int n7 = pDCluster.getPeriod();
                if (n7 == Integer.MAX_VALUE) {
                    if (pDCluster.isCompatibleWithPeriod(n2, hashMap)) continue;
                    arrayList.add(pDCluster);
                    continue;
                }
                if (n7 == n2 || n7 > n2 && n7 % n2 == 0) continue;
                arrayList.add(pDCluster);
            }
            if (arrayList.size() >= n5) continue;
            n5 = arrayList.size();
            n6 = n2;
        }
        if (n5 > pDClusterArray.length / 2) {
            return false;
        }
        n2 = this.createNewClustersGivenPeriod(n6, n, false) ? 1 : 0;
        return n2 != 0;
    }

    private boolean createNewClustersGivenPeriod(int n, int n2, boolean bl) {
        int n3;
        int n4;
        PDCluster[] pDClusterArray = new PDCluster[n];
        for (n4 = 0; n4 < n; ++n4) {
            pDClusterArray[n4] = new PDCluster(n4, null);
            pDClusterArray[n4].setPeriod(n);
            pDClusterArray[n4].setFoundFromConvergencePeriodP(bl);
        }
        for (n4 = 0; n4 < n2; ++n4) {
            pDClusterArray[n4 % n].addMember(this.pointsArray_[n4]);
        }
        n4 = 1;
        for (n3 = 0; n3 < n; ++n3) {
            pDClusterArray[n3].sortMembers();
            pDClusterArray[n3].prepContents();
            if (pDClusterArray[n3].hasAttractorP()) continue;
            n4 = 0;
        }
        this.clusters_.clear();
        for (n3 = 0; n3 < n; ++n3) {
            this.clusters_.add(pDClusterArray[n3]);
        }
        return n4 != 0;
    }

    private void finishReport(boolean bl) {
        FTCentral.message("We have " + this.clusters_.size() + (this.clusters_.size() == 1 ? " cluster" : " clusters.") + "  Higher resolution source images may reveal finer attractor structure.", false);
        ArrayList<PDCluster> arrayList = new ArrayList<PDCluster>();
        ArrayList<PDCluster> arrayList2 = new ArrayList<PDCluster>();
        for (PDCluster object : this.clusters_) {
            BigQuaternion bigQuaternion = object.getAttractor();
            if (bigQuaternion == null) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        PDCluster[] pDClusterArray = arrayList.toArray(new PDCluster[0]);
        Arrays.sort(pDClusterArray, new ByBestPointRComparitor());
        for (PDCluster pDCluster : Arrays.asList(pDClusterArray)) {
            FTCentral.message(pDCluster.report(""), false);
        }
        for (PDCluster pDCluster : arrayList2) {
            FTCentral.message(pDCluster.report(""), false);
        }
    }

    private double atanBQ(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2) {
        Fraction fraction = bigQuaternion.r;
        Fraction fraction2 = bigQuaternion2.r;
        Fraction fraction3 = bigQuaternion.i;
        Fraction fraction4 = bigQuaternion2.i;
        Fraction fraction5 = fraction2.subtract(fraction);
        Fraction fraction6 = fraction4.subtract(fraction3);
        int n = fraction5.compareTo(zero);
        int n2 = fraction6.compareTo(zero);
        if (n == 0) {
            if (n2 == 0) {
                return 0.0;
            }
            if (n2 < 0) {
                return -1.5707963267948966;
            }
            return 1.5707963267948966;
        }
        Fraction fraction7 = fraction6.divide(fraction5);
        double d = fraction7.doubleValue();
        double d2 = Math.atan(d);
        if (n > 0) {
            return d2;
        }
        if (n2 > 0) {
            return d2 + Math.PI;
        }
        return d2 - Math.PI;
    }

    private double angleDelta(double d, double d2) {
        double d3 = d2 - d;
        double d4 = Math.PI;
        if (d3 > d4) {
            return d3 - 2.0 * d4;
        }
        if (d3 < -d4) {
            return d3 + 2.0 * d4;
        }
        if (d3 == -d4) {
            return d4;
        }
        return d3;
    }

    class PDCluster {
        PDCluster parent_;
        private int id_;
        private HashMap<Integer, PointData> members_;
        PointData[] sortedIncreasing_;
        PointData[] sortedDecreasing_;
        int period_;
        boolean foundFromConvergencePeriodP_;
        BigQuaternion attractor_;
        double deltaAngle_;
        PDCluster[] subClusters_;
        ByBestPointRComparitor byBestPtRDesc_;

        public PDCluster(int n, PDCluster pDCluster) {
            this.parent_ = pDCluster;
            this.id_ = n;
            this.members_ = new HashMap();
            this.sortedIncreasing_ = null;
            this.sortedDecreasing_ = null;
            this.period_ = 0;
            this.foundFromConvergencePeriodP_ = false;
            this.attractor_ = null;
            this.deltaAngle_ = 0.0;
            this.subClusters_ = null;
            this.byBestPtRDesc_ = new ByBestPointRComparitor();
        }

        public String report(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("[");
            stringBuilder.append("Cluster:" + this.id_);
            if (this.subClusters_ != null) {
                stringBuilder.append(" has " + this.subClusters_.length + " subcluster" + (this.subClusters_.length == 1 ? "" : "s") + "]");
                Arrays.sort(this.subClusters_, this.byBestPtRDesc_);
                for (PDCluster pDCluster : Arrays.asList(this.subClusters_)) {
                    stringBuilder.append("\n" + pDCluster.report(string + "   "));
                }
            } else {
                stringBuilder.append(", converged:" + this.foundFromConvergencePeriodP_);
                if (this.period_ == 0) {
                    stringBuilder.append(", period appears to be " + (this.sortedDecreasing_[0].getIteration() - this.sortedDecreasing_[1].getIteration()));
                } else {
                    stringBuilder.append(", period appears to be:" + this.period_);
                }
                if (this.attractor_ == null) {
                    stringBuilder.append(", last point:" + this.sortedDecreasing_[0].getPoint().toString());
                } else {
                    stringBuilder.append(", attractor:" + (this.attractor_ == null ? "unknown" : this.attractor_.toString()));
                }
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }

        public int getId() {
            return this.id_;
        }

        public int size() {
            return this.members_.values().size();
        }

        public BigQuaternion getAttractor() {
            return this.attractor_;
        }

        public int getPeriod() {
            return this.period_;
        }

        public void setPeriod(int n) {
            this.period_ = n;
        }

        public void setFoundFromConvergencePeriodP(boolean bl) {
            this.foundFromConvergencePeriodP_ = bl;
        }

        public boolean getFoundFromConvergencePeriodP() {
            return this.foundFromConvergencePeriodP_;
        }

        public void addMember(PointData pointData) {
            this.members_.put(pointData.getIteration(), pointData);
        }

        public HashMap<Integer, PointData> getMembers() {
            return this.members_;
        }

        public void sortMembers() {
            this.sortedDecreasing_ = this.members_.values().toArray(new PointData[0]);
            this.sortedIncreasing_ = this.members_.values().toArray(new PointData[0]);
            Arrays.sort(this.sortedDecreasing_, OrbitCluster.this.iterationDecreasing_);
            Arrays.sort(this.sortedIncreasing_, OrbitCluster.this.iterationIncreasing_);
        }

        public void prepContents() {
            PointData pointData = this.sortedIncreasing_[0];
            for (int i = 1; i < this.sortedIncreasing_.length; ++i) {
                PointData pointData2 = this.sortedIncreasing_[i];
                pointData.setDeltaIteration(pointData2.getIteration() - pointData.getIteration());
                pointData = pointData2;
            }
            PointData pointData3 = this.sortedIncreasing_[0];
            for (int i = 1; i < this.sortedIncreasing_.length; ++i) {
                PointData pointData4 = this.sortedIncreasing_[i];
                double d = OrbitCluster.this.atanBQ(pointData3.getPoint(), pointData4.getPoint());
                pointData4.setAngle(d);
                Fraction fraction = pointData4.getPoint().minus(pointData3.getPoint()).magnitude();
                pointData4.setDistance(fraction);
                pointData3 = pointData4;
            }
        }

        private int maybeSplitCluster(int n) {
            if (n == 1) {
                return 1;
            }
            double d = 1.0E-5;
            double d2 = this.sortedDecreasing_[0].getAngle();
            int n2 = 1;
            for (int i = 1; i < this.sortedDecreasing_.length - 1; ++i) {
                if (!(Math.abs(OrbitCluster.this.angleDelta(this.sortedDecreasing_[i].getAngle(), d2)) < d)) continue;
                n2 = i;
                break;
            }
            Fraction fraction = this.sortedDecreasing_[0].getDistance();
            Fraction fraction2 = new Fraction(fraction.timesScalar(1.0E-5));
            int n3 = n2;
            for (int i = 1; i < this.sortedDecreasing_.length - 1; ++i) {
                if (this.sortedDecreasing_[i].getDistance().minus(fraction).abs().compareTo(fraction2) >= 0) continue;
                n3 = i;
                break;
            }
            if (n2 > 1 && n2 == n3 && (n == 0 || n % n2 == 0 || n2 % n == 0)) {
                PDCluster pDCluster;
                Object object;
                int n4;
                int n5;
                if (n > n2) {
                    n2 = n;
                }
                double[] dArray = new double[n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray[n5] = this.sortedDecreasing_[n5].getAngle();
                }
                for (n5 = n2; n5 < this.sortedDecreasing_.length - 1; ++n5) {
                    double d3 = this.sortedDecreasing_[n5].getAngle();
                    if (Math.abs(OrbitCluster.this.angleDelta(d3, dArray[n5 % n2])) > d) {
                        return 0;
                    }
                    dArray[n5 % n2] = d3;
                }
                Fraction[] fractionArray = new Fraction[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    fractionArray[n4] = this.sortedDecreasing_[n4].getDistance();
                }
                for (n4 = n2; n4 < this.sortedDecreasing_.length - 1; ++n4) {
                    object = this.sortedDecreasing_[n4].getDistance();
                    if ((double)((Fraction)object).minus(fractionArray[n4 % n2]).abs().compareTo(fraction2) > d) {
                        return 0;
                    }
                    fractionArray[n4 % n2] = object;
                }
                this.subClusters_ = new PDCluster[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    this.subClusters_[n4] = new PDCluster(OrbitCluster.this.nextClusterNumber_++, this);
                }
                for (n4 = 0; n4 < this.sortedDecreasing_.length; ++n4) {
                    object = this.sortedDecreasing_[n4];
                    pDCluster = this.subClusters_[n4 % n2];
                    pDCluster.addMember((PointData)object);
                    ((PointData)object).setCluster(pDCluster);
                }
                n4 = 0;
                for (int i = 0; i < this.subClusters_.length; ++i) {
                    pDCluster = this.subClusters_[i];
                    pDCluster.sortMembers();
                    pDCluster.prepContents();
                    n4 = pDCluster.hasAttractorP() ? 1 : pDCluster.maybeSplitCluster(n4);
                }
            }
            return n2 > 1 ? n2 : 0;
        }

        private boolean hasAttractorP() {
            int n = this.sortedIncreasing_.length;
            if (n < 2) {
                this.attractor_ = null;
                return false;
            }
            if (this.sortedDecreasing_[0].getPoint().equals(this.sortedDecreasing_[1].getPoint())) {
                this.attractor_ = this.sortedDecreasing_[0].getPoint();
                return true;
            }
            if (n < 5) {
                this.attractor_ = null;
                return false;
            }
            PointData pointData = this.sortedIncreasing_[1];
            PointData pointData2 = this.sortedIncreasing_[2];
            this.deltaAngle_ = OrbitCluster.this.angleDelta(pointData.getAngle(), pointData2.getAngle());
            double d = this.deltaAngle_ < 0.0 ? -1.0 : 1.0;
            for (int i = 2; i < n; ++i) {
                pointData2 = this.sortedIncreasing_[i];
                Fraction fraction = pointData2.getDistance();
                if (fraction.compareTo(zero) == 0) {
                    this.attractor_ = pointData2.getPoint();
                    return true;
                }
                Fraction fraction2 = fraction.minus(pointData.getDistance());
                int n2 = fraction2.compareTo(zero);
                if (n2 > 0) {
                    this.attractor_ = null;
                    return false;
                }
                this.deltaAngle_ = OrbitCluster.this.angleDelta(pointData.getAngle(), pointData2.getAngle());
                if (this.deltaAngle_ * d <= 0.0) {
                    this.attractor_ = null;
                    return false;
                }
                pointData = pointData2;
            }
            this.attractor_ = this.approximateAttractor(n, this.deltaAngle_);
            return true;
        }

        private BigQuaternion approximateAttractor(int n, double d) {
            if (d == 0.0) {
                return this.sortedDecreasing_[0].getPoint();
            }
            PointData pointData = this.sortedDecreasing_[0];
            if (pointData.getDistance().compareTo(zero) == 0) {
                return this.sortedDecreasing_[0].getPoint();
            }
            boolean bl = false;
            int n2 = (int)Math.round(Math.PI * 4 / (d = Math.abs(d)));
            if (n2 > n) {
                n2 = (int)Math.round(Math.PI * 2 / d);
            }
            if (2 <= n2 && n2 < n) {
                bl = true;
            }
            if (bl) {
                BigQuaternion bigQuaternion = new BigQuaternion(0.0, 0.0, 0.0, 0.0, pointData.getPoint().getDenominator());
                for (int i = 0; i < n2; ++i) {
                    BigQuaternion bigQuaternion2 = this.sortedDecreasing_[i].getPoint();
                    bigQuaternion.plus_equal(bigQuaternion2);
                }
                return bigQuaternion.times_scalar(1.0 / (double)n2);
            }
            return this.sortedDecreasing_[0].getPoint();
        }

        private int findPeriodInMembers() {
            if (this.sortedDecreasing_.length < 2) {
                return Integer.MAX_VALUE;
            }
            int n = this.sortedDecreasing_[0].getIteration() - this.sortedDecreasing_[1].getIteration();
            int n2 = Math.min(20, this.sortedDecreasing_.length);
            for (int i = 2; i < n2; ++i) {
                if (this.sortedDecreasing_[i].getIteration() - this.sortedDecreasing_[i - 1].getIteration() == n) continue;
                return Integer.MAX_VALUE;
            }
            this.period_ = n;
            return n;
        }

        private boolean isCompatibleWithPeriod(int n, HashMap<Integer, Integer> hashMap) {
            int n2;
            int n3 = Math.min(20 * n, this.sortedDecreasing_.length);
            if (n3 >= (int)((double)(n2 = hashMap.get(n).intValue()) * 0.8)) {
                for (int i = 0; i < 4; ++i) {
                    int n4 = this.sortedDecreasing_[i].getIteration();
                    boolean bl = false;
                    for (int j = 1; j < n3; ++j) {
                        if (this.members_.get(n4 - j * n) != null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cluster: " + this.id_ + " size:" + this.members_.size() + " period:" + (Serializable)(this.period_ == Integer.MAX_VALUE ? "-" : Integer.valueOf(this.period_)));
            return stringBuilder.toString();
        }
    }

    public class PointData {
        private int iteration_;
        private BigQuaternion point_;
        private PointData[] neighbors_;
        private PDCluster cluster_;
        private int deltaIteration_;
        private Fraction distance_;
        private double angle_;

        public PointData(int n, BigQuaternion bigQuaternion) {
            this.iteration_ = n;
            this.point_ = bigQuaternion;
            this.neighbors_ = null;
            this.cluster_ = null;
            this.deltaIteration_ = 0;
        }

        public int getIteration() {
            return this.iteration_;
        }

        public BigQuaternion getPoint() {
            return this.point_;
        }

        public PDCluster getCluster() {
            return this.cluster_;
        }

        public void setCluster(PDCluster pDCluster) {
            this.cluster_ = pDCluster;
        }

        public PointData getNeighbor(int n) {
            if (this.neighbors_ != null && 0 <= n && n < this.neighbors_.length) {
                return this.neighbors_[n];
            }
            return null;
        }

        public PointData[] getNeighbors() {
            return this.neighbors_;
        }

        public void setNeighbors(PointData[] pointDataArray) {
            this.neighbors_ = pointDataArray;
        }

        public int getDeltaIteration() {
            return this.deltaIteration_;
        }

        public void setDeltaIteration(int n) {
            this.deltaIteration_ = n;
        }

        public double getAngle() {
            return this.angle_;
        }

        public void setAngle(double d) {
            this.angle_ = d;
        }

        public Fraction getDistance() {
            return this.distance_;
        }

        public void setDistance(Fraction fraction) {
            this.distance_ = fraction;
        }

        public PDCluster getNeighborClusterIfOne(int n) {
            PDCluster pDCluster = null;
            for (int i = 0; i < n; ++i) {
                PointData pointData = this.neighbors_[i];
                PDCluster pDCluster2 = pointData.getCluster();
                if (pDCluster2 == null) continue;
                if (pDCluster == null) {
                    pDCluster = pDCluster2;
                    continue;
                }
                if (pDCluster2 == pDCluster) continue;
                return OrbitCluster.this.MULTIPLE_CLUSTERS;
            }
            return pDCluster;
        }

        public void setCluster_addNeighborsToDeque(PDCluster pDCluster, ArrayDeque<PointData> arrayDeque, int n) {
            this.cluster_ = pDCluster;
            this.cluster_.addMember(this);
            for (int i = 0; i < n; ++i) {
                PointData pointData = this.neighbors_[i];
                PDCluster pDCluster2 = pointData.getCluster();
                if (pDCluster2 == null) {
                    arrayDeque.add(pointData);
                    continue;
                }
                if (pDCluster2 == this.cluster_) continue;
                OrbitCluster.this.borderPoints_.add(this);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("iter:" + this.getIteration() + "  ");
            stringBuilder.append("dIter:" + this.getDeltaIteration() + "  ");
            stringBuilder.append("clus:" + (Serializable)(this.getCluster() == null ? "None" : Integer.valueOf(this.getCluster().getId())) + "  ");
            stringBuilder.append("dist:" + this.getDistance() + "  ");
            stringBuilder.append("angle:" + this.getAngle() + "  ");
            if (this.neighbors_ != null) {
                stringBuilder.append("neigh:(" + this.neighbors_[0].getIteration() + ":" + (Serializable)(this.neighbors_[0].getCluster() == null ? "-" : Integer.valueOf(this.neighbors_[0].getCluster().getId())));
                for (int i = 1; i < this.neighbors_.length; ++i) {
                    stringBuilder.append(", " + this.neighbors_[i].getIteration() + ":" + (Serializable)(this.neighbors_[i].getCluster() == null ? "-" : Integer.valueOf(this.neighbors_[i].getCluster().getId())));
                }
                stringBuilder.append(")");
            } else {
                stringBuilder.append("neigh:-");
            }
            return stringBuilder.toString();
        }
    }

    static class PDIterationDecreasing
    implements Comparator<PointData> {
        PDIterationDecreasing() {
        }

        @Override
        public int compare(PointData pointData, PointData pointData2) {
            return pointData2.getIteration() - pointData.getIteration();
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    static class PDIterationIncreasing
    implements Comparator<PointData> {
        PDIterationIncreasing() {
        }

        @Override
        public int compare(PointData pointData, PointData pointData2) {
            return pointData.getIteration() - pointData2.getIteration();
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    class PDIncreasingSizeComparitor
    implements Comparator<PDCluster> {
        PDIncreasingSizeComparitor() {
        }

        @Override
        public int compare(PDCluster pDCluster, PDCluster pDCluster2) {
            return pDCluster.size() - pDCluster2.size();
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    class PDByRComparitor
    implements Comparator<PointData> {
        PDByRComparitor() {
        }

        @Override
        public int compare(PointData pointData, PointData pointData2) {
            return pointData.getPoint().r.compareTo(pointData2.getPoint().r);
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    class pDDistComparitor
    implements Comparator<PointData> {
        PointData base_;

        public pDDistComparitor(PointData pointData) {
            this.base_ = pointData;
        }

        @Override
        public int compare(PointData pointData, PointData pointData2) {
            if (pointData == this.base_) {
                if (pointData2 == this.base_) {
                    return 0;
                }
                return 1;
            }
            if (pointData2 == this.base_) {
                return -1;
            }
            Fraction fraction = pointData.getPoint().minus(this.base_.getPoint()).magnitude();
            Fraction fraction2 = pointData2.getPoint().minus(this.base_.getPoint()).magnitude();
            return fraction.compareTo(fraction2);
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    class ByBestPointRComparitor
    implements Comparator<PDCluster> {
        ByBestPointRComparitor() {
        }

        @Override
        public int compare(PDCluster pDCluster, PDCluster pDCluster2) {
            Fraction fraction = pDCluster.getAttractor() != null ? pDCluster.getAttractor().r : pDCluster.sortedDecreasing_[0].getPoint().r;
            Fraction fraction2 = pDCluster2.getAttractor() != null ? pDCluster2.getAttractor().r : pDCluster2.sortedDecreasing_[0].getPoint().r;
            return fraction.compareTo(fraction2);
        }

        @Override
        public boolean equals(Object object) {
            return this.equals(object);
        }
    }
}

