/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.OrbitCluster;
import us.lystad.fractaltop.OrbitReporter;
import us.lystad.fractaltop.QtoPixelPoint;

public class LiveOrbitReporter
implements OrbitReporter {
    FTWindow target_;
    FTCentral fTCentral_;
    BigQuaternion pointA_;
    BigQuaternion coeff_;
    BigQuaternion trans_;
    int fromIteration_;
    int toIteration_;
    int diameter_;
    long delay_;
    Color firstColor_;
    Color prevColor_;
    Color currentColor_;
    FTCanvas tCanvas_;
    Point firstPoint_ = null;
    Point prevPoint_ = null;
    FractalSpec tSpec_;
    int depth_ = 0;
    QtoPixelPoint converter_;
    Graphics grafix_;
    boolean startReportedP_;
    boolean analysisP_;
    OrbitCluster clusterRoot_ = null;
    boolean abortTrace_;

    public LiveOrbitReporter(FTWindow fTWindow, FTCentral fTCentral, BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, boolean bl, int n, int n2, int n3, long l, Color color, Color color2, Color color3) {
        this.target_ = fTWindow;
        this.fTCentral_ = fTCentral;
        this.pointA_ = bigQuaternion;
        this.coeff_ = bigQuaternion2;
        this.trans_ = bigQuaternion3;
        this.fromIteration_ = n;
        this.toIteration_ = n2;
        this.diameter_ = n3;
        this.delay_ = l;
        this.firstColor_ = color;
        this.prevColor_ = color2;
        this.currentColor_ = color3;
        this.analysisP_ = bl;
        this.tCanvas_ = this.target_.canvas();
        this.tSpec_ = this.tCanvas_.spec();
        this.converter_ = new QtoPixelPoint(this.tSpec_);
        this.grafix_ = this.tCanvas_.getGraphics();
        this.startReportedP_ = false;
        this.abortTrace_ = false;
    }

    @Override
    public void alert(String string) {
        FTCentral.message(string, true);
    }

    public BigQuaternion getCenter() {
        return this.pointA_;
    }

    @Override
    public void metaData(String string, String string2) {
        if (!this.startReportedP_) {
            this.startReportedP_ = true;
            FTCentral.message("TraceOrbit: Orbit begun", false);
        }
        if ("depth".equals(string)) {
            this.depth_ = Integer.parseInt(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean data(int n, BigQuaternion bigQuaternion) {
        if (this.abortTrace_) {
            throw new RuntimeException("User stopped trace.");
        }
        BigQuaternion bigQuaternion2 = new BigQuaternion(bigQuaternion);
        if (!this.startReportedP_) {
            this.startReportedP_ = true;
            FTCentral.message("TraceOrbit: Orbit begun", false);
        }
        if (this.firstPoint_ == null || n == 0) {
            this.firstPoint_ = this.converter_.getPixelPoint(bigQuaternion2);
            this.tCanvas_.addOrbitSpot(new BigQuaternion(bigQuaternion), this.diameter_, this.firstColor_, this.delay_ > 0L);
            this.tCanvas_.setOrbitColors(this.firstColor_, this.prevColor_);
            this.clusterRoot_ = this.analysisP_ ? new OrbitCluster(this, this.depth_) : null;
        } else if (this.fromIteration_ <= n && n <= this.toIteration_) {
            Point point = this.converter_.getPixelPoint(bigQuaternion2);
            this.tCanvas_.addOrbitSpot(new BigQuaternion(bigQuaternion), this.diameter_, this.currentColor_, this.delay_ > 0L);
            this.prevPoint_ = point;
            if (this.delay_ > 0L) {
                long l = System.currentTimeMillis() + this.delay_;
                LiveOrbitReporter liveOrbitReporter = this;
                synchronized (liveOrbitReporter) {
                    while (System.currentTimeMillis() < l) {
                        try {
                            this.wait(Math.max(1L, l - System.currentTimeMillis()));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (this.analysisP_ && this.clusterRoot_ != null) {
            this.clusterRoot_.add(n, bigQuaternion2);
        }
        return true;
    }

    @Override
    public void finish(int n) {
        FTCentral.message("TraceOrbit: Orbit terminated after " + n + " iterations.", false);
        this.tCanvas_.liveTraceEnded();
        if (n >= this.depth_) {
            if (this.analysisP_ && this.clusterRoot_ != null) {
                this.clusterRoot_.report();
            }
            FTCentral.message("Sequence finished after " + n + " steps without divergence.", true);
        } else if (!this.tCanvas_.liveOrbitStoppedByUserP()) {
            FTCentral.message("Sequence began to diverge after " + n + " steps.", true);
        }
    }

    @Override
    public void stop() {
        this.abortTrace_ = true;
    }
}

