/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseCkBoxListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FontSetter;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.OrbitXYListener;
import us.lystad.fractaltop.QtoPixelPoint;

public class LiveOrbitDialog
extends Dialog
implements OrbitXYListener {
    private final int RIGHT = 0;
    private final int UP = 1;
    private final String targetString_ = "Target Window";
    private final String diameterString_ = "Spot Diameter";
    private final String delayString_ = "Draw Delay (ms)";
    private final String firstColorString_ = "First Spot Color";
    private final String currentColorString_ = "Current Spot Color";
    private final String previousColorString_ = "Prev. Spot Color";
    private final String fromIterationString_ = "From Iteration";
    private final String toIterationString_ = "To Iteration";
    private final String pixelXString_ = "Pixel X";
    private final String pixelYString_ = "Pixel Y";
    private final String depthString_ = "Depth";
    private final String attrAnal1_ = "Attractor";
    private final String attrAnal2_ = "Analysis";
    private final String attrAnalAll_ = "Attractor Analysis";
    private Color firstColor_ = new Color(255, 87, 51);
    private Color currentColor_ = new Color(147, 112, 219);
    private Color previousColor_ = new Color(154, 205, 50);
    private TextField targetText_;
    private TextField fromLoopText_;
    private TextField toLoopText_;
    private TextField pixels_right_;
    private TextField pixels_up_;
    private TextField diameterText_;
    private TextField delayText_;
    private TextField depthText_;
    private Button first_color_button_;
    private Button current_color_button_;
    private Button past_color_button_;
    private Button mark_image_button_;
    private Button runButton_;
    private JCheckBox attractor_analysis_checkbox_;
    private FTWindow frame_;
    private FTCentral fTCentral_;
    private int tempInt_ = 0;
    private LiveOrbitDialog self_;

    public LiveOrbitDialog(FTWindow fTWindow, FTCentral fTCentral) {
        super(fTWindow, "Draw Orbit of Window " + fTWindow.frameNumber() + " Point", false);
        this.fTCentral_ = fTCentral;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.frame_ = fTWindow;
        this.addWindowListener(new MyWindowActionListener());
        this.self_ = this;
        int n = this.fTCentral_.findOrbitTargetFor(this.frame_);
        this.setLayout(new GridLayout(7, 1, 0, 5));
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        Panel panel5 = new Panel();
        Panel panel6 = new Panel();
        Panel panel7 = new Panel();
        this.add(panel);
        this.add(panel2);
        this.add(panel3);
        this.add(panel4);
        this.add(panel5);
        this.add(panel6);
        this.add(panel7);
        panel.setLayout(new GridLayout(1, 3));
        Label label = new Label("Target Window");
        label.addMouseListener(new DocuMouseListener("Target Window"));
        label.setAlignment(1);
        panel.add(label);
        arrayList.add(label);
        Label label2 = new Label("Spot Diameter");
        label2.addMouseListener(new DocuMouseListener("Spot Diameter"));
        label2.setAlignment(1);
        panel.add(label2);
        arrayList.add(label2);
        Label label3 = new Label("Draw Delay (ms)");
        label3.addMouseListener(new DocuMouseListener("Draw Delay (ms)"));
        label3.setAlignment(1);
        panel.add(label3);
        arrayList.add(label3);
        panel2.setLayout(new GridLayout(1, 3, 2, 0));
        this.targetText_ = new TextField(String.valueOf(n));
        this.targetText_.addTextListener(new TextIntLNR());
        panel2.add(this.targetText_);
        arrayList.add(this.targetText_);
        this.diameterText_ = new TextField("5");
        this.diameterText_.addTextListener(new TextIntLNR());
        panel2.add(this.diameterText_);
        arrayList.add(this.diameterText_);
        this.delayText_ = new TextField("300");
        this.delayText_.addTextListener(new TextIntLNR());
        panel2.add(this.delayText_);
        arrayList.add(this.delayText_);
        panel3.setLayout(new GridLayout(1, 4, 2, 0));
        this.first_color_button_ = new Button("First Spot Color");
        this.first_color_button_.setBackground(this.firstColor_);
        this.first_color_button_.addActionListener(new ChooseColorLNR("First Spot Color"));
        panel3.add(this.first_color_button_);
        arrayList.add(this.first_color_button_);
        this.past_color_button_ = new Button("Prev. Spot Color");
        this.past_color_button_.setBackground(this.previousColor_);
        this.past_color_button_.addActionListener(new ChooseColorLNR("Prev. Spot Color"));
        panel3.add(this.past_color_button_);
        arrayList.add(this.past_color_button_);
        this.current_color_button_ = new Button("Current Spot Color");
        this.current_color_button_.setBackground(this.currentColor_);
        this.current_color_button_.addActionListener(new ChooseColorLNR("Current Spot Color"));
        panel3.add(this.current_color_button_);
        arrayList.add(this.current_color_button_);
        panel4.setLayout(new GridLayout(1, 4));
        Label label4 = new Label("From Iteration");
        label4.addMouseListener(new DocuMouseListener("From Iteration"));
        label4.setAlignment(1);
        panel4.add(label4);
        arrayList.add(label4);
        Label label5 = new Label("To Iteration");
        label5.addMouseListener(new DocuMouseListener("To Iteration"));
        label5.setAlignment(1);
        panel4.add(label5);
        arrayList.add(label5);
        Label label6 = new Label("Pixel X");
        label6.addMouseListener(new DocuMouseListener("Pixel X"));
        label6.setAlignment(1);
        panel4.add(label6);
        arrayList.add(label6);
        Label label7 = new Label("Pixel Y");
        label7.addMouseListener(new DocuMouseListener("Pixel Y"));
        label7.setAlignment(1);
        panel4.add(label7);
        arrayList.add(label7);
        panel5.setLayout(new GridLayout(1, 4, 2, 0));
        this.fromLoopText_ = new TextField("1");
        this.fromLoopText_.addTextListener(new TextIntLNR());
        panel5.add(this.fromLoopText_);
        arrayList.add(this.fromLoopText_);
        this.toLoopText_ = new TextField("25");
        this.toLoopText_.addTextListener(new TextIntLNR());
        panel5.add(this.toLoopText_);
        arrayList.add(this.toLoopText_);
        int n2 = this.frame_.getSpec().pix_width / 2;
        this.pixels_right_ = new TextField(String.valueOf(n2));
        this.pixels_right_.addTextListener(new TextIntLNR());
        panel5.add(this.pixels_right_);
        arrayList.add(this.pixels_right_);
        n2 = this.frame_.getSpec().pix_height / 2;
        this.pixels_up_ = new TextField(String.valueOf(n2));
        this.pixels_up_.addTextListener(new TextIntLNR());
        panel5.add(this.pixels_up_);
        arrayList.add(this.pixels_up_);
        panel6.setLayout(new GridLayout(1, 4));
        Label label8 = new Label("Depth");
        label8.addMouseListener(new DocuMouseListener("Depth"));
        label8.setAlignment(1);
        panel6.add(label8);
        arrayList.add(label8);
        JLabel jLabel = new JLabel("Attractor");
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(3);
        jLabel.setAlignmentX(0.5f);
        jLabel.setAlignmentY(1.0f);
        jLabel.addMouseListener(new DocuMouseListener("Attractor Analysis"));
        panel6.add(jLabel);
        arrayList.add(jLabel);
        this.mark_image_button_ = new Button("Mark Pixel");
        this.mark_image_button_.addActionListener(new markPtLNR("Mark Pixel"));
        panel6.add(this.mark_image_button_);
        arrayList.add(this.mark_image_button_);
        Button button = new Button("Click pix for X,Y");
        button.addActionListener(new click4XYLNR("Click pix for X,Y"));
        panel6.add(button);
        arrayList.add(button);
        panel7.setLayout(new GridLayout(1, 4, 2, 0));
        int n3 = this.frame_.getSpec().depth;
        this.depthText_ = new TextField(String.valueOf(n3 * 10));
        this.depthText_.addTextListener(new TextIntLNR());
        panel7.add(this.depthText_);
        arrayList.add(this.depthText_);
        this.attractor_analysis_checkbox_ = new JCheckBox("Analysis", false);
        this.attractor_analysis_checkbox_.addMouseListener(new DocuMouseCkBoxListener(this.attractor_analysis_checkbox_, "Attractor Analysis"));
        arrayList.add(this.attractor_analysis_checkbox_);
        panel7.add(this.attractor_analysis_checkbox_);
        Button button2 = new Button("CLOSE");
        button2.addActionListener(new CloseLNR("Orbit:CLOSE"));
        arrayList.add(button2);
        panel7.add(button2);
        this.runButton_ = new Button("RUN");
        this.runButton_.addActionListener(new runLNR("Orbit:RUN"));
        panel7.add(this.runButton_);
        arrayList.add(this.runButton_);
        this.setSize(400, 280);
        String[] stringArray = new String[]{"Courier", "courier", "Dialog", "dialog", "Times", "times"};
        FontSetter fontSetter = new FontSetter(stringArray, 1, 12);
        fontSetter.setComponentFonts(arrayList);
        fTCentral.setLocationRelativeTo(fTWindow, this, true);
        this.checkUserEntries_disableRun();
        this.setVisible(true);
    }

    @Override
    public void setXY(int n, int n2) {
        this.pixels_right_.setText(String.valueOf(n));
        this.pixels_up_.setText(String.valueOf(n2));
    }

    public void setDepth(int n) {
        this.depthText_.setText(String.valueOf(n));
    }

    int getIntValue(TextField textField) {
        String string = textField.getText();
        try {
            return Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private boolean checkXY_disableMark() {
        boolean bl = true;
        boolean bl2 = true;
        FractalSpec fractalSpec = this.frame_.getSpec();
        int n = this.getIntValue(this.pixels_right_);
        int n2 = this.getIntValue(this.pixels_up_);
        bl = 0 <= n && n < fractalSpec.pix_width;
        this.pixels_right_.setForeground(bl ? Color.black : Color.red);
        bl2 = 0 <= n2 && n2 < fractalSpec.pix_height;
        this.pixels_up_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        this.mark_image_button_.setEnabled(bl);
        return bl;
    }

    private void checkUserEntries_disableRun() {
        boolean bl = this.checkXY_disableMark();
        boolean bl2 = true;
        FractalSpec fractalSpec = this.frame_.getSpec();
        int n = this.getIntValue(this.targetText_);
        FTWindow fTWindow = this.fTCentral_.getFrame(n);
        FractalSpec fractalSpec2 = fTWindow != null ? fTWindow.getSpec() : null;
        bl2 = fractalSpec2 != null && fractalSpec2.rangeOver == 0;
        this.targetText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n2 = this.getIntValue(this.pixels_right_);
        bl2 = 0 <= n2 && n2 < fractalSpec.pix_width;
        this.pixels_right_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n3 = this.getIntValue(this.pixels_up_);
        bl2 = 0 <= n3 && n3 < fractalSpec.pix_height;
        this.pixels_up_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n4 = this.getIntValue(this.depthText_);
        bl2 = n4 > 0;
        this.depthText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n5 = this.getIntValue(this.fromLoopText_);
        bl2 = 0 <= n5 && n5 < n4;
        this.fromLoopText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n6 = this.getIntValue(this.toLoopText_);
        bl2 = n5 <= n6 && n6 <= n4;
        this.toLoopText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n7 = this.getIntValue(this.diameterText_);
        bl2 = 2 <= n7 && n7 <= 20;
        this.diameterText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        int n8 = this.getIntValue(this.delayText_);
        bl2 = 0 <= n8 && n8 < 300000;
        this.delayText_.setForeground(bl2 ? Color.black : Color.red);
        bl = bl && bl2;
        this.runButton_.setEnabled(bl);
    }

    class MyWindowActionListener
    extends WindowAdapter {
        MyWindowActionListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                LiveOrbitDialog.this.setVisible(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class TextIntLNR
    implements TextListener {
        @Override
        public void textValueChanged(TextEvent textEvent) {
            LiveOrbitDialog.this.checkUserEntries_disableRun();
        }
    }

    class ChooseColorLNR
    extends DocuActionListener {
        Component myButton_;
        CCOK_LNR okLNR_;
        CCCancel_LNR cancelLNR_;
        JColorChooser chooser_;

        public ChooseColorLNR(String string) {
            super(LiveOrbitDialog.this.frame_, string);
            this.okLNR_ = new CCOK_LNR();
            this.cancelLNR_ = new CCCancel_LNR();
            this.chooser_ = null;
        }

        @Override
        public void leftClickAction() {
            this.myButton_ = (Component)this.e_.getSource();
            boolean bl = true;
            Color color = this.myButton_.getBackground();
            this.chooser_ = new JColorChooser(new DefaultColorSelectionModel(color));
            JDialog jDialog = JColorChooser.createDialog(LiveOrbitDialog.this.frame_, "Choose spot color", bl, this.chooser_, this.okLNR_, this.cancelLNR_);
            jDialog.setVisible(true);
        }

        public class CCOK_LNR
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseColorLNR.this.myButton_.setBackground(ChooseColorLNR.this.chooser_.getColor());
            }
        }

        public class CCCancel_LNR
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        }
    }

    class markPtLNR
    extends DocuActionListener {
        public markPtLNR(String string) {
            super(LiveOrbitDialog.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            int n = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.pixels_right_);
            int n2 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.pixels_up_);
            int n3 = LiveOrbitDialog.this.frame_.getSpec().pix_height - 1 - n2;
            LiveOrbitDialog.this.frame_.canvas().drawCrossFlag(n, n3);
        }
    }

    class click4XYLNR
    extends DocuActionListener {
        public click4XYLNR(String string) {
            super(LiveOrbitDialog.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            LiveOrbitDialog.this.frame_.canvas().addOrbitXYListener(LiveOrbitDialog.this.self_);
        }
    }

    class CloseLNR
    extends DocuActionListener {
        public CloseLNR(String string) {
            super(LiveOrbitDialog.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            LiveOrbitDialog.this.setVisible(false);
        }
    }

    class runLNR
    extends DocuActionListener {
        public runLNR(String string) {
            super(LiveOrbitDialog.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FractalSpec fractalSpec = LiveOrbitDialog.this.frame_.getSpec();
            FTLooper fTLooper = LiveOrbitDialog.this.fTCentral_.findLoopObject(fractalSpec.which);
            if (fTLooper == null || !fTLooper.traceOrbit_p()) {
                FTCentral cfr_ignored_0 = LiveOrbitDialog.this.fTCentral_;
                FTCentral.message("Looper does not support traceOrbit operation.", true);
                return;
            }
            int n = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.depthText_);
            int n2 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.pixels_right_);
            int n3 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.pixels_up_);
            int n4 = fractalSpec.pix_height - 1 - n3;
            int n5 = n2;
            QtoPixelPoint qtoPixelPoint = new QtoPixelPoint(fractalSpec);
            BigQuaternion bigQuaternion = qtoPixelPoint.getQuaternion(n5, n4);
            BigQuaternion bigQuaternion2 = new BigQuaternion(fractalSpec.coeff);
            BigQuaternion bigQuaternion3 = new BigQuaternion(fractalSpec.trans);
            int n6 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.fromLoopText_);
            int n7 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.toLoopText_);
            int n8 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.targetText_);
            FTWindow fTWindow = LiveOrbitDialog.this.fTCentral_.getFrame(n8);
            if (fTWindow != null) {
                fTWindow.setVisible(true);
                fTWindow.toFront();
                n6 = n6 > 0 ? Math.min(n, n6) : 0;
                int n9 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.diameterText_);
                int n10 = LiveOrbitDialog.this.getIntValue(LiveOrbitDialog.this.delayText_);
                n7 = n7 > 0 ? Math.max(n6, Math.min(n, n7)) : n;
                LiveOrbitDialog.this.firstColor_ = LiveOrbitDialog.this.first_color_button_.getBackground();
                LiveOrbitDialog.this.currentColor_ = LiveOrbitDialog.this.current_color_button_.getBackground();
                LiveOrbitDialog.this.previousColor_ = LiveOrbitDialog.this.past_color_button_.getBackground();
                fTWindow.canvas().traceTheOrbit(fTWindow, LiveOrbitDialog.this.fTCentral_, fTLooper, bigQuaternion, bigQuaternion2, bigQuaternion3, n, LiveOrbitDialog.this.attractor_analysis_checkbox_.isSelected(), n6, n7, n9, n10, LiveOrbitDialog.this.firstColor_, LiveOrbitDialog.this.previousColor_, LiveOrbitDialog.this.currentColor_);
            }
        }
    }
}

