/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import us.lystad.fractaltop.DocuMouseListener;

class LabeledTextField
extends Panel
implements TextListener {
    public static final int IS_INT = 0;
    public static final int IS_DOUBLE = 1;
    public static final int IS_STRING = 3;
    private int valueType = 1;
    public static final int SIDE_BY_SIDE_1 = 0;
    public static final int SIDE_BY_SIDE_2 = 1;
    public static final int VERTICAL = 2;
    public static final int NO_LABEL = 3;
    private int styleType = 2;
    int int_value;
    double double_value;
    boolean is_ok_p = false;
    boolean check_needed_p = true;
    Label the_label = null;
    private TextField text_ = null;

    public LabeledTextField(String string, int n, int n2) {
        this.valueType = n;
        this.styleType = n2;
        if (n2 == 0) {
            this.setLayout(new BorderLayout(2, 0));
            this.text_ = new TextField("0", 18);
            this.text_.addTextListener(this);
            this.the_label = new Label(" ", 1);
            this.add("Center", this.the_label);
            this.add("East", this.text_);
        } else if (n2 == 1) {
            this.setLayout(new GridLayout(1, 2, 0, 0));
            this.text_ = new TextField("1", 9);
            this.text_.addTextListener(this);
            this.the_label = new Label(string, 1);
            this.add(this.the_label);
            this.add(this.text_);
        } else if (n2 == 2) {
            this.setLayout(new BorderLayout(2, 2));
            this.text_ = new TextField("0", 18);
            this.text_.addTextListener(this);
            this.the_label = new Label(string, 1);
            this.add("Center", this.the_label);
            this.add("South", this.text_);
        } else if (n2 == 3) {
            this.setLayout(new BorderLayout(2, 2));
            this.text_ = new TextField("0", 18);
            this.text_.addTextListener(this);
            this.add("Center", this.text_);
        } else {
            System.err.println("LabeledTextField() - Illegal styleTypeArg.");
        }
        DocuMouseListener docuMouseListener = new DocuMouseListener(string);
        if (this.the_label != null) {
            this.the_label.addMouseListener(docuMouseListener);
        }
        this.valueOk_p();
    }

    public void setText(String string) {
        this.text_.setText(string);
    }

    public String getText() {
        return this.text_.getText();
    }

    public void set_label(String string) {
        if (this.styleType != 3) {
            this.the_label.setText(string);
        }
    }

    @Override
    public void setFont(Font font) {
        this.text_.setFont(font);
        if (this.the_label != null) {
            this.the_label.setFont(font);
        }
        super.setFont(font);
    }

    private boolean intConvertible_p(String string) {
        try {
            Integer n = Integer.valueOf(string);
            this.int_value = n;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean doubleConvertible_p(String string) {
        try {
            Double d = Double.valueOf(string);
            this.double_value = d;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean valueOk_p(String string) {
        boolean bl = false;
        if (this.valueType == 0) {
            if (string.length() > 0 && this.intConvertible_p(string)) {
                bl = true;
            }
        } else if (this.valueType == 1) {
            if (string.length() > 0 && this.doubleConvertible_p(string)) {
                bl = true;
            }
        } else if (this.valueType == 3) {
            if (string.length() > 0 && Character.isJavaIdentifierStart(string.charAt(0))) {
                bl = true;
            }
        } else {
            System.err.println("LabeledTextField valueOk_p - impossible valueType value.");
        }
        if (bl) {
            this.text_.setForeground(Color.black);
        } else {
            this.text_.setForeground(Color.red);
        }
        this.repaint();
        return bl;
    }

    public boolean valueOk_p() {
        return this.valueOk_p(this.text_.getText());
    }

    public int intValue() {
        if (this.valueOk_p() && this.valueType == 0) {
            return this.int_value;
        }
        return 0;
    }

    public double doubleValue() {
        if (this.valueOk_p() && this.valueType == 1) {
            return this.double_value;
        }
        return 0.0;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.valueOk_p();
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.text_.addKeyListener(keyListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.text_.addTextListener(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.text_.removeTextListener(textListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.text_.addActionListener(actionListener);
    }
}

