/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import us.lystad.fractaltop.FTCentral;

class IntDialog
extends Dialog {
    TextField textArea_;
    boolean cancelled_P_ = true;
    boolean hasSign_P_ = true;

    public IntDialog(String string, Frame frame, String string2) {
        super(frame, string, true);
        this.setLayout(new BorderLayout(4, 10));
        Button button = new Button("Cancel");
        Button button2 = new Button("OK");
        this.textArea_ = new TextField(string2);
        this.textArea_.addTextListener(new TextIntLNR(this.textArea_, button2));
        this.textArea_.addActionListener(new EnterDetector());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 4, 4));
        button.addActionListener(new CancelLNR());
        button2.addActionListener(new OKLNR());
        panel.add(button);
        panel.add(new Label());
        panel.add(button2);
        this.add("Center", this.textArea_);
        this.add("South", panel);
        this.setSize(240, 92);
        this.validate();
        FTCentral.setLocationRelativeToActiveFrame(this);
        this.setVisible(true);
    }

    public int getValue() {
        if (this.cancelled_P_) {
            return 0;
        }
        if (this.textArea_.getText().length() == 0) {
            FTCentral.message("IntDialog giving 0 length 0.", false);
            this.cancelled_P_ = true;
            return 0;
        }
        try {
            String string = this.textArea_.getText();
            this.hasSign_P_ = string.startsWith("-") || string.startsWith("+");
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.cancelled_P_ = true;
            return 0;
        }
    }

    public double getDoubleValue() {
        if (this.cancelled_P_) {
            return 0.0;
        }
        if (this.textArea_.getText().length() == 0) {
            FTCentral.message("IntDialog giving 0 length 0.", false);
            this.cancelled_P_ = true;
            return 0.0;
        }
        try {
            String string = this.textArea_.getText();
            this.hasSign_P_ = string.startsWith("-") || string.startsWith("+");
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.cancelled_P_ = true;
            return 0.0;
        }
    }

    public boolean hasSign_P() {
        return this.hasSign_P_;
    }

    public boolean cancelled_P() {
        return this.cancelled_P_;
    }

    public class TextIntLNR
    implements TextListener {
        TextField textField_;
        Button OKButton_;

        public TextIntLNR(TextField textField, Button button) {
            this.textField_ = textField;
            this.OKButton_ = button;
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            boolean bl = false;
            try {
                int n = Integer.parseInt(IntDialog.this.textArea_.getText());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.textField_.setForeground(bl ? Color.black : Color.red);
            this.OKButton_.setEnabled(bl);
        }
    }

    public class EnterDetector
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Double.parseDouble(IntDialog.this.textArea_.getText());
                IntDialog.this.cancelled_P_ = false;
                IntDialog.this.setVisible(false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class CancelLNR
    implements ActionListener {
        CancelLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IntDialog.this.cancelled_P_ = true;
            IntDialog.this.setVisible(false);
        }
    }

    class OKLNR
    implements ActionListener {
        OKLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IntDialog.this.cancelled_P_ = false;
            IntDialog.this.setVisible(false);
        }
    }
}

