/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.GIFEncoderPkg;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;

public class GIFEncoder {
    public static int byteBlock = 0;
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    private static final int NO_TRANSPARENT_PIXEL = -1;
    short width_;
    short height_;
    int numColors_;
    byte[] pixels_;
    byte[] colors_ = null;
    int transparentPixel_ = -1;
    String comment_ = null;

    public GIFEncoder(int n, int n2, byte[] byArray, IndexColorModel indexColorModel) throws AWTException {
        int n3;
        this.width_ = (short)n;
        this.height_ = (short)n2;
        this.pixels_ = byArray;
        int n4 = indexColorModel.getMapSize();
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        indexColorModel.getReds(byArray2);
        indexColorModel.getGreens(byArray3);
        indexColorModel.getBlues(byArray4);
        n4 = Math.min(256, n4);
        this.colors_ = new byte[768];
        for (n3 = 0; n3 < n4; ++n3) {
            this.colors_[3 * n3] = byArray2[n3];
            this.colors_[3 * n3 + 1] = byArray3[n3];
            this.colors_[3 * n3 + 2] = byArray4[n3];
        }
        while (n3 < 256) {
            this.colors_[3 * n3] = 0;
            this.colors_[3 * n3 + 1] = 0;
            this.colors_[3 * n3 + 2] = 0;
            ++n3;
        }
        int n5 = 256;
        this.numColors_ = 1 << this.BitUtils_BitsNeeded(n5);
    }

    public GIFEncoder(Image image, IndexColorModel indexColorModel) throws AWTException {
        int n;
        int n2;
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] nArray = new int[this.width_ * this.height_];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, nArray, 0, (int)this.width_);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + pixelGrabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println(" GIFEncoder constructor exception trying to grab pixels: " + interruptedException);
        }
        byte[][] byArray = new byte[this.width_][this.height_];
        byte[][] byArray2 = new byte[this.width_][this.height_];
        byte[][] byArray3 = new byte[this.width_][this.height_];
        int n3 = 0;
        for (n2 = 0; n2 < this.height_; ++n2) {
            for (int i = 0; i < this.width_; ++i) {
                byArray[i][n2] = (byte)(nArray[n3] >> 16 & 0xFF);
                byArray2[i][n2] = (byte)(nArray[n3] >> 8 & 0xFF);
                byArray3[i][n2] = (byte)(nArray[n3] & 0xFF);
                ++n3;
            }
        }
        n2 = indexColorModel.getMapSize();
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        indexColorModel.getReds(byArray4);
        indexColorModel.getGreens(byArray5);
        indexColorModel.getBlues(byArray6);
        n2 = Math.min(256, n2);
        this.colors_ = new byte[768];
        for (n = 0; n < n2; ++n) {
            this.colors_[3 * n] = byArray4[n];
            this.colors_[3 * n + 1] = byArray5[n];
            this.colors_[3 * n + 2] = byArray6[n];
        }
        while (n < 256) {
            this.colors_[3 * n] = 0;
            this.colors_[3 * n + 1] = 0;
            this.colors_[3 * n + 2] = 0;
            ++n;
        }
        this.colors_[0] = 1;
        this.pixels_ = new byte[this.width_ * this.height_];
        int n4 = 256;
        this.numColors_ = 1 << this.BitUtils_BitsNeeded(n4);
        for (int i = 0; i < this.width_; ++i) {
            for (int j = 0; j < this.height_; ++j) {
                int n5;
                for (n5 = 0; n5 < n4; ++n5) {
                    if (this.colors_[n5 * 3] != byArray[i][j] || this.colors_[n5 * 3 + 1] != byArray2[i][j] || this.colors_[n5 * 3 + 2] != byArray3[i][j]) continue;
                    this.pixels_[j * this.width_ + i] = (byte)n5;
                    break;
                }
                if (n5 < n4) continue;
                System.out.println("GIFEncoder encountered invalid pixel.");
                this.pixels_[j * this.width_ + i] = 127;
            }
        }
    }

    public void setComment(String string) {
        this.comment_ = string;
    }

    public void Write(OutputStream outputStream) throws IOException {
        this.BitUtils_WriteString(outputStream, "GIF87a");
        ScreenDescriptor screenDescriptor = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        screenDescriptor.Write(outputStream);
        outputStream.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor imageDescriptor = new ImageDescriptor(this.width_, this.height_, ',');
        imageDescriptor.Write(outputStream);
        byte by = this.BitUtils_BitsNeeded(this.numColors_);
        if (by == 1) {
            by = (byte)(by + 1);
        }
        outputStream.write(by);
        this.LZWCompress(outputStream, by, this.pixels_);
        outputStream.write(0);
        outputStream.write(59);
        outputStream.flush();
    }

    public void JavaQuatWrite(OutputStream outputStream, String string, boolean bl, double d) throws IOException {
        Object object;
        this.BitUtils_WriteString(outputStream, "GIF89a");
        ScreenDescriptor screenDescriptor = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        screenDescriptor.Write(outputStream);
        outputStream.write(this.colors_, 0, this.colors_.length);
        if (string != null) {
            object = new byte[3];
            if (d == 1.4) {
                object[0] = 48;
                object[1] = 49;
                object[2] = 52;
                var8_7 = this.pixels_[0] >= 0 ? this.pixels_[0] : this.pixels_[0] + 256;
                this.colors_[0] = this.colors_[var8_7 * 3];
                this.colors_[1] = this.colors_[var8_7 * 3 + 1];
                this.colors_[2] = this.colors_[var8_7 * 3 + 2];
                this.pixels_[0] = 0;
            } else {
                object[0] = 48;
                var8_7 = Double.valueOf(d * 10.0).intValue();
                String string2 = String.valueOf(var8_7);
                object[1] = (byte)string2.charAt(0);
                object[2] = (byte)string2.charAt(1);
            }
            ApplicationExtension applicationExtension = new ApplicationExtension("FrctlTop", (byte[])object);
            applicationExtension.write(outputStream, string);
        }
        if (this.comment_ != null) {
            object = new CommentExtension();
            ((CommentExtension)object).write(outputStream, this.comment_);
        }
        if (this.transparentPixel_ != -1) {
            object = new GraphicsControlExtension(this.transparentPixel_);
            ((GraphicsControlExtension)object).Write(outputStream);
        }
        object = new ImageDescriptor(this.width_, this.height_, ',');
        if (bl) {
            ((ImageDescriptor)object).SetInterlaceFlag((byte)1);
        }
        ((ImageDescriptor)object).Write(outputStream);
        byte by = this.BitUtils_BitsNeeded(this.numColors_);
        if (by == 1) {
            by = (byte)(by + 1);
        }
        outputStream.write(by);
        this.LZWCompress(outputStream, by, this.pixels_);
        outputStream.write(0);
        outputStream.write(59);
        outputStream.flush();
    }

    public void setTransparentPixel(int n) {
        this.transparentPixel_ = n;
    }

    public void LZWCompress(OutputStream outputStream, int n, byte[] byArray) throws IOException {
        byteBlock = 0;
        short s = -1;
        BitFile bitFile = new BitFile(outputStream);
        LZWStringTable lZWStringTable = new LZWStringTable();
        int n2 = 1 << n;
        int n3 = n2 + 1;
        int n4 = n + 1;
        int n5 = (1 << n4) - 1;
        lZWStringTable.ClearTable(n);
        bitFile.WriteBits(n2, n4);
        for (int n6 : byArray) {
            short s2 = lZWStringTable.FindCharString(s, (byte)n6);
            if (s2 != -1) {
                s = s2;
                continue;
            }
            bitFile.WriteBits(s, n4);
            if (lZWStringTable.AddCharString(s, (byte)n6) > n5) {
                if (++n4 > 12) {
                    bitFile.WriteBits(n2, n4 - 1);
                    lZWStringTable.ClearTable(n);
                    n4 = n + 1;
                }
                n5 = (1 << n4) - 1;
            }
            s = (short)(n6 < 0 ? n6 + 256 : n6);
        }
        if (s != -1) {
            bitFile.WriteBits(s, n4);
        }
        bitFile.WriteBits(n3, n4);
        bitFile.Flush();
    }

    byte BitUtils_BitsNeeded(int n) {
        byte by = 1;
        if (n-- == 0) {
            return 0;
        }
        while ((n >>= 1) != 0) {
            by = (byte)(by + 1);
        }
        return by;
    }

    void BitUtils_WriteWord(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s & 0xFF);
        outputStream.write(s >> 8 & 0xFF);
    }

    void BitUtils_WriteString(OutputStream outputStream, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }

    class ScreenDescriptor {
        public short localScreenWidth_;
        public short localScreenHeight_;
        private byte byte_;
        public byte backgroundColorIndex_;
        public byte pixelAspectRatio_;

        public ScreenDescriptor(short s, short s2, int n) {
            this.localScreenWidth_ = s;
            this.localScreenHeight_ = s2;
            this.SetGlobalColorTableSize((byte)(GIFEncoder.this.BitUtils_BitsNeeded(n) - 1));
            this.SetGlobalColorTableFlag((byte)1);
            this.SetSortFlag((byte)0);
            this.SetColorResolution((byte)7);
            this.backgroundColorIndex_ = 0;
            this.pixelAspectRatio_ = 0;
        }

        public void Write(OutputStream outputStream) throws IOException {
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.localScreenWidth_);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.localScreenHeight_);
            outputStream.write(this.byte_);
            outputStream.write(this.backgroundColorIndex_);
            outputStream.write(this.pixelAspectRatio_);
        }

        public void SetGlobalColorTableSize(byte by) {
            this.byte_ = (byte)(this.byte_ | by & 7);
        }

        public void SetSortFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 3);
        }

        public void SetColorResolution(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 7) << 4);
        }

        public void SetGlobalColorTableFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
        }
    }

    class ImageDescriptor {
        public byte separator_;
        public short leftPosition_;
        public short topPosition_;
        public short width_;
        public short height_;
        private byte byte_;

        public ImageDescriptor(short s, short s2, char c) {
            this.separator_ = (byte)c;
            this.leftPosition_ = 0;
            this.topPosition_ = 0;
            this.width_ = s;
            this.height_ = s2;
            this.SetLocalColorTableSize((byte)0);
            this.SetReserved((byte)0);
            this.SetSortFlag((byte)0);
            this.SetInterlaceFlag((byte)0);
            this.SetLocalColorTableFlag((byte)0);
        }

        public void Write(OutputStream outputStream) throws IOException {
            outputStream.write(this.separator_);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.leftPosition_);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.topPosition_);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.width_);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.height_);
            outputStream.write(this.byte_);
        }

        public void SetLocalColorTableSize(byte by) {
            this.byte_ = (byte)(this.byte_ | by & 7);
        }

        public void SetReserved(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 3) << 3);
        }

        public void SetSortFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 5);
        }

        public void SetInterlaceFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 6);
        }

        public void SetLocalColorTableFlag(byte by) {
            this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
        }
    }

    class ApplicationExtension {
        private String identifier_;
        private byte[] authCode_;

        ApplicationExtension(String string, byte[] byArray) {
            this.identifier_ = string + "      FT";
            this.identifier_ = this.identifier_.substring(0, 8);
            this.authCode_ = new byte[3];
            System.arraycopy(byArray, 0, this.authCode_, 0, 3);
        }

        void write(OutputStream outputStream, String string) throws IOException {
            int n;
            outputStream.write(33);
            outputStream.write(-1);
            outputStream.write(11);
            GIFEncoder.this.BitUtils_WriteString(outputStream, this.identifier_);
            outputStream.write(this.authCode_[0]);
            outputStream.write(this.authCode_[1]);
            outputStream.write(this.authCode_[2]);
            int n2 = 0;
            for (int i = string.length(); i > 0; i -= n) {
                n = Math.min(i, 255);
                outputStream.write((byte)n);
                int n3 = n2 + n;
                while (n2 < n3) {
                    outputStream.write((byte)string.charAt(n2++));
                }
            }
            outputStream.write(0);
        }
    }

    class CommentExtension {
        CommentExtension() {
        }

        void write(OutputStream outputStream, String string) throws IOException {
            int n;
            outputStream.write(33);
            outputStream.write(-2);
            int n2 = 0;
            for (int i = string.length(); i > 0; i -= n) {
                n = Math.min(i, 255);
                outputStream.write((byte)n);
                int n3 = n2 + n;
                while (n2 < n3) {
                    outputStream.write((byte)string.charAt(n2++));
                }
            }
            outputStream.write(0);
        }
    }

    class GraphicsControlExtension {
        private byte extension_indicator = (byte)33;
        private byte graphics_control_label = (byte)-7;
        private byte block_size = (byte)4;
        private byte flags = 0;
        private short time_delay = 0;
        private byte transparent_index = 0;
        private byte block_terminator = 0;

        GraphicsControlExtension(int n) {
            if (n >= 0) {
                this.flags = (byte)(this.flags | 1);
                this.transparent_index = (byte)n;
            }
        }

        public void Write(OutputStream outputStream) throws IOException {
            outputStream.write(this.extension_indicator);
            outputStream.write(this.graphics_control_label);
            outputStream.write(this.block_size);
            outputStream.write(this.flags);
            GIFEncoder.this.BitUtils_WriteWord(outputStream, this.time_delay);
            outputStream.write(this.transparent_index);
            outputStream.write(this.block_terminator);
        }
    }

    class BitFile {
        OutputStream output_;
        byte[] buffer_;
        int index_;
        int bitsLeft_;

        public BitFile(OutputStream outputStream) {
            this.output_ = outputStream;
            this.buffer_ = new byte[256];
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }

        public void Flush() throws IOException {
            int n = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
            if (n > 0) {
                this.output_.write(n);
                this.output_.write(this.buffer_, 0, n);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
        }

        public void WriteBits(int n, int n2) throws IOException {
            int n3 = 255;
            do {
                if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                    this.output_.write(n3);
                    this.output_.write(this.buffer_, 0, n3);
                    this.buffer_[0] = 0;
                    this.index_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (n2 <= this.bitsLeft_) {
                    int n4 = this.index_;
                    this.buffer_[n4] = (byte)(this.buffer_[n4] | (n & (1 << n2) - 1) << 8 - this.bitsLeft_);
                    this.bitsLeft_ -= n2;
                    n2 = 0;
                    continue;
                }
                int n5 = this.index_++;
                this.buffer_[n5] = (byte)(this.buffer_[n5] | (n & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                n >>= this.bitsLeft_;
                n2 -= this.bitsLeft_;
                this.buffer_[this.index_] = 0;
                this.bitsLeft_ = 8;
            } while (n2 != 0);
        }
    }

    class LZWStringTable {
        byte[] strChr_ = new byte[4096];
        short[] strNxt_ = new short[4096];
        short[] strHsh_ = new short[9973];
        short numStrings_;

        public int AddCharString(short n, byte by) {
            if (this.numStrings_ >= 4096) {
                return 65535;
            }
            int n2 = this.Hash((short)n, by);
            while (this.strHsh_[n2] != -1) {
                n2 = (n2 + 2039) % 9973;
            }
            this.strHsh_[n2] = this.numStrings_;
            this.strChr_[this.numStrings_] = by;
            this.strNxt_[this.numStrings_] = n != -1 ? n : -1;
            short s = this.numStrings_;
            this.numStrings_ = (short)(s + 1);
            return s;
        }

        public short FindCharString(short s, byte n) {
            short s2;
            if (s == -1) {
                return (short)(n < 0 ? n + 256 : n);
            }
            int n2 = this.Hash(s, (byte)n);
            while ((s2 = this.strHsh_[n2]) != -1) {
                if (this.strNxt_[s2] == s && this.strChr_[s2] == n) {
                    return s2;
                }
                n2 = (n2 + 2039) % 9973;
            }
            return -1;
        }

        public void ClearTable(int n) {
            int n2;
            this.numStrings_ = 0;
            for (n2 = 0; n2 < 9973; ++n2) {
                this.strHsh_[n2] = -1;
            }
            n2 = (1 << n) + 2;
            for (int i = 0; i < n2; ++i) {
                this.AddCharString((short)-1, (byte)i);
            }
        }

        private int Hash(short s, byte by) {
            return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
        }
    }
}

