/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.GIFDecoderPkg;

import java.awt.AWTException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import us.lystad.fractaltop.GIFDecoderPkg.RGBxSizeSequence;

public class GIFDecoder {
    private static final int RES_CODES = 2;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static InputStream input_;
    private static int codesize_;
    private static short index_;
    private static int clearcode_;
    private static int endofinfo_;
    private static int numbits_;
    private static int limit_;
    private static int errcode_;
    private static short prefix_;
    public static BitFile bitFile_;
    private static LZWStringTable strings_;
    private static boolean freshlyResetP_;
    private static int nextPixel_;
    private boolean initialized_p_ = false;
    private Header header_;
    private LogicalScreenDescriptor logicalScreenDescriptor_;
    private RGBxSizeSequence globalRGBTable_ = null;
    private Vector<ApplicationExtension> applicationExtensions_;
    private Vector<CommentExtension> commentExtensions_;
    private Vector<GraphicsBlock> graphicBlocks_;
    private Vector<TextExtension> textExtensions_;
    final int TRAILER = 59;
    final int ZERO = 0;
    final int IMAGE = 44;
    final int EXTENSION = 33;
    final int APPLICATION = 255;
    final int COMMENT = 254;
    final int CONTROL = 249;
    final int TEXT = 1;

    public boolean initialized_p() {
        return this.initialized_p_;
    }

    public Header header() {
        return this.header_;
    }

    public LogicalScreenDescriptor logicalScreenDescriptor() {
        return this.logicalScreenDescriptor_;
    }

    public RGBxSizeSequence globalRGBTable() {
        return this.globalRGBTable_;
    }

    public Vector applicationExtensions() {
        return this.applicationExtensions_;
    }

    public Vector commentExtensions() {
        return this.commentExtensions_;
    }

    public Vector<GraphicsBlock> graphicBlocks() {
        return this.graphicBlocks_;
    }

    public int getWidth() {
        return this.width();
    }

    public int getWidth(int n) {
        return this.width(n);
    }

    public int getHeight() {
        return this.height();
    }

    public int getHeight(int n) {
        return this.height(n);
    }

    public byte[] pixelsAsIndices(int n) {
        if (n >= this.graphicBlocks_.size()) {
            return null;
        }
        return this.graphicBlocks_.elementAt((int)n).pixels;
    }

    public byte[] pixelsAsIndices() {
        int n = 0;
        if (n >= this.graphicBlocks_.size()) {
            return null;
        }
        return this.graphicBlocks_.elementAt((int)n).pixels;
    }

    public int width(int n) {
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        return this.graphicBlocks_.elementAt(n).imageDescriptor().width();
    }

    public int width() {
        int n = 0;
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        return this.graphicBlocks_.elementAt(n).imageDescriptor().width();
    }

    public int height(int n) {
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        return this.graphicBlocks_.elementAt(n).imageDescriptor().height();
    }

    public int height() {
        int n = 0;
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        return this.graphicBlocks_.elementAt(n).imageDescriptor().height();
    }

    public boolean transparentPixelP(int n) {
        if (n >= this.graphicBlocks_.size()) {
            return false;
        }
        GraphicsBlock graphicsBlock = this.graphicBlocks_.elementAt(n);
        if (graphicsBlock == null) {
            return false;
        }
        if (graphicsBlock.control() == null) {
            return false;
        }
        return graphicsBlock.control().transparentColorFlag();
    }

    public boolean transparentPixelP() {
        int n = 0;
        if (n >= this.graphicBlocks_.size()) {
            return false;
        }
        GraphicsBlock graphicsBlock = this.graphicBlocks_.elementAt(n);
        if (graphicsBlock == null) {
            return false;
        }
        if (graphicsBlock.control() == null) {
            return false;
        }
        return graphicsBlock.control().transparentColorFlag();
    }

    public int transparentPixelIndex(int n) {
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        GraphicsBlock graphicsBlock = this.graphicBlocks_.elementAt(n);
        return graphicsBlock.control().transparentColorIndex();
    }

    public int transparentPixelIndex() {
        int n = 0;
        if (n >= this.graphicBlocks_.size()) {
            return -1;
        }
        GraphicsBlock graphicsBlock = this.graphicBlocks_.elementAt(n);
        return graphicsBlock.control().transparentColorIndex();
    }

    public GIFDecoder(InputStream inputStream, boolean bl) throws AWTException, IOException {
        if (inputStream == null) {
            throw new IOException("File does not exist.");
        }
        this.applicationExtensions_ = new Vector();
        this.commentExtensions_ = new Vector();
        this.graphicBlocks_ = new Vector();
        this.textExtensions_ = new Vector();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        this.header_ = new Header(bufferedInputStream);
        this.logicalScreenDescriptor_ = new LogicalScreenDescriptor(bufferedInputStream);
        if (this.logicalScreenDescriptor_.globalRGBTableFlag()) {
            this.globalRGBTable_ = new RGBxSizeSequence(bufferedInputStream, this.logicalScreenDescriptor_.sizeOfRGBTable());
        }
        int n = bufferedInputStream.read();
        while (n != 59) {
            int n2 = n;
            block0 : switch (n2) {
                case 0: {
                    this.initialized_p_ = true;
                    return;
                }
                case 33: {
                    if (this.header().version87_p()) {
                        throw new AWTException("Illegal extension in GIF87a file.");
                    }
                    GraphicsControl graphicsControl = null;
                    n = bufferedInputStream.read();
                    if (n == 249) {
                        graphicsControl = new GraphicsControl(bufferedInputStream);
                        n = bufferedInputStream.read();
                    }
                    switch (n) {
                        case 255: {
                            if (graphicsControl != null) {
                                throw new AWTException("Control block preceeds Application block.");
                            }
                            this.applicationExtensions_.addElement(new ApplicationExtension(bufferedInputStream));
                            break block0;
                        }
                        case 254: {
                            if (graphicsControl != null) {
                                throw new AWTException("Control block preceeds Comment block.");
                            }
                            this.commentExtensions_.addElement(new CommentExtension(bufferedInputStream));
                            break block0;
                        }
                        case 1: {
                            this.textExtensions_.addElement(new TextExtension(bufferedInputStream, graphicsControl));
                            break block0;
                        }
                        case 44: {
                            this.graphicBlocks_.addElement(new GraphicsBlock(bufferedInputStream, graphicsControl, bl));
                            break block0;
                        }
                    }
                    throw new AWTException("Unknown extension label code " + n);
                }
                case 44: {
                    this.graphicBlocks_.addElement(new GraphicsBlock(bufferedInputStream, null, bl));
                    break;
                }
                default: {
                    throw new AWTException("Unknown block code " + n2);
                }
            }
            n = bufferedInputStream.read();
        }
        this.initialized_p_ = true;
    }

    public String getApplicationData(String string) {
        if (this.applicationExtensions_ == null) {
            return null;
        }
        for (int i = 0; i < this.applicationExtensions_.size(); ++i) {
            ApplicationExtension applicationExtension = this.applicationExtensions_.elementAt(i);
            if (!string.equals(applicationExtension.identifier())) continue;
            return applicationExtension.data();
        }
        return null;
    }

    public int getVersionAuthCode(String string) {
        if (this.applicationExtensions_ == null) {
            return -1;
        }
        for (int i = 0; i < this.applicationExtensions_.size(); ++i) {
            ApplicationExtension applicationExtension = this.applicationExtensions_.elementAt(i);
            if (!string.equals(applicationExtension.identifier())) continue;
            String string2 = this.Util_bytesToString(applicationExtension.authenticationCode);
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -2;
    }

    String Util_bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    int Util_bytesToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    int Util_extractBitsInt(byte by, int n, int n2) {
        return by >> n & (int)Math.pow(2.0, n2) - 1;
    }

    boolean Util_extractBitBoolean(byte by, int n) {
        return 1 == (by >> n & 1);
    }

    String Util_readDataString(BufferedInputStream bufferedInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = bufferedInputStream.read();
        while (n > 0) {
            for (int i = 0; i < n; ++i) {
                char c = (char)bufferedInputStream.read();
                stringBuffer.append(c);
            }
            n = bufferedInputStream.read();
        }
        return stringBuffer.toString();
    }

    void Util_skipDataBlocks(BufferedInputStream bufferedInputStream) throws IOException {
        long l = bufferedInputStream.read();
        while (l > 0L) {
            long l2 = bufferedInputStream.skip(l);
            while (l2 < l) {
                l2 = bufferedInputStream.skip(l -= l2);
            }
            l = bufferedInputStream.read();
        }
    }

    static {
        prefix_ = (short)-1;
        bitFile_ = null;
        strings_ = null;
        freshlyResetP_ = true;
        nextPixel_ = 0;
    }

    class Header {
        private boolean version87_p_ = false;
        byte[] buf = new byte[3];

        Header(BufferedInputStream bufferedInputStream) throws IOException, AWTException {
            bufferedInputStream.read(this.buf, 0, 3);
            if (!GIFDecoder.this.Util_bytesToString(this.buf).equals("GIF")) {
                throw new AWTException("Invalid File Type, not GIF");
            }
            bufferedInputStream.read(this.buf, 0, 3);
            if (GIFDecoder.this.Util_bytesToString(this.buf).equals("87a")) {
                this.version87_p_ = true;
            }
        }

        boolean version87_p() {
            return this.version87_p_;
        }
    }

    class LogicalScreenDescriptor {
        int width_;
        int height_;
        boolean globalRGBTableFlag_;
        int colorResolution_;
        boolean sortFlag_;
        int sizeOfRGBTable_ = 0;
        int backgroundColorIndex_;
        int pixelAspectRatio_;

        int width() {
            return this.width_;
        }

        int height() {
            return this.height_;
        }

        boolean globalRGBTableFlag() {
            return this.globalRGBTableFlag_;
        }

        int colorResolution() {
            return this.colorResolution_;
        }

        boolean sortFlag() {
            return this.sortFlag_;
        }

        int sizeOfRGBTable() {
            return (int)Math.pow(2.0, this.sizeOfRGBTable_ + 1);
        }

        int backgroundColorIndex() {
            return this.backgroundColorIndex_;
        }

        int pixelAspectRatio() {
            return this.pixelAspectRatio_;
        }

        LogicalScreenDescriptor(BufferedInputStream bufferedInputStream) throws IOException, AWTException {
            byte[] byArray = new byte[2];
            bufferedInputStream.read(byArray, 0, 2);
            this.width_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.height_ = GIFDecoder.this.Util_bytesToInt(byArray);
            byte by = (byte)bufferedInputStream.read();
            this.globalRGBTableFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 7);
            this.colorResolution_ = GIFDecoder.this.Util_extractBitsInt(by, 4, 3);
            this.sortFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 3);
            this.sizeOfRGBTable_ = GIFDecoder.this.Util_extractBitsInt(by, 0, 3);
            this.backgroundColorIndex_ = bufferedInputStream.read();
            this.pixelAspectRatio_ = bufferedInputStream.read();
        }
    }

    class GraphicsBlock {
        private GraphicsControl control_ = null;
        private ImageDescriptor imageDescriptor_;
        private RGBxSizeSequence localRGBTable_ = null;
        public byte[] pixels = null;

        public GraphicsControl control() {
            return this.control_;
        }

        public ImageDescriptor imageDescriptor() {
            return this.imageDescriptor_;
        }

        public RGBxSizeSequence localRGBTable() {
            return this.localRGBTable_;
        }

        public int width() {
            return this.imageDescriptor_.width();
        }

        public int height() {
            return this.imageDescriptor_.height();
        }

        GraphicsBlock(BufferedInputStream bufferedInputStream, GraphicsControl graphicsControl, boolean bl) throws IOException {
            this.control_ = graphicsControl;
            this.imageDescriptor_ = new ImageDescriptor(bufferedInputStream);
            if (this.imageDescriptor_.localRGBTableFlag()) {
                this.localRGBTable_ = new RGBxSizeSequence(bufferedInputStream, this.imageDescriptor_.sizeOfLocalRGBTable());
            }
            int n = this.imageDescriptor_.width();
            int n2 = this.imageDescriptor_.height();
            this.pixels = new byte[n * n2];
            int n3 = bufferedInputStream.read();
            if (bl) {
                GIFDecoder.this.Util_skipDataBlocks(bufferedInputStream);
            } else {
                new LZWInflator(bufferedInputStream, 0).inflate(bufferedInputStream, n3, this.pixels);
            }
        }
    }

    class ImageDescriptor {
        private int leftPosition_;
        private int topPosition_;
        private int width_;
        private int height_;
        private boolean localRGBTableFlag_;
        private boolean interlaceFlag_;
        private boolean sortFlag_;
        private int sizeOfRGBTable_;

        public int leftPosition() {
            return this.leftPosition_;
        }

        public int topPosition() {
            return this.topPosition_;
        }

        public int width() {
            return this.width_;
        }

        public int height() {
            return this.height_;
        }

        public boolean localRGBTableFlag() {
            return this.localRGBTableFlag_;
        }

        public boolean interlaceFlag() {
            return this.interlaceFlag_;
        }

        public boolean sortFlag() {
            return this.sortFlag_;
        }

        public int sizeOfLocalRGBTable() {
            return (int)Math.pow(2.0, this.sizeOfRGBTable_ + 1);
        }

        public int codesize() {
            return this.sizeOfRGBTable_ + 1;
        }

        ImageDescriptor(BufferedInputStream bufferedInputStream) throws IOException {
            byte[] byArray = new byte[2];
            bufferedInputStream.read(byArray, 0, 2);
            this.leftPosition_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.topPosition_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.width_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.height_ = GIFDecoder.this.Util_bytesToInt(byArray);
            byte by = (byte)bufferedInputStream.read();
            this.localRGBTableFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 7);
            this.interlaceFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 6);
            this.sortFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 5);
            this.sizeOfRGBTable_ = GIFDecoder.this.Util_extractBitsInt(by, 0, 3);
        }
    }

    class GraphicsControl {
        private int disposalMethod_;
        private boolean userInputFlag_;
        private boolean transparentColorFlag_;
        private int displayTime_;
        private int transparentColorIndex_ = 0;

        public int disposalMethod() {
            return this.disposalMethod_;
        }

        public boolean userInputFlag() {
            return this.userInputFlag_;
        }

        public boolean transparentColorFlag() {
            return this.transparentColorFlag_;
        }

        public int displayTime() {
            return this.displayTime_;
        }

        public int transparentColorIndex() {
            return this.transparentColorIndex_;
        }

        GraphicsControl(BufferedInputStream bufferedInputStream) throws IOException, AWTException {
            byte[] byArray = new byte[2];
            byte by = (byte)bufferedInputStream.read();
            if (by != 4) {
                throw new AWTException("GraphicsControl block size should have been 4, was " + by);
            }
            by = (byte)bufferedInputStream.read();
            this.disposalMethod_ = GIFDecoder.this.Util_extractBitsInt(by, 2, 3);
            this.userInputFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 1);
            this.transparentColorFlag_ = GIFDecoder.this.Util_extractBitBoolean(by, 0);
            bufferedInputStream.read(byArray, 0, 2);
            this.displayTime_ = GIFDecoder.this.Util_bytesToInt(byArray);
            this.transparentColorIndex_ = bufferedInputStream.read();
            if (!this.transparentColorFlag_) {
                this.transparentColorIndex_ = 0;
            }
            if ((by = (byte)bufferedInputStream.read()) != 0) {
                throw new AWTException("GraphicsControl end should have been 0, was " + by);
            }
        }
    }

    class ApplicationExtension {
        private String identifier_;
        private String data_;
        public byte[] authenticationCode;

        public String identifier() {
            return this.identifier_;
        }

        public String data() {
            return this.data_;
        }

        ApplicationExtension(BufferedInputStream bufferedInputStream) throws IOException, AWTException {
            byte[] byArray = new byte[8];
            this.authenticationCode = new byte[3];
            byte by = (byte)bufferedInputStream.read();
            if (by != 11) {
                throw new AWTException("ApplicationExtension block length should be 11, was " + by);
            }
            bufferedInputStream.read(byArray, 0, 8);
            this.identifier_ = GIFDecoder.this.Util_bytesToString(byArray);
            bufferedInputStream.read(this.authenticationCode, 0, 3);
            this.data_ = GIFDecoder.this.Util_readDataString(bufferedInputStream);
        }
    }

    class CommentExtension {
        private String data_;

        public String data() {
            return this.data_;
        }

        CommentExtension(BufferedInputStream bufferedInputStream) throws IOException {
            this.data_ = GIFDecoder.this.Util_readDataString(bufferedInputStream);
        }
    }

    class TextExtension {
        private GraphicsControl control_;
        private int gridLeftPosition_;
        private int gridTopPosition_;
        private int gridWidth_;
        private int gridHeight_;
        private int cellWidth_;
        private int cellHeight_;
        private int foregroundColorIndex_;
        private int backgroundColorIndex_;
        private String data_;

        public GraphicsControl control() {
            return this.control_;
        }

        public int gridLeftPosition() {
            return this.gridLeftPosition_;
        }

        public int gridTopPosition() {
            return this.gridTopPosition_;
        }

        public int gridWidth() {
            return this.gridWidth_;
        }

        public int gridHeight() {
            return this.gridHeight_;
        }

        public int cellWidth() {
            return this.cellWidth_;
        }

        public int cellHeight() {
            return this.cellHeight_;
        }

        public int foregroundColorIndex() {
            return this.foregroundColorIndex_;
        }

        public int backgroundColorIndex() {
            return this.backgroundColorIndex_;
        }

        public String data() {
            return this.data_;
        }

        TextExtension(BufferedInputStream bufferedInputStream, GraphicsControl graphicsControl) throws IOException {
            byte[] byArray = new byte[2];
            this.control_ = graphicsControl;
            bufferedInputStream.read(byArray, 0, 2);
            this.gridLeftPosition_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.gridTopPosition_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.gridWidth_ = GIFDecoder.this.Util_bytesToInt(byArray);
            bufferedInputStream.read(byArray, 0, 2);
            this.gridHeight_ = GIFDecoder.this.Util_bytesToInt(byArray);
            this.cellWidth_ = bufferedInputStream.read();
            this.cellHeight_ = bufferedInputStream.read();
            this.foregroundColorIndex_ = bufferedInputStream.read();
            this.backgroundColorIndex_ = bufferedInputStream.read();
            this.data_ = GIFDecoder.this.Util_readDataString(bufferedInputStream);
        }
    }

    class BitFile {
        InputStream input_;
        byte[] buffer_;
        int index_;
        int bitsLeft_;
        int bytesRead_;

        public BitFile(InputStream inputStream) {
            this.input_ = inputStream;
            this.buffer_ = new byte[256];
            this.index_ = 0;
            this.bytesRead_ = 0;
            this.bitsLeft_ = 8;
        }

        public int ReadBits(int n) throws IOException {
            int n2 = 0;
            int n3 = 0;
            do {
                int n4;
                if (this.index_ == this.bytesRead_ - 1 && this.bitsLeft_ == 0 || this.index_ >= this.bytesRead_) {
                    this.bytesRead_ = this.input_.read();
                    if (this.bytesRead_ < 0) {
                        this.bytesRead_ += 256;
                    }
                    for (n4 = 0; n4 < this.bytesRead_; ++n4) {
                        this.buffer_[n4] = (byte)(this.input_.read() & 0xFF);
                    }
                    this.index_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (n <= this.bitsLeft_) {
                    n4 = this.buffer_[this.index_] >> 8 - this.bitsLeft_ & (1 << n) - 1;
                    n3 |= n4 << n2;
                    if (this.bitsLeft_ == n) {
                        ++this.index_;
                        this.bitsLeft_ = 8;
                    } else {
                        this.bitsLeft_ -= n;
                    }
                    n = 0;
                    continue;
                }
                n4 = this.buffer_[this.index_] >> 8 - this.bitsLeft_ & (1 << this.bitsLeft_) - 1;
                n3 |= n4 << n2;
                n2 += this.bitsLeft_;
                n -= this.bitsLeft_;
                ++this.index_;
                this.bitsLeft_ = 8;
            } while (n != 0);
            return n3;
        }
    }

    class LZWStringTable {
        byte[] strChr_ = new byte[4096];
        short[] strNxt_ = new short[4096];
        short numStrings_;
        byte[] reverseChr_ = new byte[4096];
        short previousFindIndex_ = (short)-1;

        public short numStrings() {
            return this.numStrings_;
        }

        public void AddCharString(short s, byte by) {
            if (this.numStrings_ >= 4096) {
                System.err.println("GIFDecoder.AddCharString numStrings_ " + this.numStrings_ + " is impossibly large.");
                return;
            }
            if (s >= this.numStrings_) {
                System.err.println("GIFDecoder.AddCharString index " + s + " is larger than numStrings_ " + this.numStrings_);
                return;
            }
            this.strChr_[this.numStrings_] = by;
            this.strNxt_[this.numStrings_] = s;
            this.numStrings_ = (short)(this.numStrings_ + 1);
        }

        public int FindCharString(short s, byte[] byArray, int n) {
            int n2 = 0;
            short s2 = s;
            boolean bl = false;
            if (s > this.numStrings_) {
                System.err.println("GIFDecoder.FindCharString index " + s + " is too large.");
            }
            if (s == this.numStrings_ && this.previousFindIndex_ != -1) {
                bl = true;
                this.strNxt_[this.numStrings_] = this.previousFindIndex_;
            }
            do {
                this.reverseChr_[n2++] = this.strChr_[s2];
            } while ((s2 = this.strNxt_[s2]) != -1);
            if (this.previousFindIndex_ != -1) {
                byte by = this.reverseChr_[n2 - 1];
                this.AddCharString(this.previousFindIndex_, by);
                if (bl) {
                    this.reverseChr_[0] = by;
                }
            }
            this.previousFindIndex_ = s;
            while (n2 > 0) {
                byArray[n++] = this.reverseChr_[--n2];
            }
            return n;
        }

        public void ClearTable(int n) {
            this.numStrings_ = 0;
            this.previousFindIndex_ = (short)-1;
            int n2 = (1 << n) + 2;
            for (int i = 0; i < n2; ++i) {
                this.AddCharString((short)-1, (byte)i);
            }
        }
    }

    class LZWInflator {
        private InputStream input_2;
        private int codesize_2;
        private short index_2;
        private int clearcode_2;
        private int endofinfo_2;
        private int numbits_2;
        private int limit_2;
        private int errcode_2;
        private short prefix_2 = (short)-1;
        private BitFile bitFile_2;
        private LZWStringTable strings_2;
        private boolean freshlyResetP_2 = true;
        private int nextPixel_2 = 0;

        public void inflate(InputStream inputStream, int n, byte[] byArray) throws IOException {
            input_ = inputStream;
            codesize_ = n;
            bitFile_ = new BitFile(inputStream);
            strings_ = new LZWStringTable();
            clearcode_ = 1 << n;
            endofinfo_ = clearcode_ + 1;
            numbits_ = n + 1;
            limit_ = (1 << numbits_) - 1;
            strings_.ClearTable(n);
            nextPixel_ = 0;
            boolean bl = true;
            while (nextPixel_ < byArray.length + 1) {
                index_ = (short)bitFile_.ReadBits(numbits_);
                if (index_ == clearcode_) {
                    strings_.ClearTable(codesize_);
                    numbits_ = codesize_ + 1;
                    limit_ = (1 << numbits_) - 1;
                    bl = false;
                } else {
                    if (index_ == endofinfo_) {
                        if (nextPixel_ == byArray.length) break;
                        System.err.println("GIFDecode.LZWDepress: nextPixel = " + nextPixel_ + " whereas pixels.length = " + byArray.length);
                        break;
                    }
                    if (bl) {
                        System.err.println("GIFDecode.LZWDepress: Expected clearcode. index_=" + index_);
                    }
                    nextPixel_ = strings_.FindCharString(index_, byArray, nextPixel_);
                }
                if (strings_.numStrings() <= limit_ || nextPixel_ >= byArray.length) continue;
                if (++numbits_ > 12) {
                    numbits_ = 12;
                    bl = true;
                }
                limit_ = (1 << numbits_) - 1;
            }
        }

        public LZWInflator(InputStream inputStream, int n) throws IOException {
            this.input_2 = inputStream;
            this.codesize_2 = n;
            this.bitFile_2 = new BitFile(inputStream);
            this.strings_2 = new LZWStringTable();
            this.clearcode_2 = 1 << n;
            this.endofinfo_2 = this.clearcode_2 + 1;
            this.numbits_2 = n + 1;
            this.limit_2 = (1 << this.numbits_2) - 1;
            this.strings_2.ClearTable(n);
            this.nextPixel_2 = 0;
            this.freshlyResetP_2 = true;
        }

        public int readPixels(byte[] byArray, int n, int n2) throws IOException {
            while (n < n2) {
                this.index_2 = (short)this.bitFile_2.ReadBits(this.numbits_2);
                if (this.index_2 == this.clearcode_2) {
                    if (!this.freshlyResetP_2) {
                        System.err.println("GIFDecode.LZWDepress: Clearcode error detected. - ABORT");
                        return n;
                    }
                } else {
                    if (this.index_2 == this.endofinfo_2) {
                        if (n == byArray.length) break;
                        System.err.println("GIFDecode.LZWDepress: nextPixel = " + n + " whereas boundExclusive = " + n2);
                        break;
                    }
                    if (this.freshlyResetP_2) {
                        System.err.println("GIFDecode.LZWDepress: index_2 = " + this.index_2 + " when clearcode_ was expected.");
                    }
                    n = this.strings_2.FindCharString(this.index_2, byArray, n);
                }
                this.freshlyResetP_2 = false;
                if (this.strings_2.numStrings() <= this.limit_2) continue;
                if (++this.numbits_2 > 12) {
                    this.strings_2.ClearTable(this.codesize_2);
                    this.numbits_2 = this.codesize_2 + 1;
                    this.freshlyResetP_2 = true;
                }
                this.limit_2 = (1 << this.numbits_2) - 1;
            }
            return n;
        }
    }
}

