/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class Fraction
extends Number {
    public static final BigInteger MINUS_ONE = new BigInteger("-1");
    public static final BigInteger zero = new BigInteger("0");
    private static final BigInteger two = new BigInteger("2");
    private static final double ln2 = Math.log(2.0);
    private static double log2of10 = 0.0;
    static final int doubleBits = 52;
    static final int goodMeasure = 10;
    static final int doubleBitsPlus = 62;
    private BigInteger numerator_;
    private int denominator_;

    public static double log2(double d) {
        return Math.log(d) / ln2;
    }

    public static void main(String[] stringArray) {
    }

    public Fraction(BigInteger bigInteger, int n) {
        this.numerator_ = bigInteger;
        this.denominator_ = n;
    }

    public Fraction(String string, int n) {
        this.numerator_ = new BigInteger(string.trim());
        this.denominator_ = n;
    }

    public Fraction(String string, String string2) {
        this.numerator_ = new BigInteger(string.trim());
        this.denominator_ = Integer.parseInt(string2.trim());
    }

    public Fraction(Fraction fraction) {
        this.numerator_ = fraction.numerator_;
        this.denominator_ = fraction.denominator_;
    }

    public Fraction(double d, int n) {
        this.init(d);
        this.setDenominatorMinValue(n);
    }

    public Fraction(double d) {
        this.init(d);
    }

    public Fraction(BigDecimal bigDecimal) {
        this.setFromBigDecimal(bigDecimal);
    }

    public Fraction(String object) {
        if (((String)object).startsWith(".")) {
            object = "0" + (String)object;
        }
        if (String.valueOf(Double.parseDouble((String)object)).equals(object)) {
            this.init(Double.parseDouble((String)object));
        } else {
            BigDecimal bigDecimal = new BigDecimal((String)object);
            this.setFromBigDecimal(bigDecimal);
        }
    }

    private void init(double d) {
        this.denominator_ = Fraction.denominatorNeeded(d);
        BigDecimal bigDecimal = new BigDecimal(d);
        this.numerator_ = bigDecimal.multiply(new BigDecimal(2.0).pow(this.denominator_)).unscaledValue();
        this.numerator_ = this.numerator_.divide(new BigInteger("10").pow(bigDecimal.scale()));
    }

    private void setFromBigDecimal(BigDecimal bigDecimal) {
        this.denominator_ = (int)Math.ceil(log2of10 * (double)bigDecimal.scale()) + 10;
        this.numerator_ = bigDecimal.multiply(new BigDecimal(2.0).pow(this.denominator_)).unscaledValue();
        this.numerator_ = this.numerator_.divide(new BigInteger("10").pow(bigDecimal.scale()));
    }

    public String toString() {
        BigDecimal bigDecimal = new BigDecimal(this.numerator_);
        BigInteger bigInteger = two.pow(this.denominator_);
        BigDecimal bigDecimal2 = new BigDecimal(bigInteger);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, MathContext.UNLIMITED);
        bigDecimal3 = bigDecimal3.setScale((int)Math.round((double)(this.denominator_ - 10) / log2of10), RoundingMode.HALF_UP);
        return bigDecimal3.stripTrailingZeros().toPlainString();
    }

    public static int denominatorNeeded(double d) {
        if (d == 0.0) {
            return 0;
        }
        double d2 = Math.abs(Fraction.log2(Math.abs(d)));
        return Math.max(0, (int)Math.ceil(52.0 + d2));
    }

    public int getDenominator() {
        return this.denominator_;
    }

    public void setValue(Double d) {
        this.init(d);
    }

    public void setValue(Fraction fraction) {
        this.numerator_ = fraction.numerator_;
        this.denominator_ = fraction.denominator_;
    }

    public void setDenominatorMinValue(int n) {
        if (n > this.denominator_) {
            this.numerator_ = this.numerator_.shiftLeft(n - this.denominator_);
            this.denominator_ = n;
        }
    }

    public void setDenominatorValue(int n) {
        if (n != this.denominator_) {
            this.numerator_ = this.numerator_.shiftLeft(n - this.denominator_);
            this.denominator_ = n;
        }
    }

    public static int setCommonDenominator(Fraction ... fractionArray) {
        if (fractionArray.length == 2) {
            Fraction fraction = fractionArray[0];
            Fraction fraction2 = fractionArray[1];
            if (fraction.denominator_ > fraction2.denominator_) {
                fraction2.numerator_ = fraction2.numerator_.shiftLeft(fraction.denominator_ - fraction2.denominator_);
                fraction2.denominator_ = fraction.denominator_;
            } else if (fraction2.denominator_ > fraction.denominator_) {
                fraction.numerator_ = fraction.numerator_.shiftLeft(fraction2.denominator_ - fraction.denominator_);
                fraction.denominator_ = fraction2.denominator_;
            }
            return fraction.denominator_;
        }
        if (fractionArray.length > 2) {
            int n = fractionArray[0].denominator_;
            for (Fraction fraction : fractionArray) {
                if (fraction == null || fraction.denominator_ <= n) continue;
                n = fraction.denominator_;
            }
            for (Fraction fraction : fractionArray) {
                if (fraction == null) continue;
                fraction.setDenominatorMinValue(n);
            }
            return n;
        }
        return fractionArray.length == 1 ? fractionArray[0].denominator_ : 0;
    }

    public boolean equals(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return fraction2.numerator_.equals(fraction3.numerator_);
        }
        return this.numerator_.equals(fraction.numerator_);
    }

    public int compareTo(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return fraction2.numerator_.compareTo(fraction3.numerator_);
        }
        return this.numerator_.compareTo(fraction.numerator_);
    }

    public Fraction add(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return new Fraction(fraction2.numerator_.add(fraction3.numerator_), fraction2.denominator_);
        }
        return new Fraction(this.numerator_.add(fraction.numerator_), this.denominator_);
    }

    public Fraction plus(Fraction fraction) {
        return this.add(fraction);
    }

    public Fraction plus_equal(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction);
        if (this.denominator_ != fraction.denominator_) {
            Fraction.setCommonDenominator(this, fraction2);
        }
        this.numerator_ = this.numerator_.add(fraction2.numerator_);
        return this;
    }

    public Fraction subtract(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return new Fraction(fraction2.numerator_.subtract(fraction3.numerator_), fraction2.denominator_);
        }
        return new Fraction(this.numerator_.subtract(fraction.numerator_), this.denominator_);
    }

    public Fraction minus(Fraction fraction) {
        return this.subtract(fraction);
    }

    public Fraction subtract_A(Fraction fraction, Fraction fraction2) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction3 = new Fraction(this);
            Fraction fraction4 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction3, fraction4);
            fraction2.numerator_ = fraction3.numerator_.subtract(fraction4.numerator_);
            fraction2.denominator_ = fraction3.denominator_;
        } else {
            fraction2.numerator_ = this.numerator_.subtract(fraction.numerator_);
            fraction2.denominator_ = this.denominator_;
        }
        return fraction2;
    }

    public Fraction minus_equal(Fraction fraction) {
        Fraction fraction2 = new Fraction(fraction);
        if (this.denominator_ != fraction.denominator_) {
            Fraction.setCommonDenominator(this, fraction2);
        }
        this.numerator_ = this.numerator_.subtract(fraction2.numerator_);
        return this;
    }

    public Fraction multiply(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return new Fraction(fraction2.numerator_.multiply(fraction3.numerator_).shiftRight(fraction3.denominator_), fraction2.denominator_);
        }
        return new Fraction(this.numerator_.multiply(fraction.numerator_).shiftRight(fraction.denominator_), this.denominator_);
    }

    public Fraction multiply_A(Fraction fraction, Fraction fraction2) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction3 = new Fraction(this);
            Fraction fraction4 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction3, fraction4);
            fraction2.numerator_ = fraction3.numerator_.multiply(fraction4.numerator_).shiftRight(fraction3.denominator_);
            fraction2.denominator_ = fraction3.denominator_;
        } else {
            fraction2.numerator_ = this.numerator_.multiply(fraction.numerator_).shiftRight(fraction.denominator_);
            fraction2.denominator_ = this.denominator_;
        }
        return fraction2;
    }

    public Fraction times_equal(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction.setCommonDenominator(this, fraction);
        }
        this.numerator_ = this.numerator_.multiply(fraction.numerator_).shiftRight(fraction.denominator_);
        return this;
    }

    public Fraction divide(Fraction fraction) {
        if (this.denominator_ != fraction.denominator_) {
            Fraction fraction2 = new Fraction(this);
            Fraction fraction3 = new Fraction(fraction);
            Fraction.setCommonDenominator(fraction2, fraction3);
            return new Fraction(fraction2.numerator_.shiftLeft(fraction3.getDenominator()).divide(fraction3.numerator_), fraction2.denominator_);
        }
        return new Fraction(this.numerator_.shiftLeft(fraction.getDenominator()).divide(fraction.numerator_), this.denominator_);
    }

    public Fraction timesScalar(int n) {
        return new Fraction(this.numerator_.multiply(new BigInteger(String.valueOf(n))), this.denominator_);
    }

    public Fraction timesScalar(double d) {
        return new Fraction(d).multiply(this);
    }

    public Fraction doubled() {
        return new Fraction(this.numerator_.shiftLeft(1), this.denominator_);
    }

    public Fraction doubled_A(Fraction fraction) {
        fraction.numerator_ = this.numerator_.shiftLeft(1);
        fraction.denominator_ = this.denominator_;
        return fraction;
    }

    public int decimalPrecision() {
        return (int)Math.ceil((double)this.denominator_ / log2of10) + 10;
    }

    public Fraction sqrt() {
        int n = 6;
        BigInteger bigInteger = this.numerator_.shiftLeft(this.denominator_ + n);
        BigInteger bigInteger2 = new BigInteger("1").shiftLeft(bigInteger.bitLength() / 2);
        BigInteger bigInteger3 = zero;
        while (bigInteger2.compareTo(bigInteger3) != 0) {
            bigInteger3 = bigInteger2;
            bigInteger2 = bigInteger3.subtract(bigInteger3.multiply(bigInteger3).subtract(bigInteger).divide(two.multiply(bigInteger3)));
        }
        bigInteger2 = bigInteger2.shiftRight(n / 2);
        return new Fraction(bigInteger2, this.denominator_);
    }

    public boolean isPositive() {
        return this.numerator_.compareTo(zero) > 0;
    }

    public boolean isZero() {
        return this.numerator_.compareTo(zero) == 0;
    }

    public boolean isNegative() {
        return this.numerator_.compareTo(zero) < 0;
    }

    public Fraction abs() {
        return new Fraction(this.numerator_.abs(), this.denominator_);
    }

    @Override
    public double doubleValue() {
        BigInteger bigInteger = new BigInteger("1").shiftLeft(this.denominator_);
        return this.numerator_.doubleValue() / bigInteger.doubleValue();
    }

    @Override
    public byte byteValue() {
        return Double.valueOf(this.doubleValue()).byteValue();
    }

    @Override
    public float floatValue() {
        return Double.valueOf(this.doubleValue()).floatValue();
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.doubleValue());
    }

    @Override
    public long longValue() {
        return this.bigIntegerValue().longValue();
    }

    @Override
    public short shortValue() {
        return Double.valueOf(this.doubleValue()).shortValue();
    }

    public BigDecimal bigDecimalValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numerator_);
        BigInteger bigInteger = two.pow(this.denominator_);
        BigDecimal bigDecimal2 = new BigDecimal(bigInteger);
        MathContext mathContext = new MathContext(this.numerator_.toString().length() + 10);
        return bigDecimal.divide(bigDecimal2, mathContext);
    }

    public BigInteger bigIntegerValue() {
        Fraction fraction = new Fraction(this);
        fraction.setDenominatorValue(0);
        return fraction.numerator_;
    }

    public String toTokens() {
        return "B" + this.numerator_.toString() + " " + this.denominator_;
    }

    public static String mathTest() {
        StringBuilder stringBuilder = new StringBuilder(100000);
        stringBuilder.append("Fraction Math Test:\n");
        Fraction fraction = new Fraction(3.0E-4);
        Fraction fraction2 = new Fraction(4.0E-4);
        Fraction fraction3 = new Fraction(5.0E-4);
        Fraction fraction4 = new Fraction(5.0E-5);
        Fraction fraction5 = new Fraction(3.5E-4);
        Fraction fraction6 = new Fraction(2.5E-4);
        stringBuilder.append("Add 0.0003+0.00005:  " + fraction + " + " + fraction4 + " = " + fraction.add(fraction4) + " expected = " + fraction5 + " or " + fraction.add(fraction4).floatValue() + "\n");
        stringBuilder.append("Subt0.0003-0.00005: " + fraction + " - " + fraction4 + " = " + fraction.subtract(fraction4) + " expected = " + fraction6 + " or " + fraction.subtract(fraction4).floatValue() + "\n");
        stringBuilder.append("Mult0.0003*0.00005: " + fraction + " * " + fraction4 + " = " + fraction.multiply(fraction4) + " or " + fraction.multiply(fraction4).floatValue() + "expected = 1.5e-8\n");
        try {
            stringBuilder.append("Pythag (sqrt (+ (* 0.0003 0.0003) (* 0.0004 0.0004))) = " + fraction.multiply(fraction).add(fraction2.multiply(fraction2)).sqrt() + " expected = " + fraction3 + "\n");
            stringBuilder.append("    which is " + fraction.multiply(fraction).add(fraction2.multiply(fraction2)).sqrt().floatValue() + "\n");
        }
        catch (Throwable throwable) {
            stringBuilder.append("Error taking sqrt in Fraction.mathTest() \n");
        }
        stringBuilder.append("Div 0.00025/0.0005 = 1/2 and 0.0005/0.00025 = 2: " + fraction6.divide(fraction3).doubleValue() + " and " + fraction3.divide(fraction6).doubleValue() + "\n");
        stringBuilder.append("Times Scalar 0.0004 * 10 = " + fraction2.timesScalar(10) + "\n");
        stringBuilder.append("Times Scalar 0.0004 * 10 doubleValue = " + fraction2.timesScalar(10).doubleValue() + "\n");
        stringBuilder.append("Times Scalar 0.0004 * 0.0000010 = " + fraction2.timesScalar(1.0E-6) + "\n");
        stringBuilder.append("Times Scalar 0.0004 * 0.0000010 doubleValue = " + fraction2.timesScalar(1.0E-6).doubleValue() + "\n");
        BigDecimal bigDecimal = new BigDecimal("-0.000010000200003000040000500006");
        Fraction fraction7 = new Fraction(bigDecimal);
        stringBuilder.append("Input is BigDecimal('-0.000010000200003000040000500006').  Generated Fraction is " + fraction7 + "\n");
        return stringBuilder.toString();
    }

    static {
        log2of10 = Fraction.log2(10.0);
    }
}

