/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTArgReader;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.Fraction;
import us.lystad.fractaltop.ThumbNailProducer;

public class FractalSpec {
    public static final int CENTER = 0;
    public static final int COEFF = 1;
    public static final int TRANS = 2;
    public static final int INTERPOLATE_OFF = 0;
    public static final int INTERPOLATE_HSB = 1;
    public static final int INTERPOLATE_RGB = 2;
    public static final int INTERPOLATE_INVERSE_HSB = 3;
    public BigQuaternion center;
    public BigQuaternion coeff;
    public BigQuaternion trans;
    public boolean cache_is_current;
    public BigQuaternion lox;
    public BigQuaternion hiy;
    public BigQuaternion incx;
    public BigQuaternion incy;
    public FastQuaternion vx;
    public FastQuaternion vy;
    public FastQuaternion vz;
    public double range = 2.7;
    public int rangeOver = 0;
    public int pix_width = 550;
    public int pix_height = 550;
    public int depth = 1000;
    public String which = "Mandelbrot";
    public int panels = 1;
    public int panel_x = 0;
    public int panel_y = 0;
    public int colorsCount = 256;
    public int interpolateColors = 0;
    public double loops_per_color = 1.0;
    public boolean hifi_p = false;
    public String trapPathname = null;
    public double version;
    public double hAxisScale = 1.0;
    public ThumbNailProducer thumbNail;
    public boolean loggingP_ = false;
    public boolean ioToURLP_ = false;
    public boolean colorsFromTrapP_ = false;
    public boolean userWantsToAddComment_ = false;
    public Dimension wHRatio_ = new Dimension(-1, -1);
    private String comment_ = "";

    public String getComment() {
        return this.comment_;
    }

    private void setComment(String string) {
        this.comment_ = string;
    }

    public FractalSpec() {
        this.center = new BigQuaternion();
        this.coeff = new BigQuaternion();
        this.trans = new BigQuaternion();
        this.vx = new FastQuaternion();
        this.vy = new FastQuaternion();
        this.vz = new FastQuaternion();
        this.vx.r = 1.0;
        this.vy.i = 1.0;
        this.thumbNail = null;
        this.version = 5.0;
        this.cache_is_current = false;
        this.lox = new BigQuaternion();
        this.hiy = new BigQuaternion();
        this.incx = new BigQuaternion();
        this.incy = new BigQuaternion();
    }

    public FractalSpec(boolean bl) {
        this.center = new BigQuaternion();
        this.coeff = new BigQuaternion();
        this.trans = new BigQuaternion();
        this.vx = new FastQuaternion();
        this.vy = new FastQuaternion();
        this.vz = new FastQuaternion();
        this.vx.r = 1.0;
        this.vy.i = 1.0;
        this.thumbNail = null;
        this.version = 5.0;
        if (bl) {
            this.center.r = new Fraction(-0.75);
            this.coeff.setR(1.0);
            this.setCommonDenominators();
        }
        this.cache_is_current = false;
        this.lox = new BigQuaternion();
        this.hiy = new BigQuaternion();
        this.incx = new BigQuaternion();
        this.incy = new BigQuaternion();
    }

    public static FractalSpec parseParmsString(String string) {
        int n = -1;
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
            FTArgReader fTArgReader = new FTArgReader();
            FractalSpec fractalSpec = fTArgReader.readArgFile(inputStreamReader, n);
            fractalSpec.setComment(fTArgReader.getComment());
            return fractalSpec;
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.parseParmsString - ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
            return null;
        }
    }

    public boolean gifColorsP() {
        return this.colorsCount == 256 && (this.interpolateColors == 0 || this.loops_per_color == 1.0);
    }

    public double getRange() {
        return this.range;
    }

    public String getWhichFractal() {
        return this.which;
    }

    public void setCommonDenominators() {
        Fraction.setCommonDenominator(this.center.r, this.center.i, this.center.j, this.center.k, this.coeff.r, this.coeff.i, this.coeff.j, this.coeff.k, this.trans.r, this.trans.i, this.trans.j, this.trans.k);
    }

    public void setCache(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, BigQuaternion bigQuaternion4) {
        this.lox.assign_from(bigQuaternion);
        this.hiy.assign_from(bigQuaternion2);
        this.incx.assign_from(bigQuaternion3);
        this.incy.assign_from(bigQuaternion4);
    }

    public void normalizeAxes() {
        this.vx.normalize_n();
        this.vy.normalize_n();
        this.vz.normalize_n();
    }

    public int neededBitsOfPrecision() {
        double d = this.range / (double)(this.pix_width * this.panels);
        int n = Fraction.denominatorNeeded(d);
        int n2 = (int)Math.ceil(Math.abs(Fraction.log2(this.depth)));
        return n + n2;
    }

    public void setNecessaryPrecision() {
        int n = this.neededBitsOfPrecision();
        this.center.r.setDenominatorValue(n);
        this.center.i.setDenominatorValue(n);
        this.center.j.setDenominatorValue(n);
        this.center.k.setDenominatorValue(n);
        this.coeff.r.setDenominatorValue(n);
        this.coeff.i.setDenominatorValue(n);
        this.coeff.j.setDenominatorValue(n);
        this.coeff.k.setDenominatorValue(n);
        this.trans.r.setDenominatorValue(n);
        this.trans.i.setDenominatorValue(n);
        this.trans.j.setDenominatorValue(n);
        this.trans.k.setDenominatorValue(n);
    }

    public String toString(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("((log_id ");
        stringBuilder.append(n);
        stringBuilder.append(" )(version ");
        stringBuilder.append(this.version);
        stringBuilder.append(" )(ct_r ");
        stringBuilder.append(this.center.rToString());
        stringBuilder.append(" )(ct_i ");
        stringBuilder.append(this.center.iToString());
        stringBuilder.append(" )(ct_j ");
        stringBuilder.append(this.center.jToString());
        stringBuilder.append(" )(ct_k ");
        stringBuilder.append(this.center.kToString());
        stringBuilder.append(" )(co_r ");
        stringBuilder.append(this.coeff.rToString());
        stringBuilder.append(" )(co_i ");
        stringBuilder.append(this.coeff.iToString());
        stringBuilder.append(" )(co_j ");
        stringBuilder.append(this.coeff.jToString());
        stringBuilder.append(" )(co_k ");
        stringBuilder.append(this.coeff.kToString());
        stringBuilder.append(" )(tr_r ");
        stringBuilder.append(this.trans.rToString());
        stringBuilder.append(" )(tr_i ");
        stringBuilder.append(this.trans.iToString());
        stringBuilder.append(" )(tr_j ");
        stringBuilder.append(this.trans.jToString());
        stringBuilder.append(" )(tr_k ");
        stringBuilder.append(this.trans.kToString());
        stringBuilder.append(" )(vx_r ");
        stringBuilder.append(this.vx.rToString());
        stringBuilder.append(" )(vx_i ");
        stringBuilder.append(this.vx.iToString());
        stringBuilder.append(" )(vx_j ");
        stringBuilder.append(this.vx.jToString());
        stringBuilder.append(" )(vx_k ");
        stringBuilder.append(this.vx.kToString());
        stringBuilder.append(" )(vy_r ");
        stringBuilder.append(this.vy.rToString());
        stringBuilder.append(" )(vy_i ");
        stringBuilder.append(this.vy.iToString());
        stringBuilder.append(" )(vy_j ");
        stringBuilder.append(this.vy.jToString());
        stringBuilder.append(" )(vy_k ");
        stringBuilder.append(this.vy.kToString());
        stringBuilder.append(" )(range ");
        stringBuilder.append(this.range);
        stringBuilder.append(" )(hifi ");
        stringBuilder.append(this.hifi_p ? "T" : "F");
        stringBuilder.append(" )(rangeOver ");
        stringBuilder.append(this.rangeOver);
        stringBuilder.append(" )(colorsCount ");
        stringBuilder.append(this.colorsCount);
        stringBuilder.append(" )(interpolate ");
        stringBuilder.append(this.interpolateColors);
        stringBuilder.append(" )(panels ");
        stringBuilder.append(this.panels);
        stringBuilder.append(" )(panel_x ");
        stringBuilder.append(this.panel_x);
        stringBuilder.append(" )(panel_y ");
        stringBuilder.append(this.panel_y);
        stringBuilder.append(" )(width ");
        stringBuilder.append(this.pix_width);
        stringBuilder.append(" )(height ");
        stringBuilder.append(this.pix_height);
        stringBuilder.append(" )(depth ");
        stringBuilder.append(this.depth);
        stringBuilder.append(" )(id ");
        stringBuilder.append(this.which);
        stringBuilder.append(" )(loops_per_color ");
        stringBuilder.append(this.loops_per_color);
        if (this.trapPathname != null && this.trapPathname.trim().length() > 0) {
            stringBuilder.append(" )(trapPathname ");
            stringBuilder.append(this.trapPathname);
        }
        stringBuilder.append(" )(comment ");
        stringBuilder.append("Created: ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        Date date = new Date();
        String string2 = dateFormat.format(date);
        stringBuilder.append(string2);
        stringBuilder.append(" by Fractal Top ver. 5.0");
        if (string != null && string.length() > 0) {
            stringBuilder.append(" -*- ");
            stringBuilder.append(string);
            stringBuilder.append(" -*- ");
        }
        stringBuilder.append(" end_of_comment ))");
        return stringBuilder.toString();
    }

    public FractalSpec(FractalSpec fractalSpec) {
        this.center = new BigQuaternion();
        this.coeff = new BigQuaternion();
        this.trans = new BigQuaternion();
        this.vx = new FastQuaternion();
        this.vy = new FastQuaternion();
        this.vz = new FastQuaternion();
        this.center.assign_from(fractalSpec.center);
        this.vx.assign_from(fractalSpec.vx);
        this.vy.assign_from(fractalSpec.vy);
        this.vz.assign_from(fractalSpec.vz);
        this.coeff.assign_from(fractalSpec.coeff);
        this.trans.assign_from(fractalSpec.trans);
        this.range = fractalSpec.range;
        this.rangeOver = fractalSpec.rangeOver;
        this.pix_width = fractalSpec.pix_width;
        this.pix_height = fractalSpec.pix_height;
        this.depth = fractalSpec.depth;
        this.which = fractalSpec.which;
        this.panels = fractalSpec.panels;
        this.panel_x = fractalSpec.panel_x;
        this.panel_y = fractalSpec.panel_y;
        this.colorsCount = fractalSpec.colorsCount;
        this.interpolateColors = fractalSpec.interpolateColors;
        this.loops_per_color = fractalSpec.loops_per_color;
        this.hifi_p = fractalSpec.hifi_p;
        this.version = fractalSpec.version;
        this.hAxisScale = fractalSpec.hAxisScale;
        this.thumbNail = fractalSpec.thumbNail;
        this.cache_is_current = fractalSpec.cache_is_current;
        this.lox = new BigQuaternion(fractalSpec.lox);
        this.hiy = new BigQuaternion(fractalSpec.hiy);
        this.incx = new BigQuaternion(fractalSpec.incx);
        this.incy = new BigQuaternion(fractalSpec.incy);
        this.trapPathname = fractalSpec.trapPathname;
        this.wHRatio_.setSize(fractalSpec.wHRatio_);
    }

    public FractalSpec assignFrom(FractalSpec fractalSpec) {
        this.center.assign_from(fractalSpec.center);
        this.coeff.assign_from(fractalSpec.coeff);
        this.trans.assign_from(fractalSpec.trans);
        this.vx.assign_from(fractalSpec.vx);
        this.vy.assign_from(fractalSpec.vy);
        this.vz.assign_from(fractalSpec.vz);
        this.range = fractalSpec.range;
        this.rangeOver = fractalSpec.rangeOver;
        this.pix_width = fractalSpec.pix_width;
        this.pix_height = fractalSpec.pix_height;
        this.depth = fractalSpec.depth;
        this.which = fractalSpec.which;
        this.panels = fractalSpec.panels;
        this.panel_x = fractalSpec.panel_x;
        this.panel_y = fractalSpec.panel_y;
        this.colorsCount = fractalSpec.colorsCount;
        this.interpolateColors = fractalSpec.interpolateColors;
        this.loops_per_color = fractalSpec.loops_per_color;
        this.hifi_p = fractalSpec.hifi_p;
        this.version = fractalSpec.version;
        this.hAxisScale = fractalSpec.hAxisScale;
        this.thumbNail = fractalSpec.thumbNail;
        this.cache_is_current = fractalSpec.cache_is_current;
        this.lox.assign_from(fractalSpec.lox);
        this.hiy.assign_from(fractalSpec.hiy);
        this.incx.assign_from(fractalSpec.incx);
        this.incy.assign_from(fractalSpec.incy);
        this.trapPathname = fractalSpec.trapPathname;
        return this;
    }

    public boolean equal_p(FractalSpec fractalSpec) {
        return this.center.equal_p(fractalSpec.center) && this.vx.equals(fractalSpec.vx) && this.vy.equals(fractalSpec.vy) && this.coeff.equal_p(fractalSpec.coeff) && this.trans.equal_p(fractalSpec.trans) && this.range == fractalSpec.range && this.rangeOver == fractalSpec.rangeOver && this.pix_width == fractalSpec.pix_width && this.pix_height == fractalSpec.pix_height && this.depth == fractalSpec.depth && (this.which == null ? fractalSpec.which == null : this.which.equals(fractalSpec.which)) && this.panels == fractalSpec.panels && this.panel_x == fractalSpec.panel_x && this.panel_y == fractalSpec.panel_y && this.loops_per_color == fractalSpec.loops_per_color && this.hifi_p == fractalSpec.hifi_p && this.version == fractalSpec.version && this.interpolateColors == fractalSpec.interpolateColors && (this.trapPathname == null ? fractalSpec.trapPathname == null : fractalSpec.trapPathname != null && this.trapPathname.equals(fractalSpec.trapPathname)) && this.hAxisScale == fractalSpec.hAxisScale;
    }
}

