/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.Tetra;

public class TetraPower3
extends Tetra {
    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^3 + C*Z(0) + T - using Tetra mult table.";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return " __________________________\n  * ||  r |  i |  j |  k |\n==========================\n| r ||  r |  i |  j |  k |\n__________________________\n| i ||  i | -j |  k |  r |\n__________________________\n| j ||  j | -k | -r |  i |\n__________________________\n| k ||  k | -r | -i | -j |\n__________________________\nZ^3 here is Z(Z^2).  For (Z^2)Z interchange i and k.";
    }

    @Override
    public String q1String() {
        return "Z(0)";
    }

    @Override
    public String q2String() {
        return "C";
    }

    @Override
    public String q3String() {
        return "T";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion.j;
        double d4 = fastQuaternion.k;
        double d5 = d * fastQuaternion2.r + d2 * fastQuaternion2.k - d3 * fastQuaternion2.j - d4 * fastQuaternion2.i + fastQuaternion3.r;
        double d6 = d * fastQuaternion2.i + d2 * fastQuaternion2.r + d3 * fastQuaternion2.k - d4 * fastQuaternion2.j + fastQuaternion3.i;
        double d7 = d * fastQuaternion2.j - d2 * fastQuaternion2.i + d3 * fastQuaternion2.r - d4 * fastQuaternion2.k + fastQuaternion3.j;
        double d8 = d * fastQuaternion2.k + d2 * fastQuaternion2.j - d3 * fastQuaternion2.i + d4 * fastQuaternion2.r + fastQuaternion3.k;
        for (int i = 1; i < n; ++i) {
            double d9 = d * d;
            double d10 = d3 * d3;
            double d11 = d2 * d2 + d4 * d4;
            if (d9 + d10 + d11 > 10.0) {
                return i;
            }
            double d12 = d * (d9 - 3.0 * d10) + d3 * d11 + d5;
            double d13 = 3.0 * d9 - d10;
            double d14 = d2 * d13 + d4 * d11 + d6;
            d3 = d3 * d13 - 3.0 * d * d11 + d7;
            d4 = d4 * d13 - d2 * d11 + d8;
            d = d12;
            d2 = d14;
        }
        return n;
    }
}

