/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class QuatPower5
extends FTLooper {
    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return "\nQuaternion multiplication table:\n  __________________________\n   * ||  r |  i |  j |  k |\n ==========================\n | r ||  r |  i |  j |  k |\n __________________________\n | i ||  i | -r |  k | -j |\n __________________________\n | j ||  j | -k | -r |  i |\n __________________________\n | k ||  k |  j | -i | -r | \n __________________________";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^5 + C*Z(0) + T - using quaternion space";
    }

    @Override
    public String q1String() {
        return "Z(0)";
    }

    @Override
    public String q2String() {
        return "C";
    }

    @Override
    public String q3String() {
        return "T";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        double d = fastQuaternion.r * fastQuaternion2.r - fastQuaternion.i * fastQuaternion2.i - fastQuaternion.j * fastQuaternion2.j - fastQuaternion.k * fastQuaternion2.k + fastQuaternion3.r;
        double d2 = fastQuaternion.r * fastQuaternion2.i + fastQuaternion.i * fastQuaternion2.r + fastQuaternion.j * fastQuaternion2.k - fastQuaternion.k * fastQuaternion2.j + fastQuaternion3.i;
        double d3 = fastQuaternion.r * fastQuaternion2.j - fastQuaternion.i * fastQuaternion2.k + fastQuaternion.j * fastQuaternion2.r + fastQuaternion.k * fastQuaternion2.i + fastQuaternion3.j;
        double d4 = fastQuaternion.r * fastQuaternion2.k + fastQuaternion.i * fastQuaternion2.j - fastQuaternion.j * fastQuaternion2.i + fastQuaternion.k * fastQuaternion2.r + fastQuaternion3.k;
        double d5 = fastQuaternion.r;
        double d6 = fastQuaternion.i;
        double d7 = fastQuaternion.j;
        double d8 = fastQuaternion.k;
        for (int i = 1; i < n; ++i) {
            double d9 = d5 * d5;
            double d10 = d6 * d6;
            double d11 = d7 * d7;
            double d12 = d8 * d8;
            if (d9 + d10 + d11 + d12 > 2.0) {
                return i;
            }
            double d13 = d9 - d10 - d11 - d12;
            double d14 = d13 * d13 - 4.0 * d9 * (d10 + d11 + d12);
            double d15 = 4.0 * d5 * d6 * d13;
            double d16 = 4.0 * d5 * d7 * d13;
            double d17 = 4.0 * d5 * d8 * d13;
            double d18 = d5 * d14 - d6 * d15 - d7 * d16 - d8 * d17 + d;
            double d19 = d5 * d15 + d6 * d14 + d7 * d17 - d8 * d16 + d2;
            double d20 = d5 * d16 - d6 * d17 + d7 * d14 + d8 * d15 + d3;
            d8 = d5 * d17 + d6 * d16 - d7 * d15 + d8 * d14 + d4;
            d7 = d20;
            d6 = d19;
            d5 = d18;
        }
        return n;
    }
}

