/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class Phoenix_21
extends FTLooper {
    public boolean outputsColorIndexP() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(n) + P*Z(n-1)";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.653, 0.0, 2.0, 0.0);
    }

    @Override
    public String docString() {
        return "This is, I believe, the Phoenix formula in the complex plane.\nSpecialized to the case where A=2 and B=1";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "P//-/-";
    }

    @Override
    public String q3String() {
        return "C//-/-";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 1; i < n; ++i) {
            double d5 = d * d - d2 * d2 + fastQuaternion3.r * d - fastQuaternion3.i * d2 + fastQuaternion2.r * d3 - fastQuaternion2.i * d4;
            double d6 = 2.0 * d * d2 + fastQuaternion3.r * d2 + fastQuaternion3.i * d + fastQuaternion2.r * d4 + fastQuaternion2.i * d3;
            d3 = d;
            d4 = d2;
            d = d5;
            d2 = d6;
            if (!(d * d + d2 * d2 > 2.0)) continue;
            return (int)(256.0 * Phoenix_21.atanIndex(d3, d4, d, d2, i % 2 == 0));
        }
        return 255;
    }

    static double atanIndex(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.abs(d3 - d);
        double d6 = d5 == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(d4 - d2) / d5);
        if (d6 < 0.0) {
            d6 += Math.PI;
        }
        if (bl) {
            return 0.984375 * (d6 / Math.PI);
        }
        return 0.984375 * (d6 / Math.PI) + 0.5;
    }

    public static void main(String[] stringArray) {
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 0.0, 10.0, true) + "index = " + 256.0 * Phoenix_21.atanIndex(0.0, 0.0, 0.0, 10.0, true));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 8.6, 5.0, true));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, 5.0, true));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, 8.6, true));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 10.0, 0.0, true) + "index = " + 256.0 * Phoenix_21.atanIndex(0.0, 0.0, 10.0, 0.0, true));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, -10.0, 0.0, true));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, -8.6, true));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, -5.0, 5.0, true));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 8.6, -5.0, true));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 0.0, -10.0, true));
        System.out.println("break");
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 0.0, 10.0, false) + "index = " + 256.0 * Phoenix_21.atanIndex(0.0, 0.0, 0.0, 10.0, false));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 8.6, 5.0, false));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, 5.0, false));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, 8.6, false));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 10.0, 0.0, false) + "index = " + 256.0 * Phoenix_21.atanIndex(0.0, 0.0, 10.0, 0.0, false));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, -10.0, 0.0, false));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 5.0, -8.6, false));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, -5.0, 5.0, false));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 8.6, -5.0, false));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + Phoenix_21.atanIndex(0.0, 0.0, 0.0, -10.0, false));
    }
}

