/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.Complex;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.TrapFrame;

public class PhoenixTrapGIF
extends FTLooper {
    TrapFrame trap_ = null;
    double halfRange_ = 0.0;

    @Override
    public boolean acceptsTrapGif() {
        return true;
    }

    public boolean outputsColorIndexP() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^A + C*Z(n)^B + P*Z(n-1)";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 2.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(-0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.653, 0.0, 0.0, 0.18);
    }

    @Override
    public String docString() {
        return "This is an Image Trap loop.\nLoad a GIF file for the trap.  Transparency is honored.\nR and Imid set the position of the image.\nCclk is a degrees rotation of the image.\nSize is the size of the embedded image.";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, A, B)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, Rmid, Imid)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, cclk, size)";
    }

    @Override
    public void prepare(FractalSpec fractalSpec) {
        FastQuaternion fastQuaternion = new FastQuaternion(fractalSpec.coeff);
        FastQuaternion fastQuaternion2 = new FastQuaternion(fractalSpec.trans);
        this.trap_ = FTCentral.getTrapFrame_static();
        this.trap_.setCenter(fastQuaternion.j, fastQuaternion.k);
        this.trap_.setRotation(fastQuaternion2.j);
        boolean bl = this.trap_.setRange(fastQuaternion2.k == 0.0 ? 0.18 : fastQuaternion2.k);
        if (!bl) {
            FTCentral.message("PhoenixTrapGIF.prepare: call to TrapFrame.setRange returned FALSE!  Trap is not set up right.", true);
        }
        this.halfRange_ = 1.1 * fastQuaternion2.k * (this.trap_.radius() / (double)this.trap_.width());
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        Complex complex = new Complex(fastQuaternion.r, fastQuaternion.i);
        Complex complex2 = new Complex(fastQuaternion2.r, fastQuaternion2.i);
        Complex complex3 = new Complex(fastQuaternion3.r, fastQuaternion3.i);
        int n2 = (int)fastQuaternion.j;
        int n3 = (int)fastQuaternion.k;
        Complex complex4 = new Complex(0.0, 0.0);
        for (int i = 1; i < n; ++i) {
            Integer n4;
            double d = complex.r - fastQuaternion2.j;
            double d2 = complex.i - fastQuaternion2.k;
            if (Math.abs(d) <= this.halfRange_ && Math.abs(d2) <= this.halfRange_ && (n4 = this.trap_.hitP(complex.r, complex.i)) != null) {
                return n4;
            }
            Complex complex5 = complex.toPower(n2).plus_equal(complex.toPower(n3).times_equal(complex3)).plus_equal(complex4.times_equal(complex2));
            complex4 = complex;
            complex = complex5;
        }
        return 0;
    }
}

