/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.Complex;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class PhoenixDepth
extends FTLooper {
    public boolean outputsColorIndexP() {
        return false;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^A + C*Z(n)^B + P*Z(n-1); K is bound.";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(0.5, 0.0, 2.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.653, 0.0, 2.0, 0.0);
    }

    @Override
    public String docString() {
        return "This is, I believe, the Phoenix formula in the complex plane.\nThis one returns the number of iterations till divergence\nat |Z(n)| > K.";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "P//K/-";
    }

    @Override
    public String q3String() {
        return "C//A/B";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        Complex complex = new Complex(fastQuaternion.r, fastQuaternion.i);
        Complex complex2 = new Complex(fastQuaternion2.r, fastQuaternion2.i);
        Complex complex3 = new Complex(fastQuaternion3.r, fastQuaternion3.i);
        int n2 = (int)fastQuaternion3.j;
        int n3 = (int)fastQuaternion3.k;
        int n4 = (int)fastQuaternion2.j;
        Complex complex4 = new Complex(0.0, 0.0);
        for (int i = 1; i < n; ++i) {
            Complex complex5 = complex.toPower(n2).plus_equal(complex.toPower(n3).times_equal(complex3)).plus_equal(complex4.times_equal(complex2));
            complex4 = complex;
            complex = complex5;
            if (!(complex.magnitude() > (double)n4)) continue;
            return i;
        }
        return n;
    }
}

