/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.Complex;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class Phoenix
extends FTLooper {
    public boolean outputsColorIndexP() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^A + C*Z(n)^B + P*Z(n-1)";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.653, 0.0, 2.0, 0.0);
    }

    @Override
    public String docString() {
        return "This is, I believe, the Phoenix formula in the complex plane.";
    }

    @Override
    public String q1String() {
        return "(Z(0)r, Z(0)i, -, -)";
    }

    @Override
    public String q2String() {
        return "(Pr, Pi, -, -)";
    }

    @Override
    public String q3String() {
        return "(Cr, Ci, A, B)";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        Complex complex = new Complex(fastQuaternion.r, fastQuaternion.i);
        Complex complex2 = new Complex(fastQuaternion2.r, fastQuaternion2.i);
        Complex complex3 = new Complex(fastQuaternion3.r, fastQuaternion3.i);
        int n2 = (int)fastQuaternion3.j;
        int n3 = (int)fastQuaternion3.k;
        Complex complex4 = new Complex(0.0, 0.0);
        for (int i = 1; i < n; ++i) {
            Complex complex5 = complex.toPower(n2).plus_equal(complex.toPower(n3).times_equal(complex3)).plus_equal(complex4.times_equal(complex2));
            complex4 = complex;
            complex = complex5;
            if (!(complex.magnitude() > 2.0)) continue;
            return (int)(256.0 * Phoenix.atanIndex(complex4.r, complex4.i, complex.r, complex.i, i % 2 == 0));
        }
        return 255;
    }

    static double atanIndex(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.abs(d3 - d);
        double d6 = d5 == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(d4 - d2) / d5);
        if (d6 < 0.0) {
            d6 += Math.PI;
        }
        if (bl) {
            return 0.984375 * (d6 / Math.PI);
        }
        return 0.984375 * (d6 / Math.PI) + 0.5;
    }

    public static void main(String[] stringArray) {
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 0.0, 10.0, true) + "index = " + 256.0 * Phoenix.atanIndex(0.0, 0.0, 0.0, 10.0, true));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 8.6, 5.0, true));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, 5.0, true));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, 8.6, true));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 10.0, 0.0, true) + "index = " + 256.0 * Phoenix.atanIndex(0.0, 0.0, 10.0, 0.0, true));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, -10.0, 0.0, true));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, -8.6, true));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, -5.0, 5.0, true));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 8.6, -5.0, true));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 0.0, -10.0, true));
        System.out.println("break");
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 0.0, 10.0, false) + "index = " + 256.0 * Phoenix.atanIndex(0.0, 0.0, 0.0, 10.0, false));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 8.6, 5.0, false));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, 5.0, false));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, 8.6, false));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 10.0, 0.0, false) + "index = " + 256.0 * Phoenix.atanIndex(0.0, 0.0, 10.0, 0.0, false));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, -10.0, 0.0, false));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 5.0, -8.6, false));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, -5.0, 5.0, false));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 8.6, -5.0, false));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + Phoenix.atanIndex(0.0, 0.0, 0.0, -10.0, false));
    }
}

