/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;
import us.lystad.fractaltop.OrbitReporter;

public class MandelbrotG
extends FTLooper {
    private boolean asBigP = true;

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double rangeInit() {
        return 4.2;
    }

    @Override
    public String docString() {
        return " Mandelbrot and Julia fractal in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//-/-";
    }

    @Override
    public boolean bigLoop_p() {
        return this.asBigP;
    }

    @Override
    public String getLoopName() {
        return "Mandelbrot";
    }

    @Override
    public boolean traceOrbit_p() {
        return true;
    }

    private Fraction getBoundSquared(BigQuaternion bigQuaternion) {
        Fraction fraction = new Fraction("1", 0);
        Fraction fraction2 = bigQuaternion.magnitude_sq().sqrt();
        Fraction fraction3 = fraction2.timesScalar(4.0).add(fraction).sqrt().add(fraction).timesScalar(0.5);
        return fraction3.multiply(fraction3).add(new Fraction(1.0E-16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String traceOrbit(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n, OrbitReporter orbitReporter) {
        int n2 = 0;
        try {
            BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
            Fraction fraction = new Fraction(1.0);
            Fraction fraction2 = new Fraction(0.0);
            Fraction fraction3 = new Fraction(bigQuaternion.r);
            Fraction fraction4 = new Fraction(bigQuaternion.i);
            Fraction fraction5 = bigQuaternion4.r;
            Fraction fraction6 = bigQuaternion4.i;
            Fraction fraction7 = this.getBoundSquared(bigQuaternion4);
            Fraction fraction8 = fraction3.multiply(fraction3);
            Fraction fraction9 = fraction4.multiply(fraction4);
            BigQuaternion bigQuaternion5 = new BigQuaternion(bigQuaternion);
            orbitReporter.metaData("LoopName", "Mandelbrot");
            orbitReporter.metaData("depth", String.valueOf(n));
            orbitReporter.metaData("point", bigQuaternion.toString());
            orbitReporter.metaData("coeff", bigQuaternion2.toString());
            orbitReporter.metaData("trans", bigQuaternion3.toString());
            bigQuaternion5.j = new Fraction(0.0);
            bigQuaternion5.k = new Fraction(0.0);
            orbitReporter.data(0, bigQuaternion5);
            for (n2 = 1; n2 <= n; ++n2) {
                fraction8.subtract_A(fraction9, fraction2).plus_equal(fraction5);
                fraction4.multiply_A(fraction3, fraction).doubled_A(fraction4).plus_equal(fraction6);
                fraction3.setValue(fraction2);
                fraction3.multiply_A(fraction3, fraction8);
                fraction4.multiply_A(fraction4, fraction9);
                bigQuaternion5.r = new Fraction(fraction3);
                bigQuaternion5.i = new Fraction(fraction4);
                orbitReporter.data(n2, bigQuaternion5);
                if (fraction8.add(fraction9).compareTo(fraction7) <= 0) continue;
                orbitReporter.metaData("Exit", "at " + n2 + " iterations with a limit of " + n + ".");
                String string = "";
                return string;
            }
            orbitReporter.metaData("Exit", "at " + n + ", the iterations limit.");
        }
        catch (Throwable throwable) {
            orbitReporter.alert("ERROR: An ERROR occurred in the loop Mandelbrot.traceOrbit:" + throwable.getMessage());
        }
        finally {
            orbitReporter.finish(n2);
        }
        return "";
    }

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
        Fraction fraction = new Fraction(1.0);
        Fraction fraction2 = new Fraction(0.0);
        Fraction fraction3 = new Fraction(bigQuaternion.r);
        Fraction fraction4 = new Fraction(bigQuaternion.i);
        Fraction fraction5 = bigQuaternion4.r;
        Fraction fraction6 = bigQuaternion4.i;
        Fraction fraction7 = fraction3.multiply(fraction3);
        Fraction fraction8 = fraction4.multiply(fraction4);
        Fraction fraction9 = this.getBoundSquared(bigQuaternion4);
        for (int i = 1; i <= n; ++i) {
            fraction7.subtract_A(fraction8, fraction2).plus_equal(fraction5);
            fraction4.multiply_A(fraction3, fraction).doubled_A(fraction4).plus_equal(fraction6);
            fraction3.setValue(fraction2);
            fraction3.multiply_A(fraction3, fraction7);
            fraction4.multiply_A(fraction4, fraction8);
            if (fraction7.add(fraction8).compareTo(fraction9) <= 0) continue;
            return i;
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        double d8 = (1.0 + Math.sqrt(1.0 + 4.0 * d7)) / 2.0 + 1.0E-16;
        d8 *= d8;
        for (int i = 1; i <= n; ++i) {
            double d9 = d5 - d6 + d3;
            d = d9;
            if (!((d5 = d * d) + (d6 = (d2 = 2.0 * d * d2 + d4) * d2) > d8)) continue;
            return i;
        }
        return n;
    }
}

