/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;
import us.lystad.fractaltop.OrbitReporter;

public class Mandelbrot
extends FTLooper {
    private static boolean libLoadedP_ = false;
    private static boolean setIgnoreCompiledCodeP_ = false;

    @Override
    public boolean libLoadedP() {
        return libLoadedP_;
    }

    @Override
    public boolean useCompiledCodeP() {
        return libLoadedP_ && this.cleanupLoadedP() && !setIgnoreCompiledCodeP_;
    }

    @Override
    public String getCompiledCodeStatus() {
        if (!libLoadedP_) {
            return "Compiled code unavailable";
        }
        return setIgnoreCompiledCodeP_ ? "Compiled code is off" : "Compiled code is on";
    }

    @Override
    public String toggleUseCompiledCode() {
        setIgnoreCompiledCodeP_ = !setIgnoreCompiledCodeP_;
        return this.getCompiledCodeStatus();
    }

    @Override
    public boolean bigLoop_p() {
        return true;
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(-0.75, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double rangeInit() {
        return 2.7;
    }

    @Override
    public String docString() {
        return " Mandelbrot and Julia fractal in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, -, -)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, -, -)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, -, -)";
    }

    @Override
    public String getLoopName() {
        return "Mandelbrot";
    }

    @Override
    public boolean traceOrbit_p() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String traceOrbit(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n, OrbitReporter orbitReporter) {
        int n2 = 0;
        try {
            BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
            Fraction fraction = new Fraction(1.0);
            Fraction fraction2 = new Fraction(0.0);
            Fraction fraction3 = new Fraction(bigQuaternion.r);
            Fraction fraction4 = new Fraction(bigQuaternion.i);
            Fraction fraction5 = bigQuaternion4.r;
            Fraction fraction6 = bigQuaternion4.i;
            Fraction fraction7 = fraction3.multiply(fraction3);
            Fraction fraction8 = fraction4.multiply(fraction4);
            Fraction fraction9 = this.getBoundSquared(bigQuaternion4);
            BigQuaternion bigQuaternion5 = new BigQuaternion(bigQuaternion);
            orbitReporter.metaData("LoopName", "Mandelbrot");
            orbitReporter.metaData("depth", String.valueOf(n));
            orbitReporter.metaData("point", bigQuaternion.toString());
            orbitReporter.metaData("coeff", bigQuaternion2.toString());
            orbitReporter.metaData("trans", bigQuaternion3.toString());
            bigQuaternion5.j = new Fraction(0.0);
            bigQuaternion5.k = new Fraction(0.0);
            orbitReporter.data(0, bigQuaternion5);
            for (n2 = 0; n2 <= n; ++n2) {
                if (fraction7.add(fraction8).compareTo(fraction9) > 0) {
                    orbitReporter.metaData("Exit", "at " + n2 + " iterations with a limit of " + n + ".");
                    String string = "";
                    return string;
                }
                fraction7.subtract_A(fraction8, fraction2).plus_equal(fraction5);
                fraction4.multiply_A(fraction3, fraction).doubled_A(fraction4).plus_equal(fraction6);
                fraction3.setValue(fraction2);
                fraction3.multiply_A(fraction3, fraction7);
                fraction4.multiply_A(fraction4, fraction8);
                bigQuaternion5.r = new Fraction(fraction3);
                bigQuaternion5.i = new Fraction(fraction4);
                orbitReporter.data(n2, bigQuaternion5);
            }
            orbitReporter.metaData("Exit", "at " + n + ", the iterations limit.");
        }
        catch (Throwable throwable) {
            orbitReporter.alert("ERROR: An ERROR occurred in the loop Mandelbrot.traceOrbit:\n" + FTCentral.getExceptionSynopsis(throwable));
        }
        finally {
            orbitReporter.finish(Math.min(n2, n));
        }
        return "";
    }

    private Fraction getBoundSquared(BigQuaternion bigQuaternion) {
        Fraction fraction = new Fraction("1", 0);
        Fraction fraction2 = bigQuaternion.magnitude_sq().sqrt();
        Fraction fraction3 = fraction2.timesScalar(4.0).add(fraction).sqrt().add(fraction).timesScalar(0.5);
        return fraction3.multiply(fraction3).add(new Fraction(1.0E-16));
    }

    private double getBoundSquared(FastQuaternion fastQuaternion) {
        double d = Math.sqrt(fastQuaternion.r * fastQuaternion.r + fastQuaternion.i * fastQuaternion.i);
        double d2 = (Math.sqrt(d * 4.0 + 1.0) + 1.0) / 2.0;
        return d2 * d2;
    }

    private native int compiledMandelbrot(String var1, String var2, String var3, String var4, int var5, int var6);

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        if (this.useCompiledCodeP()) {
            try {
                String string = bigQuaternion.r.toString();
                String string2 = bigQuaternion.i.toString();
                BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
                String string3 = bigQuaternion4.r.toString();
                String string4 = bigQuaternion4.i.toString();
                return this.compiledMandelbrot(string, string2, string3, string4, n, bigQuaternion.r.getDenominator());
            }
            catch (Throwable throwable) {
                System.out.print("Got a compiled loop error: " + throwable.getMessage() + ", error type = " + throwable.getClass().getName());
                libLoadedP_ = false;
            }
        }
        BigQuaternion bigQuaternion5 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
        Fraction fraction = new Fraction(1.0);
        Fraction fraction2 = new Fraction(bigQuaternion.r);
        Fraction fraction3 = new Fraction(bigQuaternion.i);
        Fraction fraction4 = new Fraction(fraction2);
        Fraction fraction5 = bigQuaternion5.r;
        Fraction fraction6 = bigQuaternion5.i;
        Fraction fraction7 = fraction2.multiply(fraction2);
        Fraction fraction8 = fraction3.multiply(fraction3);
        Fraction fraction9 = this.getBoundSquared(bigQuaternion5);
        for (int i = 0; i <= n; ++i) {
            if (fraction7.add(fraction8).compareTo(fraction9) > 0) {
                return i;
            }
            fraction7.subtract_A(fraction8, fraction4).plus_equal(fraction5);
            fraction3.multiply_A(fraction2, fraction).doubled_A(fraction3).plus_equal(fraction6);
            fraction2.setValue(fraction4);
            fraction2.multiply_A(fraction2, fraction7);
            fraction3.multiply_A(fraction3, fraction8);
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = this.getBoundSquared(fastQuaternion4);
        for (int i = 0; i <= n; ++i) {
            if (d5 + d6 > d7) {
                return i;
            }
            double d8 = d5 - d6 + d3;
            d2 = 2.0 * d * d2 + d4;
            d = d8;
            d5 = d * d;
            d6 = d2 * d2;
        }
        return n;
    }

    static {
        String string = "?";
        try {
            string = Mandelbrot.getCppLibName("mandelbrot");
            System.loadLibrary(string);
            libLoadedP_ = true;
            System.out.println("Mandelbrot.static: Load SUCCEEDED for " + string);
        }
        catch (Throwable throwable) {
            System.out.println("Mandelbrot.static:  Library not found: " + string);
        }
    }
}

