/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;

public class MandelCubeG
extends FTLooper {
    @Override
    public boolean bigLoop_p() {
        return true;
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double rangeInit() {
        return 5.0;
    }

    @Override
    public String docString() {
        return " MandelCube: Mandelbrot-like fractal using 3rd power of Z(n) in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^3 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//-/-";
    }

    private Fraction getBoundSquared(BigQuaternion bigQuaternion) {
        Fraction fraction = new Fraction("1", 0);
        Fraction fraction2 = bigQuaternion.magnitude_sq().sqrt();
        Fraction fraction3 = fraction2.timesScalar(4.0).add(fraction).sqrt().add(fraction).timesScalar(0.5);
        return fraction3.multiply(fraction3).add(new Fraction(1.0E-16));
    }

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        Fraction.setCommonDenominator(bigQuaternion.r, bigQuaternion.i, bigQuaternion2.r, bigQuaternion2.i);
        BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
        Fraction fraction = bigQuaternion.r;
        Fraction fraction2 = bigQuaternion.i;
        Fraction fraction3 = bigQuaternion4.r;
        Fraction fraction4 = bigQuaternion4.i;
        Fraction fraction5 = fraction.multiply(fraction);
        Fraction fraction6 = fraction2.multiply(fraction2);
        Fraction fraction7 = new Fraction(3.0);
        Fraction fraction8 = this.getBoundSquared(bigQuaternion4);
        for (int i = 1; i < n; ++i) {
            Fraction fraction9 = fraction.multiply(fraction5.subtract(fraction7.multiply(fraction6))).add(fraction3);
            fraction2 = fraction2.multiply(fraction7.multiply(fraction5).subtract(fraction6)).add(fraction4);
            fraction = fraction9;
            fraction5 = fraction.multiply(fraction);
            if (fraction5.add(fraction6 = fraction2.multiply(fraction2)).compareTo(fraction8) <= 0) continue;
            return i;
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        double d8 = (1.0 + Math.sqrt(1.0 + 4.0 * d7)) / 2.0 + 1.0E-16;
        d8 *= d8;
        for (int i = 1; i < n; ++i) {
            double d9 = d * (d5 - 3.0 * d6) + d3;
            if (!((d5 = (d = d9) * d) + (d6 = (d2 = d2 * (3.0 * d5 - d6) + d4) * d2) > d8)) continue;
            return i;
        }
        return n;
    }
}

