/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class Loop25
extends FTLooper {
    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^5 + C2*Z(0) + T";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return " Mandelbrot-like fractal using 5th power in the complex plane";
    }

    @Override
    public String q1String() {
        return "Z(0):r/i/-/-";
    }

    @Override
    public String q2String() {
        return "C:r/i/-/-";
    }

    @Override
    public String q3String() {
        return "T:r/i/-/-";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        for (int i = 1; i < n; ++i) {
            double d7 = d5 * d5 * d - 10.0 * d5 * d6 * d + 5.0 * d6 * d6 * d + d3;
            if (!((d5 = (d = d7) * d) + (d6 = (d2 = 5.0 * d5 * d5 * d2 - 10.0 * d5 * d6 * d2 + d6 * d6 * d2 + d4) * d2) > 4.0)) continue;
            return i;
        }
        return n;
    }
}

