/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class Loop23
extends FTLooper {
    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return " Mandelbrot-like fractal using 3rd power in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^3 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//-/-";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        for (int i = 1; i < n; ++i) {
            double d7 = d5 * d - 3.0 * d * d6 + d3;
            if (!((d5 = (d = d7) * d) + (d6 = (d2 = 3.0 * d5 * d2 - d2 * d6 + d4) * d2) > 4.0)) continue;
            return i;
        }
        return n;
    }
}

