/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;

public class Loop22_BD
extends FTLooper {
    private boolean hasBigP = true;
    private BigDecimal BD_2 = new BigDecimal("2");

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(-0.75, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return " Mandelbrot and Julia fractal in the complex plane";
    }

    @Override
    public String formulaString() {
        return "BigDecimal Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//-/-";
    }

    @Override
    public boolean bigLoop_p() {
        return this.hasBigP;
    }

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        Fraction.setCommonDenominator(bigQuaternion.r, bigQuaternion.i, bigQuaternion2.r, bigQuaternion2.i);
        BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
        MathContext mathContext = new MathContext(bigQuaternion.r.decimalPrecision(), RoundingMode.HALF_EVEN);
        BigDecimal bigDecimal = bigQuaternion.r.bigDecimalValue();
        BigDecimal bigDecimal2 = bigQuaternion.i.bigDecimalValue();
        BigDecimal bigDecimal3 = bigQuaternion4.r.bigDecimalValue();
        BigDecimal bigDecimal4 = bigQuaternion4.i.bigDecimalValue();
        BigDecimal bigDecimal5 = bigDecimal.pow(2, mathContext);
        BigDecimal bigDecimal6 = bigDecimal2.pow(2, mathContext);
        BigDecimal bigDecimal7 = bigQuaternion2.magnitude_sq().add(bigQuaternion2.times_scalar(2).magnitude()).add(new Fraction(1.0)).bigDecimalValue();
        for (int i = 1; i < n; ++i) {
            BigDecimal bigDecimal8 = bigDecimal5.subtract(bigDecimal6, mathContext).add(bigDecimal3, mathContext);
            bigDecimal2 = bigDecimal.multiply(bigDecimal2, mathContext).multiply(this.BD_2, mathContext).add(bigDecimal4, mathContext);
            bigDecimal = bigDecimal8;
            bigDecimal5 = bigDecimal.multiply(bigDecimal, mathContext);
            if (bigDecimal5.add(bigDecimal6 = bigDecimal2.multiply(bigDecimal2, mathContext), mathContext).compareTo(bigDecimal7) <= 0) continue;
            return i;
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = fastQuaternion2.r * fastQuaternion2.r + fastQuaternion2.i * fastQuaternion2.i + 1.0;
        for (int i = 1; i < n; ++i) {
            double d8 = d5 - d6 + d3;
            d = d8;
            if (!((d5 = d * d) + (d6 = (d2 = 2.0 * d * d2 + d4) * d2) > 4.0)) continue;
            return i;
        }
        return n;
    }
}

