/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;

public class Loop22
extends FTLooper {
    private boolean asBigP = true;

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(-0.75, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double rangeInit() {
        return 2.7;
    }

    @Override
    public String docString() {
        return " Mandelbrot and Julia fractal in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//-/-";
    }

    @Override
    public boolean bigLoop_p() {
        return this.asBigP;
    }

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion).plus(bigQuaternion3);
        Fraction fraction = new Fraction(1.0);
        Fraction fraction2 = new Fraction(0.0);
        Fraction fraction3 = new Fraction(bigQuaternion.r);
        Fraction fraction4 = new Fraction(bigQuaternion.i);
        Fraction fraction5 = bigQuaternion4.r;
        Fraction fraction6 = bigQuaternion4.i;
        Fraction fraction7 = fraction3.multiply(fraction3);
        Fraction fraction8 = fraction4.multiply(fraction4);
        Fraction fraction9 = bigQuaternion2.magnitude_sq().add(bigQuaternion2.times_scalar(2).magnitude()).add(fraction);
        for (int i = 1; i < n; ++i) {
            fraction7.subtract_A(fraction8, fraction2).plus_equal(fraction5);
            fraction4.multiply_A(fraction3, fraction).doubled_A(fraction4).plus_equal(fraction6);
            fraction3.setValue(fraction2);
            fraction3.multiply_A(fraction3, fraction7);
            fraction4.multiply_A(fraction4, fraction8);
            if (fraction7.add(fraction8).compareTo(fraction9) <= 0) continue;
            return i;
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = fastQuaternion2.r * fastQuaternion2.r + fastQuaternion2.i * fastQuaternion2.i + 1.0;
        for (int i = 1; i < n; ++i) {
            double d8 = d5 - d6 + d3;
            d = d8;
            if (!((d5 = d * d) + (d6 = (d2 = 2.0 * d * d2 + d4) * d2) > 4.0)) continue;
            return i;
        }
        return n;
    }
}

