/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class HcxPower2
extends FTLooper {
    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return "\nHypercomplex multiplication table:\n  __________________________\n   * ||  r |  i |  j |  k |\n ==========================\n | r ||  r |  i |  j |  k |\n __________________________\n | i ||  i | -r |  k | -j |\n __________________________\n | j ||  j |  k | -r | -i |\n __________________________\n | k ||  k | -j | -i |  r | \n __________________________";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T - using hypercomplex space";
    }

    @Override
    public String q1String() {
        return "Z(0)";
    }

    @Override
    public String q2String() {
        return "C";
    }

    @Override
    public String q3String() {
        return "T";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = new FastQuaternion(fastQuaternion);
        fastQuaternion4.assign_from(this.unique_times_equal(fastQuaternion4, fastQuaternion2).plus(fastQuaternion3));
        FastQuaternion fastQuaternion5 = new FastQuaternion(fastQuaternion);
        for (int i = 1; i < n; ++i) {
            if (fastQuaternion5.magnitude_sq() > 10.0) {
                return i;
            }
            this.unique_sq_self(fastQuaternion5).plus_equal(fastQuaternion4);
        }
        return n;
    }

    private FastQuaternion unique_times_equal(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2) {
        double d = fastQuaternion.r * fastQuaternion2.r - fastQuaternion.i * fastQuaternion2.i - fastQuaternion.j * fastQuaternion2.j + fastQuaternion.k * fastQuaternion2.k;
        double d2 = fastQuaternion.r * fastQuaternion2.i + fastQuaternion.i * fastQuaternion2.r - fastQuaternion.j * fastQuaternion2.k - fastQuaternion.k * fastQuaternion2.j;
        double d3 = fastQuaternion.r * fastQuaternion2.j - fastQuaternion.i * fastQuaternion2.k + fastQuaternion.j * fastQuaternion2.r - fastQuaternion.k * fastQuaternion2.i;
        double d4 = fastQuaternion.r * fastQuaternion2.k - fastQuaternion.i * fastQuaternion2.j - fastQuaternion.j * fastQuaternion2.i + fastQuaternion.k * fastQuaternion2.r;
        fastQuaternion.r = d;
        fastQuaternion.i = d2;
        fastQuaternion.j = d3;
        fastQuaternion.k = d4;
        return fastQuaternion;
    }

    private FastQuaternion unique_sq_self(FastQuaternion fastQuaternion) {
        double d = fastQuaternion.r * fastQuaternion.r - fastQuaternion.i * fastQuaternion.i - fastQuaternion.j * fastQuaternion.j + fastQuaternion.k * fastQuaternion.k;
        double d2 = 2.0 * (fastQuaternion.r * fastQuaternion.i - fastQuaternion.j * fastQuaternion.k);
        double d3 = 2.0 * (fastQuaternion.r * fastQuaternion.j - fastQuaternion.k * fastQuaternion.i);
        double d4 = 2.0 * (fastQuaternion.r * fastQuaternion.k - fastQuaternion.i * fastQuaternion.j);
        fastQuaternion.r = d;
        fastQuaternion.i = d2;
        fastQuaternion.j = d3;
        fastQuaternion.k = d4;
        return fastQuaternion;
    }
}

