/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.OrbitReporter;

public abstract class FTLooper {
    private static boolean cleanupLoadedP_ = false;

    public boolean cleanupLoadedP() {
        return cleanupLoadedP_;
    }

    public static String getCppLibName(String string) {
        String string2 = System.getProperty("os.arch");
        String string3 = "";
        String string4 = System.getProperty("os.name");
        if (string4.toLowerCase().contains("win")) {
            string3 = "win";
        } else if (string4.toLowerCase().contains("mac")) {
            string3 = "mac";
        } else if (string4.toLowerCase().contains("nix")) {
            string3 = "unix";
        } else if (string4.toLowerCase().contains("nux")) {
            string3 = "linux";
        } else if (string4.toLowerCase().contains("aix")) {
            string3 = "aix";
        } else if (string4.toLowerCase().contains("sunos")) {
            string3 = "sol";
        }
        return "ft_" + string3 + "_" + string2 + "_" + string;
    }

    public abstract int loop(FastQuaternion var1, FastQuaternion var2, FastQuaternion var3, int var4);

    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        return this.loop(bigQuaternion.fastQuaternionValue(), bigQuaternion2.fastQuaternionValue(), bigQuaternion3.fastQuaternionValue(), n);
    }

    public boolean libLoadedP() {
        return false;
    }

    public boolean useCompiledCodeP() {
        return false;
    }

    public String getCompiledCodeStatus() {
        return "Compiled code unavailable";
    }

    public String toggleUseCompiledCode() {
        return "Error: FTLooper default";
    }

    private native void threadCleanUp();

    public void cleanMPFROnMyThread() {
        if (this.useCompiledCodeP()) {
            this.threadCleanUp();
        }
    }

    public boolean bigLoop_p() {
        return false;
    }

    public String getLoopName() {
        return "<This base class loop does not supply a name.>";
    }

    public String traceOrbit(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n, OrbitReporter orbitReporter) {
        orbitReporter.alert("FTLooper.traceOrbit wass called with an OrbitListener of class " + orbitReporter.getClass().toString() + " - The FTLooper class should define this method if it's to be used.  Caller should check method FTLooper.traceOrbit_p().");
        orbitReporter.finish(n);
        return "This is a stub";
    }

    public boolean traceOrbit_p() {
        return false;
    }

    public boolean acceptsTrapGif() {
        return false;
    }

    public String rString() {
        return "real";
    }

    public String iString() {
        return "i";
    }

    public String jString() {
        return "j";
    }

    public String kString() {
        return "k";
    }

    public String q1String() {
        return "Z(0)";
    }

    public String q2String() {
        return "Q2";
    }

    public String q3String() {
        return "Q3";
    }

    public String formulaString() {
        return "Q(n+1) = Q(n)^2 + Q2*Q(0) + Q3";
    }

    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    public FastQuaternion q2Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    public double rangeInit() {
        return 3.0;
    }

    public int depthInit() {
        return 1000;
    }

    public double loopsPerColorInit() {
        return 1.0;
    }

    public String docString() {
        return "There is no documentation on this loop.";
    }

    public void prepare(FractalSpec fractalSpec) {
    }

    static {
        String string = "?";
        try {
            string = FTLooper.getCppLibName("ftlooper");
            System.loadLibrary(string);
            cleanupLoadedP_ = true;
            System.out.println("FTLooper.static: Load SUCCEEDED for " + string);
        }
        catch (Throwable throwable) {
            System.out.println("FTLooper.static: Library not found: " + string);
        }
    }
}

