/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.Fraction;

public class CubeLessZeroSq
extends FTLooper {
    private static boolean libLoadedP_ = false;
    private static boolean setIgnoreCompiledCodeP_ = false;

    @Override
    public boolean libLoadedP() {
        return libLoadedP_;
    }

    @Override
    public boolean useCompiledCodeP() {
        return libLoadedP_ && this.cleanupLoadedP() && !setIgnoreCompiledCodeP_;
    }

    @Override
    public String getCompiledCodeStatus() {
        if (!libLoadedP_) {
            return "Compiled code unavailable";
        }
        return setIgnoreCompiledCodeP_ ? "Compiled code is off" : "Compiled code is on";
    }

    @Override
    public String toggleUseCompiledCode() {
        setIgnoreCompiledCodeP_ = !setIgnoreCompiledCodeP_;
        return this.getCompiledCodeStatus();
    }

    @Override
    public boolean bigLoop_p() {
        return true;
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public double rangeInit() {
        return 5.0;
    }

    @Override
    public String docString() {
        return " CubeLessZeroSq: Mandelbrot-like fractal using 3rd power of Z(n) in the complex plane";
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^3 + C*Z(0) + T";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, -, -)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, -, -)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, -, -)";
    }

    private Fraction getBoundSquared(BigQuaternion bigQuaternion) {
        Fraction fraction = new Fraction("1", 0);
        Fraction fraction2 = bigQuaternion.magnitude_sq().sqrt();
        Fraction fraction3 = fraction2.timesScalar(4.0).add(fraction).sqrt().add(fraction).timesScalar(0.5);
        return fraction3.multiply(fraction3).add(new Fraction(1.0E-16));
    }

    private double getBoundSquared(FastQuaternion fastQuaternion) {
        double d = Math.sqrt(fastQuaternion.r * fastQuaternion.r + fastQuaternion.i * fastQuaternion.i);
        double d2 = (Math.sqrt(d * 4.0 + 1.0) + 1.0) / 2.0;
        return d2 * d2;
    }

    private native int compiledCubeLessZeroSq(String var1, String var2, String var3, String var4, int var5, int var6);

    @Override
    public int bigLoop(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n) {
        if (this.useCompiledCodeP()) {
            try {
                String string = bigQuaternion.r.toString();
                String string2 = bigQuaternion.i.toString();
                BigQuaternion bigQuaternion4 = bigQuaternion2.times(bigQuaternion.times(bigQuaternion)).plus(bigQuaternion3);
                String string3 = bigQuaternion4.r.toString();
                String string4 = bigQuaternion4.i.toString();
                return this.compiledCubeLessZeroSq(string, string2, string3, string4, n, bigQuaternion.r.getDenominator());
            }
            catch (Throwable throwable) {
                System.out.print("Got a compiled loop error: " + throwable.getMessage() + ", error type = " + throwable.getClass().getName());
                libLoadedP_ = false;
            }
        }
        Fraction.setCommonDenominator(bigQuaternion.r, bigQuaternion.i, bigQuaternion2.r, bigQuaternion2.i);
        BigQuaternion bigQuaternion5 = bigQuaternion2.times(bigQuaternion.times(bigQuaternion)).plus(bigQuaternion3);
        Fraction fraction = bigQuaternion.r;
        Fraction fraction2 = bigQuaternion.i;
        Fraction fraction3 = bigQuaternion5.r;
        Fraction fraction4 = bigQuaternion5.i;
        Fraction fraction5 = fraction.multiply(fraction);
        Fraction fraction6 = fraction2.multiply(fraction2);
        Fraction fraction7 = new Fraction(3.0);
        Fraction fraction8 = this.getBoundSquared(bigQuaternion5);
        for (int i = 0; i < n; ++i) {
            if (fraction5.add(fraction6).compareTo(fraction8) > 0) {
                return i;
            }
            fraction = fraction.multiply(fraction5.subtract(fraction7.multiply(fraction6))).add(fraction3);
            fraction2 = fraction2.multiply(fraction7.multiply(fraction5).subtract(fraction6)).add(fraction4);
            fraction5 = fraction.multiply(fraction);
            fraction6 = fraction2.multiply(fraction2);
        }
        return n;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = fastQuaternion2.times(fastQuaternion.times(fastQuaternion)).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion4.r;
        double d4 = fastQuaternion4.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        double d7 = this.getBoundSquared(fastQuaternion4);
        for (int i = 0; i < n; ++i) {
            if (d5 + d6 > d7) {
                return i;
            }
            d = d * (d5 - 3.0 * d6) + d3;
            d2 = d2 * (3.0 * d5 - d6) + d4;
            d5 = d * d;
            d6 = d2 * d2;
        }
        return n;
    }

    static {
        String string = "?";
        try {
            string = CubeLessZeroSq.getCppLibName("cubelesszerosq");
            System.loadLibrary(string);
            libLoadedP_ = true;
            System.out.println("CubeLessZeroSq.static: Load SUCCEEDED for " + string);
        }
        catch (Throwable throwable) {
            System.out.println("CubeLessZeroSq.static: Library not found: " + string);
        }
    }
}

