/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.TrapFrame;

public class CpxZ0
extends FTLooper {
    TrapFrame trap_ = null;
    double realHalfRange_ = 0.0;
    double imagHalfRange_ = 0.0;

    @Override
    public boolean acceptsTrapGif() {
        return true;
    }

    @Override
    public String rString() {
        return "real";
    }

    @Override
    public String iString() {
        return "i";
    }

    @Override
    public String jString() {
        return "-/rmid/cclk";
    }

    @Override
    public String kString() {
        return "bg/imid/size";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, -, ret)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, Rmid, Imid)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, cclk, size)";
    }

    @Override
    public void prepare(FractalSpec fractalSpec) {
        this.trap_ = FTCentral.getTrapFrame_static();
        FastQuaternion fastQuaternion = new FastQuaternion(fractalSpec.coeff);
        FastQuaternion fastQuaternion2 = new FastQuaternion(fractalSpec.trans);
        this.trap_.setCenter(fastQuaternion.j, fastQuaternion.k);
        this.trap_.setRotation(fastQuaternion2.j);
        boolean bl = this.trap_.setRange(fastQuaternion2.k == 0.0 ? 1.0 : fastQuaternion2.k);
        if (!bl) {
            FTCentral.message("CpxZ0.prepare: call to TrapFrame.setRange returned FALSE!  Trap is not set up right.", true);
        }
        this.imagHalfRange_ = this.realHalfRange_ = 1.1 * fastQuaternion2.k * (this.trap_.radius() / (double)this.trap_.width());
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = new FastQuaternion(fastQuaternion);
        fastQuaternion4.j = 0.0;
        fastQuaternion4.k = 0.0;
        FastQuaternion fastQuaternion5 = fastQuaternion2.times(fastQuaternion4).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion5.r;
        double d4 = fastQuaternion5.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        for (int i = 1; i < n; ++i) {
            Integer n2;
            double d7 = d5 - d6 + d3;
            d2 = 2.0 * d * d2 + d4;
            d = d7;
            d5 = d * d;
            d6 = d2 * d2;
            double d8 = d - fastQuaternion2.j;
            double d9 = d2 - fastQuaternion2.k;
            if (Math.abs(d8) <= this.realHalfRange_ && Math.abs(d9) <= this.imagHalfRange_ && (n2 = this.trap_.hitP(d, d2)) != null) {
                return n2;
            }
            if (!(d5 + d6 >= 4.0)) continue;
            return (int)fastQuaternion.k;
        }
        return (int)fastQuaternion.k;
    }
}

