/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.Complex;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;

public class CpxNAtan
extends FTLooper {
    public boolean outputsColorIndexP() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^A + C*Z(0) + T";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 2.0, 0.0);
    }

    @Override
    public String docString() {
        return "This is like CpxN but with an Atan coloring.";
    }

    @Override
    public String q1String() {
        return "Z(0)//-/-";
    }

    @Override
    public String q2String() {
        return "C//-/-";
    }

    @Override
    public String q3String() {
        return "T//A/-";
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        Complex complex = new Complex(fastQuaternion.r, fastQuaternion.i);
        Complex complex2 = new Complex(fastQuaternion2.r, fastQuaternion2.i);
        Complex complex3 = new Complex(fastQuaternion3.r, fastQuaternion3.i).plus_equal(complex2.times_equal(complex));
        Complex complex4 = new Complex(0.0, 0.0);
        int n2 = (int)fastQuaternion3.j;
        for (int i = 1; i < n; ++i) {
            complex4.assign_from(complex);
            complex.assign_from(complex.toPower(n2).plus_equal(complex3));
            if (!(complex.magnitude() > 2.0)) continue;
            return (int)(256.0 * CpxNAtan.atanIndex(complex4.r, complex4.i, complex.r, complex.i, i % 2 == 0));
        }
        return 255;
    }

    static double atanIndex(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.abs(d3 - d);
        double d6 = d5 == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(d4 - d2) / d5);
        if (d6 < 0.0) {
            d6 += Math.PI;
        }
        if (bl) {
            return 0.984375 * (d6 / Math.PI);
        }
        return 0.984375 * (d6 / Math.PI) + 0.5;
    }

    public static void main(String[] stringArray) {
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 0.0, 10.0, true) + "index = " + 256.0 * CpxNAtan.atanIndex(0.0, 0.0, 0.0, 10.0, true));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 8.6, 5.0, true));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, 5.0, true));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, 8.6, true));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 10.0, 0.0, true) + "index = " + 256.0 * CpxNAtan.atanIndex(0.0, 0.0, 10.0, 0.0, true));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, -10.0, 0.0, true));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, -8.6, true));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, -5.0, 5.0, true));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 8.6, -5.0, true));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 0.0, -10.0, true));
        System.out.println("break");
        System.out.println("for (0, 0) - (0, 10) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 0.0, 10.0, false) + "index = " + 256.0 * CpxNAtan.atanIndex(0.0, 0.0, 0.0, 10.0, false));
        System.out.println("for (0, 0) - (8.6, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 8.6, 5.0, false));
        System.out.println("for (0, 0) - (5, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, 5.0, false));
        System.out.println("for (0, 0) - (5, 8.6) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, 8.6, false));
        System.out.println("for (0, 0) - (10, 0) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 10.0, 0.0, false) + "index = " + 256.0 * CpxNAtan.atanIndex(0.0, 0.0, 10.0, 0.0, false));
        System.out.println("for (0, 0) - (-10, 0) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, -10.0, 0.0, false));
        System.out.println("for (0, 0) - (5, -8.6) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 5.0, -8.6, false));
        System.out.println("for (0, 0) - (-5, 5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, -5.0, 5.0, false));
        System.out.println("for (0, 0) - (8.6, -5) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 8.6, -5.0, false));
        System.out.println("for (0, 0) - (0, -10) atanIndex = " + CpxNAtan.atanIndex(0.0, 0.0, 0.0, -10.0, false));
    }
}

