/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.TrapFrame;

public class Cpx2TrapGIF
extends FTLooper {
    TrapFrame trap_ = null;
    double realHalfRange_ = 0.0;
    double imagHalfRange_ = 0.0;

    @Override
    public boolean acceptsTrapGif() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(-0.75, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 0.2);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.05);
    }

    @Override
    public String docString() {
        return "This is my original Image Trap loop.\nLoad a GIF file for the trap.\nSwt (switch) -1 (act like Manderbrot), 1 (draw trap, fill .\n    with Ret), 0 (draw trap, fill with Mandelbrot)  \nRet is the color set index returned for background (See Swt.)Rmid and Imid set the position of the trap image center.\nCclk is a degrees rotation counter-clockwise of the image.\nSize is the width of the embedded trap image.";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, Swt, Ret)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, Rmid, Imid)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, Cclk, Size)";
    }

    @Override
    public void prepare(FractalSpec fractalSpec) {
        FastQuaternion fastQuaternion = new FastQuaternion(fractalSpec.coeff);
        FastQuaternion fastQuaternion2 = new FastQuaternion(fractalSpec.trans);
        this.trap_ = FTCentral.getTrapFrame_static();
        this.trap_.setCenter(fastQuaternion.j, fastQuaternion.k);
        this.trap_.setRotation(fastQuaternion2.j);
        boolean bl = this.trap_.setRange(fastQuaternion2.k == 0.0 ? 1.0 : fastQuaternion2.k);
        if (!bl) {
            FTCentral.message("Cpx2TrapGIF.prepare: call to TrapFrame.setRange returned FALSE!  Trap is not set up right.", true);
        }
        this.imagHalfRange_ = this.realHalfRange_ = 1.1 * fastQuaternion2.k * (this.trap_.radius() / (double)this.trap_.width());
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        double d = fastQuaternion.r * fastQuaternion2.r - fastQuaternion.i * fastQuaternion2.i + fastQuaternion3.r;
        double d2 = fastQuaternion.r * fastQuaternion2.i + fastQuaternion.i * fastQuaternion2.r + fastQuaternion3.i;
        double d3 = fastQuaternion.r;
        double d4 = fastQuaternion.i;
        double d5 = d3 * d3;
        double d6 = d4 * d4;
        for (int i = 1; i < n; ++i) {
            double d7 = d5 - d6 + d;
            d4 = 2.0 * d3 * d4 + d2;
            d3 = d7;
            d5 = d3 * d3;
            d6 = d4 * d4;
            if (fastQuaternion.j >= 0.0) {
                Integer n2;
                double d8 = d3 - fastQuaternion2.j;
                double d9 = d4 - fastQuaternion2.k;
                if (Math.abs(d8) <= this.realHalfRange_ && Math.abs(d9) <= this.imagHalfRange_ && (n2 = this.trap_.hitP(d3, d4)) != null) {
                    return n2;
                }
            }
            if (!(d5 + d6 > 4.0)) continue;
            return fastQuaternion.j > 0.0 ? (int)fastQuaternion.k : i;
        }
        return (int)fastQuaternion.k;
    }
}

