/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop.FractalLoops;

import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.TrapFrame;

public class Cpx2InvTrapGIF
extends FTLooper {
    TrapFrame trap_ = null;
    double bound_ = 0.0;
    double donut_ = 0.0;

    @Override
    public boolean acceptsTrapGif() {
        return true;
    }

    @Override
    public String formulaString() {
        return "Z(n+1) = Z(n)^2 + C*Z(0) + T";
    }

    @Override
    public FastQuaternion q1Init() {
        return new FastQuaternion(-0.75, 0.0, 0.0, 0.0);
    }

    @Override
    public FastQuaternion q2Init() {
        return new FastQuaternion(1.0, 0.0, 0.0, 6.0);
    }

    @Override
    public FastQuaternion q3Init() {
        return new FastQuaternion(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public String docString() {
        return "This is my original Image Trap loop.\nLoad a GIF file for the trap.\nRet is the color map index returned if the depth is reached.Bnd:Image is reflected around circle of radius 2 out to Bnd.Cclk is a degrees rotation of the image.\n";
    }

    @Override
    public String q1String() {
        return "Z(0): (r, i, -, ret)";
    }

    @Override
    public String q2String() {
        return "   C: (r, i, -, Bnd)";
    }

    @Override
    public String q3String() {
        return "   T: (r, i, cclk, -)";
    }

    @Override
    public void prepare(FractalSpec fractalSpec) {
        FastQuaternion fastQuaternion = new FastQuaternion(fractalSpec.coeff);
        FastQuaternion fastQuaternion2 = new FastQuaternion(fractalSpec.trans);
        this.trap_ = FTCentral.getTrapFrame_static();
        this.trap_.setCenter(0.0, 0.0);
        this.trap_.setRotation(fastQuaternion2.j);
        boolean bl = this.trap_.setRange(1.0);
        if (!bl) {
            FTCentral.message("Cpx2InvTrapGIF.prepare: call to TrapFrame.setRange returned FALSE!  Trap is not set up right.", true);
        }
        this.bound_ = fastQuaternion.k;
        this.donut_ = this.bound_ - 2.0;
    }

    @Override
    public int loop(FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2, FastQuaternion fastQuaternion3, int n) {
        FastQuaternion fastQuaternion4 = new FastQuaternion(fastQuaternion);
        fastQuaternion4.j = 0.0;
        fastQuaternion4.k = 0.0;
        FastQuaternion fastQuaternion5 = fastQuaternion2.times(fastQuaternion4).plus(fastQuaternion3);
        double d = fastQuaternion.r;
        double d2 = fastQuaternion.i;
        double d3 = fastQuaternion5.r;
        double d4 = fastQuaternion5.i;
        double d5 = d * d;
        double d6 = d2 * d2;
        for (int i = 1; i < n; ++i) {
            Integer n2;
            double d7 = d5 - d6 + d3;
            d2 = 2.0 * d * d2 + d4;
            d = d7;
            d5 = d * d;
            d6 = d2 * d2;
            if (!(d * d + d2 * d2 > 4.0) || (n2 = this.trap_.hitP((this.bound_ - d) / this.donut_, (this.bound_ - d2) / this.donut_)) == null) continue;
            return n2;
        }
        return (int)fastQuaternion.k;
    }
}

