/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.math.BigDecimal;
import us.lystad.fractaltop.BigQuaternion;

public class FastQuaternion {
    public double r;
    public double i;
    public double j;
    public double k;

    public FastQuaternion(double d, double d2, double d3, double d4) {
        this.r = d;
        this.i = d2;
        this.j = d3;
        this.k = d4;
    }

    public FastQuaternion() {
        this.k = 0.0;
        this.j = 0.0;
        this.i = 0.0;
        this.r = 0.0;
    }

    public FastQuaternion(FastQuaternion fastQuaternion) {
        this.r = fastQuaternion.r;
        this.i = fastQuaternion.i;
        this.j = fastQuaternion.j;
        this.k = fastQuaternion.k;
    }

    public FastQuaternion(BigQuaternion bigQuaternion) {
        this.r = bigQuaternion.r.doubleValue();
        this.i = bigQuaternion.i.doubleValue();
        this.j = bigQuaternion.j.doubleValue();
        this.k = bigQuaternion.k.doubleValue();
    }

    public void setR(double d) {
        this.r = d;
    }

    public void setI(double d) {
        this.i = d;
    }

    public void setJ(double d) {
        this.j = d;
    }

    public void setK(double d) {
        this.k = d;
    }

    public void setR(BigDecimal bigDecimal) {
        this.r = bigDecimal.doubleValue();
    }

    public void setI(BigDecimal bigDecimal) {
        this.i = bigDecimal.doubleValue();
    }

    public void setJ(BigDecimal bigDecimal) {
        this.j = bigDecimal.doubleValue();
    }

    public void setK(BigDecimal bigDecimal) {
        this.k = bigDecimal.doubleValue();
    }

    public String rToString() {
        return String.valueOf(this.r);
    }

    public String iToString() {
        return String.valueOf(this.i);
    }

    public String jToString() {
        return String.valueOf(this.j);
    }

    public String kToString() {
        return String.valueOf(this.k);
    }

    public FastQuaternion assign_from(FastQuaternion fastQuaternion) {
        this.r = fastQuaternion.r;
        this.i = fastQuaternion.i;
        this.j = fastQuaternion.j;
        this.k = fastQuaternion.k;
        return this;
    }

    public FastQuaternion assign_from(BigQuaternion bigQuaternion) {
        this.r = bigQuaternion.r.doubleValue();
        this.i = bigQuaternion.i.doubleValue();
        this.j = bigQuaternion.j.doubleValue();
        this.k = bigQuaternion.k.doubleValue();
        return this;
    }

    public boolean equals(FastQuaternion fastQuaternion) {
        return this.r == fastQuaternion.r && this.i == fastQuaternion.i && this.j == fastQuaternion.j && this.k == fastQuaternion.k;
    }

    public FastQuaternion plus(FastQuaternion fastQuaternion) {
        return new FastQuaternion(this.r + fastQuaternion.r, this.i + fastQuaternion.i, this.j + fastQuaternion.j, this.k + fastQuaternion.k);
    }

    public FastQuaternion plus_equal(FastQuaternion fastQuaternion) {
        this.r += fastQuaternion.r;
        this.i += fastQuaternion.i;
        this.j += fastQuaternion.j;
        this.k += fastQuaternion.k;
        return this;
    }

    public FastQuaternion minus(FastQuaternion fastQuaternion) {
        return new FastQuaternion(this.r - fastQuaternion.r, this.i - fastQuaternion.i, this.j - fastQuaternion.j, this.k - fastQuaternion.k);
    }

    public FastQuaternion minus_equal(FastQuaternion fastQuaternion) {
        this.r -= fastQuaternion.r;
        this.i -= fastQuaternion.i;
        this.j -= fastQuaternion.j;
        this.k -= fastQuaternion.k;
        return this;
    }

    public FastQuaternion times(FastQuaternion fastQuaternion) {
        return new FastQuaternion(this.r * fastQuaternion.r - this.i * fastQuaternion.i - this.j * fastQuaternion.j - this.k * fastQuaternion.k, this.r * fastQuaternion.i + this.i * fastQuaternion.r + this.j * fastQuaternion.k - this.k * fastQuaternion.j, this.r * fastQuaternion.j - this.i * fastQuaternion.k + this.j * fastQuaternion.r + this.k * fastQuaternion.i, this.r * fastQuaternion.k + this.i * fastQuaternion.j - this.j * fastQuaternion.i + this.k * fastQuaternion.r);
    }

    public FastQuaternion times_scalar_n(double d) {
        this.r *= d;
        this.i *= d;
        this.j *= d;
        this.k *= d;
        return this;
    }

    public FastQuaternion times_scalar_n(int n) {
        this.r *= (double)n;
        this.i *= (double)n;
        this.j *= (double)n;
        this.k *= (double)n;
        return this;
    }

    public FastQuaternion times_scalar(double d) {
        return new FastQuaternion(this.r * d, this.i * d, this.j * d, this.k * d);
    }

    public FastQuaternion times_scalar(int n) {
        return new FastQuaternion(this.r * (double)n, this.i * (double)n, this.j * (double)n, this.k * (double)n);
    }

    public FastQuaternion times_equal(FastQuaternion fastQuaternion) {
        double d = this.r * fastQuaternion.r - this.i * fastQuaternion.i - this.j * fastQuaternion.j - this.k * fastQuaternion.k;
        double d2 = this.r * fastQuaternion.i + this.i * fastQuaternion.r + this.j * fastQuaternion.k - this.k * fastQuaternion.j;
        double d3 = this.r * fastQuaternion.j - this.i * fastQuaternion.k + this.j * fastQuaternion.r + this.k * fastQuaternion.i;
        double d4 = this.r * fastQuaternion.k + this.i * fastQuaternion.j - this.j * fastQuaternion.i + this.k * fastQuaternion.r;
        this.r = d;
        this.i = d2;
        this.j = d3;
        this.k = d4;
        return this;
    }

    public BigQuaternion bigQuaternionValue() {
        return new BigQuaternion(this.r, this.i, this.j, this.k);
    }

    public double dot(FastQuaternion fastQuaternion) {
        return this.r * fastQuaternion.r + this.i * fastQuaternion.i + this.j * fastQuaternion.j + this.k * fastQuaternion.k;
    }

    public FastQuaternion projection_onto(FastQuaternion fastQuaternion) {
        return fastQuaternion.times_scalar(this.dot(fastQuaternion));
    }

    public FastQuaternion orthogonal_component_to(FastQuaternion fastQuaternion) {
        FastQuaternion fastQuaternion2 = this.minus(this.projection_onto(fastQuaternion));
        double d = fastQuaternion2.magnitude();
        if (d < 1.0E-20) {
            return new FastQuaternion();
        }
        fastQuaternion2.normalize_n();
        FastQuaternion fastQuaternion3 = fastQuaternion2.minus(fastQuaternion2.projection_onto(fastQuaternion));
        if (fastQuaternion3.magnitude() < 0.9) {
            return new FastQuaternion();
        }
        fastQuaternion3.r = FastQuaternion.fixAlmostIntegers(fastQuaternion3.r);
        fastQuaternion3.i = FastQuaternion.fixAlmostIntegers(fastQuaternion3.i);
        fastQuaternion3.j = FastQuaternion.fixAlmostIntegers(fastQuaternion3.j);
        fastQuaternion3.k = FastQuaternion.fixAlmostIntegers(fastQuaternion3.k);
        d = fastQuaternion3.magnitude();
        fastQuaternion3 = fastQuaternion3.normalize_n().times_scalar(d);
        fastQuaternion3.r = FastQuaternion.fixAlmostIntegers(fastQuaternion3.r);
        fastQuaternion3.i = FastQuaternion.fixAlmostIntegers(fastQuaternion3.i);
        fastQuaternion3.j = FastQuaternion.fixAlmostIntegers(fastQuaternion3.j);
        fastQuaternion3.k = FastQuaternion.fixAlmostIntegers(fastQuaternion3.k);
        return fastQuaternion3;
    }

    private static double fixAlmostIntegers(double d) {
        double d2 = Math.rint(d);
        double d3 = Math.abs(d - d2);
        if (d3 < 1.0E-15) {
            return d2;
        }
        return d;
    }

    public double magnitude() {
        return Math.sqrt(this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k);
    }

    public double magnitude_sq() {
        return this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k;
    }

    public FastQuaternion normalize_n() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.r /= d;
            this.i /= d;
            this.j /= d;
            this.k /= d;
            if (-1.0E-13 < this.r && this.r < 1.0E-13) {
                this.r = 0.0;
            }
            if (-1.0E-13 < this.i && this.i < 1.0E-13) {
                this.i = 0.0;
            }
            if (-1.0E-13 < this.j && this.j < 1.0E-13) {
                this.j = 0.0;
            }
            if (-1.0E-13 < this.k && this.k < 1.0E-13) {
                this.k = 0.0;
            }
            d = this.magnitude();
            if (this.r != 0.0) {
                this.r /= d;
            }
            if (this.i != 0.0) {
                this.i /= d;
            }
            if (this.j != 0.0) {
                this.j /= d;
            }
            if (this.k != 0.0) {
                this.k /= d;
            }
        }
        return this;
    }

    public boolean normalizePerpendicularTo(FastQuaternion fastQuaternion) {
        if (fastQuaternion.magnitude() == 0.0) {
            return false;
        }
        if (this.magnitude() == 0.0) {
            return false;
        }
        FastQuaternion fastQuaternion2 = new FastQuaternion(this);
        FastQuaternion fastQuaternion3 = new FastQuaternion(fastQuaternion);
        fastQuaternion3.normalize_n();
        fastQuaternion2.normalize_n();
        fastQuaternion2 = fastQuaternion2.orthogonal_component_to(fastQuaternion3);
        if (fastQuaternion2.magnitude() < 1.0E-15) {
            return false;
        }
        fastQuaternion2.normalize_n();
        this.assign_from(fastQuaternion2);
        fastQuaternion.assign_from(fastQuaternion3);
        return true;
    }

    public static FastQuaternion rotate(double d, FastQuaternion fastQuaternion, FastQuaternion fastQuaternion2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = d * Math.PI / 180.0;
        if (d == 90.0) {
            d6 = 0.0;
            d5 = 1.0;
        } else if (d == 0.0) {
            d6 = 1.0;
            d5 = 0.0;
        } else {
            d6 = Math.cos(d7);
            d5 = Math.sin(d7);
        }
        double d8 = fastQuaternion.r * d6 + fastQuaternion2.r * d5;
        if (d8 == -0.0) {
            d8 = 0.0;
        }
        if ((d4 = fastQuaternion.i * d6 + fastQuaternion2.i * d5) == -0.0) {
            d4 = 0.0;
        }
        if ((d3 = fastQuaternion.j * d6 + fastQuaternion2.j * d5) == -0.0) {
            d3 = 0.0;
        }
        if ((d2 = fastQuaternion.k * d6 + fastQuaternion2.k * d5) == -0.0) {
            d2 = 0.0;
        }
        d8 = FastQuaternion.fixAlmostIntegers(d8);
        d4 = FastQuaternion.fixAlmostIntegers(d4);
        d3 = FastQuaternion.fixAlmostIntegers(d3);
        d2 = FastQuaternion.fixAlmostIntegers(d2);
        return new FastQuaternion(d8, d4, d3, d2);
    }

    public void print(String string) {
        System.out.println(string + " r=" + this.r + " i=" + this.i + " j=" + this.j + " k=" + this.k);
    }

    public String toString() {
        return " r=" + this.r + " i=" + this.i + " j=" + this.j + " k=" + this.k;
    }
}

