/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.BoxInOtherWindowDialog;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseCkBoxMenuItemListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.FTArgReader;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTFileChooser;
import us.lystad.fractaltop.FTIO;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.GIFDecoderPkg.GIFDecoder;
import us.lystad.fractaltop.GIFEncoderPkg.GIFEncoder;
import us.lystad.fractaltop.IntDialog;
import us.lystad.fractaltop.LiveOrbitDialog;
import us.lystad.fractaltop.PanelJoiner;
import us.lystad.fractaltop.Properties;
import us.lystad.fractaltop.RatioDialog;
import us.lystad.fractaltop.SeqDialog;
import us.lystad.fractaltop.SeqSpec;
import us.lystad.fractaltop.TextDialog;

public class FTWindow
extends JFrame {
    static final String titleString_ = "Fractal-Top Drawing Window ";
    static String lastComment_ = "";
    static double RotateArbLNR_previousValue_ = 0.0;
    static int minWidth = 500;
    static int minHeight = 125;
    private FTCentral fTCentral_;
    private FTWindow self_;
    private FTCanvas canvas_;
    private FractalSpec savedSequencePauseSpec_;
    private int myFrameNumber_;
    private ArrayList<JCheckBoxMenuItem> loopCheckBoxes_ = new ArrayList(35);
    private Dimension hVRatio_ = null;
    private boolean seqInProgressP_ = false;
    private boolean seqPausedP_ = false;
    private boolean seqPaused4ScreenCaptureP_ = false;
    private boolean initializingWindow_ = false;
    private SeqDialog seqDialog_ = null;
    private LiveOrbitDialog liveOrbitDialog_ = null;
    private BoxInOtherWindowDialog boxInOtherWindowDialog_ = null;
    private SeqSpec seqSpec_ = null;
    private int seqSpecNextFrame_ = -1;
    private Dimension lastCanvasPadding_ = new Dimension(19, 65);
    FTFileChooser fileChooser_;
    private Rectangle displayDimensions_;
    private JMenu windowsMenu_;
    private JMenu scanOnMenu_;
    private JMenuItem startDrawMI_;
    private JMenuItem liveOrbitFileMI_;
    private JMenuItem trapMI_;
    private JCheckBoxMenuItem fastMI_;
    private JMenu interpolateColorsMenu_;
    private JCheckBoxMenuItem interpolOFF_;
    private JCheckBoxMenuItem interpolHSB_;
    private JCheckBoxMenuItem interpolRGB_;
    private JCheckBoxMenuItem Q1MI_;
    private JCheckBoxMenuItem Q2MI_;
    private JCheckBoxMenuItem Q3MI_;
    private JMenuItem boxColorInEditorMI_;
    private JMenuItem useCompiledCodeMI_;
    private JMenuItem openFileMI_;
    private JMenuItem openParmMI_;
    private JMenuItem clipBdMI_;
    ButtonGroup interpolateButtonGroup_;
    ButtonGroup QButtonGroup_;
    private JMenuItem LoopLabelMI_;
    private JMenuItem startSeqMI_;
    private JMenuItem saveAsFileMI_;
    private JMenuItem saveParamsFileMI_;
    private JMenuItem saveCountsCSVMI_;
    private JMenuItem seqSetupMI_;
    private JCheckBoxMenuItem loggingMI_;
    private JCheckBoxMenuItem write2URLMI_;
    private JCheckBoxMenuItem userCommentMI_;

    public FTWindow(FTCentral fTCentral, int n, int n2) {
        super(titleString_ + fTCentral.frameCount());
        try {
            FTWindow fTWindow;
            this.initializingWindow_ = true;
            this.myFrameNumber_ = fTCentral.incFrameCount();
            this.fTCentral_ = fTCentral;
            this.hVRatio_ = this.fTCentral_.getHVRatio();
            this.canvas_ = new FTCanvas(this.fTCentral_, this, this.myFrameNumber_);
            this.seqSpec_ = new SeqSpec();
            this.fileChooser_ = new FTFileChooser(this);
            this.self_ = this;
            this.setLayout(new BorderLayout(0, 0));
            this.add("Center", new JScrollPane(this.canvas_, 20, 30));
            this.addWindowListener(new MyWindowLNR());
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            String string = "File";
            JMenu jMenu = new JMenu(string, true);
            jMenu.addMenuListener(new FileMenuLNR());
            JMenuItem jMenuItem = new JMenuItem("New Window");
            jMenuItem.addActionListener(new newFrameLNR("File->New Window"));
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            this.openFileMI_ = new JMenuItem("Open FT Image...");
            this.openFileMI_.addActionListener(new openFileLNR("File->Open FT Image..."));
            jMenu.add(this.openFileMI_);
            this.openParmMI_ = new JMenuItem("Open FT Parms...");
            this.openParmMI_.addActionListener(new openParmLNR("File->Open FT Parms..."));
            jMenu.add(this.openParmMI_);
            JMenuItem jMenuItem2 = new JMenuItem("Open Log Entry...");
            jMenuItem2.addActionListener(new openLogLNR("File->Open Log Entry..."));
            jMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Open Trap GIF...");
            jMenuItem3.addActionListener(new trapFileLNR("File->Open Trap GIF..."));
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
            this.saveAsFileMI_ = new JMenuItem("Save Image...");
            this.saveAsFileMI_.addActionListener(new saveAsFileLNR("File->Save Image..."));
            this.saveAsFileMI_.setEnabled(true);
            jMenu.add(this.saveAsFileMI_);
            this.saveParamsFileMI_ = new JMenuItem("Save Params...");
            this.saveParamsFileMI_.addActionListener(new saveArgsFLNR("File->Save Params..."));
            this.saveParamsFileMI_.setEnabled(true);
            jMenu.add(this.saveParamsFileMI_);
            this.saveCountsCSVMI_ = new JMenuItem("Save Pixel Counts...");
            this.saveCountsCSVMI_.addActionListener(new saveCountsCSVLNR("File->Save Pixel Counts..."));
            this.saveCountsCSVMI_.setEnabled(true);
            jMenu.add(this.saveCountsCSVMI_);
            JMenuItem jMenuItem4 = new JMenuItem("Join Panels...");
            jMenuItem4.addActionListener(new JoinPanelsLNR("File->Join Panels..."));
            jMenuItem4.setEnabled(true);
            jMenu.add(jMenuItem4);
            jMenu.addSeparator();
            this.write2URLMI_ = new JCheckBoxMenuItem("Use URL I/O?");
            this.write2URLMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.write2URLMI_, "File->Use URL I/O?"));
            this.write2URLMI_.addActionListener(new write2URLLNR());
            this.write2URLMI_.setState(this.fTCentral_.write2URLP());
            jMenu.add(this.write2URLMI_);
            this.loggingMI_ = new JCheckBoxMenuItem("Logging?");
            this.loggingMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.loggingMI_, "Logging?"));
            this.loggingMI_.addActionListener(new loggingLNR());
            this.loggingMI_.setState(this.fTCentral_.loggingP());
            jMenu.add(this.loggingMI_);
            this.userCommentMI_ = new JCheckBoxMenuItem("Comment on Save?");
            this.userCommentMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.userCommentMI_, "File->Comment on Save?"));
            this.userCommentMI_.addActionListener(new usrComLNR());
            this.userCommentMI_.setState(this.fTCentral_.userWantsToAddCOmmentP());
            jMenu.add(this.userCommentMI_);
            jMenu.addSeparator();
            JMenuItem jMenuItem5 = new JMenuItem("Close");
            jMenuItem5.addActionListener(new closeLNR("File->Close"));
            jMenu.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Quit");
            jMenuItem6.addActionListener(new quitLNR("File->Quit"));
            jMenuItem6.setEnabled(true);
            jMenu.add(jMenuItem6);
            JMenu jMenu2 = new JMenu("Draw", true);
            this.startDrawMI_ = new JMenuItem("Start");
            this.startDrawMI_.addActionListener(new startDrawLNR("Draw->Start"));
            jMenu2.add(this.startDrawMI_);
            JMenuItem jMenuItem7 = new JMenuItem("Pause");
            jMenuItem7.addActionListener(new pauseDrawLNR("Draw->Pause"));
            jMenu2.add(jMenuItem7);
            jMenu2.addSeparator();
            this.liveOrbitFileMI_ = new JMenuItem("Orbit Trace");
            this.liveOrbitFileMI_.addActionListener(new LiveOrbitFLNR("Draw->Orbit Trace"));
            this.liveOrbitFileMI_.setEnabled(false);
            jMenu2.add(this.liveOrbitFileMI_);
            JMenuItem jMenuItem8 = new JMenuItem("Refresh");
            jMenuItem8.addActionListener(new RefreshLNR("Draw->Refresh"));
            jMenu2.add(jMenuItem8);
            jMenu2.addSeparator();
            JMenuItem jMenuItem9 = new JMenuItem("Outline this in Other Window");
            jMenuItem9.addActionListener(new BoxInOtherWindowLNR("Draw->Outline this in Other Window"));
            jMenu2.add(jMenuItem9);
            this.boxColorInEditorMI_ = new JMenuItem("Box color in Editor");
            this.boxColorInEditorMI_.addActionListener(new BoxColorInEditorLNR("Settings->Box color in Editor"));
            jMenu2.add(this.boxColorInEditorMI_);
            this.clipBdMI_ = new JMenuItem("Copy");
            this.clipBdMI_.addActionListener(new ClipboardCopyLNR("Draw->Copy"));
            jMenu2.add(this.clipBdMI_);
            JMenu jMenu3 = new JMenu("Settings", true);
            this.fastMI_ = new JCheckBoxMenuItem("Draw Fast Approximation?");
            this.fastMI_.setState(true);
            this.fastMI_.addActionListener(new DrawFastLNR());
            this.fastMI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.fastMI_, "Settings->Draw Fast Approximation?"));
            jMenu3.add(this.fastMI_);
            JMenuItem jMenuItem10 = new JMenuItem("W/H Ratio...");
            jMenuItem10.addActionListener(new HVRatioLNR("Settings->W/H Ratio..."));
            jMenu3.add(jMenuItem10);
            this.interpolateColorsMenu_ = new JMenu("Interpolation OFF", false);
            jMenu3.add(this.interpolateColorsMenu_);
            this.interpolateButtonGroup_ = new ButtonGroup();
            this.interpolOFF_ = new JCheckBoxMenuItem("OFF");
            this.interpolOFF_.addActionListener(new interpolLNR("OFF"));
            this.interpolOFF_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolOFF_, "Settings->interpolOFF"));
            this.interpolateColorsMenu_.add(this.interpolOFF_);
            this.interpolHSB_ = new JCheckBoxMenuItem("HSB");
            this.interpolHSB_.addActionListener(new interpolLNR("HSB"));
            this.interpolHSB_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolHSB_, "Settings->interpolHSB"));
            this.interpolateColorsMenu_.add(this.interpolHSB_);
            this.interpolRGB_ = new JCheckBoxMenuItem("RGB");
            this.interpolRGB_.addActionListener(new interpolLNR("RGB"));
            this.interpolRGB_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.interpolateButtonGroup_, this.interpolRGB_, "Settings->interpolRGB"));
            this.interpolateColorsMenu_.add(this.interpolRGB_);
            this.interpolateButtonGroup_.add(this.interpolOFF_);
            this.interpolateButtonGroup_.add(this.interpolHSB_);
            this.interpolateButtonGroup_.add(this.interpolRGB_);
            this.interpolateButtonGroup_.setSelected(this.interpolOFF_.getModel(), true);
            jMenu3.addSeparator();
            this.scanOnMenu_ = new JMenu("Scan On: Q1", true);
            jMenu3.add(this.scanOnMenu_);
            this.QButtonGroup_ = new ButtonGroup();
            this.Q1MI_ = new JCheckBoxMenuItem("Q1");
            this.Q1MI_.addActionListener(new Q_LNR("Q1"));
            this.Q1MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q1MI_, "Settings->Q1"));
            this.scanOnMenu_.add(this.Q1MI_);
            this.Q2MI_ = new JCheckBoxMenuItem("Q2");
            this.Q2MI_.addActionListener(new Q_LNR("Q2"));
            this.Q2MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q2MI_, "Settings->Q2"));
            this.scanOnMenu_.add(this.Q2MI_);
            this.Q3MI_ = new JCheckBoxMenuItem("Q3");
            this.Q3MI_.addActionListener(new Q_LNR("Q3"));
            this.Q3MI_.addMouseListener(new DocuMouseCkBoxMenuItemListener(this.QButtonGroup_, this.Q3MI_, "Settings->Q3"));
            this.scanOnMenu_.add(this.Q3MI_);
            this.QButtonGroup_.add(this.Q1MI_);
            this.QButtonGroup_.add(this.Q2MI_);
            this.QButtonGroup_.add(this.Q3MI_);
            this.QButtonGroup_.setSelected(this.Q1MI_.getModel(), true);
            jMenu3.addSeparator();
            JMenuItem jMenuItem11 = new JMenuItem("Show Arguments");
            jMenuItem11.addActionListener(new displayParmsLNR("Settings->Show Arguments"));
            jMenu3.add(jMenuItem11);
            this.useCompiledCodeMI_ = new JMenuItem("Initial value.");
            this.useCompiledCodeMI_.addActionListener(new UseCompiledCodeLNR("Settings->Compiled code toggle"));
            jMenu3.add(this.useCompiledCodeMI_);
            JMenu jMenu4 = new JMenu("Adjust", true);
            JMenuItem jMenuItem12 = new JMenuItem("Zoom...");
            jMenuItem12.addActionListener(new EnlargeLNR("Adjust->Zoom..."));
            jMenu4.add(jMenuItem12);
            JMenuItem jMenuItem13 = new JMenuItem("Zoom again");
            jMenuItem13.addActionListener(new EnlrgAgnLNR("Adjust->Zoom again"));
            jMenu4.add(jMenuItem13);
            jMenu4.addSeparator();
            JMenuItem jMenuItem14 = new JMenuItem("Shift fractal LEFT (pixels)...");
            jMenuItem14.addActionListener(new RightLNR("Adjust->Shift fractal LEFT (pixels)..."));
            jMenu4.add(jMenuItem14);
            JMenuItem jMenuItem15 = new JMenuItem("Repeat LEFT shift");
            jMenuItem15.addActionListener(new RightAgnLNR("Adjust->Repeat LEFT shift"));
            jMenu4.add(jMenuItem15);
            JMenuItem jMenuItem16 = new JMenuItem("Shift fractal UP (pixels)...");
            jMenuItem16.addActionListener(new DownLNR("Adjust->Shift fractal UP (pixels)..."));
            jMenu4.add(jMenuItem16);
            JMenuItem jMenuItem17 = new JMenuItem("Repeat UP shift");
            jMenuItem17.addActionListener(new DownAgnLNR("Adjust->Repeat UP shift"));
            jMenu4.add(jMenuItem17);
            jMenu4.addSeparator();
            JMenuItem jMenuItem18 = new JMenuItem("W axis shift...");
            jMenuItem18.addActionListener(new OnWLNR("Adjust->W axis shift..."));
            jMenu4.add(jMenuItem18);
            JMenuItem jMenuItem19 = new JMenuItem("Repeat W axis shift");
            jMenuItem19.addActionListener(new OnWAgnLNR("Adjust->Repeat W axis shift"));
            jMenu4.add(jMenuItem19);
            JMenu jMenu5 = new JMenu("Axes", true);
            JMenuItem jMenuItem20 = new JMenuItem("H <=> V");
            jMenuItem20.addActionListener(new swapHVLNR("Axis->H <=> V"));
            jMenu5.add(jMenuItem20);
            JMenuItem jMenuItem21 = new JMenuItem("Rot. 90 left");
            jMenuItem21.addActionListener(new Rotate90LLNR("Axis->Rot. 90 left"));
            jMenu5.add(jMenuItem21);
            JMenuItem jMenuItem22 = new JMenuItem("Rot. 90 right");
            jMenuItem22.addActionListener(new Rotate90RLNR("Axis->Rot. 90 right"));
            jMenu5.add(jMenuItem22);
            JMenuItem jMenuItem23 = new JMenuItem("Rotate ...");
            jMenuItem23.addActionListener(new RotateArbLNR("Axis->Rotate ..."));
            jMenu5.add(jMenuItem23);
            jMenu5.addSeparator();
            JMenuItem jMenuItem24 = new JMenuItem("W => H");
            jMenuItem24.addActionListener(new W2HLNR("Axis->W => H"));
            jMenu5.add(jMenuItem24);
            JMenuItem jMenuItem25 = new JMenuItem("W => V");
            jMenuItem25.addActionListener(new W2VLNR("Axis->W => V"));
            jMenu5.add(jMenuItem25);
            jMenu5.addSeparator();
            JMenuItem jMenuItem26 = new JMenuItem("H => Mem H");
            jMenuItem26.addActionListener(new H2MemHLNR("Axis->H => Mem H"));
            jMenu5.add(jMenuItem26);
            JMenuItem jMenuItem27 = new JMenuItem("V => Mem V");
            jMenuItem27.addActionListener(new V2MemVLNR("Axis->V => Mem V"));
            jMenu5.add(jMenuItem27);
            JMenuItem jMenuItem28 = new JMenuItem("Mem H => H");
            jMenuItem28.addActionListener(new MemH2HLNR("Axis->Mem H => H"));
            jMenu5.add(jMenuItem28);
            JMenuItem jMenuItem29 = new JMenuItem("Mem V => V");
            jMenuItem29.addActionListener(new MemV2VLNR("Axis->Mem V => V"));
            jMenu5.add(jMenuItem29);
            jMenu5.addSeparator();
            JMenuItem jMenuItem30 = new JMenuItem("Mouse V-axis");
            jMenuItem30.addActionListener(new mouseV2LNR("Axis->Mouse V-axis"));
            jMenu5.add(jMenuItem30);
            JMenuItem jMenuItem31 = new JMenuItem("Mouse H-axis");
            jMenuItem31.addActionListener(new mouseH2LNR("Axis->Mouse H-axis"));
            jMenu5.add(jMenuItem31);
            this.windowsMenu_ = new JMenu("Windows", true);
            JMenuItem jMenuItem32 = new JMenuItem("Parameters Window");
            jMenuItem32.addActionListener(new parmsLNR("Windows->Parameters Window"));
            this.windowsMenu_.add(jMenuItem32);
            JMenuItem jMenuItem33 = new JMenuItem("Color Set Editor");
            jMenuItem33.addActionListener(new colorsLNR("Windows->Color Set Editor"));
            this.windowsMenu_.add(jMenuItem33);
            JMenuItem jMenuItem34 = new JMenuItem("Messages Window");
            jMenuItem34.addActionListener(new msgLNR("Windows->Messages Window"));
            this.windowsMenu_.add(jMenuItem34);
            this.trapMI_ = new JMenuItem("Trap GIF Window");
            this.trapMI_.addActionListener(new TrapLNR("Windows->Trap GIF Window"));
            this.windowsMenu_.add(this.trapMI_);
            this.windowsMenu_.addSeparator();
            JMenu jMenu6 = new JMenu("Sequence", true);
            this.startSeqMI_ = new JMenuItem("Start");
            this.startSeqMI_.addActionListener(new startSeqLNR("Sequence->Start"));
            jMenu6.add(this.startSeqMI_);
            jMenu6.addSeparator();
            this.seqSetupMI_ = new JMenuItem("Sequence Setup...");
            this.seqSetupMI_.addActionListener(new seqLNR("Sequence->Sequence Setup..."));
            jMenu6.add(this.seqSetupMI_);
            jMenu6.addSeparator();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Reverse order panels.");
            jCheckBoxMenuItem.addMouseListener(new DocuMouseCkBoxMenuItemListener(jCheckBoxMenuItem, "Sequence->Reverse order panels."));
            jCheckBoxMenuItem.addItemListener(new RevPanelsLNR());
            jCheckBoxMenuItem.setState(false);
            jMenu6.add(jCheckBoxMenuItem);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Row by row.");
            jCheckBoxMenuItem2.addMouseListener(new DocuMouseCkBoxMenuItemListener(jCheckBoxMenuItem2, "Sequence->Row by row."));
            jCheckBoxMenuItem2.addItemListener(new RowByRowLNR());
            jCheckBoxMenuItem2.setState(true);
            jMenu6.add(jCheckBoxMenuItem2);
            JMenu jMenu7 = new JMenu("Loop", true);
            this.LoopLabelMI_ = new JMenuItem("Name set later");
            jMenu7.add(this.LoopLabelMI_);
            JMenuItem jMenuItem35 = new JMenuItem("Default Arguments");
            jMenuItem35.addActionListener(new defaultLNR("Loop->Default Arguments"));
            jMenu7.add(jMenuItem35);
            jMenuItem35 = new JMenuItem("Loop documentation");
            jMenuItem35.addActionListener(new docLNR("Loop->Loop documentation"));
            jMenu7.add(jMenuItem35);
            jMenu7.addSeparator();
            JMenu jMenu8 = new JMenu("Complex Powers (CPX)", true);
            jMenu7.add(jMenu8);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = this.newLoopCheckbox("Mandelbrot");
            jMenu8.add(jCheckBoxMenuItem3);
            jMenu8.add(this.newLoopCheckbox("MandelCube"));
            jMenu8.add(this.newLoopCheckbox("CpxPower4"));
            jMenu8.add(this.newLoopCheckbox("Cpx8"));
            jMenu8.add(this.newLoopCheckbox("CpxN"));
            jMenu8.add(this.newLoopCheckbox("Cpx2TrapGIF"));
            jMenu8.add(this.newLoopCheckbox("Cpx3TrapGIF"));
            jMenu8.add(this.newLoopCheckbox("CpxNTrapGIF"));
            jMenu8.add(this.newLoopCheckbox("Cpx2InvTrapGIF"));
            jMenu8 = new JMenu("Phoenix", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("PhoenixDepth"));
            jMenu8.add(this.newLoopCheckbox("Phoenix"));
            jMenu8.add(this.newLoopCheckbox("PhoenixTrapGIF"));
            jMenu8 = new JMenu("Quaternion (QAT)", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("QuatPower2"));
            jMenu8.add(this.newLoopCheckbox("QuatPower4"));
            jMenu8.add(this.newLoopCheckbox("QuatPower5"));
            jMenu8 = new JMenu("HyperComplex (HCX)", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("HcxPower2"));
            jMenu8 = new JMenu("Tetran (TET)", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("TetraPower2"));
            jMenu8.add(this.newLoopCheckbox("TetraPower3"));
            jMenu8.add(this.newLoopCheckbox("TetraPower4"));
            jMenu8 = new JMenu("Miscelaneous (MSC 3D)", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("Loop32"));
            jMenu8.add(this.newLoopCheckbox("Loop321"));
            jMenu8.add(this.newLoopCheckbox("Loop322"));
            jMenu8.add(this.newLoopCheckbox("Loop323"));
            jMenu8.add(this.newLoopCheckbox("Loop324"));
            jMenu8.add(this.newLoopCheckbox("Loop322k"));
            jMenu8 = new JMenu("Miscelaneous (MSC 4D)", true);
            jMenu7.add(jMenu8);
            jMenu8.add(this.newLoopCheckbox("LoopTetraR"));
            jMenu8.add(this.newLoopCheckbox("LoopTetraP"));
            jMenu8.add(this.newLoopCheckbox("LoopTetraN"));
            jMenu8.add(this.newLoopCheckbox("LoopTetraRN"));
            jMenu8.add(this.newLoopCheckbox("LoopTetraRP"));
            jMenu8.add(this.newLoopCheckbox("LoopTetraNP"));
            jMenu8.add(this.newLoopCheckbox("Loop429"));
            jMenu8.add(this.newLoopCheckbox("Loop42A"));
            jMenu8.add(this.newLoopCheckbox("Loop42B"));
            jMenu8.add(this.newLoopCheckbox("Loop42C"));
            jMenu8.add(this.newLoopCheckbox("Loop448"));
            JMenu jMenu9 = new JMenu("Help", true);
            JMenuItem jMenuItem36 = new JMenuItem("Quick Start");
            jMenuItem36.addActionListener(new HelpActionLNR("Help->Quick Start"));
            jMenu9.add(jMenuItem36);
            JMenuItem jMenuItem37 = new JMenuItem("Context Help");
            jMenuItem37.addActionListener(new HelpActionLNR("Help->Context Help"));
            jMenu9.add(jMenuItem37);
            JMenuItem jMenuItem38 = new JMenuItem("Mouse Help");
            jMenuItem38.addActionListener(new HelpActionLNR("Help->Mouse Help"));
            jMenu9.add(jMenuItem38);
            JMenuItem jMenuItem39 = new JMenuItem("Fractals (1) Complex Plane");
            jMenuItem39.addActionListener(new HelpActionLNR("Help->About Fractals Part 1"));
            jMenu9.add(jMenuItem39);
            JMenuItem jMenuItem40 = new JMenuItem("Fractals (2) Complex Arithmetic");
            jMenuItem40.addActionListener(new HelpActionLNR("Help->About Fractals Part 2"));
            jMenu9.add(jMenuItem40);
            JMenuItem jMenuItem41 = new JMenuItem("Fractals (3) Mandelbrot Defined");
            jMenuItem41.addActionListener(new HelpActionLNR("Help->About Fractals Part 3"));
            jMenu9.add(jMenuItem41);
            JMenuItem jMenuItem42 = new JMenuItem("About Fractal Top");
            jMenuItem42.addActionListener(new HelpActionLNR("Help->About Fractal Top"));
            jMenu9.add(jMenuItem42);
            int n3 = 128;
            int n4 = System.getProperty("os.name").startsWith("Mac") ? 256 : 512;
            this.seqSetupMI_.setAccelerator(KeyStroke.getKeyStroke(65, n3));
            this.startSeqMI_.setAccelerator(KeyStroke.getKeyStroke(66, n3));
            this.boxColorInEditorMI_.setAccelerator(KeyStroke.getKeyStroke(66, n4));
            this.clipBdMI_.setAccelerator(KeyStroke.getKeyStroke(67, n3));
            this.startDrawMI_.setAccelerator(KeyStroke.getKeyStroke(68, n3));
            jMenuItem33.setAccelerator(KeyStroke.getKeyStroke(69, n3));
            jMenuItem37.setAccelerator(KeyStroke.getKeyStroke(72, n3));
            jMenuItem34.setAccelerator(KeyStroke.getKeyStroke(77, n3));
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n3));
            this.openFileMI_.setAccelerator(KeyStroke.getKeyStroke(79, n3));
            jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(80, n3));
            jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(81, n3));
            jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(82, n3));
            this.saveAsFileMI_.setAccelerator(KeyStroke.getKeyStroke(83, n3));
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(84, n3));
            jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(87, n3));
            jMenuItem32.setAccelerator(KeyStroke.getKeyStroke(61, n3));
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            jMenuBar.add(this.windowsMenu_);
            jMenuBar.add(jMenu6);
            jMenuBar.add(jMenu7);
            jMenuBar.add(jMenu9);
            this.setEnableSaveMenus(false);
            this.setEnableSeqStartMenu(false);
            this.displayDimensions_ = FTWindow.getGraphicsDeviceSizeForFrame(this.self_);
            int n5 = this.myFrameNumber_ - 1;
            if (this.myFrameNumber_ > 1 && (fTWindow = this.fTCentral_.getFrame(n5)) != null) {
                this.fTCentral_.setLocationRelativeTo(fTWindow, this, false);
            } else {
                float f = 10.0f;
                int n6 = this.displayDimensions_.height - n2;
                int n7 = (int)Math.floor(f * (float)n5 % (float)n6);
                int n8 = (int)Math.floor(f * (float)n5 / (float)n6);
                int n9 = this.displayDimensions_.width - n;
                int n10 = (int)Math.floor((f * (float)n8 * 3.0f + (float)n7) % (float)n9);
                this.self_.setLocation(n10 + this.displayDimensions_.x, n7 + this.displayDimensions_.y);
            }
            if (this.myFrameNumber_ == 1) {
                this.setLooper(this.fTCentral_.getParmFrameLooperName());
            } else {
                this.fTCentral_.parmsToSpec(this.canvas_.spec());
            }
            this.setBackground(Color.lightGray);
            Dimension dimension = this.resizeForDraw(n, n2);
            this.setSize((int)Math.max(dimension.getWidth(), (double)minWidth), (int)Math.max(dimension.getHeight(), (double)minHeight));
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Crash in FTWindow.<constructor>" + FTCentral.getExceptionSynopsis(throwable));
        }
    }

    public FTCentral getFTCentral() {
        return this.fTCentral_;
    }

    public static Rectangle getGraphicsDeviceSizeForFrame(JFrame jFrame) {
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration2.getBounds();
    }

    public void setLiveOrbitEnabled(boolean bl) {
        this.liveOrbitFileMI_.setEnabled(bl);
    }

    private JCheckBoxMenuItem newLoopCheckbox(String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addItemListener(new loopLNR(string));
        jCheckBoxMenuItem.addMouseListener(new DocuMouseListener("loop_" + string));
        this.loopCheckBoxes_.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    public int frameNumber() {
        return this.myFrameNumber_;
    }

    public FTCanvas canvas() {
        return this.canvas_;
    }

    public FractalSpec getSpec() {
        return this.canvas_.spec();
    }

    public void setwrite2URL(boolean bl) {
        this.write2URLMI_.setState(bl);
    }

    public Dimension resizeForDraw(int n, int n2) {
        Cloneable cloneable;
        int n3 = 2;
        this.canvas_.setPreferredSize(new Dimension(n, n2));
        this.canvas_.revalidate();
        if (this.self_.isVisible()) {
            Point point = this.self_.getLocationOnScreen();
            Point point2 = this.canvas_.getLocationOnScreen();
            cloneable = this.self_.getInsets();
            this.lastCanvasPadding_ = new Dimension(cloneable.right + n3 + (int)(point2.getX() - point.getX()), cloneable.bottom + n3 + (int)(point2.getY() - point.getY()));
        }
        int n4 = n + (int)this.lastCanvasPadding_.getWidth();
        int n5 = n2 + (int)this.lastCanvasPadding_.getHeight();
        this.displayDimensions_ = FTWindow.getGraphicsDeviceSizeForFrame(this.self_);
        n4 = (int)Math.round(Math.min(this.displayDimensions_.getWidth() - 50.0, (double)Math.max(minWidth, n4)));
        n5 = (int)Math.round(Math.min(this.displayDimensions_.getHeight() - 50.0, (double)Math.max(minHeight, n5)));
        cloneable = new Dimension(n4, n5);
        if (this.self_.isVisible()) {
            this.self_.setSize((Dimension)cloneable);
        }
        this.canvas_.revalidate();
        return cloneable;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw() {
        if (this.seqInProgressP_) {
            FTCentral.message("There is a sequence in progress.  You must finish or pause it first.", true);
            return;
        }
        if (this.canvas_.drawing_p()) {
            FTCentral.message("There is an image in progress.  You must finish or pause it first.", true);
            return;
        }
        FractalSpec fractalSpec = new FractalSpec();
        if (!this.fTCentral_.parmsToSpec(fractalSpec)) {
            FTCentral.message("Invalid parameters, please correct and try again.", true);
            return;
        }
        if (fractalSpec.equal_p(this.getSpec()) && this.canvas().everStartedP()) {
            if (this.canvas().everFinishedP()) {
                FTCentral.message("This image has already been computed.", false);
                return;
            }
            FTCentral.message("Resuming the draw on window " + this.myFrameNumber_ + ".", false);
        } else {
            this.resizeForDraw(fractalSpec.pix_width, fractalSpec.pix_height);
            this.validate();
            String string = this.canvas_.importParameters(fractalSpec);
            int n = string.contains("double precision") ? 52 : fractalSpec.center.r.getDenominator();
            this.importWhatsDrawn(fractalSpec);
            FTCentral.message("Beginning draw on window " + this.myFrameNumber_ + " using " + string + " (" + n + " bits).", false);
        }
        if (this.seqPausedP_) {
            this.seqPausedP_ = false;
            this.startSeqMI_.setText("Start");
        }
        this.canvas_.threaded_paint_fractal();
    }

    public boolean compatibleForZoomP(FTWindow fTWindow) {
        if (this.looper() == null || fTWindow == null || fTWindow.looper() == null) {
            if (fTWindow == null) {
                FTCentral.message("Second drawing window doesn't exist.", true);
            } else {
                FTCentral.message("Window " + (this.looper() == null ? this.myFrameNumber_ : fTWindow.frameNumber()) + " has no loop function.", true);
            }
            return false;
        }
        if (!this.looper().equals(fTWindow.looper())) {
            FTCentral.message("These windows have diffenert loop functions: here: " + this.looper() + " other: " + fTWindow.looper(), true);
        }
        return this.looper().equals(fTWindow.looper());
    }

    public boolean doingSequenceP() {
        return this.seqInProgressP_ || this.seqPausedP_;
    }

    public Dimension getHVRatio() {
        return this.hVRatio_;
    }

    public String getUserComment() {
        return new TextDialog("Add Comments", this, lastComment_).getText();
    }

    public String getWritePathFromDialog() {
        try {
            boolean bl = this.canvas().imageHas256ColorsP() && this.canvas().everFinishedP() && !this.imageInterpolatedP();
            return this.getFileChooser().getWriteFilename("png" + (this.canvas_.countsExistP() ? ", ftr" : "") + (bl ? ", gif" : ""), true);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private boolean writeFractal(boolean bl, String object) {
        try {
            FTLooper fTLooper;
            FTIO fTIO = new FTIO(this);
            Object object2 = "";
            if (!this.canvas_.imageExistsP()) {
                FTCentral.message("There is no image.", false);
                return false;
            }
            if (object == null && ((object = bl ? fTIO.urlStringFromDialog() : this.getWritePathFromDialog()) == null || ((String)object).length() == 0)) {
                FTCentral.message("Write fractal image - No action taken.", false);
                return false;
            }
            FTIO.backupExistingFile((String)object);
            if (this.fTCentral_.userWantsToAddCOmmentP()) {
                object2 = this.getUserComment();
            }
            if ((fTLooper = this.fTCentral_.findLoopObject(this.canvas_.spec().which)) != null && fTLooper.acceptsTrapGif() && this.fTCentral_.trapPathname() != null) {
                object2 = "\nTrap:" + this.fTCentral_.trapPathname() + "\n" + (String)object2;
            }
            boolean bl2 = false;
            String string = ((String)object).toLowerCase();
            if (string.endsWith(".ftr")) {
                if (this.canvas_.hasLoopCounts()) {
                    bl2 = this.writePNG_or_FTR(false, bl, (String)object, (String)object2);
                    if (bl2) {
                        FTCentral.message("FT Raw file saved as " + (String)object + ".", false);
                    }
                } else {
                    int n = this.canvas_.getTypeOfImagePreparation();
                    String string2 = n == 3 ? "PNG " : (n == 2 ? "GIF " : "NON-");
                    FTCentral.message("Error: A " + string2 + "file does not contain the loop counts needed to\n        create an FT raw data file (.ftr).  Redraw then save.", true);
                }
            } else if (string.endsWith(".gif") && this.canvas_.imageHas256ColorsP()) {
                bl2 = this.writeGIF(bl, (String)object, (String)object2, fTIO);
                if (bl2) {
                    FTCentral.message("GIF file saved as " + (String)object + ".", false);
                }
            } else {
                if (!string.endsWith(".png")) {
                    object = (String)object + ".png";
                }
                if (bl2 = this.writePNG_or_FTR(true, bl, (String)object, (String)object2)) {
                    FTCentral.message("PNG file saved as " + (String)object + ".", false);
                }
            }
            return bl2;
        }
        catch (Throwable throwable) {
            FTCentral.message("FTWindow.resizeForDraw ERROR on stream or encode: " + FTCentral.getExceptionSynopsis(throwable), true);
            return false;
        }
    }

    private boolean writePNG_or_FTR(boolean bl, boolean bl2, String string, String string2) {
        File file;
        try {
            BufferedImage bufferedImage;
            String string3 = this.canvas().colorGuideAsString();
            BufferedImage bufferedImage2 = bufferedImage = bl ? this.canvas().fractalProducer_.getImage() : this.canvas().fractalProducer_.createRawImage();
            if (bufferedImage == null) {
                if (!bl) {
                    FTCentral.message("FTWindow.writePNG_or_FTR - Raw data is not available from loaded GIF or PNG files.  No action taken.", true);
                } else {
                    FTCentral.message("FTWindow.writePNG_or_FTR - ERROR: no image was found for the write operation.  No action taken.", true);
                }
                return false;
            }
            if (string2 == null) {
                string2 = "";
            }
            IIOMetadata iIOMetadata = FTIO.createMetadata(string2, this.canvas().spec().toString(1, ""), string3);
            file = bl2 ? File.createTempFile("FT_", ".png") : new File(string);
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
            imageWriter.setOutput(fileImageOutputStream);
            imageWriter.write(iIOMetadata, new IIOImage(bufferedImage, null, iIOMetadata), null);
            fileImageOutputStream.close();
            imageWriter.dispose();
            if (!bl2) {
                return true;
            }
        }
        catch (IOException iOException) {
            FTCentral.message("FTWindow.writePNG_or_FTR - Unable to write image to file: " + (iOException.getMessage() != null ? iOException.getMessage() : iOException.getClass().getName()), true);
            return false;
        }
        try {
            return this.writePNGFileToURL(string, file);
        }
        catch (Exception exception) {
            FTCentral.message("FTWindow.writePNG_or_FTR - Unable to copy temp image file to URL " + string + ": " + (exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName()), true);
            return false;
        }
    }

    public boolean writePNGFileToURL(String string, File file) throws IOException {
        int n;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestProperty("Content-Type", "image/png");
        OutputStream outputStream = httpURLConnection.getOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        outputStream.close();
        int n2 = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        if (n2 != 200) {
            FTCentral.message("Image upload failed! HTTP Response Code: " + n2, true);
            return false;
        }
        return true;
    }

    private boolean writeGIF(boolean bl, String string, String string2, FTIO fTIO) {
        boolean bl2 = false;
        try (OutputStream outputStream = fTIO.toOutputStream(string, bl, false);){
            Object object;
            if (outputStream == null) {
                throw new IOException("NOT FOUND: " + string);
            }
            GIFEncoder gIFEncoder = this.canvas_.createGIFEncoder();
            FractalSpec fractalSpec = new FractalSpec(this.canvas_.spec());
            Object object2 = object = string2 == null ? "" : string2;
            if (fractalSpec.which.equals("Mandelbrot") || fractalSpec.which.equals("MandelCube")) {
                if (((String)object).length() > 0) {
                    object = (String)object + "\n";
                }
                object = (String)object + fractalSpec.which + "[C=(" + fractalSpec.coeff.r.toString() + ", " + fractalSpec.coeff.i.toString() + ") T=(" + fractalSpec.trans.r.toString() + ", " + fractalSpec.trans.i.toString() + ")] at (" + fractalSpec.center.r.toString() + ", " + fractalSpec.center.i.toString() + ") width=" + fractalSpec.range;
            }
            if (((String)object).length() > 0) {
                gIFEncoder.setComment((String)object);
            }
            gIFEncoder.JavaQuatWrite(outputStream, fractalSpec.toString(1, string2), bl2, fractalSpec.version);
        }
        catch (Throwable throwable) {
            FTCentral.message("FTWindow.writeGIF - Error on stream or encode: " + throwable, true);
            FTCentral.message(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage(), true);
            return false;
        }
        return true;
    }

    public boolean writeParms(boolean bl, String object) {
        boolean bl2;
        block13: {
            FTIO fTIO = new FTIO(this);
            String string = "";
            if (!this.canvas_.imageExistsP()) {
                FTCentral.message("There is no image for which to save arguments.", false);
                return false;
            }
            if (object == null) {
                object = bl ? fTIO.urlStringFromDialog() : this.getFileChooser().getWriteFilename("text, txt", false);
            }
            if (object == null || ((String)object).length() == 0) {
                FTCentral.message("Write arguments - No action taken.", false);
                return false;
            }
            if (!((String)object).toLowerCase().endsWith(".text") && !((String)object).toLowerCase().endsWith(".txt")) {
                object = (String)object + ".text";
            }
            if (this.fTCentral_.userWantsToAddCOmmentP()) {
                string = this.getUserComment();
            }
            OutputStream outputStream = fTIO.toOutputStream((String)object, bl, false);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                String string2 = this.spec().toString(1, string);
                outputStreamWriter.write(string2, 0, string2.length());
                outputStreamWriter.flush();
                outputStreamWriter.close();
                FTCentral.message("Parameters Saved.", false);
                bl2 = true;
                if (outputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    FTCentral.message("FTWindow.writeParms - Error: " + FTCentral.getExceptionSynopsis(throwable3), true);
                    return false;
                }
            }
            outputStream.close();
        }
        return bl2;
    }

    public boolean writeCountsCSV() {
        boolean bl;
        block12: {
            FTIO fTIO = new FTIO(this);
            String string = this.canvas_.getCountsCSV();
            if (string == null) {
                return false;
            }
            Object object = this.getFileChooser().getWriteFilename("csv", false);
            if (object == null || ((String)object).length() == 0) {
                FTCentral.message("Write counts CSV - No action taken.", false);
                return false;
            }
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            OutputStream outputStream = fTIO.toOutputStream((String)object, false, false);
            try {
                if (outputStream == null) {
                    throw new Exception("Unable to create file " + (String)(object == null ? "." : object));
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.flush();
                outputStreamWriter.close();
                FTCentral.message("Counts CSV Saved to " + (String)object + ".", false);
                bl = true;
                if (outputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    FTCentral.message("FTWindow.writeCountsCSV - Error: " + FTCentral.getExceptionSynopsis(throwable3), true);
                    return false;
                }
            }
            outputStream.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FractalSpec readParms(boolean bl, int n) {
        InputStream inputStream = null;
        FractalSpec fractalSpec = null;
        FTIO fTIO = new FTIO(this);
        String string = bl ? fTIO.urlStringFromDialog() : this.getFileChooser().getReadFilename("text, txt", false);
        if (string == null || string.length() == 0) {
            FTCentral.message("No action taken.", false);
            return null;
        }
        try {
            inputStream = fTIO.toInputStream(string, bl, false);
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                FTArgReader fTArgReader = new FTArgReader();
                fractalSpec = fTArgReader.readArgFile(inputStreamReader, n);
                fractalSpec.cache_is_current = false;
                fractalSpec = new FractalSpec(fractalSpec);
                if (n == -1) {
                    FTCentral.message("First arg set loaded.", false);
                } else {
                    FTCentral.message("Arg set " + n + " loaded.", false);
                }
            }
        }
        catch (Throwable throwable) {
            FTCentral.message(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage(), true);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (fractalSpec == null) {
            return null;
        }
        this.setCheckBoxValues(fractalSpec);
        this.fTCentral_.setParameters(fractalSpec);
        return fractalSpec;
    }

    public void openImage() {
        boolean bl = this.fTCentral_.write2URLP();
        FTIO fTIO = new FTIO(this);
        String string = bl ? fTIO.urlStringFromDialog() : this.getFileChooser().getReadFilename("png, ftr, gif", true);
        if (string == null || string.length() == 0) {
            FTCentral.message("No action taken.", false);
            return;
        }
        if (!(string.toLowerCase().endsWith(".gif") || string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".ftr"))) {
            FTCentral.message("No acceptable file extension given in " + string + ".  - .gif, .png, or .ftr is required.", true);
            return;
        }
        if (string.toLowerCase().endsWith(".png")) {
            this.loadPNG(bl, string);
        } else if (string.toLowerCase().endsWith(".ftr")) {
            this.loadFTR(bl, string);
        } else {
            this.loadGIF(bl, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FractalSpec loadGIF(boolean bl, String string) {
        boolean bl2 = true;
        GIFDecoder gIFDecoder = null;
        InputStream inputStream = null;
        FractalSpec fractalSpec = null;
        FTIO fTIO = new FTIO(this);
        try {
            inputStream = fTIO.toInputStream(string, bl, false);
            if (inputStream == null) {
                throw new IOException("NOT FOUND: " + string);
            }
            gIFDecoder = new GIFDecoder(inputStream, bl2);
            String string2 = "FrctlTop";
            int n = gIFDecoder.getVersionAuthCode(string2);
            if (n == -2) {
                n = gIFDecoder.getVersionAuthCode("JavaQuat");
                string2 = "JavaQuat";
            }
            boolean bl3 = true;
            switch (n) {
                case 14: {
                    FTCentral.message("Style 1.4 image read.", false);
                    break;
                }
                case 20: {
                    FTCentral.message("Style 2.0 image read.", false);
                    bl3 = false;
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: {
                    FTCentral.message("Style " + n / 10 + "." + n % 10 + " image read.", false);
                    bl3 = false;
                    break;
                }
                default: {
                    throw new AWTException("Not recognized as a FrctlTop or JavaQuat image.");
                }
            }
            String string3 = gIFDecoder.getApplicationData(string2);
            StringReader stringReader = new StringReader(string3);
            FTArgReader fTArgReader = new FTArgReader();
            fractalSpec = new FractalSpec(fTArgReader.readArgFile(stringReader, -1));
            fractalSpec.cache_is_current = false;
            if (bl3) {
                fractalSpec.version = 1.4;
            }
        }
        catch (Throwable throwable) {
            FTCentral.message(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage(), false);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (fractalSpec == null) {
            return null;
        }
        this.updateWindowFromReadSpec(fractalSpec);
        if (bl) {
            try {
                URL uRL = new URL(string);
                this.canvas_.loadGIF(uRL, fractalSpec, gIFDecoder.globalRGBTable());
            }
            catch (Throwable throwable) {
                FTCentral.message(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage(), false);
            }
        } else {
            this.canvas_.loadGIF(string, fractalSpec, gIFDecoder.globalRGBTable());
        }
        FTCentral.message("Image read: " + string, false);
        return fractalSpec;
    }

    public FractalSpec loadPNG(boolean bl, String string) {
        try {
            FractalSpec fractalSpec;
            FTCentral.message("Reading PNG image: " + string, false);
            if (bl) {
                URL uRL = new URL(string);
                fractalSpec = this.canvas().loadPNG(uRL);
            } else {
                fractalSpec = this.canvas().loadPNG(string);
            }
            if (fractalSpec == null) {
                return null;
            }
            this.updateWindowFromReadSpec(fractalSpec);
            FTCentral.message("Style " + fractalSpec.version + " image read.", false);
            return fractalSpec;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public FractalSpec loadFTR(boolean bl, String string) {
        try {
            FractalSpec fractalSpec;
            FTCentral.message("Reading FT raw data: " + string, false);
            if (bl) {
                URL uRL = new URL(string);
                fractalSpec = this.canvas().loadFTR(uRL);
            } else {
                fractalSpec = this.canvas().loadFTR(string);
            }
            if (fractalSpec == null) {
                return null;
            }
            this.updateWindowFromReadSpec(fractalSpec);
            FTCentral.message("Style " + fractalSpec.version + " data read.", false);
            return fractalSpec;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void updateWindowFromReadSpec(FractalSpec fractalSpec) {
        this.spec().assignFrom(fractalSpec);
        this.setCheckBoxValues(this.spec());
        this.fTCentral_.setParameters(this.spec());
        this.resizeForDraw(this.spec().pix_width, this.spec().pix_height);
    }

    public String looper() {
        return this.spec().which;
    }

    public FractalSpec spec() {
        return this.canvas_.spec();
    }

    public void setLooper(String string) {
        for (JCheckBoxMenuItem jCheckBoxMenuItem : this.loopCheckBoxes_) {
            jCheckBoxMenuItem.setSelected(jCheckBoxMenuItem.getText().equals(string));
        }
        this.LoopLabelMI_.setText(string);
        this.spec().which = string;
        this.setCompiledCodeMenuItem();
    }

    public void setCheckBoxValues(FractalSpec fractalSpec) {
        this.importFlags(fractalSpec);
        this.setLooper(fractalSpec.which);
        this.setEnableSaveMenus(true);
        boolean bl = this.seqSpec_ != null && this.seqSpec_.readyP(false);
        this.setEnableSeqStartMenu(bl);
    }

    public void importFlags(FractalSpec fractalSpec) {
        this.fastMI_.setState(!fractalSpec.hifi_p);
        this.spec().hifi_p = fractalSpec.hifi_p;
        this.hVRatio_ = new Dimension(fractalSpec.wHRatio_);
        this.spec().wHRatio_ = fractalSpec.wHRatio_;
        if (fractalSpec.interpolateColors == 0) {
            this.interpolateButtonGroup_.setSelected(this.interpolOFF_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: OFF");
            this.spec().interpolateColors = 0;
        } else if (fractalSpec.interpolateColors == 1) {
            this.interpolateButtonGroup_.setSelected(this.interpolHSB_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: HSB");
            this.spec().interpolateColors = 1;
        } else if (fractalSpec.interpolateColors == 2) {
            this.interpolateButtonGroup_.setSelected(this.interpolRGB_.getModel(), true);
            this.interpolateColorsMenu_.setText("Interpolation: RGB");
            this.spec().interpolateColors = 2;
        }
    }

    public void importWhatsDrawn(FractalSpec fractalSpec) {
        if (fractalSpec.rangeOver == 0) {
            this.QButtonGroup_.setSelected(this.Q1MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q1");
            this.spec().rangeOver = 0;
        } else if (fractalSpec.rangeOver == 1) {
            this.QButtonGroup_.setSelected(this.Q2MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q2");
            this.spec().rangeOver = 1;
        } else if (fractalSpec.rangeOver == 2) {
            this.QButtonGroup_.setSelected(this.Q3MI_.getModel(), true);
            this.scanOnMenu_.setText("Scan On: Q3");
            this.spec().rangeOver = 2;
        }
        this.setLooper(fractalSpec.which);
    }

    public void getCheckBoxValues(FractalSpec fractalSpec) {
        this.exportFlags(fractalSpec);
        fractalSpec.which = this.LoopLabelMI_.getText();
    }

    public void exportFlags(FractalSpec fractalSpec) {
        fractalSpec.hifi_p = !this.fastMI_.getState();
        fractalSpec.wHRatio_ = new Dimension(this.hVRatio_);
        ButtonModel buttonModel = this.QButtonGroup_.getSelection();
        if (buttonModel == this.Q1MI_.getModel()) {
            fractalSpec.rangeOver = 0;
        } else if (buttonModel == this.Q2MI_.getModel()) {
            fractalSpec.rangeOver = 1;
        } else if (buttonModel == this.Q3MI_.getModel()) {
            fractalSpec.rangeOver = 2;
        }
        buttonModel = this.interpolateButtonGroup_.getSelection();
        if (buttonModel == this.interpolOFF_.getModel()) {
            fractalSpec.interpolateColors = 0;
        } else if (buttonModel == this.interpolHSB_.getModel()) {
            fractalSpec.interpolateColors = 1;
        } else if (buttonModel == this.interpolRGB_.getModel()) {
            fractalSpec.interpolateColors = 2;
        }
    }

    public void exportWhatsDrawn(FractalSpec fractalSpec) {
        ButtonModel buttonModel = this.QButtonGroup_.getSelection();
        if (buttonModel == this.Q1MI_.getModel()) {
            fractalSpec.rangeOver = 0;
        } else if (buttonModel == this.Q2MI_.getModel()) {
            fractalSpec.rangeOver = 1;
        } else if (buttonModel == this.Q3MI_.getModel()) {
            fractalSpec.rangeOver = 2;
        }
        fractalSpec.which = this.spec().which;
    }

    public void setEnableSaveMenus(boolean bl) {
        this.saveAsFileMI_.setEnabled(bl);
        this.clipBdMI_.setEnabled(bl);
    }

    public void setEnableDrawStartMenu(boolean bl) {
        this.startDrawMI_.setEnabled(bl);
        this.seqSetupMI_.setEnabled(bl);
        if (!bl && this.startSeqMI_.getText().equals("Start")) {
            this.startSeqMI_.setEnabled(bl);
        }
    }

    public void setEnableSeqStartMenu(boolean bl) {
        if (!this.seqInProgressP_) {
            if (!bl || !this.seqSpec_.readyP(true)) {
                this.startSeqMI_.setEnabled(false);
                return;
            }
            this.getCheckBoxValues(this.seqSpec_.startSpec());
            FractalSpec fractalSpec = new FractalSpec(this.seqSpec_.startSpec());
            if (this.fTCentral_.parmsToSpec(fractalSpec)) {
                this.seqSpec_.startSpec().panels = fractalSpec.panels;
                this.seqSpec_.startSpec().panel_x = fractalSpec.panel_x;
                this.seqSpec_.startSpec().panel_y = fractalSpec.panel_y;
                this.seqSpec_.enabled_p = true;
            }
        }
        this.startSeqMI_.setEnabled(true);
    }

    public void setSeqSpec(SeqSpec seqSpec) {
        this.stopSequence();
        this.seqSpec_.assignFrom(seqSpec, true, true);
    }

    public void setSeqSpecNextFrame(int n) {
        this.seqSpecNextFrame_ = n;
    }

    public void autoAdvance(FractalSpec fractalSpec) {
        boolean bl = false;
        FractalSpec fractalSpec2 = new FractalSpec(fractalSpec);
        if (this.seqInProgressP_) {
            if (this.seqSpec_.pause_p) {
                if (bl) {
                    System.out.println("FTWindow.autoAdvance entry: pt1");
                }
                this.seqInProgressP_ = false;
                this.openFileMI_.setEnabled(true);
                this.openParmMI_.setEnabled(true);
                this.seqPausedP_ = true;
                this.seqPaused4ScreenCaptureP_ = true;
                if (this.seqSpec_.advance(fractalSpec2, this.seqSpec_.getFrameNumber() + 1)) {
                    this.savedSequencePauseSpec_ = fractalSpec2;
                    this.fTCentral_.setParameters(fractalSpec2);
                    this.startSeqMI_.setText("Resume");
                    this.startSeqMI_.setEnabled(true);
                } else {
                    this.startSeqMI_.setText("Start");
                    this.startSeqMI_.setEnabled(false);
                }
            } else if (this.canvas_.stoppedP()) {
                if (this.canvas_.everFinishedP()) {
                    if (!this.seqSpec_.pause_p) {
                        this.writeFractal(this.seqSpec_.destinationURLP(), this.seqSpec_.pathname(fractalSpec));
                    }
                    if (this.seqSpec_.advance(fractalSpec2, this.seqSpecNextFrame_ > -1 ? this.seqSpecNextFrame_ : this.seqSpec_.getFrameNumber() + 1)) {
                        this.seqInProgressP_ = false;
                        this.seqPausedP_ = true;
                        this.fTCentral_.setParameters(fractalSpec2);
                        this.startSeqMI_.setText("Resume");
                        this.startSeqMI_.setEnabled(true);
                        this.openFileMI_.setEnabled(true);
                        this.openParmMI_.setEnabled(true);
                        this.seqPaused4ScreenCaptureP_ = true;
                        this.savedSequencePauseSpec_ = fractalSpec2;
                    } else {
                        this.concludeSequence();
                    }
                }
            } else if (!this.writeFractal(this.seqSpec_.destinationURLP(), this.seqSpec_.pathname(fractalSpec))) {
                if (bl) {
                    System.out.println("FTWindow.autoAdvance entry: pt2");
                }
                FTCentral.message("Sequence write failed - stopping", true);
                this.seqInProgressP_ = false;
                this.openFileMI_.setEnabled(true);
                this.openParmMI_.setEnabled(true);
                this.seqPausedP_ = false;
                this.startSeqMI_.setText("Start");
                this.seqSpec_.advance(fractalSpec2, this.seqSpec_.getFrameNumber() + 1);
                this.seqSpec_.setStartSpec(null);
                this.savedSequencePauseSpec_ = fractalSpec2;
            } else if (this.seqSpec_.advance(fractalSpec2, this.seqSpecNextFrame_ > -1 ? this.seqSpecNextFrame_ : this.seqSpec_.getFrameNumber() + 1)) {
                if (bl) {
                    System.out.println("FTWindow.autoAdvance entry: pt3");
                }
                this.doNormalAdvance(fractalSpec2);
            } else {
                if (bl) {
                    System.out.println("FTWindow.autoAdvance entry: pt4");
                }
                this.concludeSequence();
            }
        }
    }

    private void doNormalAdvance(FractalSpec fractalSpec) {
        this.seqSpecNextFrame_ = -1;
        this.canvas_.importParameters(fractalSpec);
        this.fTCentral_.setParameters(fractalSpec);
        this.canvas_.threaded_paint_fractal();
    }

    private void concludeSequence() {
        this.seqInProgressP_ = false;
        this.openFileMI_.setEnabled(true);
        this.openParmMI_.setEnabled(true);
        this.seqPausedP_ = false;
        this.startSeqMI_.setText("Start");
        this.seqSpec_.setStartSpec(null);
        this.seqSpec_.enabled_p = false;
        this.startSeqMI_.setEnabled(false);
    }

    private FractalSpec getAdjustBaseSpec() {
        FractalSpec fractalSpec = new FractalSpec();
        if (!this.fTCentral_.parmsToSpec(fractalSpec)) {
            FTCentral.message("Taking value from image. Parameters window value is invalid.", true);
            fractalSpec.assignFrom(this.canvas_.spec());
        }
        return fractalSpec;
    }

    public void adjustEnlarge(int n) {
        FractalSpec fractalSpec = this.getAdjustBaseSpec();
        fractalSpec.range = n >= 0 ? fractalSpec.range * 100.0 / (double)(100 + n) : fractalSpec.range / 100.0 * (double)(100 + -n);
        this.fTCentral_.setParameters(fractalSpec);
    }

    public void adjustCenterRight(int n) {
        FractalSpec fractalSpec = this.getAdjustBaseSpec();
        double d = fractalSpec.range / ((double)fractalSpec.pix_width - 1.0);
        BigQuaternion bigQuaternion = fractalSpec.vx.times_scalar((double)n * d).bigQuaternionValue();
        if (fractalSpec.rangeOver == 0) {
            fractalSpec.center.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 1) {
            fractalSpec.coeff.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 2) {
            fractalSpec.trans.plus_equal(bigQuaternion);
        }
        this.fTCentral_.setParameters(fractalSpec);
    }

    public void adjustCenterUp(int n) {
        FractalSpec fractalSpec = this.getAdjustBaseSpec();
        double d = fractalSpec.range / ((double)fractalSpec.pix_width - 1.0);
        BigQuaternion bigQuaternion = fractalSpec.vy.times_scalar((double)n * d).bigQuaternionValue();
        if (fractalSpec.rangeOver == 0) {
            fractalSpec.center.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 1) {
            fractalSpec.coeff.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 2) {
            fractalSpec.trans.plus_equal(bigQuaternion);
        }
        this.fTCentral_.setParameters(fractalSpec);
    }

    public void adjustCenterOnW(int n) {
        FractalSpec fractalSpec = this.getAdjustBaseSpec();
        double d = fractalSpec.range / ((double)fractalSpec.pix_width - 1.0);
        FastQuaternion fastQuaternion = this.fTCentral_.parmsWAxis();
        BigQuaternion bigQuaternion = fastQuaternion.times_scalar((double)n * d).bigQuaternionValue();
        if (fractalSpec.rangeOver == 0) {
            fractalSpec.center.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 1) {
            fractalSpec.coeff.plus_equal(bigQuaternion);
        } else if (fractalSpec.rangeOver == 2) {
            fractalSpec.trans.plus_equal(bigQuaternion);
        }
        this.fTCentral_.setParameters(fractalSpec);
    }

    public int numberOfProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public boolean imageInterpolatedP() {
        return this.canvas().imageInterpolatedP();
    }

    public FTFileChooser getFileChooser() {
        return this.fileChooser_;
    }

    public void showDoc(String string) {
        String string2 = FTCentral.findDocString(string);
        JOptionPane.showMessageDialog(this, string2);
    }

    public void saveImage() {
        this.writeFractal(this.fTCentral_.write2URLP(), null);
    }

    public void setLogging(boolean bl) {
        if (this.loggingMI_.getState() != bl) {
            this.loggingMI_.setState(bl);
            this.spec().loggingP_ = bl;
        }
    }

    public void setWrite2URLP(boolean bl) {
        this.write2URLMI_.setState(bl);
        this.spec().ioToURLP_ = bl;
    }

    public void setUserWantsToAddCommentP(boolean bl) {
        this.userCommentMI_.setState(bl);
        this.spec().userWantsToAddComment_ = bl;
    }

    public void addToWindowsMenu(FTWindow fTWindow) {
        JMenuItemWithNumber jMenuItemWithNumber = new JMenuItemWithNumber(fTWindow.frameNumber());
        jMenuItemWithNumber.addActionListener(new WindowToFrontLNR(fTWindow));
        this.windowsMenu_.add(jMenuItemWithNumber);
    }

    public void removeFromWindowMenu(int n) {
        int n2 = -1;
        for (int i = 0; i < this.windowsMenu_.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.windowsMenu_.getItem(i);
            if (!(jMenuItem instanceof JMenuItemWithNumber) || ((JMenuItemWithNumber)jMenuItem).getNumber() != n) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.windowsMenu_.remove(n2);
        } else {
            FTCentral.message("Error in FTWindow.removeFromWindowMenu - nothing found", true);
        }
    }

    public void sequenceEndedWithStop() {
        if (this.seqInProgressP_) {
            this.seqInProgressP_ = false;
            this.startSeqMI_.setText("Resume");
            this.startSeqMI_.setEnabled(true);
            this.openFileMI_.setEnabled(true);
            this.openParmMI_.setEnabled(true);
            this.seqPausedP_ = true;
        }
    }

    public void setCompiledCodeMenuItem() {
        String string = this.canvas().getCompiledCodeStatus();
        this.useCompiledCodeMI_.setText(string);
        boolean bl = this.canvas().compiledCodeLoadedP();
        this.useCompiledCodeMI_.setEnabled(bl);
    }

    private void assignDisplayedParms(FractalSpec fractalSpec) {
        this.fTCentral_.setParameters(fractalSpec);
        this.setCheckBoxValues(fractalSpec);
        FTCentral.message("Format " + this.canvas_.spec().version, false);
    }

    private void stopSequence() {
        this.seqInProgressP_ = false;
        this.openFileMI_.setEnabled(true);
        this.openParmMI_.setEnabled(true);
        this.seqPausedP_ = false;
        this.seqPaused4ScreenCaptureP_ = false;
        this.seqSpec_.setStartSpec(null);
        this.startSeqMI_.setText("Start");
        this.setEnableSeqStartMenu(false);
        this.canvas_.stop();
    }

    @Override
    public String toString() {
        return "<FTWindow " + this.frameNumber() + ">";
    }

    class MyWindowLNR
    implements WindowListener {
        MyWindowLNR() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (FTWindow.this.fTCentral_.activeFrameCount() > 1) {
                Properties.saveDictionary();
                FTWindow.this.fTCentral_.removeFrame(FTWindow.this.self_);
            } else {
                FTWindow.this.self_.setDefaultCloseOperation(0);
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            try {
                FTWindow.this.fTCentral_.activateMe(FTWindow.this.self_, FTWindow.this.initializingWindow_);
            }
            finally {
                FTWindow.this.initializingWindow_ = false;
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    class FileMenuLNR
    implements MenuListener {
        FileMenuLNR() {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            FTWindow.this.saveCountsCSVMI_.setEnabled(FTWindow.this.canvas_.countsExistP() && FTWindow.this.canvas_.everFinishedP());
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    }

    class newFrameLNR
    extends DocuActionListener {
        public newFrameLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.makeNewFrame(FTWindow.this.self_);
        }
    }

    class openFileLNR
    extends DocuActionListener {
        public openFileLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.self_.openImage();
        }
    }

    class openParmLNR
    extends DocuActionListener {
        public openParmLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            int n = -1;
            FTWindow.this.self_.readParms(FTWindow.this.fTCentral_.write2URLP(), n);
        }
    }

    class openLogLNR
    extends DocuActionListener {
        public openLogLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Enter log entry number", FTWindow.this.self_, "-1");
            if (!intDialog.cancelled_P()) {
                try {
                    int n = intDialog.getValue();
                    FTWindow.this.self_.readParms(FTWindow.this.fTCentral_.write2URLP(), n);
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral cfr_ignored_0 = FTWindow.this.fTCentral_;
                    FTCentral cfr_ignored_1 = FTWindow.this.fTCentral_;
                    FTCentral.message("Error in reading entry number.  " + FTCentral.getExceptionSynopsis(numberFormatException), true);
                }
            }
        }
    }

    class trapFileLNR
    extends DocuActionListener {
        public trapFileLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.openTrapImage();
        }
    }

    class saveAsFileLNR
    extends DocuActionListener {
        public saveAsFileLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.writeFractal(FTWindow.this.fTCentral_.write2URLP(), null);
        }
    }

    class saveArgsFLNR
    extends DocuActionListener {
        public saveArgsFLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.writeParms(FTWindow.this.fTCentral_.write2URLP(), null);
        }
    }

    class saveCountsCSVLNR
    extends DocuActionListener {
        public saveCountsCSVLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.writeCountsCSV();
        }
    }

    class JoinPanelsLNR
    extends DocuActionListener {
        public JoinPanelsLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            PanelJoiner panelJoiner;
            String string;
            File file = FTWindow.this.fileChooser_.getDirectory();
            if (file != null && file.exists() && (string = (panelJoiner = new PanelJoiner(file.toString())).joinFiles()) != null) {
                FTCentral.message("Joined panels written to " + string, true);
            }
        }
    }

    class write2URLLNR
    implements ActionListener {
        write2URLLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0 && FTWindow.this.self_.isActive()) {
                boolean bl = FTWindow.this.write2URLMI_.getState();
                FTWindow.this.fTCentral_.toggleWrite2URLP(bl);
            }
        }
    }

    class loggingLNR
    implements ActionListener {
        loggingLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                boolean bl = FTWindow.this.loggingMI_.getState();
                FTWindow.this.fTCentral_.toggleLogging(bl);
            }
        }
    }

    class usrComLNR
    implements ActionListener {
        usrComLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                boolean bl = FTWindow.this.userCommentMI_.getState();
                FTWindow.this.fTCentral_.toggleUserWantsToAddCommentP(bl);
            }
        }
    }

    class closeLNR
    extends DocuActionListener {
        public closeLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.removeFrame(FTWindow.this.self_);
        }
    }

    class quitLNR
    extends DocuActionListener {
        public quitLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.timeToQuit();
        }
    }

    class startDrawLNR
    extends DocuActionListener {
        public startDrawLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.self_.draw();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.startDrawLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class pauseDrawLNR
    extends DocuActionListener {
        public pauseDrawLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.canvas_.stop();
                FTWindow.this.canvas_.liveTraceStop();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.pauseDrawLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class LiveOrbitFLNR
    extends DocuActionListener {
        public LiveOrbitFLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            if (FTWindow.this.liveOrbitDialog_ == null) {
                FTWindow.this.liveOrbitDialog_ = new LiveOrbitDialog(FTWindow.this.self_, FTWindow.this.fTCentral_);
                FTWindow.this.liveOrbitDialog_.setVisible(FTWindow.this.canvas_.canPerformTraceOrbit());
            }
            if (FTWindow.this.canvas_.canPerformTraceOrbit()) {
                FTWindow.this.liveOrbitDialog_.setVisible(true);
                FTWindow.this.liveOrbitDialog_.toFront();
                FTWindow.this.liveOrbitDialog_.setDepth(FTWindow.this.getSpec().depth * 10);
            }
        }
    }

    class RefreshLNR
    extends DocuActionListener {
        public RefreshLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.canvas_.clearOrbitSpots();
                FTWindow.this.canvas_.clearPolygon();
                FTWindow.this.canvas_.repaint();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.RefreshLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class BoxInOtherWindowLNR
    extends DocuActionListener {
        public BoxInOtherWindowLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                if (FTWindow.this.boxInOtherWindowDialog_ == null) {
                    FTWindow.this.boxInOtherWindowDialog_ = new BoxInOtherWindowDialog(FTWindow.this.self_, FTWindow.this.fTCentral_);
                } else {
                    FTWindow.this.boxInOtherWindowDialog_.setVisible(true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.BoxInOtherWindowLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class BoxColorInEditorLNR
    extends DocuActionListener {
        public BoxColorInEditorLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.canvas().setBoxInColorEditor();
        }
    }

    class ClipboardCopyLNR
    extends DocuActionListener {
        public ClipboardCopyLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.canvas_.copyImageToSystemClipboard();
        }
    }

    class DrawFastLNR
    implements ActionListener {
        DrawFastLNR() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0 && FTWindow.this.self_.isActive()) {
                FTWindow.this.exportFlags(FTWindow.this.canvas_.spec());
                FTWindow.this.fTCentral_.flagsToParmFrame();
            }
        }
    }

    class HVRatioLNR
    extends DocuActionListener {
        public HVRatioLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                RatioDialog ratioDialog = new RatioDialog("Width/Height Ratio", FTWindow.this.self_, FTWindow.this.hVRatio_);
                if (!FTWindow.this.hVRatio_.equals(ratioDialog.getDimension())) {
                    FTWindow.this.hVRatio_ = ratioDialog.getDimension();
                    FTWindow.this.exportFlags(FTWindow.this.canvas_.spec());
                    FTWindow.this.fTCentral_.flagsToParmFrame();
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.HVRatioLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class interpolLNR
    implements ActionListener {
        String which_;

        public interpolLNR(String string) {
            this.which_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.getState()) {
                    FTWindow.this.interpolateColorsMenu_.setText("Interpolation: " + this.which_);
                }
                if (FTWindow.this.self_.isActive()) {
                    FTWindow.this.exportFlags(FTWindow.this.canvas_.spec());
                    FTWindow.this.fTCentral_.flagsToParmFrame();
                }
            }
        }
    }

    class Q_LNR
    implements ActionListener {
        String which_;

        public Q_LNR(String string) {
            this.which_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = actionEvent.getModifiers();
            if ((n & 1) == 0) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.getState()) {
                    FTWindow.this.scanOnMenu_.setText("Scan On: " + this.which_);
                }
                if (FTWindow.this.self_.isActive()) {
                    FTWindow.this.fTCentral_.whatsDrawnToParmFrame(FTWindow.this.self_);
                }
            }
        }
    }

    class displayParmsLNR
    extends DocuActionListener {
        public displayParmsLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.assignDisplayedParms(FTWindow.this.canvas_.spec());
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.displayParmsLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class UseCompiledCodeLNR
    extends DocuActionListener {
        public UseCompiledCodeLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            String string = FTWindow.this.canvas().toggleUseCompiledCode();
            FTWindow.this.useCompiledCodeMI_.setText(string);
            boolean bl = FTWindow.this.canvas().compiledCodeLoadedP();
            FTWindow.this.useCompiledCodeMI_.setEnabled(bl);
        }
    }

    class EnlargeLNR
    extends DocuActionListener {
        public EnlargeLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Zoom Percentage", FTWindow.this.self_, String.valueOf(FTWindow.this.fTCentral_.enlargePixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    FTWindow.this.fTCentral_.setEnlargePixels(intDialog.getValue());
                    FTWindow.this.adjustEnlarge(FTWindow.this.fTCentral_.enlargePixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral.message("Error in FTWindow.EnlargeLNR: Illegal percentage entered: " + numberFormatException, true);
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class EnlrgAgnLNR
    extends DocuActionListener {
        public EnlrgAgnLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.adjustEnlarge(FTWindow.this.fTCentral_.enlargePixels());
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.EnlrgAgnL.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class RightLNR
    extends DocuActionListener {
        public RightLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift fractal LEFT (pixels)", FTWindow.this.self_, String.valueOf(FTWindow.this.fTCentral_.rightPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    FTWindow.this.fTCentral_.setRightPixels(intDialog.getValue());
                    FTWindow.this.adjustCenterRight(FTWindow.this.fTCentral_.rightPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral.message("Error in FTWindow.RightLNR: Illegal # of pixels: " + numberFormatException, true);
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class RightAgnLNR
    extends DocuActionListener {
        public RightAgnLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.adjustCenterRight(FTWindow.this.fTCentral_.rightPixels());
        }
    }

    class DownLNR
    extends DocuActionListener {
        public DownLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift fractal UP (pixels)", FTWindow.this.self_, String.valueOf(FTWindow.this.fTCentral_.downPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    FTWindow.this.fTCentral_.setDownPixels(intDialog.getValue());
                    FTWindow.this.adjustCenterUp(-FTWindow.this.fTCentral_.downPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral.message("Error in FTWindow.DownLNR: Illegal # of pixels: " + numberFormatException, true);
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class DownAgnLNR
    extends DocuActionListener {
        public DownAgnLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.adjustCenterUp(-FTWindow.this.fTCentral_.downPixels());
        }
    }

    class OnWLNR
    extends DocuActionListener {
        public OnWLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("Shift pixels on W", FTWindow.this.self_, String.valueOf(FTWindow.this.fTCentral_.onWPixels()));
            if (!intDialog.cancelled_P()) {
                try {
                    FTWindow.this.fTCentral_.setOnWPixels(intDialog.getValue());
                    FTWindow.this.adjustCenterOnW(FTWindow.this.fTCentral_.onWPixels());
                }
                catch (NumberFormatException numberFormatException) {
                    FTCentral.message("Error in FTWindow.OnWLNR: Illegal # of pixels: " + numberFormatException, true);
                    FTCentral.message(numberFormatException.getMessage() == null ? numberFormatException.toString() : numberFormatException.getMessage(), true);
                }
            }
        }
    }

    class OnWAgnLNR
    extends DocuActionListener {
        public OnWAgnLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            FTWindow.this.fTCentral_.adjustCenterOnW(FTWindow.this.fTCentral_.onWPixels());
        }
    }

    class swapHVLNR
    extends DocuActionListener {
        public swapHVLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.swapHV();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.swapHVLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class Rotate90LLNR
    extends DocuActionListener {
        public Rotate90LLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.rotate90L();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.Rotate90LLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class Rotate90RLNR
    extends DocuActionListener {
        public Rotate90RLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.rotate90R();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.Rotate90RLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class RotateArbLNR
    extends DocuActionListener {
        public RotateArbLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            IntDialog intDialog = new IntDialog("", FTWindow.this.self_, String.valueOf(RotateArbLNR_previousValue_));
            if (!intDialog.cancelled_P()) {
                try {
                    RotateArbLNR_previousValue_ = intDialog.getDoubleValue();
                    FTWindow.this.fTCentral_.rotateClockwise(RotateArbLNR_previousValue_);
                }
                catch (Throwable throwable) {
                    FTCentral.message("Error in FTWindow.RotateArbLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
                }
            }
        }
    }

    class W2HLNR
    extends DocuActionListener {
        public W2HLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.w2H();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.W2HLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class W2VLNR
    extends DocuActionListener {
        public W2VLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.w2V();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.W2VLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class H2MemHLNR
    extends DocuActionListener {
        public H2MemHLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.h2MemH();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.H2MemHLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class V2MemVLNR
    extends DocuActionListener {
        public V2MemVLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.v2MemV();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.V2MemVLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class MemH2HLNR
    extends DocuActionListener {
        public MemH2HLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.memH2H();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.MemH2HLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class MemV2VLNR
    extends DocuActionListener {
        public MemV2VLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.memV2V();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.MemV2VLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class mouseV2LNR
    extends DocuActionListener {
        public mouseV2LNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.mouseNewVAxis();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.mouseV2LNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class mouseH2LNR
    extends DocuActionListener {
        public mouseH2LNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.mouseNewHAxis();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.mouseH2LNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class parmsLNR
    extends DocuActionListener {
        public parmsLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.showParmFrameFor(FTWindow.this.self_);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.parms.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class colorsLNR
    extends DocuActionListener {
        public colorsLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.showColorGuideEditor(FTWindow.this.self_);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.colorsLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class msgLNR
    extends DocuActionListener {
        public msgLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.setMessagesVisible(FTWindow.this.self_);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.msgLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class TrapLNR
    extends DocuActionListener {
        public TrapLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                FTWindow.this.fTCentral_.showTrapFrame();
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in Trap.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class startSeqLNR
    extends DocuActionListener {
        public startSeqLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void leftClickAction() {
            block9: {
                block11: {
                    block12: {
                        block10: {
                            if (FTWindow.this.seqInProgressP_ || FTWindow.this.canvas_.drawing_p()) break block9;
                            FractalSpec fractalSpec = new FractalSpec(FTWindow.this.spec());
                            if (FTWindow.this.seqSpec_.startSpec() == null) {
                                if (!FTWindow.this.fTCentral_.parmsToSpec(fractalSpec)) {
                                    FTWindow.this.seqSpec_.setStartSpec(null);
                                    FTCentral.message("Sequence is not properly specified: no start\nspec or valid parameter window values.", true);
                                    return;
                                }
                                FTWindow.this.getCheckBoxValues(fractalSpec);
                                FTWindow.this.seqSpec_.setStartSpec(fractalSpec);
                            } else if (!FTWindow.this.seqPausedP_ && FTWindow.this.fTCentral_.parmsToSpec(fractalSpec)) {
                                FTWindow.this.seqSpec_.startSpec().panels = fractalSpec.panels;
                                FTWindow.this.seqSpec_.startSpec().panel_x = fractalSpec.panel_x;
                                FTWindow.this.seqSpec_.startSpec().panel_y = fractalSpec.panel_y;
                            }
                            if (!FTWindow.this.seqSpec_.readyP(true)) {
                                FTCentral.message("Sequence is not properly specified: Sequence spec not ready.", true);
                                return;
                            }
                            if (!FTWindow.this.seqPaused4ScreenCaptureP_) break block10;
                            FTWindow.this.canvas_.importParameters(FTWindow.this.savedSequencePauseSpec_);
                            FTWindow.this.seqPaused4ScreenCaptureP_ = false;
                            break block11;
                        }
                        if (FTWindow.this.seqPausedP_) break block12;
                        FTWindow.this.canvas_.importParameters(FTWindow.this.seqSpec_.startSpec());
                        FTWindow.this.canvas_.setSpecVersionToCurrent();
                        FTWindow.this.assignDisplayedParms(FTWindow.this.seqSpec_.startSpec());
                        int n = FTWindow.this.seqSpec_.startWindowNumber();
                        FTWindow.this.resizeForDraw(FTWindow.this.seqSpec_.startSpec().pix_width, FTWindow.this.seqSpec_.startSpec().pix_height);
                        if (FTWindow.this.myFrameNumber_ != n) {
                            FTWindow fTWindow = FTWindow.this.fTCentral_.getFrame(n);
                            FTWindow.this.canvas_.copyColorMapFrom(fTWindow.canvas(), false);
                            FTWindow.this.canvas_.setRefresherImage(null);
                            FTWindow.this.canvas_.setEverStartedP(false);
                            FTWindow.this.canvas_.setEverFinishedP(false);
                            FTWindow.this.canvas_.setFractalSpecForSeqFrameNumber(FTWindow.this.seqSpec_);
                            break block11;
                        } else if (FTWindow.this.seqSpec_.getFrameNumber() != 0) {
                            FTWindow.this.canvas_.setRefresherImage(null);
                            FTWindow.this.canvas_.setEverStartedP(false);
                            FTWindow.this.canvas_.setEverFinishedP(false);
                            FTWindow.this.canvas_.setFractalSpecForSeqFrameNumber(FTWindow.this.seqSpec_);
                        }
                        break block11;
                    }
                    FTCentral.message("Continuing from pause in sequence.", false);
                }
                FTWindow.this.seqInProgressP_ = true;
                FTWindow.this.openFileMI_.setEnabled(false);
                FTWindow.this.openParmMI_.setEnabled(false);
                FTWindow.this.seqPausedP_ = false;
                FTWindow.this.startSeqMI_.setText("Stop");
                FTWindow.this.canvas_.threaded_paint_fractal();
                return;
            }
            FTWindow.this.stopSequence();
            if (FTWindow.this.seqInProgressP_) {
                FTCentral.message("Another sequence is in progress.", true);
            }
            if (!FTWindow.this.canvas_.drawing_p()) return;
            FTCentral.message("This window is currently drawing a fractal.", true);
        }
    }

    class seqLNR
    extends DocuActionListener {
        public seqLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                if (FTWindow.this.seqDialog_ == null) {
                    FTWindow.this.seqDialog_ = new SeqDialog("Sequence Setup", FTWindow.this.self_, FTWindow.this.seqSpec_, FTWindow.this.fTCentral_);
                } else {
                    FTWindow.this.seqDialog_.setDisplay();
                }
                FTWindow.this.seqDialog_.setLocationRelativeTo(FTWindow.this.self_.canvas());
                FTWindow.this.seqDialog_.setVisible(true);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.seqLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class RevPanelsLNR
    implements ItemListener {
        RevPanelsLNR() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                FTWindow.this.seqSpec_.advancePanelsBackwards_p = false;
            } else if (itemEvent.getStateChange() == 1) {
                FTWindow.this.seqSpec_.advancePanelsBackwards_p = true;
            }
        }
    }

    class RowByRowLNR
    implements ItemListener {
        RowByRowLNR() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 2) {
                FTWindow.this.seqSpec_.advanceRowByRow_p = false;
            } else if (itemEvent.getStateChange() == 1) {
                FTWindow.this.seqSpec_.advanceRowByRow_p = true;
            }
        }
    }

    class defaultLNR
    extends DocuActionListener {
        public defaultLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = FTWindow.this.LoopLabelMI_.getText();
                FTLooper fTLooper = FTWindow.this.fTCentral_.findLoopObject(string);
                if (fTLooper != null) {
                    FTWindow.this.fTCentral_.setParmFramePanelFields(1, 0, 0);
                    FTWindow.this.fTCentral_.setLooperDefaults(fTLooper);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.defaultLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class docLNR
    extends DocuActionListener {
        public docLNR(String string) {
            super(FTWindow.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = FTWindow.this.LoopLabelMI_.getText();
                FTLooper fTLooper = FTWindow.this.fTCentral_.findLoopObject(string);
                if (fTLooper != null) {
                    FTCentral.message(fTLooper.docString(), true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.docLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    public class HelpActionLNR
    implements ActionListener {
        String key_;

        public HelpActionLNR(String string) {
            this.key_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = FTCentral.findDocString(this.key_);
            if (object == null) {
                object = "\"" + this.key_ + "\" is not documented.";
            }
            JOptionPane.showMessageDialog(FTWindow.this.self_, object);
        }
    }

    class loopLNR
    implements ItemListener {
        String loopName_;

        public loopLNR(String string) {
            this.loopName_ = string;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                FTWindow.this.setLooper(this.loopName_);
                if (!FTWindow.this.initializingWindow_) {
                    FTWindow.this.fTCentral_.setLoooper4ParmFrame(this.loopName_);
                    FTLooper fTLooper = FTWindow.this.fTCentral_.findLoopObject(this.loopName_);
                    Window window = FTWindow.this.fTCentral_.getParmsSetBy();
                    if (fTLooper != null && (window == null || window == FTWindow.this.self_)) {
                        FTWindow.this.fTCentral_.setLooperDefaults(fTLooper);
                    }
                }
            }
        }
    }

    public class JMenuItemWithNumber
    extends JMenuItem {
        int myWindowsNumber;

        public JMenuItemWithNumber(int n) {
            super("Drawing Window " + n);
            this.myWindowsNumber = n;
        }

        public int getNumber() {
            return this.myWindowsNumber;
        }
    }

    class WindowToFrontLNR
    implements ActionListener {
        FTWindow myDrawingWindow;

        public WindowToFrontLNR(FTWindow fTWindow2) {
            this.myDrawingWindow = fTWindow2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.myDrawingWindow.toFront();
                this.myDrawingWindow.setExtendedState(0);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.WindowToFrontLNR.actionPerformed - Drawing Window " + (Serializable)(this.myDrawingWindow == null ? "NULL" : Integer.valueOf(this.myDrawingWindow.frameNumber())) + "\n    " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }
}

