/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.UrlDialog;

class FTIO {
    public static final String commentKey_ = "Comment";
    public static final String paramsKey_ = "Parameters";
    public static final String colorGuideKey_ = "ColorGuide";
    Frame frame_;

    public FTIO(Frame frame) {
        this.frame_ = frame;
    }

    public static void writeImageToFile(BufferedImage bufferedImage, String string, String string2) {
        try {
            FTIO.backupExistingFile(string);
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage, string2, file);
            System.out.println("Image saved successfully.");
        }
        catch (IOException iOException) {
            System.out.println("Error writing image: " + iOException.getMessage());
        }
    }

    public static BufferedImage loadImageFromResource(String string) {
        try {
            InputStream inputStream = FTIO.class.getResourceAsStream(string);
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
                return bufferedImage;
            }
            FTCentral.message("FTIO.loadImageFromResource - Resource not found: " + string, false);
        }
        catch (IOException iOException) {
            FTCentral.message("FTIO.loadImageFromResource ERROR: " + FTCentral.getExceptionSynopsis(iOException), false);
        }
        return null;
    }

    public String pathFromDialog(boolean bl) {
        FileDialog fileDialog = bl ? new FileDialog(this.frame_, null, 0) : new FileDialog(this.frame_, null, 1);
        try {
            fileDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            return null;
        }
        String string = fileDialog.getDirectory();
        if (string == null) {
            return null;
        }
        boolean bl2 = string.charAt(string.length() - 1) == File.separator.charAt(0);
        return string + (bl2 ? "" : File.separator) + fileDialog.getFile();
    }

    public String urlStringFromDialog() {
        UrlDialog urlDialog = new UrlDialog("Enter URL", this.frame_);
        try {
            urlDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            return null;
        }
        return urlDialog.getText();
    }

    public String urlStringFromDialog(String string) {
        UrlDialog urlDialog = new UrlDialog("Enter URL", this.frame_);
        urlDialog.setText(string);
        try {
            urlDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            return null;
        }
        return urlDialog.getText();
    }

    public InputStream toInputStream(String string, boolean bl, boolean bl2) {
        InputStream inputStream = null;
        try {
            if (!bl) {
                File file = new File(string);
                if (!file.exists()) {
                    throw new IOException("File DOES NOT EXIST - no read done.");
                }
                if (!bl2) {
                    inputStream = new FileInputStream(string);
                }
            } else {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
        }
        catch (MalformedURLException malformedURLException) {
            FTCentral.message("FTIO.toInputStream ERROR: Malformed URL - try again.", true);
        }
        catch (Throwable throwable) {
            FTCentral.message("FTIO.toInputStream ERROR: " + FTCentral.getExceptionSynopsis(throwable), false);
        }
        return inputStream;
    }

    public static boolean backupExistingFile(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                File file2;
                int n = 1;
                while ((file2 = new File(string + ".~" + n + "~")).exists()) {
                    if (n++ <= 1000) continue;
                    throw new IOException("Excessive backup versions exist - no write done.");
                }
                file.renameTo(file2);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public OutputStream toOutputStream(String string, boolean bl, boolean bl2) {
        OutputStream outputStream = null;
        try {
            if (!bl) {
                File file = new File(string);
                if (file.exists()) {
                    File file2;
                    int n = 1;
                    while ((file2 = new File(string + ".~" + n + "~")).exists()) {
                        if (n++ <= 1000) continue;
                        throw new IOException("Excessive backup versions exist - no write done.");
                    }
                    file.renameTo(file2);
                    file = new File(string);
                    if (file.exists()) {
                        throw new IOException("Already Exists or invalid - no write done.");
                    }
                }
                if (!bl2) {
                    outputStream = new FileOutputStream(string);
                }
            } else {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                outputStream = uRLConnection.getOutputStream();
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("JQIO.toOutputStream ERROR: " + FTCentral.getExceptionSynopsis(throwable), false);
        }
        return outputStream;
    }

    public static IIOMetadata createMetadata(String string, String string2, String string3) throws IIOInvalidTreeException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(2), null);
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("tEXt");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("tEXtEntry");
        iIOMetadataNode2.setAttribute("keyword", commentKey_);
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("tEXtEntry");
        iIOMetadataNode3.setAttribute("keyword", paramsKey_);
        iIOMetadataNode3.setAttribute("value", string2);
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("tEXtEntry");
        iIOMetadataNode4.setAttribute("keyword", colorGuideKey_);
        iIOMetadataNode4.setAttribute("value", string3);
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("javax_imageio_png_1.0");
        iIOMetadataNode5.appendChild(iIOMetadataNode);
        iIOMetadata.mergeTree("javax_imageio_png_1.0", iIOMetadataNode5);
        return iIOMetadata;
    }

    public static String[] getMetadataComment_Parms_ColorsStrings(ImageInputStream imageInputStream) throws Exception {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            Node node = iIOMetadata.getAsTree("javax_imageio_png_1.0");
            String[] stringArray = new String[]{FTIO.findTextNodeValue(node, commentKey_), FTIO.findTextNodeValue(node, paramsKey_), FTIO.findTextNodeValue(node, colorGuideKey_)};
            return stringArray;
        }
        return null;
    }

    public static String findTextNodeValue(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"tEXt".equals(node2.getNodeName())) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                String string2;
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equals("tEXtEntry") || !string.equals(string2 = node3.getAttributes().getNamedItem("keyword").getNodeValue())) continue;
                return node3.getAttributes().getNamedItem("value").getNodeValue();
            }
        }
        return null;
    }

    public static String getFileExtension(File file) {
        Path path = file.toPath();
        return FTIO.getFileExtension(path);
    }

    public static String getFileExtension(Path path) {
        String string = path.getFileName().toString();
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return null;
    }
}

