/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import us.lystad.fractaltop.ColorGuideEditor;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.ParmFrame;
import us.lystad.fractaltop.Properties;

public class FTFileChooser {
    private final String defaultDirectoryKey_ = "FractalTopDefaultDirectory";
    private String myDefaultDirectoryKey_ = "";
    private JFrame parent_ = null;
    private JFileChooser dialog_ = null;
    private JFileChooser dialogWithPreview_ = null;
    private FTFileFilter fileFilter_ = null;

    public FTFileChooser(JFrame jFrame) {
        this(jFrame, null);
    }

    public FTFileChooser(JFrame jFrame, String string) {
        this.parent_ = jFrame;
        this.myDefaultDirectoryKey_ = string == null || string.trim().length() == 0 ? "FractalTopDefaultDirectory" + (Serializable)(this.parent_ instanceof FTWindow ? Integer.valueOf(((FTWindow)this.parent_).frameNumber()) : (this.parent_ instanceof ParmFrame ? "_parms" : (this.parent_ instanceof ColorGuideEditor ? "_colorEd" : ""))) : "FractalTopDefaultDirectory" + string;
        String string2 = Properties.getProperty(this.myDefaultDirectoryKey_);
        if (string2 == null || string2.length() == 0) {
            string2 = System.getenv("user.home");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = System.getenv("HOME");
        }
        File file = null;
        if (string2 != null && string2.length() != 0) {
            try {
                file = new File(string2);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTFileChooser.<constructor>: " + FTCentral.getExceptionSynopsis(throwable), false);
            }
        }
        this.fileFilter_ = new FTFileFilter();
        this.dialogWithPreview_ = new JFileChooser();
        this.dialogWithPreview_.setAccessory(new ImagePreview(this.dialogWithPreview_));
        this.dialogWithPreview_.addChoosableFileFilter(this.fileFilter_);
        this.dialogWithPreview_.setAcceptAllFileFilterUsed(false);
        this.dialog_ = new JFileChooser();
        this.dialog_.addChoosableFileFilter(this.fileFilter_);
        this.dialog_.setAcceptAllFileFilterUsed(false);
        if (file != null) {
            this.dialogWithPreview_.setCurrentDirectory(file.getAbsoluteFile());
            this.dialog_.setCurrentDirectory(file.getAbsoluteFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDirectory() {
        LookAndFeel lookAndFeel = null;
        try {
            lookAndFeel = UIManager.getLookAndFeel();
            File file = null;
            String string = Properties.getProperty(this.myDefaultDirectoryKey_);
            if (string != null && string.length() != 0 && !(file = new File(string)).exists()) {
                file = null;
            }
            if (file == null) {
                file = FileSystemView.getFileSystemView().getHomeDirectory();
            }
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setDialogTitle("Choose a directory");
            jFileChooser.setFileSelectionMode(1);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(jFileChooser);
            int n = jFileChooser.showSaveDialog(this.parent_);
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this.parent_);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                Properties.setProperty(this.myDefaultDirectoryKey_, file2.getPath());
                File file3 = file2;
                return file3;
            }
            FTCentral.message("No directory selected.", false);
        }
        catch (Throwable throwable) {
            FTCentral.message("FTFileChooser.getDirectory ERROR: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            if (UIManager.getLookAndFeel() != lookAndFeel) {
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public String getReadFilename(String string, boolean bl) {
        File file = this.getReadFile(string, bl);
        return file == null ? null : file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getReadFile(String string, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            File file;
            lookAndFeel = UIManager.getLookAndFeel();
            JFileChooser jFileChooser = bl ? this.dialogWithPreview_ : this.dialog_;
            JFileChooser jFileChooser2 = bl ? this.dialog_ : this.dialogWithPreview_;
            this.fileFilter_.setSuffixes(string);
            jFileChooser.setDialogTitle("Read file");
            jFileChooser.setDragEnabled(true);
            jFileChooser.setFileSelectionMode(0);
            String string2 = Properties.getProperty(this.myDefaultDirectoryKey_);
            if (string2 != null && string2.length() != 0 && (file = new File(string2)).exists()) {
                jFileChooser.setCurrentDirectory(file.getAbsoluteFile());
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(jFileChooser);
            int n = jFileChooser.showOpenDialog(this.parent_);
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this.parent_);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                jFileChooser2.setSelectedFile(file2);
                File file3 = jFileChooser.getCurrentDirectory();
                Properties.setProperty(this.myDefaultDirectoryKey_, file3.getPath());
                jFileChooser.setSelectedFile(null);
                jFileChooser2.setSelectedFile(null);
                File file4 = file2;
                return file4;
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("Internal ERROR in FTFileChooser.getReadFile: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            if (UIManager.getLookAndFeel() != lookAndFeel) {
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public String getWriteFilename(String string, boolean bl) {
        File file = this.getSaveFile(string, bl);
        return file == null ? null : file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getSaveFile(String string, boolean bl) {
        LookAndFeel lookAndFeel = null;
        try {
            File file;
            lookAndFeel = UIManager.getLookAndFeel();
            JFileChooser jFileChooser = bl ? this.dialogWithPreview_ : this.dialog_;
            JFileChooser jFileChooser2 = bl ? this.dialog_ : this.dialogWithPreview_;
            this.fileFilter_.setSuffixes(string);
            jFileChooser.setDialogTitle("Write file");
            jFileChooser.setDragEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            String string2 = Properties.getProperty(this.myDefaultDirectoryKey_);
            if (string2 != null && string2.length() != 0 && (file = new File(string2)).exists()) {
                jFileChooser.setCurrentDirectory(file.getAbsoluteFile());
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(jFileChooser);
            int n = jFileChooser.showSaveDialog(this.parent_);
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this.parent_);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                if (file2.exists()) {
                    FTFileChooser.backupExistingFile(file2, this.parent_);
                }
                jFileChooser2.setSelectedFile(file2);
                File file3 = jFileChooser.getCurrentDirectory();
                Properties.setProperty(this.myDefaultDirectoryKey_, file3.getPath());
                jFileChooser.setSelectedFile(null);
                jFileChooser2.setSelectedFile(null);
                File file4 = file2;
                return file4;
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("Internal ERROR in FTFileChooser.getSaveFile: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            if (UIManager.getLookAndFeel() != lookAndFeel) {
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Throwable throwable) {}
            }
        }
        return null;
    }

    public static boolean backupExistingFile(File file, JFrame jFrame) {
        String string = file.getPath();
        try {
            File file2 = null;
            int n = 250;
            if (new File(string + ".~" + n + "~").exists()) {
                int n2 = 1;
                while ((file2 = new File(string + ".~" + n2 + "~")).exists()) {
                    if (n2++ <= n) continue;
                    throw new IOException("Excessive backup versions exist - no write done.");
                }
            } else {
                int n3;
                for (n3 = 250; n3 > 0 && !new File(string + ".~" + n3 + "~").exists(); --n3) {
                }
                file2 = new File(string + ".~" + n3 + "~");
                file.renameTo(file2);
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("Unable to create backup version of " + string + FTCentral.getExceptionSynopsis(throwable), true);
        }
        return true;
    }

    public static class FTFileFilter
    extends FileFilter {
        ArrayList<String> acceptableSuffix_ = new ArrayList();
        String separator_ = ",";

        public void setSuffixes(String string) {
            String string2;
            int n = 0;
            int n2 = -1;
            int n3 = string.length();
            this.acceptableSuffix_.clear();
            while ((n2 = string.indexOf(this.separator_, n)) >= 0) {
                string2 = string.substring(n, n2);
                this.acceptableSuffix_.add(string2.trim().toLowerCase());
                n = Math.min(n2 + 1, n3 - 1);
            }
            if (n < string.length()) {
                string2 = string.substring(n, n3);
                this.acceptableSuffix_.add(string2.trim().toLowerCase());
            }
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            for (String string2 : this.acceptableSuffix_) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.contentString();
        }

        public String toString() {
            return "<FileFilter for " + this.contentString() + ">";
        }

        private String contentString() {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : this.acceptableSuffix_) {
                    stringBuilder.append(string + ", ");
                }
                if (stringBuilder.length() > 2) {
                    stringBuilder.setLength(stringBuilder.length() - 2);
                }
                return stringBuilder.toString();
            }
            catch (Throwable throwable) {
                return "Theoretically impossible Error in ColorGuideEditor.EditorImageFilter.contentString";
            }
        }
    }

    static class ImagePreview
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon thumbnail_ = null;
        File file = null;

        public ImagePreview(JFileChooser jFileChooser) {
            this.setPreferredSize(new Dimension(100, 50));
            jFileChooser.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.file == null) {
                this.thumbnail_ = null;
                return;
            }
            ImageIcon imageIcon = new ImageIcon(this.file.getPath());
            this.thumbnail_ = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : (imageIcon.getIconHeight() > 50 ? new ImageIcon(imageIcon.getImage().getScaledInstance(-1, 50, 1)) : imageIcon);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                this.file = null;
                bl = true;
            } else if ("SelectedFileChangedProperty".equals(string)) {
                this.file = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
            if (bl) {
                this.thumbnail_ = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.thumbnail_ == null) {
                this.loadImage();
            }
            if (this.thumbnail_ != null) {
                int n = this.getWidth() / 2 - this.thumbnail_.getIconWidth() / 2;
                int n2 = this.getHeight() / 2 - this.thumbnail_.getIconHeight() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n < 5) {
                    n = 5;
                }
                this.thumbnail_.paintIcon(this, graphics, n, n2);
            }
        }
    }
}

