/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JPopupMenu;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.ColorGuideEditor;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTFileChooser;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FastQuaternion;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.MsgFrame;
import us.lystad.fractaltop.ParmFrame;
import us.lystad.fractaltop.Properties;
import us.lystad.fractaltop.TrapFrame;

public class FTCentral
extends Frame {
    private static FTCentral self_;
    public static final String appName = "FrctlTop";
    public static final String oldAppName = "JavaQuat";
    public static final int defaultWidth = 550;
    public static final int defaultHeight = 550;
    private static final int NOTHING = 0;
    private static final int MOUSE_H_AXIS_NEEDS_2_PTS = 3;
    private static final int MOUSE_H_AXIS_NEEDS_1_PT = 4;
    private static final int MOUSE_V_AXIS_NEEDS_2_PTS = 5;
    private static final int MOUSE_V_AXIS_NEEDS_1_PT = 6;
    public static final int IMAGE_FRAME = 0;
    public static final int PARM_FRAME = 1;
    public static final int TRAP_FRAME = 3;
    public String package_;
    private int awaiting_ = 0;
    private Dimension firstXY_ = new Dimension(0, 0);
    private ArrayList<FTWindow> frameList_ = new ArrayList(10);
    private int frameNumber_ = 1;
    private static MsgFrame msgFrame_;
    private HashMap<String, FTLooper> loopers_ = new HashMap(150);
    private FTWindow activeFrame_;
    private Window parmFrameSetBy_ = null;
    private FTCanvas activeCanvas_ = null;
    private ParmFrame parmFrame_;
    private TrapFrame trapFrame_ = null;
    private int lastWidth_ = 400;
    private int lastHeight_ = 400;
    private int lastActiveWindow_ = 0;
    private int lastImageWindow_ = 0;
    private ColorGuideEditor colorGuideEditor_ = null;
    private boolean parmFrameNeverInitializedP_ = true;
    private boolean logging_ = false;
    private boolean write2URLP_ = false;
    private boolean userWantsToAddCOmmentP_ = false;
    private String logPathname_ = null;
    private int logEntryNumber_ = 0;
    private boolean setColorMapWhenReadingTrapImageP_ = true;
    private int enlargePixels_;
    private int rightPixels_;
    private int downPixels_;
    private int onWPixels_;
    private Date last_time_;
    private int last_color_map_index_ = -1;
    private static HashMap<String, String> documentation_;
    private boolean debugP_ = false;

    public FTCentral(String[] stringArray) {
        self_ = this;
        this.package_ = this.getClass().getPackage().toString();
        new Properties();
        if (this.package_.startsWith("package")) {
            this.package_ = this.package_.substring("package".length() + 1);
        }
        msgFrame_ = new MsgFrame("Messages", 600, 660);
        this.parmFrame_ = new ParmFrame(this);
        this.parmFrame_.setVisible(false);
        this.activeFrame_ = new FTWindow(this, 550, 550);
        this.activeCanvas_ = this.activeFrame_.canvas();
        this.setParameters(this.activeFrame_.canvas().spec());
        String string = this.getParmFrameLooperName();
        FTLooper fTLooper = this.findLoopObject(string);
        if (fTLooper != null) {
            this.setLooperDefaults(fTLooper);
            this.parametersToCanvas(this.activeCanvas_);
        }
        this.frameList_.add(this.activeFrame_);
        this.last_time_ = new Date();
        this.parmFrame_.addToWindowsMenu(this.activeFrame_);
        this.colorGuideEditor_ = new ColorGuideEditor(this);
        this.colorGuideEditor_.addToPortMenus(this.activeFrame_);
        this.colorGuideEditor_.exportColorSet("New Standard", this.activeFrame_);
        this.readDocumentationFile();
        this.trapFrame_ = new TrapFrame(this);
        this.activeFrame_.setVisible(true);
    }

    public boolean setDebugP(boolean bl) {
        boolean bl2 = this.debugP_;
        this.debugP_ = bl;
        return bl2;
    }

    public boolean debugP() {
        return this.debugP_;
    }

    public int enlargePixels() {
        return this.enlargePixels_;
    }

    public void setEnlargePixels(int n) {
        this.enlargePixels_ = n;
    }

    public int rightPixels() {
        return this.rightPixels_;
    }

    public void setRightPixels(int n) {
        this.rightPixels_ = n;
    }

    public int downPixels() {
        return this.downPixels_;
    }

    public void setDownPixels(int n) {
        this.downPixels_ = n;
    }

    public int onWPixels() {
        return this.onWPixels_;
    }

    public void setOnWPixels(int n) {
        this.onWPixels_ = n;
    }

    public void readParms(boolean bl, int n) {
        this.activeFrame_.readParms(bl, n);
    }

    public boolean writeParms(boolean bl, String string) {
        return this.activeFrame_.writeParms(bl, string);
    }

    public void saveActiveCounts() {
        this.activeFrame_.writeCountsCSV();
    }

    public String getParmFrameLooperName() {
        return this.parmFrame_.getParmFrameLooperName();
    }

    public void setLoooper4ParmFrame(String string) {
        if (this.parmFrame_ != null && this.parmFrame_.importLooper(string)) {
            this.whatsDrawnToFrame(this.activeFrame_);
        }
    }

    public void setLooperDefaults(FTLooper fTLooper) {
        this.parmFrame_.setLooperDefaults(fTLooper);
    }

    public boolean toggleLogging(boolean bl) {
        if (bl) {
            FTFileChooser fTFileChooser = new FTFileChooser(this.activeFrame_);
            this.logPathname_ = fTFileChooser.getWriteFilename("text, txt", false);
            if (this.logPathname_ == null) {
                bl = false;
                this.parmFrame_.setLogging(false);
                FTCentral.message("Logging toggled back off.", false);
                return false;
            }
            if (!this.logPathname_.endsWith(".text") && !this.logPathname_.endsWith(".txt")) {
                this.logPathname_ = this.logPathname_ + ".text";
            }
        }
        if (this.logging_ != bl) {
            this.logging_ = bl;
            this.parmFrame_.setLogging(this.logging_);
            for (FTWindow fTWindow : this.frameList_) {
                fTWindow.setLogging(this.logging_);
            }
        }
        return true;
    }

    public boolean loggingP() {
        return this.logging_;
    }

    public synchronized void writeToLog(FractalSpec fractalSpec) {
        String string = null;
        if (this.userWantsToAddCOmmentP()) {
            string = this.activeFrame_.getUserComment();
        }
        Object object = "";
        if (this.logEntryNumber_ > 0) {
            object = "\n\n";
        }
        object = (String)object + fractalSpec.toString(this.logEntryNumber_++, string);
        try {
            FileWriter fileWriter = new FileWriter(this.logPathname_, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write((String)object);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            FTCentral.message("FTCentral.writeToLog: ERROR: " + FTCentral.getExceptionSynopsis(iOException), true);
        }
    }

    public boolean toggleWrite2URLP(boolean bl) {
        if (this.write2URLP_ != bl) {
            this.write2URLP_ = bl;
            this.parmFrame_.setWrite2URLP(bl);
            for (FTWindow fTWindow : this.frameList_) {
                fTWindow.setWrite2URLP(bl);
            }
        }
        return true;
    }

    public void setWrite2URLP(boolean bl) {
        this.write2URLP_ = bl;
    }

    public boolean write2URLP() {
        return this.write2URLP_;
    }

    public void toggleUserWantsToAddCommentP(boolean bl) {
        if (this.userWantsToAddCOmmentP_ != bl) {
            this.userWantsToAddCOmmentP_ = bl;
            this.parmFrame_.setUserWantsToAddCommentP(bl);
            for (FTWindow fTWindow : this.frameList_) {
                fTWindow.setUserWantsToAddCommentP(bl);
            }
        }
    }

    public void setUserWantsToAddCOmmentP(boolean bl) {
        this.userWantsToAddCOmmentP_ = bl;
    }

    public boolean userWantsToAddCOmmentP() {
        return this.userWantsToAddCOmmentP_;
    }

    public void swapHV() {
        this.parmFrame_.swapHV();
    }

    public void rotate90R() {
        this.parmFrame_.rotate90R();
    }

    public void rotateClockwise(double d) {
        this.parmFrame_.rotateClockwise(d);
    }

    public void rotate90L() {
        this.parmFrame_.rotate90L();
    }

    public void w2H() {
        this.parmFrame_.w2H();
    }

    public void w2V() {
        this.parmFrame_.w2V();
    }

    public void h2MemH() {
        this.parmFrame_.h2MemH();
    }

    public void v2MemV() {
        this.parmFrame_.v2MemV();
    }

    public void memH2H() {
        this.parmFrame_.memH2H();
    }

    public void memV2V() {
        this.parmFrame_.memV2V();
    }

    public void drawActiveCanvas() {
        this.activeFrame_.draw();
    }

    public boolean activeCanvasEverFinishedP() {
        return this.activeCanvas_.everFinishedP();
    }

    public void openImage() {
        this.activeFrame_.openImage();
    }

    public void saveImage() {
        this.activeFrame_.saveImage();
    }

    public void pauseActiveCanvas() {
        this.activeCanvas_.stop();
    }

    public void setCheckBoxValues4Frame(FractalSpec fractalSpec) {
        this.activeFrame_.setCheckBoxValues(fractalSpec);
    }

    public void adjustEnlarge(int n) {
        this.activeFrame_.adjustEnlarge(n);
    }

    public void adjustCenterRight(int n) {
        this.activeFrame_.adjustCenterRight(n);
    }

    public void adjustCenterUp(int n) {
        this.activeFrame_.adjustCenterUp(n);
    }

    public void adjustCenterOnW(int n) {
        this.activeFrame_.adjustCenterOnW(n);
    }

    public void openTrapImage() {
        this.openTrapImage(null);
    }

    public void openTrapImage(String string) {
        this.trapFrame_.openGIFImage(string, this.write2URLP_, this.setColorMapWhenReadingTrapImageP_);
        if (this.trapFrame_.readyP() && this.activeCanvas_ != null) {
            this.activeCanvas_.set_other_change_requires_redraw_p(true);
        }
    }

    public void setTrapImage(BufferedImage bufferedImage, String string) {
        this.trapFrame_.setTrapImage(bufferedImage, string);
    }

    public static TrapFrame getTrapFrame_static() {
        return self_.getTrapFrame();
    }

    public TrapFrame getTrapFrame() {
        return this.trapFrame_;
    }

    void timeToQuit() {
        Properties.saveDictionary();
        System.exit(0);
    }

    ArrayList<FTWindow> activeFrames() {
        return new ArrayList<FTWindow>(this.frameList_);
    }

    int activeFrameCount() {
        return this.frameList_.size();
    }

    int frameCount() {
        return this.frameNumber_;
    }

    public FTWindow getFrame(int n) {
        for (int i = 0; i < this.activeFrameCount(); ++i) {
            if (this.frameList_.get(i).frameNumber() != n) continue;
            return this.frameList_.get(i);
        }
        return null;
    }

    public int getFrameNumberOrNext(int n) {
        int n2 = this.frameList_.get(0).frameNumber();
        for (int i = 0; i < this.activeFrameCount(); ++i) {
            int n3 = this.frameList_.get(i).frameNumber();
            if (n3 == n) {
                return n;
            }
            if (n2 > n) {
                if (n3 >= n2) continue;
                n2 = n3;
                continue;
            }
            if (n3 >= n2 && n3 <= n) continue;
            n2 = n3;
        }
        return n2;
    }

    public boolean compatibleForZoomP(int n, int n2) {
        FTWindow fTWindow = this.getFrame(n);
        FTWindow fTWindow2 = this.getFrame(n2);
        if (fTWindow == null) {
            FTCentral.message("There is no window #" + n, true);
        }
        if (fTWindow2 == null) {
            FTCentral.message("There is no window #" + n, true);
        }
        return fTWindow != null && fTWindow2 != null && fTWindow.compatibleForZoomP(fTWindow2);
    }

    synchronized int incFrameCount() {
        return this.frameNumber_++;
    }

    void removeFrame(FTWindow fTWindow) {
        if (this.frameList_.size() > 1) {
            this.frameList_.remove(fTWindow);
            this.parmFrame_.removeFromWindowMenu(fTWindow.frameNumber());
            this.colorGuideEditor_.removeFromPortsMenus(fTWindow.frameNumber());
            for (FTWindow fTWindow2 : this.frameList_) {
                if (fTWindow2 == fTWindow) continue;
                fTWindow2.removeFromWindowMenu(fTWindow.frameNumber());
            }
            if (this.activeFrame_ == fTWindow) {
                FractalSpec fractalSpec = new FractalSpec();
                this.activeFrame_ = this.frameList_.get(0);
                this.activeFrame_.getCheckBoxValues(fractalSpec);
                this.parmFrame_.setCheckBoxValues(fractalSpec);
            }
            fTWindow.dispose();
            try {
                this.activateMe(this.activeFrame_);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void makeNewFrame(FTWindow fTWindow) {
        FTWindow fTWindow2 = this.activeFrame_;
        Dimension dimension = this.parmFrame_.exportWH();
        if (dimension.getWidth() * dimension.getHeight() == 0.0) {
            dimension = fTWindow2.getSize();
        } else {
            this.lastWidth_ = (int)dimension.getWidth();
            this.lastHeight_ = (int)dimension.getHeight();
        }
        FTWindow fTWindow3 = new FTWindow(this, this.lastWidth_, this.lastHeight_);
        this.frameList_.add(fTWindow3);
        this.parmsSpecToWindow(fTWindow3);
        this.flagsToFrame(fTWindow3);
        this.whatsDrawnToFrame(fTWindow3);
        if (fTWindow != null) {
            this.setLocationRelativeTo(fTWindow2, fTWindow3, true);
        } else {
            this.setLocationRelativeTo(this.parmFrame_, fTWindow3, true);
        }
        Color[] colorArray = fTWindow2.canvas().getColorGuideCopy();
        fTWindow3.canvas().setColorGuide(colorArray);
        fTWindow3.setVisible(true);
        this.parmFrame_.addToWindowsMenu(fTWindow3);
        this.colorGuideEditor_.addToPortMenus(fTWindow3);
        for (FTWindow fTWindow4 : this.frameList_) {
            if (fTWindow4 == fTWindow3) continue;
            fTWindow4.addToWindowsMenu(fTWindow3);
            fTWindow3.addToWindowsMenu(fTWindow4);
        }
    }

    public void showTrapFrameInColorSetEditor(boolean bl) {
        this.colorGuideEditor_.addTrapFrameToPortMenus(bl);
    }

    public static void simpleMessage(String string) {
        msgFrame_.addMessageLn(string);
    }

    public static void message(String string, boolean bl) {
        String string2 = DateFormat.getDateTimeInstance(2, 2).format(new Date());
        msgFrame_.addMessageLn("(" + string2 + ") - " + string);
        if (bl) {
            if (!msgFrame_.isVisible()) {
                msgFrame_.setVisible(true);
            }
            msgFrame_.toFront();
        }
    }

    public void messagePlusTime(String string, boolean bl) {
        msgFrame_.addMessageLn(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Above message at: ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        Date date = new Date();
        stringBuilder.append(dateFormat.format(date) + "\n");
        if (bl && !msgFrame_.isVisible()) {
            msgFrame_.setVisible(true);
        }
        msgFrame_.addMessageLn(stringBuilder.toString());
    }

    public void stackTraceMessage(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        msgFrame_.addMessageLn(" ");
        this.messagePlusTime("---- Error occurred: " + throwable.getMessage(), true);
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            msgFrame_.addMessageLn(stackTraceElement.toString());
        }
        msgFrame_.addMessageLn("---- End of trace.");
    }

    boolean messagesVisible_p() {
        return msgFrame_.isVisible();
    }

    public void setMessagesVisible(Window window) {
        if (!msgFrame_.isVisible()) {
            this.setLocationRelativeTo(window, msgFrame_, false);
        }
        msgFrame_.setVisible(true);
        msgFrame_.toFront();
        msgFrame_.setExtendedState(0);
    }

    public String translateLoopName(String string) {
        if (string.equals("CpxPower2")) {
            return "Mandelbrot";
        }
        if (string.equals("Loop22")) {
            return "Mandelbrot";
        }
        if (string.equals("CpxPower3") || string.equals("Mandelcube") || string.equals("Loop23")) {
            return "MandelCube";
        }
        if (string.equals("CpxPower4")) {
            return "Loop24";
        }
        if (string.equals("CpxPower5")) {
            return "Loop25";
        }
        if (string.equals("TetPower2")) {
            return "LoopTetra2";
        }
        if (string.equals("HcxPower2")) {
            return "HcxPower2";
        }
        return string;
    }

    public FTLooper findLoopObject(String string) {
        FTLooper fTLooper = this.loopers_.get(string = this.translateLoopName(string));
        if (fTLooper != null) {
            return fTLooper;
        }
        FTLooper fTLooper2 = null;
        try {
            Class<?> clazz = Class.forName(this.package_ + ".FractalLoops." + string);
            if (clazz != null && FTLooper.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                fTLooper2 = (FTLooper)constructor.newInstance(new Object[0]);
                this.loopers_.put(string, fTLooper2);
                return fTLooper2;
            }
            FTCentral.message("Class " + string + " does not implement the JQLooper interface.", true);
        }
        catch (InstantiationException instantiationException) {
            FTCentral.message("JQCentral.findLoopObject says: \"Error instantiating class " + string + "\"", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            FTCentral.message("JQCentral.findLoopObject says: \"Illegal access to class " + string + "\"", true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FTCentral.message("JQCentral.findLoopObject says: \"Class " + string + " not found.\"", true);
        }
        catch (Throwable throwable) {
            FTCentral.message("JQCentral.findLoopObject ERROR: \"" + FTCentral.getExceptionSynopsis(throwable), true);
        }
        return null;
    }

    private boolean checkParameters() {
        return true;
    }

    public boolean parametersToCanvas(FTCanvas fTCanvas) {
        if (this.checkParameters()) {
            FractalSpec fractalSpec = new FractalSpec(fTCanvas.spec());
            fTCanvas.importParameters(fractalSpec);
            return true;
        }
        return false;
    }

    public void setParameters(FractalSpec fractalSpec) {
        this.setParameters(fractalSpec, null);
    }

    public void setParameters(FractalSpec fractalSpec, Window window) {
        if (fractalSpec == null) {
            fractalSpec = this.activeCanvas_.spec();
        }
        fractalSpec.normalizeAxes();
        this.parmFrame_.importFractalSpec(fractalSpec);
        this.parmFrameSetBy_ = window;
        this.parmFrameNeverInitializedP_ = false;
    }

    public Window getParmsSetBy() {
        return this.parmFrameSetBy_;
    }

    public void parmsSetByHand() {
        this.parmFrameSetBy_ = null;
    }

    public boolean parmsToSpec(FractalSpec fractalSpec) {
        String string;
        if (this.parmFrameNeverInitializedP_) {
            this.setParameters(new FractalSpec(true));
        }
        boolean bl = this.parmFrame_.exportToSpec(fractalSpec);
        fractalSpec.which = this.translateLoopName(fractalSpec.which);
        FTLooper fTLooper = this.findLoopObject(fractalSpec.which);
        if (fTLooper.acceptsTrapGif() && (string = this.trapFrame_.pathname()) != null && string.trim().length() > 0) {
            fractalSpec.trapPathname = string;
        }
        return bl;
    }

    public void windowSpecToParmFrame(FTWindow fTWindow) {
        FractalSpec fractalSpec = new FractalSpec(fTWindow.canvas().spec());
        this.parmFrame_.importFractalSpec(fractalSpec);
    }

    public void parmsSpecToWindow(FTWindow fTWindow) {
        FractalSpec fractalSpec = new FractalSpec();
        this.parmFrame_.exportToSpec(fractalSpec);
        fTWindow.canvas().importParameters(fractalSpec);
    }

    public void flagsToParmFrame() {
        FractalSpec fractalSpec = new FractalSpec();
        this.activeFrame_.exportFlags(fractalSpec);
        this.parmFrame_.importFlags(fractalSpec);
    }

    public void flagsToActiveFrame() {
        this.flagsToFrame(this.activeFrame_);
    }

    public void flagsToFrame(FTWindow fTWindow) {
        FractalSpec fractalSpec = new FractalSpec();
        this.parmFrame_.exportFlags(fractalSpec);
        fTWindow.importFlags(fractalSpec);
    }

    private void whatsDrawnToFrame(FTWindow fTWindow) {
        FractalSpec fractalSpec = new FractalSpec();
        this.parmFrame_.exportWhatsDrawn(fractalSpec);
        fTWindow.importWhatsDrawn(fractalSpec);
    }

    public void whatsDrawnToActiveFrame() {
        this.whatsDrawnToFrame(this.activeFrame_);
    }

    public void whatsDrawnToParmFrame(FTWindow fTWindow) {
        FractalSpec fractalSpec = new FractalSpec();
        fTWindow.exportWhatsDrawn(fractalSpec);
        this.parmFrame_.importWhatsDrawn(fractalSpec);
    }

    public FastQuaternion parmsDAxis() {
        return this.parmFrame_.dAxis();
    }

    public FastQuaternion parmsWAxis() {
        return this.parmFrame_.wAxis();
    }

    public void showParmFrameFor(FTWindow fTWindow) {
        if (fTWindow == null) {
            fTWindow = this.activeFrame_;
        }
        if (fTWindow != this.activeFrame_ || this.parmFrameNeverInitializedP_) {
            FTCanvas fTCanvas = fTWindow.canvas();
            if (fTCanvas == null) {
                FTCentral.message("JQCentral.showParmFramdFor: activeCanvas_ == null.", true);
                return;
            }
            this.parmFrame_.importFractalSpec(fTCanvas.spec());
        }
        if (!this.parmFrame_.isVisible()) {
            this.setLocationRelativeTo(fTWindow, this.parmFrame_, true);
            this.parmFrame_.setVisible(true);
        }
        this.parmFrame_.toFront();
        this.parmFrame_.setExtendedState(0);
        this.parmFrameNeverInitializedP_ = false;
    }

    public void setLocationRelativeTo(Window window, Window window2, boolean bl) {
        int n = 20;
        Point point = window.getLocationOnScreen();
        Dimension dimension = window.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Dimension dimension2 = window2.getSize();
        int n4 = dimension2.width;
        int n5 = dimension2.height;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (bl) {
            if (point.y + n3 + n5 < dimension3.height) {
                window2.setLocation(point.x, point.y + n3);
                return;
            }
            if (point.y >= n5) {
                window2.setLocation(point.x, point.y - n5);
                return;
            }
        }
        if (point.x + n2 + n4 < dimension3.width) {
            window2.setLocation(point.x + n2, point.y);
            return;
        }
        if (point.x >= n4) {
            window2.setLocation(point.x - n4, point.y);
            return;
        }
        if (!bl) {
            if (point.y + n3 + n5 < dimension3.height) {
                window2.setLocation(point.x, point.y + n3);
                return;
            }
            if (point.y >= n5) {
                window2.setLocation(point.x, point.y - n5);
                return;
            }
        }
        int n6 = point.x + (point.x > dimension3.width / 2 ? -n : n);
        int n7 = point.y + (point.y > dimension3.height / 2 ? -n : n);
        if (n6 + n4 > dimension3.width) {
            n6 = Math.max(0, dimension3.width - n4);
        }
        if (n7 + n5 > dimension3.height) {
            n7 = Math.max(0, dimension3.height - n5);
        }
        if (Math.abs(n6 - point.x) < n) {
            n6 = point.x + (point.x >= n ? -n : n);
        }
        if (Math.abs(n7 - point.y) < n) {
            n7 = point.y + (point.y >= n ? -n : n);
        }
        window2.setLocation(n6, n7);
    }

    public void setTrapFrameIsTargetP(boolean bl) {
        if (bl) {
            this.lastActiveWindow_ = 3;
            this.lastImageWindow_ = 3;
        } else {
            this.lastActiveWindow_ = 0;
            this.lastImageWindow_ = 0;
        }
    }

    public void activateParmFrame() {
        if (this.lastActiveWindow_ != 1) {
            FractalSpec fractalSpec = new FractalSpec();
            this.activeFrame_.getCheckBoxValues(fractalSpec);
            this.parmFrame_.setCheckBoxValues(fractalSpec);
            this.lastActiveWindow_ = 1;
        }
    }

    public void activateMe(FTWindow fTWindow) {
        this.activateMe(fTWindow, false);
    }

    public void activateMe(FTWindow fTWindow, boolean bl) {
        if (this.activeFrame_ != null && this.activeFrame_.getTitle().charAt(0) == '*') {
            this.activeFrame_.setTitle(this.activeFrame_.getTitle().substring(2));
        }
        this.activeFrame_ = fTWindow;
        this.activeCanvas_ = this.activeFrame_.canvas();
        if (this.activeFrame_.getTitle().charAt(0) != '*') {
            this.activeFrame_.setTitle("* " + fTWindow.getTitle());
        }
        if (!bl) {
            this.flagsToParmFrame();
        } else {
            this.flagsToActiveFrame();
        }
        this.activeFrame_.setCompiledCodeMenuItem();
        this.lastActiveWindow_ = 0;
        fTWindow.repaint();
    }

    public void setActiveCanvas(FTCanvas fTCanvas) {
        this.activeCanvas_ = fTCanvas;
        this.activeFrame_ = fTCanvas.parent();
    }

    public boolean receivePoint(FTCanvas fTCanvas, FractalSpec fractalSpec, MouseEvent mouseEvent) {
        this.lastImageWindow_ = 0;
        if (fTCanvas != this.activeCanvas_) {
            return false;
        }
        BigQuaternion bigQuaternion = new BigQuaternion();
        if (fractalSpec.rangeOver == 1) {
            bigQuaternion.assign_from(fractalSpec.coeff);
        } else if (fractalSpec.rangeOver == 2) {
            bigQuaternion.assign_from(fractalSpec.trans);
        } else {
            bigQuaternion.assign_from(fractalSpec.center);
        }
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        if (this.awaiting_ == 3) {
            this.firstXY_.setSize(d, d2);
            this.awaiting_ = 4;
            return true;
        }
        if (this.awaiting_ == 5) {
            this.firstXY_.setSize(d, d2);
            this.awaiting_ = 6;
            return true;
        }
        if (this.awaiting_ == 0) {
            this.parmFrame_.importFractalSpec(fractalSpec);
            return false;
        }
        if (this.awaiting_ == 4 || this.awaiting_ == 6) {
            double d3;
            double d4;
            double d5 = d - this.firstXY_.getWidth();
            double d6 = this.firstXY_.getHeight() - d2;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            if (this.awaiting_ == 4) {
                d4 = d5 / d7;
                d3 = d6 / d7;
            } else {
                d4 = d6 / d7;
                d3 = -d5 / d7;
            }
            FastQuaternion fastQuaternion = fractalSpec.vx.times_scalar(d4).plus(fractalSpec.vy.times_scalar(d3));
            FastQuaternion fastQuaternion2 = fractalSpec.vy.times_scalar(d4).minus(fractalSpec.vx.times_scalar(d3));
            fastQuaternion.normalize_n();
            if (fastQuaternion2.normalizePerpendicularTo(fastQuaternion)) {
                this.parmFrame_.setHandVAxes(fastQuaternion, fastQuaternion2);
            } else {
                FTCentral.message("FTCentral.receivePoint H: Problem setting axes.", true);
            }
            this.awaiting_ = 0;
            return true;
        }
        return false;
    }

    public void setParmFramePanelFields(int n, int n2, int n3) {
        this.parmFrame_.setPanelFields(n, n2, n3);
    }

    public void setParmFrameRange(double d) {
        this.parmFrame_.setRange(d);
    }

    public void scaleVAxis(double d) {
        this.parmFrame_.scaleVAxis(d);
    }

    public int parmFramePanels() {
        return this.parmFrame_.numberOfPanels();
    }

    public int parmFramePixelsWide() {
        return this.parmFrame_.pixelsWide();
    }

    public int parmFramePixelsHigh() {
        return this.parmFrame_.pixelsHigh();
    }

    public void mouseNewVAxis() {
        this.awaiting_ = 5;
    }

    public void mouseNewHAxis() {
        this.awaiting_ = 3;
    }

    public void setHVRatio(Dimension dimension) {
        this.parmFrame_.setHVRatio(dimension);
    }

    public Dimension getHVRatio() {
        return this.parmFrame_.getHVRatio();
    }

    public int findOrbitTargetFor(FTWindow fTWindow) {
        double d = fTWindow.getSpec().getRange();
        String string = fTWindow.getSpec().getWhichFractal();
        FTWindow fTWindow2 = fTWindow;
        for (FTWindow fTWindow3 : this.frameList_) {
            if (!fTWindow3.getSpec().getWhichFractal().equals(string) || !(fTWindow3.getSpec().getRange() > d)) continue;
            fTWindow2 = fTWindow3;
        }
        return fTWindow2.frameNumber();
    }

    public void boxCountInColorMapEditor(int n) {
        if (this.colorGuideEditor_.isVisible()) {
            this.colorGuideEditor_.setBoxIndex(n);
        }
    }

    public void showColorGuideEditor(FTWindow fTWindow) {
        if (fTWindow == null) {
            fTWindow = this.activeFrame_;
        }
        if (!this.colorGuideEditor_.isVisible()) {
            this.setLocationRelativeTo(fTWindow, this.colorGuideEditor_, false);
            this.colorGuideEditor_.setVisible(true);
        }
        this.colorGuideEditor_.toFront();
        this.colorGuideEditor_.setExtendedState(0);
    }

    public void showTrapFrame() {
        if (!this.trapFrame_.isVisible()) {
            this.setLocationRelativeTo(this.activeFrame_, this.trapFrame_, false);
            this.trapFrame_.setVisible(true);
        }
        this.trapFrame_.setExtendedState(0);
        this.trapFrame_.toFront();
    }

    public String trapPathname() {
        if (this.trapFrame_ != null) {
            return this.trapFrame_.pathname();
        }
        return null;
    }

    public static String getExceptionSynopsis(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = throwable;
        while (throwable3 != null && (throwable2 = throwable3.getCause()) != null) {
            throwable3 = throwable2;
        }
        Object object = throwable3 == null ? "null exception mistake" : throwable3.getClass().getSimpleName();
        try {
            int n;
            StackTraceElement stackTraceElement;
            int n2;
            if (throwable3 != null) {
                object = (String)object + "  " + throwable3.getMessage();
            }
            StackTraceElement[] stackTraceElementArray = throwable == null ? new StackTraceElement[]{} : throwable.getStackTrace();
            String string = null;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n3 = stackTraceElementArray2.length;
            for (n2 = 0; n2 < n3 && !(string = (stackTraceElement = stackTraceElementArray2[n2]).toString()).contains("us.lystad.fractaltop"); ++n2) {
            }
            if (string != null && string.length() > 1 && (n2 = string.lastIndexOf(".", (n3 = string.lastIndexOf(".", (n = string.indexOf("(")) == -1 ? string.length() - 1 : n)) >= 1 ? n3 - 1 : string.length() - 1)) >= 0 && n2 + 1 < string.length()) {
                string = string.substring(n2 + 1);
            }
            return (String)object + " AT " + string;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            return object;
        }
    }

    private void readDocumentationFile() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("resources/documentation.text");){
            if (inputStream != null) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string2 = null;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().startsWith("//")) continue;
                    if (string.startsWith("*")) {
                        if (string2 != null) {
                            documentation_.put(string2, stringBuilder.toString());
                        }
                        string2 = string.substring(1);
                        stringBuilder = new StringBuilder();
                        continue;
                    }
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
                if (string2 != null) {
                    documentation_.put(string2, stringBuilder.toString());
                }
            } else {
                FTCentral.message("FTCentral.readDocumentationFile - File not found!", true);
            }
        }
        catch (IOException iOException) {
            FTCentral.message("FTCentral.readDocumentationFile Error: " + FTCentral.getExceptionSynopsis(iOException), true);
        }
    }

    public static String findDocString(String string) {
        try {
            String string2 = documentation_.get(string);
            return string2;
        }
        catch (Throwable throwable) {
            return "This is a CATCH stub from FTCentral.findDocString.";
        }
    }

    public static void setLocationRelativeToActiveFrame(Dialog dialog) {
        self_.setLocationRelativeToActiveFrameNonStatic(dialog);
    }

    public void setLocationRelativeToActiveFrameNonStatic(Dialog dialog) {
        dialog.setLocationRelativeTo(this.activeFrame_);
    }

    public static void setBusyCursor(EventObject eventObject, boolean bl) {
        Object object = eventObject.getSource();
        if (object instanceof Component) {
            Window window = FTCentral.getWindowAncestor((Component)object);
            if (window != null) {
                Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
                window.setCursor(cursor);
            } else {
                FTCentral.message("REMOVE ME from FTCentral.setBusyCursor(EventObject, boolean).", true);
            }
        }
    }

    public static Window getWindowAncestor(Component component) {
        while (component != null && !(component instanceof Window)) {
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        return component == null ? null : (Window)component;
    }

    public static void setBusyCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursor(Component component) {
        component.setCursor(Cursor.getDefaultCursor());
    }

    static {
        documentation_ = new HashMap();
    }
}

