/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JPanel;
import us.lystad.fractaltop.BigQuaternion;
import us.lystad.fractaltop.ColorMapOwner;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTIO;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.FractalLoops.FTLooper;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.GIFDecoderPkg.RGBxSizeSequence;
import us.lystad.fractaltop.GIFEncoderPkg.GIFEncoder;
import us.lystad.fractaltop.LiveOrbitReporter;
import us.lystad.fractaltop.OrbitXYListener;
import us.lystad.fractaltop.PosByte;
import us.lystad.fractaltop.Properties;
import us.lystad.fractaltop.Q1ImageProducer;
import us.lystad.fractaltop.Q2ImageProducer;
import us.lystad.fractaltop.Q3ImageProducer;
import us.lystad.fractaltop.QtoPixelPoint;
import us.lystad.fractaltop.RatioDialog;
import us.lystad.fractaltop.SeqSpec;
import us.lystad.fractaltop.TransferCMap;
import us.lystad.fractaltop.TransferableImage;
import us.lystad.fractaltop.TrapFrame;
import us.lystad.fractaltop.TrapImageProducer;

class FTCanvas
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener,
ClipboardOwner,
TransferCMap {
    static final int bitsPerByte_ = 8;
    public static final int NOiMAGE = 0;
    public static final int COMPUTED = 1;
    public static final int LOADgIF = 2;
    public static final int LOADpNG = 3;
    public static final int LOADfTR = 4;
    static final Color chartreuse = new Color(127, 255, 0);
    static final Color green = new Color(0, 255, 0);
    static final Color skyBlue1 = new Color(135, 206, 255);
    static final Color steelBlue1 = new Color(99, 184, 255);
    static final Color violet = new Color(148, 0, 211);
    static final Color blueviolet = new Color(138, 43, 226);
    private final FTCentral fTCentral_;
    private final FTWindow fTWindow_;
    private final Stack<OrbitXYListener> traceOrbitDialogList_;
    int who_am_i_;
    private FractalSpec spec_;
    TraceThread liveTraceOrbitThread_;
    private int max_minutes_per_row_ = 45;
    private final int maskBase_ = 255;
    Thread runner_;
    private Color indicatorColor_ = Color.RED;
    private boolean sendCountToColorGuideEditor_ = false;
    private int typeOfImagePreparation_ = 0;
    private boolean useHighPrecisionP_ = false;
    private boolean useCompiledLoopP_ = false;
    private QtoPixelPoint converter_;
    private boolean parameter_change_p_ = false;
    private boolean ever_started_p_ = false;
    private boolean ever_finished_p_ = false;
    private boolean other_change_requires_redraw_p_ = false;
    private int orbitSpotCount_;
    private Color orbitFirstColor_;
    private Color orbitPrevColor_;
    static int min_pix_width_ = 20;
    int h_offset_ = 0;
    int v_offset_ = 0;
    int drag_anchor_x = -1;
    int drag_anchor_y = -1;
    private int lastBoxMinX_ = -1;
    private int lastBoxMinY_ = -1;
    private int lastBoxMaxX_ = -1;
    private int lastBoxMaxY_ = -1;
    private boolean lastBoxPreserved_ = false;
    private boolean dragUnderwayP_ = false;
    private boolean boxDragUnderwayP_ = false;
    private boolean mouseDownP_ = false;
    boolean drawBox_p = false;
    boolean drawCross_p = false;
    int box_low_x;
    int box_low_y;
    int box_hi_x;
    int box_hi_y;
    boolean drawPolygon_p_ = false;
    ArrayList<Point> polygonPoints_ = new ArrayList();
    ArrayList<OrbitSpotSpec> orbitSpots_ = new ArrayList();
    ArrayList<OrbitSpotSpec> orbitSpotsWaitingToBeDrawn_ = new ArrayList();
    int colorsForGIF_ = 256;
    int colors = 256;
    private Color[] color_guide_ = new Color[this.colors];
    private Color[] pendingColorGuide_ = null;
    private final byte[] reds = new byte[this.colorsForGIF_];
    private final byte[] greens = new byte[this.colorsForGIF_];
    private final byte[] blues = new byte[this.colorsForGIF_];
    ColorModel colorModel;
    DirectColorModel colorModelDirect_;
    IndexColorModel colorModel256_;
    Q1ImageProducer fractalProducer_ = null;
    private BufferedImage refresher_ = null;
    private boolean liveOrbitStoppedByUserP_ = false;
    private int orbitOnlyPaintModulus_ = 5;
    private int orbitOnlyPaintCount_ = 0;

    public void set_other_change_requires_redraw_p(boolean bl) {
        this.other_change_requires_redraw_p_ = bl;
    }

    public boolean useHighPrecisionP() {
        return this.useHighPrecisionP_;
    }

    public boolean liveOrbitStoppedByUserP() {
        return this.liveOrbitStoppedByUserP_;
    }

    public void setBoxInColorEditor() {
        this.sendCountToColorGuideEditor_ = true;
    }

    FTCanvas(FTCentral fTCentral, FTWindow fTWindow, int n) {
        this.fTCentral_ = fTCentral;
        this.fTWindow_ = fTWindow;
        this.who_am_i_ = n;
        this.spec_ = new FractalSpec(true);
        this.SetUpColorMap();
        this.colorModelDirect_ = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        this.colorModel256_ = new IndexColorModel(8, this.colors, this.reds, this.greens, this.blues);
        this.colorModel = this.colorModel256_;
        this.liveTraceOrbitThread_ = null;
        if (this.who_am_i_ == 1) {
            this.spec_.center.setR(-0.75);
            this.spec_.coeff.setR(1.0);
            this.spec_.range = 2.7;
            this.spec_.pix_width = 550;
            this.spec_.pix_height = 550;
            this.spec_.depth = 1000;
            this.spec_.panels = 1;
            this.spec_.which = "Mandelbrot";
        }
        this.converter_ = new QtoPixelPoint(this.spec_);
        this.traceOrbitDialogList_ = new Stack();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public FractalSpec spec() {
        return this.spec_;
    }

    public FTWindow parent() {
        return this.fTWindow_;
    }

    public void liveTraceEnded() {
        this.liveTraceOrbitThread_ = null;
        this.repaint();
    }

    public void liveTraceStop() {
        if (this.liveTraceOrbitThread_ != null) {
            this.liveTraceOrbitThread_.stopTrace();
            this.liveOrbitStoppedByUserP_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalToUser_UseBigQ(Graphics graphics, boolean bl, boolean bl2) {
        this.indicatorColor_ = bl ? (bl2 ? (this.indicatorColor_ == violet ? blueviolet : violet) : (this.indicatorColor_ == chartreuse ? green : chartreuse)) : (this.indicatorColor_ == skyBlue1 ? steelBlue1 : skyBlue1);
        Rectangle rectangle = this.getBounds();
        FTCanvas fTCanvas = this;
        synchronized (fTCanvas) {
            graphics.setColor(this.indicatorColor_);
            graphics.fillOval(5, rectangle.height - 25, 20, 20);
            graphics.setColor(Color.RED);
            graphics.drawArc(4, rectangle.height - 26, 21, 21, 0, 360);
        }
        Thread.yield();
    }

    public boolean debugP() {
        return this.fTCentral_.debugP();
    }

    public BufferedImage getCanvasImage() {
        BufferedImage bufferedImage;
        Object object;
        BufferedImage bufferedImage2 = this.refresher_;
        if (bufferedImage2 == null && this.fractalProducer_ != null) {
            bufferedImage2 = this.fractalProducer_.getImage();
        }
        if (bufferedImage2 != null) {
            object = bufferedImage2.getColorModel();
            bufferedImage = new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(this.getWidth(), this.getHeight()), ((ColorModel)object).isAlphaPremultiplied(), null);
        } else {
            bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        object = bufferedImage.getGraphics();
        this.paint((Graphics)object);
        ((Graphics)object).dispose();
        return bufferedImage;
    }

    public boolean copyImageToSystemClipboard() {
        if (this.refresher_ != null) {
            try {
                TransferableImage transferableImage = new TransferableImage(this.getCanvasImage());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    clipboard.setContents(transferableImage, null);
                }
                catch (Throwable throwable) {
                    FTCentral.message("Error in FTCanvas.copyImageToSystemClipboard.  " + FTCentral.getExceptionSynopsis(throwable), true);
                }
                return true;
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTCanvas.copyImageToSystemClipboard.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        } else {
            FTCentral.message("Error in FTCanvas.copyImageToSystemClipboard.  There is no image available.", false);
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public IndexColorModel colorModel256() {
        return this.colorModel256_;
    }

    public byte[] getGIFColorIndices() {
        if (this.fractalProducer_ == null) {
            return null;
        }
        return this.fractalProducer_.getGIFColorIndices();
    }

    public Color getColorAt(int n) {
        if (0 <= n && n < this.color_guide_.length) {
            return this.color_guide_[n];
        }
        return null;
    }

    @Override
    public void transferColorMapTo(ColorMapOwner colorMapOwner) {
        for (int i = 0; i < this.color_guide_.length; ++i) {
            colorMapOwner.setIndexAndColor(i, this.getColorAt(i), i == this.color_guide_.length - 1);
        }
    }

    void updateColors(Color[] colorArray) {
        int n = colorArray.length;
        if (n == this.colorsForGIF_) {
            for (int i = 0; i < n; ++i) {
                Color color = colorArray[i];
                this.reds[i] = (byte)color.getRed();
                this.greens[i] = (byte)color.getGreen();
                this.blues[i] = (byte)color.getBlue();
            }
            this.colorModel256_ = new IndexColorModel(8, this.colors, this.reds, this.greens, this.blues);
        }
        this.color_guide_ = Arrays.copyOf(colorArray, n);
    }

    protected void copyColorMapFrom(FTCanvas fTCanvas, boolean bl) {
        Color[] colorArray = fTCanvas.color_guide_;
        int n = Math.min(colorArray.length, this.color_guide_.length);
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            this.setColorAtIndex(i, colorArray[i], bl && i == n2);
        }
        if (!bl) {
            this.updateColorModel();
        }
    }

    boolean setColorAtIndex(int n, Color color, boolean bl) {
        if (n < this.color_guide_.length) {
            this.color_guide_[n] = color;
            this.reds[n] = (byte)color.getRed();
            this.greens[n] = (byte)color.getGreen();
            this.blues[n] = (byte)color.getBlue();
            if (bl) {
                this.updateColorModel();
            }
            if (this.fractalProducer_ != null && bl) {
                this.setRefresherImage(this.fractalProducer_.getImage());
                this.repaint();
            }
            return true;
        }
        return false;
    }

    void SetUpColorMap() {
        float f = this.colors;
        int n = (int)((double)(5.0f * f) / 6.0) + 12;
        f = this.colors - 1;
        int n2 = (int)f - 1;
        for (int i = 0; i < this.colors - 1; ++i) {
            Color color;
            int n3 = n2 - i;
            int n4 = i + n;
            if (n4 >= this.colors) {
                n4 -= this.colors;
            }
            this.color_guide_[n3] = color = Color.getHSBColor((float)n4 / f, 1.0f, 1.0f);
        }
        this.color_guide_[255] = new Color(0, 0, 0);
        this.fillRedsGreensBluesFromColorGuide(this.reds, this.greens, this.blues);
    }

    private void fillRedsGreensBluesFromColorGuide(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = this.color_guide_.length;
        if (byArray.length != n || byArray2.length != n || byArray3.length != n) {
            FTCentral.message("FTCanvas.fillRedsGreensBluesFromColorGuide was passed invaled length array(s)", true);
        }
        for (int i = 0; i < n; ++i) {
            Color color = this.color_guide_[i];
            byArray[i] = (byte)color.getRed();
            byArray2[i] = (byte)color.getGreen();
            byArray3[i] = (byte)color.getBlue();
        }
    }

    public void set256ColorMapFromCanvas(FTCanvas fTCanvas) {
        IndexColorModel indexColorModel = fTCanvas.colorModel256();
        indexColorModel.getReds(this.reds);
        indexColorModel.getGreens(this.greens);
        indexColorModel.getBlues(this.blues);
        this.setColorModelAndColorGuide(this.reds, this.greens, this.blues);
    }

    void updateColorModel() {
        this.colorModel256_ = new IndexColorModel(8, this.colors, this.reds, this.greens, this.blues);
        this.colorModel = this.imageHas256ColorsP() ? this.colorModel256_ : this.colorModelDirect_;
    }

    private void setColorModelAndColorGuide(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (this.color_guide_.length != this.colorsForGIF_) {
            this.color_guide_ = new Color[this.colorsForGIF_];
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.color_guide_[i] = new Color(PosByte.asInt(byArray[i]), PosByte.asInt(byArray2[i]), PosByte.asInt(byArray3[i]));
        }
        this.updateColorModel();
    }

    public boolean imageExistsP() {
        return this.refresher_ != null;
    }

    public boolean countsExistP() {
        return this.refresher_ != null && this.hasLoopCounts() && this.fractalProducer_ != null;
    }

    public GIFEncoder createGIFEncoder() throws AWTException {
        return new GIFEncoder(this.spec_.pix_width, this.spec_.pix_height, this.getGIFColorIndices(), this.colorModel256());
    }

    public void stop() {
        this.typeOfImagePreparation_ = 1;
        if (this.fractalProducer_ != null) {
            this.fractalProducer_.stop();
        }
    }

    public boolean isReadGIF_p() {
        return this.typeOfImagePreparation_ == 2;
    }

    public boolean hasLoopCounts() {
        return this.typeOfImagePreparation_ == 1 || this.typeOfImagePreparation_ == 4;
    }

    public int getTypeOfImagePreparation() {
        return this.typeOfImagePreparation_;
    }

    public boolean everStartedP() {
        return this.ever_started_p_;
    }

    public void setEverStartedP(boolean bl) {
        this.ever_started_p_ = bl;
    }

    public boolean everFinishedP() {
        return this.ever_finished_p_;
    }

    public void setEverFinishedP(boolean bl) {
        this.ever_finished_p_ = bl;
    }

    private boolean trapImageProducerP(String string) {
        FTLooper fTLooper = this.fTCentral_.findLoopObject(string);
        if (fTLooper == null || this.fTCentral_.getTrapFrame() == null) {
            return false;
        }
        return fTLooper.acceptsTrapGif();
    }

    private Q1ImageProducer createImageProducer(FractalSpec fractalSpec) {
        if (this.trapImageProducerP(fractalSpec.which)) {
            return new TrapImageProducer(fractalSpec, this, this.fTCentral_.getTrapFrame());
        }
        if (fractalSpec.rangeOver == 0) {
            return new Q1ImageProducer(fractalSpec, this);
        }
        if (fractalSpec.rangeOver == 1) {
            return new Q2ImageProducer(fractalSpec, this);
        }
        if (fractalSpec.rangeOver == 2) {
            return new Q3ImageProducer(fractalSpec, this);
        }
        FTCentral.message("FTCanvas:: specArg.rangeOver had illegal value" + fractalSpec.rangeOver, true);
        fractalSpec.rangeOver = 0;
        return new Q1ImageProducer(fractalSpec, this);
    }

    private Q1ImageProducer createImageProducer(BufferedImage bufferedImage, FractalSpec fractalSpec) {
        if (this.trapImageProducerP(fractalSpec.which)) {
            return new TrapImageProducer(bufferedImage, fractalSpec, this, this.fTCentral_.getTrapFrame());
        }
        if (fractalSpec.rangeOver == 0) {
            return new Q1ImageProducer(bufferedImage, fractalSpec, this);
        }
        if (fractalSpec.rangeOver == 1) {
            return new Q2ImageProducer(bufferedImage, fractalSpec, this);
        }
        if (fractalSpec.rangeOver == 2) {
            return new Q3ImageProducer(bufferedImage, fractalSpec, this);
        }
        FTCentral.message("FTCanvas:: specArg.rangeOver had illegal value" + fractalSpec.rangeOver, true);
        fractalSpec.rangeOver = 0;
        return new Q1ImageProducer(bufferedImage, fractalSpec, this);
    }

    public void setSpecVersionToCurrent() {
        this.spec_.version = 5.0;
    }

    public void set_max_minutes_per_row(int n) {
        this.max_minutes_per_row_ = n;
    }

    public int get_max_minutes_per_row() {
        return this.max_minutes_per_row_;
    }

    public String importParameters(FractalSpec fractalSpec) {
        fractalSpec.setCommonDenominators();
        this.parameter_change_p_ = !this.spec_.equal_p(fractalSpec) || !this.everStartedP() || this.other_change_requires_redraw_p_;
        this.other_change_requires_redraw_p_ = false;
        int n = this.spec_.pix_width;
        int n2 = this.spec_.pix_height;
        int n3 = this.spec_.rangeOver;
        if (this.parameter_change_p_) {
            this.setEverStartedP(false);
            this.setEverFinishedP(false);
            this.spec_.assignFrom(fractalSpec);
            this.converter_ = new QtoPixelPoint(this.spec_);
            this.setRefresherImage(null);
            if (this.spec_.pix_width < min_pix_width_) {
                this.spec_.pix_width = min_pix_width_;
            }
            if (this.spec_.pix_height < min_pix_width_) {
                this.spec_.pix_height = min_pix_width_;
            }
            this.fractalProducer_ = null;
            this.spec_.which = fractalSpec.which == null || fractalSpec.which.length() == 0 ? "Mandelbrot" : fractalSpec.which;
            this.updateColorModel();
            System.gc();
            this.fractalProducer_ = this.createImageProducer(this.spec_);
            Rectangle rectangle = this.getBounds();
            this.h_offset_ = Math.max(0, (rectangle.width - this.spec_.pix_width) / 2);
            this.v_offset_ = Math.max(0, (rectangle.height - this.spec_.pix_height) / 2);
        }
        this.spec_.setNecessaryPrecision();
        this.fractalProducer_.setParameters(this.spec_, this.parameter_change_p_);
        int n4 = this.spec_.pix_width * this.spec_.panels - 1;
        double d = this.spec_.range / (double)n4;
        double d2 = Math.sqrt(this.spec_.center.magnitude_sq().doubleValue());
        double d3 = d / d2;
        this.useHighPrecisionP_ = d3 < 2.0E-16;
        boolean bl = this.useCompiledLoopP_ = this.useHighPrecisionP_ && this.fractalProducer_.libLoadedP();
        String string = this.useCompiledLoopP_ ? "C++ extended precision code (Gnu's MPFR)" : (this.useHighPrecisionP_ ? "FT/Java extended precision code" : "Java double precision");
        return string;
    }

    public FTCentral ftCentral() {
        return this.fTCentral_;
    }

    public boolean canPerformTraceOrbit() {
        FTLooper fTLooper = null;
        return this.fractalProducer_ != null && this.spec_ != null && (fTLooper = this.ftCentral().findLoopObject(this.spec_.which)) != null && fTLooper.traceOrbit_p();
    }

    public boolean compiledCodeLoadedP() {
        try {
            FTLooper fTLooper = this.ftCentral().findLoopObject(this.spec_.which);
            return fTLooper.libLoadedP();
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.compiledCodeLoadedP: Loop " + (this.spec_ == null ? "?" : this.spec_.which) + " not found.", true);
            return false;
        }
    }

    public String getCompiledCodeStatus() {
        try {
            FTLooper fTLooper = this.ftCentral().findLoopObject(this.spec_.which);
            return fTLooper.getCompiledCodeStatus();
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.getCompiledCodeStatus: Loop " + (this.spec_ == null ? "?" : this.spec_.which) + " not found.", true);
            return "Compiled code unavailable";
        }
    }

    public String toggleUseCompiledCode() {
        try {
            FTLooper fTLooper = this.ftCentral().findLoopObject(this.spec_.which);
            return fTLooper.toggleUseCompiledCode();
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.toggleUseCompiledCode: Loop " + (this.spec_ == null ? "?" : this.spec_.which) + " not found.", true);
            return "Compiled code unavailable";
        }
    }

    public synchronized void threaded_paint_fractal() {
        this.lastBoxPreserved_ = false;
        if (this.fractalProducer_ == null) {
            FTCentral.message("FTCanvas.threaded_paint_fractal called when fractalProducer_ is null.", true);
            return;
        }
        if (this.fractalProducer_.drawing_p()) {
            FTCentral.message("Draw on this canvas already in progress.", false);
            return;
        }
        this.runner_ = new Thread((Runnable)this, "image process " + this.who_am_i_);
        this.runner_.setPriority(1);
        this.runner_.start();
    }

    public boolean drawing_p() {
        return this.fractalProducer_ != null && this.fractalProducer_.drawing_p();
    }

    public boolean stoppedP() {
        return this.fractalProducer_.stoppedP();
    }

    @Override
    public void run() {
        try {
            if (this.refresher_ == null || !this.everFinishedP()) {
                if (this.fTCentral_.loggingP()) {
                    this.fTCentral_.writeToLog(this.spec_);
                }
                this.clearPolygon();
                this.setRefresherImage(null);
                this.setSpecVersionToCurrent();
                this.parent().setEnableSaveMenus(false);
                this.parent().setEnableDrawStartMenu(false);
                this.fractalProducer_.set_drawing_p(true);
                this.typeOfImagePreparation_ = 0;
                this.fractalProducer_.drawTheFractal();
                this.typeOfImagePreparation_ = 1;
                this.setRefresherImage(this.fractalProducer_.getImage());
                this.parent().setEnableDrawStartMenu(true);
                this.parent().setEnableSaveMenus(true);
                this.parent().setLiveOrbitEnabled(this.canPerformTraceOrbit());
                if (this.everFinishedP()) {
                    FTCentral.message("Image finished.", false);
                    this.fTWindow_.autoAdvance(this.spec_);
                } else {
                    FTCentral.message("Image paused.", false);
                }
                if (this.parent().doingSequenceP() && this.stoppedP()) {
                    this.parent().sequenceEndedWithStop();
                }
            } else {
                this.fractalProducer_.setStopP(false);
                this.fTWindow_.autoAdvance(this.spec_);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error: Crash in FTCanvas.run()." + FTCentral.getExceptionSynopsis(throwable));
            FTCentral.message("Error: Crash in FTCanvas.run()." + FTCentral.getExceptionSynopsis(throwable), true);
        }
        finally {
            if (this.drawing_p()) {
                this.fractalProducer_.set_drawing_p(false);
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.fractalProducer_ == null) {
            return;
        }
        Object object = this.orbitSpotsWaitingToBeDrawn_;
        synchronized (object) {
            if (this.orbitSpotsWaitingToBeDrawn_.size() > 0) {
                for (OrbitSpotSpec orbitSpotSpec : this.orbitSpotsWaitingToBeDrawn_) {
                    this.drawOrbitSpot(graphics, orbitSpotSpec);
                }
                this.orbitSpotsWaitingToBeDrawn_.clear();
                this.orbitOnlyPaintCount_ = this.orbitOnlyPaintCount_++ % this.orbitOnlyPaintModulus_;
                if (this.orbitOnlyPaintCount_ != 0) {
                    return;
                }
            }
        }
        this.h_offset_ = Math.max(0, (dimension.width - this.spec_.pix_width) / 2);
        this.v_offset_ = Math.max(0, (dimension.height - this.spec_.pix_height) / 2);
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        object = this.refresher_;
        if (object == null) {
            object = this.fractalProducer_.getImage();
        }
        graphics.drawImage((Image)object, this.h_offset_, this.v_offset_, this);
        if (this.refresher_ != null) {
            this.drawBoxCrossOrOrbit(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBoxCrossOrOrbit(Graphics graphics) {
        if (this.drawBox_p) {
            this.drawBox(graphics);
        } else if (this.drawCross_p) {
            this.drawCross(graphics);
        }
        if (this.drawPolygon_p_ && !this.polygonPoints_.isEmpty()) {
            this.drawPolygon(graphics);
        }
        if (!this.orbitSpots_.isEmpty()) {
            ArrayList<OrbitSpotSpec> arrayList = this.orbitSpots_;
            synchronized (arrayList) {
                for (OrbitSpotSpec orbitSpotSpec : this.orbitSpots_) {
                    this.drawOrbitSpot(graphics, orbitSpotSpec);
                }
            }
        }
    }

    private void drawOrbitSpot(Graphics graphics, OrbitSpotSpec orbitSpotSpec) {
        int n = orbitSpotSpec.diameter / 2;
        Point point = this.converter_.getPixelPoint(orbitSpotSpec.point);
        graphics.setColor(orbitSpotSpec.color);
        graphics.fillOval((int)point.getX() - n + this.h_offset_, (int)point.getY() - n + this.v_offset_, orbitSpotSpec.diameter, orbitSpotSpec.diameter);
    }

    public void clearOrbitSpots() {
        this.orbitSpots_.clear();
    }

    public void clearPolygon() {
        this.polygonPoints_.clear();
        this.drawPolygon_p_ = false;
    }

    public void pushPolygonPoint(Point point) {
        this.polygonPoints_.add(point);
    }

    public void drawPolygonFlag() {
        this.drawPolygon_p_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPolygon(Graphics graphics) {
        Point point = null;
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        Color color = graphics.getColor();
        try {
            int n4 = 0;
            boolean bl2 = false;
            for (Point point2 : this.polygonPoints_) {
                if (n4 % 10 == 0) {
                    bl2 = false;
                    n2 = this.polygonPoints_.size() >= n4 + 2 ? Math.abs(this.polygonPoints_.get((int)n4).x - this.polygonPoints_.get((int)(n4 + 1)).x) : 0;
                    n3 = this.polygonPoints_.size() >= n4 + 3 ? Math.abs(this.polygonPoints_.get((int)(n4 + 1)).y - this.polygonPoints_.get((int)(n4 + 2)).y) : 0;
                    bl = n2 >= n && n3 >= n;
                } else if (bl2) {
                    ++n4;
                    continue;
                }
                if (bl) {
                    if (n4 % 10 == 0) {
                        graphics.setColor(Color.WHITE);
                    } else if (n4 % 10 == 5) {
                        graphics.setColor(Color.BLACK);
                    }
                    if (n4 % 5 != 0) {
                        graphics.drawLine((int)point.getX() + this.h_offset_, (int)point.getY() + this.v_offset_, (int)point2.getX() + this.h_offset_, (int)point2.getY() + this.v_offset_);
                    }
                } else {
                    graphics.setColor(Color.WHITE);
                    int n5 = this.polygonPoints_.get((int)0).x + this.h_offset_;
                    int n6 = this.polygonPoints_.get((int)0).y + this.v_offset_;
                    graphics.drawOval(n5 + 1, n6 + 1, n - 2, n - 2);
                    graphics.drawOval(n5, n6, n, n);
                    graphics.setColor(Color.RED);
                    graphics.drawOval(n5 - 1, n6 - 1, n + 2, n + 2);
                    bl2 = true;
                }
                ++n4;
                point = point2;
            }
        }
        finally {
            graphics.setColor(color);
        }
    }

    public void drawBoxFlag(int n, int n2, int n3, int n4) {
        this.drawBox_p = true;
        this.box_low_x = n + this.h_offset_;
        this.box_low_y = n2 + this.v_offset_;
        this.box_hi_x = n3 + this.h_offset_;
        this.box_hi_y = n4 + this.v_offset_;
        this.repaint();
    }

    private void drawBox(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.drawRect(this.box_low_x, this.box_low_y, this.box_hi_x - this.box_low_x + 1, this.box_hi_y - this.box_low_y + 1);
        if (!this.dragUnderwayP_) {
            this.drawBox_p = false;
        }
    }

    public void drawCrossFlag(int n, int n2) {
        this.drawCross_p = true;
        this.box_low_x = n + this.h_offset_;
        this.box_low_y = n2 + this.v_offset_;
        this.repaint();
    }

    private void drawCross(Graphics graphics) {
        graphics.setColor(Color.white);
        int n = this.spec_.pix_width + this.h_offset_;
        int n2 = this.spec_.pix_height + this.v_offset_;
        graphics.drawLine(this.box_low_x, Math.max(0, this.box_low_y - 4), this.box_low_x, Math.max(0, this.box_low_y - 2));
        graphics.drawLine(this.box_low_x, Math.min(n2, this.box_low_y + 4), this.box_low_x, Math.min(n2, this.box_low_y + 2));
        graphics.drawLine(Math.max(0, this.box_low_x - 4), this.box_low_y, Math.max(0, this.box_low_x - 2), this.box_low_y);
        graphics.drawLine(Math.min(n, this.box_low_x + 4), this.box_low_y, Math.min(n, this.box_low_x + 2), this.box_low_y);
        this.drawCross_p = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrbitSpot(BigQuaternion bigQuaternion, int n, Color color, boolean bl) {
        OrbitSpotSpec orbitSpotSpec = null;
        this.orbitSpotCount_ = color.equals(this.orbitFirstColor_) ? 1 : ++this.orbitSpotCount_;
        if (this.orbitSpotCount_ > 2) {
            orbitSpotSpec = this.orbitSpots_.get(this.orbitSpots_.size() - 1);
            orbitSpotSpec.changeColor(this.orbitPrevColor_);
        }
        OrbitSpotSpec orbitSpotSpec2 = new OrbitSpotSpec(bigQuaternion, n, color);
        ArrayList<OrbitSpotSpec> arrayList = this.orbitSpots_;
        synchronized (arrayList) {
            this.orbitSpots_.add(orbitSpotSpec2);
        }
        arrayList = this.orbitSpotsWaitingToBeDrawn_;
        synchronized (arrayList) {
            if (orbitSpotSpec != null) {
                this.orbitSpotsWaitingToBeDrawn_.add(orbitSpotSpec);
            }
            this.orbitSpotsWaitingToBeDrawn_.add(orbitSpotSpec2);
        }
        if (bl) {
            this.repaint();
        }
    }

    public void addOrbitSpot_old(BigQuaternion bigQuaternion, int n, Color color) {
        this.orbitSpots_.add(new OrbitSpotSpec(bigQuaternion, n, color));
    }

    public void setOrbitColors(Color color, Color color2) {
        this.orbitFirstColor_ = color;
        this.orbitPrevColor_ = color2;
    }

    public String getCountsCSV() {
        if (!this.countsExistP() || !this.everFinishedP()) {
            FTCentral.message("ERROR" + (this.typeOfImagePreparation_ != 1 && this.typeOfImagePreparation_ != 4 ? "  Type of image is not .FTR or COMPUTED." : "") + (this.fractalProducer_ == null ? "  No fractalProducer_" : "") + (this.refresher_ == null ? "  No refresher_." : "") + (!this.everFinishedP() ? "  Never finished an image." : ""), true);
            return null;
        }
        return this.fractalProducer_.getCountsCSV();
    }

    public synchronized boolean keepCurrentDrawLine(int n, int n2, int n3, Color color) {
        this.repaint();
        return true;
    }

    public void setRefresherImage(BufferedImage bufferedImage) {
        this.refresher_ = bufferedImage;
    }

    public void setFractalSpecForSeqFrameNumber(SeqSpec seqSpec) {
        int n = seqSpec.getFrameNumber();
        FractalSpec fractalSpec = new FractalSpec(this.spec_);
        seqSpec.advance(fractalSpec, n);
        this.importParameters(fractalSpec);
        this.fTCentral_.setParameters(fractalSpec);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDownP_ = true;
        this.drag_anchor_x = mouseEvent.getX();
        this.drag_anchor_y = mouseEvent.getY();
        if (this.lastBoxPreserved_ && this.lastBoxMinX_ <= this.drag_anchor_x && this.drag_anchor_x <= this.lastBoxMaxX_ && this.lastBoxMinY_ <= this.drag_anchor_y && this.drag_anchor_y <= this.lastBoxMaxY_) {
            this.boxDragUnderwayP_ = true;
        } else {
            this.lastBoxPreserved_ = false;
        }
    }

    private static String getColorAt(JPanel jPanel, Point point) throws AWTException {
        try {
            Robot robot = new Robot();
            Point point2 = new Point(jPanel.getLocationOnScreen().x + point.x, jPanel.getLocationOnScreen().y + point.y);
            Color color = robot.getPixelColor(point2.x, point2.y);
            return "\n       Color: (alpha=" + color.getAlpha() + ", r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + ")";
        }
        catch (Throwable throwable) {
            return "  Unable to obtain color.";
        }
    }

    private void describePointClicked(FractalSpec fractalSpec, int n, int n2, int n3) {
        String string = null;
        try {
            string = String.valueOf(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            BigQuaternion bigQuaternion = this.converter_.getQuaternion(Math.round(n2), Math.round(n3));
            FTCentral.message("Point clicked is at (" + n2 + ", " + n3 + ", " + (string != null ? string : "?") + ")" + FTCanvas.getColorAt(this, new Point(n2, n3)) + "\n       Image scan location is at " + (String)(fractalSpec.vx.r != 0.0 || fractalSpec.vy.r != 0.0 ? "\n          r = " + bigQuaternion.r : "") + (String)(fractalSpec.vx.i != 0.0 || fractalSpec.vy.i != 0.0 ? "\n          i = " + bigQuaternion.i : "") + (String)(fractalSpec.vx.j != 0.0 || fractalSpec.vy.j != 0.0 ? "\n          j = " + bigQuaternion.j : "") + (String)(fractalSpec.vx.k != 0.0 || fractalSpec.vy.k != 0.0 ? "\n          k = " + bigQuaternion.k : ""), true);
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.describePointClicked ERROR: Attempt to print click location failed.", true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = mouseEvent.getX();
        int n6 = mouseEvent.getY();
        this.mouseDownP_ = false;
        while (!this.traceOrbitDialogList_.isEmpty()) {
            this.traceOrbitDialogList_.pop().setXY(n5 - this.h_offset_, this.spec_.pix_height - 1 - n6 - this.v_offset_);
        }
        if (this.fTWindow_.doingSequenceP() || this.drag_anchor_x < 0 || !this.everStartedP()) {
            this.drag_anchor_x = -1;
            return;
        }
        this.fTCentral_.setActiveCanvas(this);
        int n7 = n5 - this.drag_anchor_x;
        int n8 = n6 - this.drag_anchor_y;
        boolean bl2 = this.boxDragUnderwayP_ && this.lastBoxPreserved_;
        this.boxDragUnderwayP_ = false;
        this.lastBoxPreserved_ = false;
        if (bl2) {
            n4 = this.lastBoxMinX_ + n7;
            n3 = this.lastBoxMinY_ + n8;
            n2 = this.lastBoxMaxX_ + n7;
            n = this.lastBoxMaxY_ + n8;
        } else {
            n4 = Math.min(this.drag_anchor_x, mouseEvent.getX()) - this.h_offset_;
            n3 = Math.min(this.drag_anchor_y, mouseEvent.getY()) - this.v_offset_;
            n2 = Math.max(this.drag_anchor_x, mouseEvent.getX()) - this.h_offset_;
            n = Math.max(this.drag_anchor_y, mouseEvent.getY()) - this.v_offset_;
            Dimension dimension = this.fTCentral_.getHVRatio();
            if (!RatioDialog.offP(dimension)) {
                double d = (double)dimension.height / (double)dimension.width;
                double d2 = n2 - n4;
                double d3 = n - n3;
                if (d2 >= 1.0 && d3 >= 1.0) {
                    if (d3 < d2 * d) {
                        if (n3 == this.drag_anchor_y) {
                            n = n3 + (int)Math.round(d2 * d);
                        } else {
                            n3 = n - (int)Math.round(d2 * d);
                        }
                    } else if (d2 < d3 / d) {
                        if (n4 == this.drag_anchor_x) {
                            n2 = n4 + (int)Math.round(d3 / d);
                        } else {
                            n4 = n2 - (int)Math.round(d3 / d);
                        }
                    }
                }
            }
        }
        int n9 = n2 - n4;
        int n10 = n - n3;
        double d = 0.0;
        double d4 = 0.0;
        d += (double)n4 + (double)n9 / 2.0;
        d4 += (double)n3 + (double)n10 / 2.0;
        int n11 = this.spec_.pix_width * this.spec_.panels - 1;
        int n12 = this.spec_.pix_height * this.spec_.panels - 1;
        this.lastBoxMinX_ = n4;
        this.lastBoxMinY_ = n3;
        this.lastBoxMaxX_ = n2;
        this.lastBoxMaxY_ = n;
        this.drag_anchor_x = -1;
        BigQuaternion bigQuaternion = this.fractalProducer_.lox_.plus(this.fractalProducer_.hiy_.minus(this.fractalProducer_.incy_.times_scalar(d4)));
        BigQuaternion bigQuaternion2 = bigQuaternion.plus(this.fractalProducer_.incx_.times_scalar(d));
        FractalSpec fractalSpec = new FractalSpec(this.spec_);
        if (fractalSpec.rangeOver == 1) {
            fractalSpec.coeff.assign_from(bigQuaternion2);
        } else if (fractalSpec.rangeOver == 2) {
            fractalSpec.trans.assign_from(bigQuaternion2);
        } else {
            fractalSpec.center.assign_from(bigQuaternion2);
        }
        fractalSpec.setCommonDenominators();
        boolean bl3 = bl = n9 > 2 && n10 > 2;
        if (bl) {
            this.dragUnderwayP_ = false;
            double d5 = this.spec_.pix_width;
            double d6 = this.spec_.pix_height;
            if (d5 <= 0.0 || d6 <= 0.0) {
                d5 = this.spec_.pix_width;
                d6 = this.spec_.pix_height;
            }
            double d7 = Math.sqrt(d5 * d6 / (double)((float)n9 * (float)n10));
            fractalSpec.pix_width = (int)Math.round((double)n9 * d7);
            fractalSpec.pix_height = (int)Math.round((double)n10 * d7);
            this.lastBoxPreserved_ = true;
            this.drawBoxFlag(n4, n3, n4 + n9, n3 + n10);
            fractalSpec.range = (double)n9 * this.spec_.range / (double)n11;
            this.fTCentral_.setParameters(fractalSpec, this.parent());
            this.fTCentral_.setParmFramePanelFields(1, 0, 0);
        } else if (this.sendCountToColorGuideEditor_) {
            this.sendCountToColorGuideEditor_ = false;
            int n13 = this.fractalProducer_.getLoopCount((int)Math.round(d), (int)Math.round(d4));
            if (n13 > 0) {
                int n14 = (int)Math.floor((double)n13 / this.spec_.loops_per_color);
                this.fTCentral_.boxCountInColorMapEditor(n14);
            }
        } else {
            boolean bl4;
            int n15;
            this.drawCrossFlag((int)Math.round(d), (int)Math.round(d4));
            if (mouseEvent.getButton() == 3) {
                n15 = mouseEvent.getModifiersEx();
                bl4 = (n15 & 0x40) != 0;
                boolean bl5 = (n15 & 0x80) != 0;
                boolean bl6 = (n15 & 0x200) != 0;
                boolean bl7 = (n15 & 0x100) != 0;
                try {
                    int n16 = this.fractalProducer_.getLoopCount((int)Math.round(d), (int)Math.round(d4));
                    if (!bl5) {
                        this.describePointClicked(this.spec_, n16, (int)Math.round(d), (int)Math.round(d4));
                    } else if (n16 > 0) {
                        int n17 = (int)Math.floor((double)n16 / this.spec_.loops_per_color);
                        this.fTCentral_.boxCountInColorMapEditor(n17);
                    } else {
                        FTCentral.message("Couldn't obtain loop count (i.e. sequence length) for point clicked.", true);
                    }
                }
                catch (Throwable throwable) {
                    FTCentral.message("FTCanvas.mouseReleased ERROR processing right click: " + FTCentral.getExceptionSynopsis(throwable), true);
                }
            }
            n15 = this.fTCentral_.parmFramePanels();
            bl4 = this.fTCentral_.receivePoint(this, fractalSpec, mouseEvent);
            if (bl4) {
                if (n15 == this.spec_.panels) {
                    this.fTCentral_.setParmFramePanelFields(1, 0, 0);
                    this.fTCentral_.setParmFrameRange(this.spec_.range / (double)this.spec_.panels);
                } else if (n15 > 1) {
                    double d8 = d + (double)(n11 / -2) + (double)(this.spec_.panel_x * this.spec_.pix_width);
                    double d9 = -d4 + (double)(n12 / 2) - (double)(this.spec_.panel_y * this.spec_.pix_height);
                    this.fTCentral_.receivePoint(this, this.spec_, mouseEvent);
                    double d10 = 0.5 + d8 / (double)(this.spec_.pix_width * this.spec_.panels);
                    double d11 = 0.5 - d9 / (double)(this.spec_.pix_height * this.spec_.panels);
                    int n18 = (int)(d10 * (double)n15);
                    int n19 = (int)(d11 * (double)n15);
                    this.fTCentral_.setParmFramePanelFields(n15, n18, n19);
                }
            }
        }
        this.dragUnderwayP_ = false;
    }

    public void setColorGuide(Color[] colorArray) {
        switch (this.typeOfImagePreparation_) {
            case 0: {
                this.color_guide_ = colorArray;
                if (this.color_guide_.length != 256) break;
                this.fillRedsGreensBluesFromColorGuide(this.reds, this.greens, this.blues);
                this.colorModel256_ = new IndexColorModel(8, this.colors, this.reds, this.greens, this.blues);
                this.colorModel = this.colorModel256_;
                break;
            }
            case 2: {
                if (colorArray.length != 256) {
                    FTCentral.message("A read GIF file cannot be recolored unless the color guide has total size of 256.\n  Hint: Redraw with depth <= depth + 1.", true);
                    break;
                }
            }
            case 1: 
            case 4: {
                if (this.fractalProducer_ == null) {
                    FTCentral.message("Error: FTCanvas.setColorGuide found that there's no fractalProducer_.", true);
                    return;
                }
                BufferedImage bufferedImage = this.fractalProducer_.setColorGuideGetImage(colorArray);
                if (bufferedImage != null) {
                    this.color_guide_ = colorArray;
                    this.setRefresherImage(bufferedImage);
                    if (this.color_guide_.length == 256) {
                        this.fillRedsGreensBluesFromColorGuide(this.reds, this.greens, this.blues);
                        this.colorModel256_ = new IndexColorModel(8, this.colors, this.reds, this.greens, this.blues);
                        this.colorModel = this.colorModel256_;
                    }
                    this.repaint();
                    break;
                }
                FTCentral.message("Error: In FTCanvas.setColorGuide(.) unexpectedly couldn't create a new image for a COMPUTED, FTR, or GIF fracatal.", true);
                break;
            }
            case 3: {
                FTCentral.message("A read PNG file cannot be recolored unless the color guide has total size of 256.\n   Hint: Redraw with depth <= depth + 1.", true);
                break;
            }
            default: {
                FTCentral.message("Error: The impossible has happened, unrecognized typeOfImagePreparation_ of " + this.typeOfImagePreparation_ + ", in FTCanvas.setColorGuide(.).", true);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mouseDownP_) {
            return;
        }
        if (this.boxDragUnderwayP_) {
            if (this.lastBoxPreserved_) {
                int n = mouseEvent.getX() - this.drag_anchor_x;
                int n2 = mouseEvent.getY() - this.drag_anchor_y;
                int n3 = this.lastBoxMinX_ + n;
                int n4 = this.lastBoxMinY_ + n2;
                int n5 = this.lastBoxMaxX_ + n;
                int n6 = this.lastBoxMaxY_ + n2;
                if (n3 >= 0 && n5 - n3 > 2 && n6 - n4 > 2) {
                    this.dragUnderwayP_ = true;
                    this.drawBoxFlag(n3, n4, n5, n6);
                }
            }
        } else {
            int n = Math.min(this.drag_anchor_x, mouseEvent.getX());
            int n7 = Math.min(this.drag_anchor_y, mouseEvent.getY());
            int n8 = Math.max(this.drag_anchor_x, mouseEvent.getX());
            int n9 = Math.max(this.drag_anchor_y, mouseEvent.getY());
            Dimension dimension = this.fTCentral_.getHVRatio();
            if (!RatioDialog.offP(dimension)) {
                double d = (double)dimension.height / (double)dimension.width;
                double d2 = n8 - n;
                double d3 = n9 - n7;
                if (d2 >= 1.0 && d3 >= 1.0) {
                    if (d3 < d2 * d) {
                        if (n7 == this.drag_anchor_y) {
                            n9 = n7 + (int)Math.round(d2 * d);
                        } else {
                            n7 = n9 - (int)Math.round(d2 * d);
                        }
                    } else if (d2 < d3 / d) {
                        if (n == this.drag_anchor_x) {
                            n8 = n + (int)Math.round(d3 / d);
                        } else {
                            n = n8 - (int)Math.round(d3 / d);
                        }
                    }
                }
            }
            if (n >= 0 && n8 - n > 2 && n9 - n7 > 2) {
                this.dragUnderwayP_ = true;
                this.drawBoxFlag(n - this.h_offset_, n7 - this.v_offset_, n8 - this.h_offset_, n9 - this.v_offset_);
            }
        }
    }

    public boolean doingSequenceP() {
        return this.fTWindow_.doingSequenceP();
    }

    public void traceTheOrbit(FTWindow fTWindow, FTCentral fTCentral, FTLooper fTLooper, BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n, boolean bl, int n2, int n3, int n4, long l, Color color, Color color2, Color color3) {
        this.liveOrbitStoppedByUserP_ = false;
        LiveOrbitReporter liveOrbitReporter = new LiveOrbitReporter(fTWindow, fTCentral, bigQuaternion, bigQuaternion2, bigQuaternion3, bl, n2, n3, n4, l, color, color2, color3);
        this.liveTraceOrbitThread_ = new TraceThread(bigQuaternion, bigQuaternion2, bigQuaternion3, n, liveOrbitReporter, fTLooper, fTWindow.canvas());
        this.liveTraceOrbitThread_.start();
    }

    public boolean imageInterpolatedP() {
        if (this.fractalProducer_ != null) {
            return this.fractalProducer_.getSpec().interpolateColors != 0 && this.fractalProducer_.getSpec().loops_per_color != 1.0;
        }
        return this.spec_.interpolateColors != 0 && this.spec_.loops_per_color != 1.0;
    }

    public boolean imageHas256ColorsP() {
        return this.color_guide_.length == 256;
    }

    public void addOrbitXYListener(OrbitXYListener orbitXYListener) {
        this.traceOrbitDialogList_.push(orbitXYListener);
    }

    @Override
    public Color[] getColorGuide() {
        return this.color_guide_;
    }

    public Color[] getColorGuideCopy() {
        return Arrays.copyOf(this.color_guide_, this.color_guide_.length);
    }

    public boolean loadGIF(String string, FractalSpec fractalSpec, RGBxSizeSequence rGBxSizeSequence) {
        try {
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage != null) {
                return this.finishLoadingGIF(bufferedImage, fractalSpec, rGBxSizeSequence);
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.loadGIF(String...) Error: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        return false;
    }

    public boolean loadGIF(URL uRL, FractalSpec fractalSpec, RGBxSizeSequence rGBxSizeSequence) {
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            if (bufferedImage != null) {
                return this.finishLoadingGIF(bufferedImage, fractalSpec, rGBxSizeSequence);
            }
        }
        catch (Throwable throwable) {
            FTCentral.message("FTCanvas.loadGIF(URL...) Error: " + FTCentral.getExceptionSynopsis(throwable), true);
        }
        return false;
    }

    private boolean finishLoadingGIF(BufferedImage bufferedImage, FractalSpec fractalSpec, RGBxSizeSequence rGBxSizeSequence) {
        this.spec_ = fractalSpec;
        boolean bl = true;
        if (bl) {
            ColorModel colorModel = bufferedImage.getColorModel();
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                int n = indexColorModel.getMapSize();
                indexColorModel.getReds(this.reds);
                indexColorModel.getGreens(this.greens);
                indexColorModel.getBlues(this.blues);
            } else {
                FTCentral.message("FTCanvas.finishLoadingGIF Error: Somehow the GIF's ColorModel wasn't an IndexColorModel!", true);
            }
        } else {
            int n = rGBxSizeSequence.byteTable.length / 3;
            if (n < this.colorsForGIF_) {
                FTCentral.message("FTCanvas::loadGIF only got " + n + " colors.", true);
            }
            for (int i = 0; i < n; ++i) {
                int n2 = i * 3;
                this.reds[i] = rGBxSizeSequence.byteTable[n2];
                this.greens[i] = rGBxSizeSequence.byteTable[n2 + 1];
                this.blues[i] = rGBxSizeSequence.byteTable[n2 + 2];
            }
        }
        this.setColorModelAndColorGuide(this.reds, this.greens, this.blues);
        this.typeOfImagePreparation_ = 2;
        this.setRefresherImage(bufferedImage);
        this.fractalProducer_ = this.createDummyProducer();
        this.finishLoadImage();
        return true;
    }

    private static Color[] parseColorGuideString(String string) {
        int n = Integer.parseUnsignedInt(string, 0, 4, 10);
        int n2 = string.length() / 8;
        if (n == 1) {
            Color[] colorArray = new Color[n2];
            int n3 = -1;
            for (int i = 4; i < string.length(); i += 8) {
                n3 = Integer.parseUnsignedInt(string, i, i + 8, 16);
                colorArray[i / 8] = new Color(n3, true);
            }
            return colorArray;
        }
        FTCentral.message("FTCanvas.loadPNGImageAndMetadata - ERROR: Invaled value for colorGuideFormat, read " + n, true);
        return null;
    }

    private FractalSpec loadPNGMetadata(ImageInputStream imageInputStream) throws Exception {
        String[] stringArray = FTIO.getMetadataComment_Parms_ColorsStrings(imageInputStream);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        FractalSpec fractalSpec = FractalSpec.parseParmsString(string2);
        this.pendingColorGuide_ = FTCanvas.parseColorGuideString(string3);
        if (string != null && string.length() > 0) {
            FTCentral.message("Reading, user comment: \n  " + string, false);
        }
        return fractalSpec;
    }

    public FractalSpec loadPNG(String string) {
        try {
            File file = new File(string);
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage != null) {
                this.setRefresherImage(bufferedImage);
            }
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            return this.finishLoadPNG(imageInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public FractalSpec loadPNG(URL uRL) {
        try {
            BufferedImage bufferedImage = ImageIO.read(uRL);
            if (bufferedImage != null) {
                this.setRefresherImage(bufferedImage);
            }
            InputStream inputStream = uRL.openStream();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
            return this.finishLoadPNG(imageInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public FractalSpec finishLoadPNG(ImageInputStream imageInputStream) {
        try {
            FractalSpec fractalSpec = this.loadPNGMetadata(imageInputStream);
            imageInputStream.flush();
            imageInputStream.close();
            if (fractalSpec == null || this.refresher_ == null) {
                if (fractalSpec == null) {
                    FTCentral.message("FractalSpec.loadPNG(String) - ERROR, no FT drawing parameters found in this file.", true);
                }
                if (this.refresher_ == null) {
                    FTCentral.message("FractalSpec.loadPNG(String) - ERROR, no image found in this file.", true);
                }
                return null;
            }
            if (fractalSpec.trapPathname != null && fractalSpec.trapPathname.trim().length() > 0) {
                this.tryToLoadTrapImage(fractalSpec.which);
            }
            this.typeOfImagePreparation_ = 3;
            this.color_guide_ = this.pendingColorGuide_;
            this.spec_.assignFrom(fractalSpec);
            this.fractalProducer_ = this.createDummyProducer();
            this.finishLoadImage();
            return fractalSpec;
        }
        catch (Exception exception) {
            FTCentral.message("FTCanvas.finishLoadPNG Error: " + FTCentral.getExceptionSynopsis(exception), true);
            return null;
        }
    }

    public FractalSpec loadFTR(String string) {
        try {
            File file = new File(string);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            BufferedImage bufferedImage = ImageIO.read(file);
            FractalSpec fractalSpec = this.loadPNGMetadata(imageInputStream);
            imageInputStream.flush();
            imageInputStream.close();
            this.setRefresherImage(null);
            if (fractalSpec == null || bufferedImage == null) {
                if (fractalSpec == null) {
                    FTCentral.message("FractalSpec.loadFTR(String) - ERROR, no FT drawing parameters found in this file.", true);
                }
                if (bufferedImage == null) {
                    FTCentral.message("FractalSpec.loadFTR(String) - ERROR, no image found in this file.", true);
                }
                return null;
            }
            if (fractalSpec.trapPathname != null && fractalSpec.trapPathname.trim().length() > 0) {
                this.tryToLoadTrapImage(fractalSpec.which);
            }
            this.typeOfImagePreparation_ = 4;
            this.color_guide_ = this.pendingColorGuide_;
            this.spec_.assignFrom(fractalSpec);
            this.fractalProducer_ = this.createImageProducer(fractalSpec);
            BufferedImage bufferedImage2 = this.fractalProducer_.setLoopCountsFromFTRImage(bufferedImage);
            this.setRefresherImage(bufferedImage2);
            this.finishLoadImage();
            return fractalSpec;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FractalSpec loadFTR(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
            BufferedImage bufferedImage = ImageIO.read(uRL);
            FractalSpec fractalSpec = this.loadPNGMetadata(imageInputStream);
            imageInputStream.flush();
            imageInputStream.close();
            this.setRefresherImage(null);
            if (fractalSpec == null || bufferedImage == null) {
                if (fractalSpec == null) {
                    FTCentral.message("FractalSpec.loadFTR(URL) - ERROR, no FT drawing parameters found in this file.", true);
                }
                if (bufferedImage == null) {
                    FTCentral.message("FractalSpec.loadFTR(URL) - ERROR, no image found in this file.", true);
                }
                return null;
            }
            this.typeOfImagePreparation_ = 4;
            this.color_guide_ = this.pendingColorGuide_;
            this.spec_.assignFrom(fractalSpec);
            this.fractalProducer_ = this.createImageProducer(fractalSpec);
            BufferedImage bufferedImage2 = this.fractalProducer_.setLoopCountsFromFTRImage(bufferedImage);
            this.setRefresherImage(bufferedImage2);
            this.finishLoadImage();
            return fractalSpec;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String colorGuideAsString() {
        return FTCanvas.colorGuideAsString(this.getColorGuide());
    }

    public static String colorGuideAsString(Color[] colorArray) {
        String string = "0001";
        int[] nArray = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = colorArray[i].getRGB();
        }
        return string + FTCanvas.intArrayAsUnformattedHex(nArray);
    }

    public static Color[] stringAsColorGuide(String string) {
        int n = Integer.parseUnsignedInt(string, 0, 4, 10);
        int n2 = string.length() / 8;
        if (n == 1) {
            Color[] colorArray = new Color[n2];
            int n3 = -1;
            for (int i = 4; i < string.length(); i += 8) {
                n3 = Integer.parseUnsignedInt(string, i, i + 8, 16);
                colorArray[i / 8] = new Color(n3, true);
            }
            return colorArray;
        }
        return null;
    }

    private static String intArrayAsUnformattedHex(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 9);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(String.format("%08x", nArray[i]));
        }
        return stringBuilder.toString();
    }

    public static BufferedImage imageToBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public BufferedImage stdImageToGIFImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        if (this.color_guide_.length != 256 || this.fractalProducer_ != null && this.fractalProducer_.getSpec().gifColorsP()) {
            return null;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)this.color_guide_[i].getRed();
            byArray2[i] = (byte)this.color_guide_[i].getGreen();
            byArray3[i] = (byte)this.color_guide_[i].getBlue();
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 13, indexColorModel);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, n, n2, this);
        graphics.dispose();
        return bufferedImage2;
    }

    private void finishLoadImage() {
        String string;
        this.clearPolygon();
        this.parameter_change_p_ = false;
        this.h_offset_ = 0;
        this.v_offset_ = 0;
        int n = this.refresher_.getWidth(this);
        int n2 = this.refresher_.getHeight(this);
        if (n2 != this.spec_.pix_height || n != this.spec_.pix_width) {
            FTCentral.message("FTCanvas has noted that the image is " + n + " by " + n2 + " but the draw parameters are set to " + this.spec_.pix_width + " by " + this.spec_.pix_height + ".", true);
        }
        if ((string = this.spec_.trapPathname) != null && string.trim().length() > 0) {
            this.tryToLoadTrapImage(string.trim());
        }
        this.fTWindow_.setEnableSaveMenus(true);
        this.setEverStartedP(true);
        this.setEverFinishedP(true);
        this.repaint();
    }

    private void tryToLoadTrapImage(String string) {
        if (this.trapImageProducerP(this.spec_.which)) {
            Path path = Paths.get(string, new String[0]);
            String string2 = path.getFileName().toString();
            try {
                InputStream inputStream;
                Object object;
                String string3;
                boolean bl = false;
                File file = new File(string);
                if (file.exists()) {
                    this.fTCentral_.openTrapImage(string);
                    bl = true;
                }
                if (!bl) {
                    try {
                        string3 = Properties.getFTAppDataDirectory().getCanonicalPath();
                        object = TrapFrame.trapDirectoryName;
                        this.fTCentral_.openTrapImage(string3 + File.separator + (String)object + File.separator + string2);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!bl && (inputStream = FTCanvas.class.getResourceAsStream((String)(object = File.separator + "resources" + File.separator + (string3 = TrapFrame.trapDirectoryName) + File.separator + string2))) != null) {
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage != null) {
                        this.fTCentral_.setTrapImage(bufferedImage, string);
                    }
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("FTCanvas.tryToLoadTrapImage Error for " + string2 + ": " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    private Q1ImageProducer createDummyProducer() {
        System.gc();
        if (this.spec_.version == 1.4) {
            this.blues[0] = 1;
            this.greens[0] = 1;
            this.reds[0] = 1;
        }
        return this.createImageProducer(this.refresher_, this.spec_);
    }

    public class TraceThread
    extends Thread {
        BigQuaternion z_;
        BigQuaternion c_;
        BigQuaternion t_;
        LiveOrbitReporter r_;
        FTLooper fractalLoop_;
        int depth_;
        FTCanvas tCanvas_;

        public TraceThread(BigQuaternion bigQuaternion, BigQuaternion bigQuaternion2, BigQuaternion bigQuaternion3, int n, LiveOrbitReporter liveOrbitReporter, FTLooper fTLooper, FTCanvas fTCanvas2) {
            this.z_ = bigQuaternion;
            this.c_ = bigQuaternion2;
            this.t_ = bigQuaternion3;
            this.r_ = liveOrbitReporter;
            this.fractalLoop_ = fTLooper;
            this.depth_ = n;
            if (this.depth_ < 250) {
                this.depth_ = 250;
            }
            this.tCanvas_ = fTCanvas2;
        }

        @Override
        public void run() {
            try {
                this.fractalLoop_.traceOrbit(this.z_, this.c_, this.t_, this.depth_, this.r_);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error while running " + this.fractalLoop_.getLoopName() + ".traceOrbit: " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }

        public void stopTrace() {
            this.r_.stop();
        }
    }

    public class OrbitSpotSpec {
        public BigQuaternion point;
        public int diameter;
        public Color color;

        public OrbitSpotSpec(BigQuaternion bigQuaternion, int n, Color color) {
            this.point = bigQuaternion;
            this.diameter = n;
            this.color = color;
        }

        public void changeColor(Color color) {
            this.color = color;
        }
    }

    class TransImage
    implements Transferable {
        TransImage() {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return FTCanvas.this.refresher_;
        }
    }
}

