/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FractalSpec;
import us.lystad.fractaltop.Fraction;

public class FTArgReader {
    private StreamTokenizer tokens;
    private FractalSpec values;
    private double color_cycles_ = -1.0;
    private String comment_ = "";

    public String getComment() {
        return this.comment_;
    }

    public FractalSpec readArgFile(Reader reader, int n) {
        this.values = new FractalSpec();
        this.values.depth = -1;
        this.values.version = 1.4;
        this.values.pix_height = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.tokens = new StreamTokenizer(reader);
        this.tokens.eolIsSignificant(true);
        int n2 = 33;
        int n3 = 39;
        this.tokens.wordChars(n2, n3);
        int n4 = 40;
        int n5 = 41;
        this.tokens.whitespaceChars(n4, n5);
        int n6 = 42;
        int n7 = 47;
        this.tokens.wordChars(n6, n7);
        int n8 = 58;
        int n9 = 64;
        this.tokens.wordChars(n8, n9);
        int n10 = 91;
        int n11 = 96;
        this.tokens.wordChars(n10, n11);
        int n12 = 123;
        int n13 = 126;
        this.tokens.wordChars(n12, n13);
        if (!this.skipToRightId(n)) {
            FTCentral.message("JQArgReader did not find the desired log-id", true);
            return null;
        }
        boolean bl = false;
        try {
            this.tokens.nextToken();
            block5: while (this.tokens.ttype != -1 && !bl) {
                switch (this.tokens.ttype) {
                    case -3: {
                        if (this.tokens.sval.equals("log_id")) {
                            bl = true;
                            continue block5;
                        }
                        this.fillField(this.tokens.sval, stringBuffer);
                        continue block5;
                    }
                }
                this.tokens.nextToken();
            }
        }
        catch (Throwable throwable) {
            stringBuffer.append("\nRead error: ").append(throwable.getMessage());
        }
        String string = stringBuffer.toString();
        int n14 = string.lastIndexOf("\n");
        if (string.length() > 1 && n14 >= string.length() - 3) {
            string = string.substring(0, n14);
        }
        FTCentral.message(string, false);
        this.comment_ = string;
        this.values.setCommonDenominators();
        return this.values;
    }

    private String translateWhich(String string) {
        if (string.equals("Loop428")) {
            return "LoopTetra2";
        }
        if (string.equals("LoopHCx")) {
            return "HcxPower2";
        }
        if (string.equals("Loop22")) {
            return "Mandelbrot";
        }
        if (string.equals("Loop23")) {
            return "MandelCube";
        }
        return string;
    }

    private boolean skipToRightId(int n) {
        try {
            this.tokens.nextToken();
            while (true) {
                if (this.tokens.ttype == -1) {
                    return false;
                }
                if (this.tokens.ttype == -3 && this.tokens.sval.equals("log_id")) {
                    this.tokens.nextToken();
                    if (this.tokens.ttype != -2 || n >= 0 && this.tokens.nval != (double)n) continue;
                    return true;
                }
                this.tokens.nextToken();
            }
        }
        catch (IOException iOException) {
            System.err.println("skipToRightId: " + iOException.getMessage());
            return false;
        }
    }

    private void fillField(String string, StringBuffer stringBuffer) throws IOException {
        this.tokens.nextToken();
        if (string.equals("ct_r") || string.equals("Q1_r")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.center.setR(this.readFraction());
            } else {
                stringBuffer.append("Bad value: center.r\n");
            }
        } else if (string.equals("ct_i") || string.equals("Q1_i")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.center.setI(this.readFraction());
            } else {
                stringBuffer.append("Bad value: center.i\n");
            }
        } else if (string.equals("ct_j") || string.equals("Q1_j")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.center.setJ(this.readFraction());
            } else {
                stringBuffer.append("Bad value: center.j\n");
            }
        } else if (string.equals("ct_k") || string.equals("Q1_k")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.center.setK(this.readFraction());
            } else {
                stringBuffer.append("Bad value: center.k\n");
            }
        } else if (string.equals("co_r") || string.equals("Q2_r")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.coeff.setR(this.readFraction());
            } else {
                stringBuffer.append("Bad value: coeff.r\n");
            }
        } else if (string.equals("co_i") || string.equals("Q2_i")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.coeff.setI(this.readFraction());
            } else {
                stringBuffer.append("Bad value: coeff.i\n");
            }
        } else if (string.equals("co_j") || string.equals("Q2_j")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.coeff.setJ(this.readFraction());
            } else {
                stringBuffer.append("Bad value: coeff.j\n");
            }
        } else if (string.equals("co_k") || string.equals("Q2_k")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.coeff.setK(this.readFraction());
            } else {
                stringBuffer.append("Bad value: coeff.k\n");
            }
        } else if (string.equals("tr_r") || string.equals("Q3_r")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.trans.setR(this.readFraction());
            } else {
                stringBuffer.append("Bad value: trans.r\n");
            }
        } else if (string.equals("tr_i") || string.equals("Q3_i")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.trans.setI(this.readFraction());
            } else {
                stringBuffer.append("Bad value: trans.i\n");
            }
        } else if (string.equals("tr_j") || string.equals("Q3_j")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.trans.setJ(this.readFraction());
            } else {
                stringBuffer.append("Bad value: trans.j\n");
            }
        } else if (string.equals("tr_k") || string.equals("Q3_k")) {
            if (this.tokens.ttype == -2 || this.tokens.ttype == -3) {
                this.values.trans.setK(this.readFraction());
            } else {
                stringBuffer.append("Bad value: trans.k\n");
            }
        } else if (string.equals("vx_r")) {
            if (this.tokens.ttype == -2) {
                this.values.vx.r = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vx.r\n");
            }
        } else if (string.equals("vx_i")) {
            if (this.tokens.ttype == -2) {
                this.values.vx.i = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vx.i\n");
            }
        } else if (string.equals("vx_j")) {
            if (this.tokens.ttype == -2) {
                this.values.vx.j = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vx.j\n");
            }
        } else if (string.equals("vx_k")) {
            if (this.tokens.ttype == -2) {
                this.values.vx.k = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vx.k\n");
            }
        } else if (string.equals("vy_r")) {
            if (this.tokens.ttype == -2) {
                this.values.vy.r = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vy.r\n");
            }
        } else if (string.equals("vy_i")) {
            if (this.tokens.ttype == -2) {
                this.values.vy.i = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vy.i\n");
            }
        } else if (string.equals("vy_j")) {
            if (this.tokens.ttype == -2) {
                this.values.vy.j = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vy.j\n");
            }
        } else if (string.equals("vy_k")) {
            if (this.tokens.ttype == -2) {
                this.values.vy.k = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vy.k\n");
            }
        } else if (string.equals("vz_r")) {
            if (this.tokens.ttype == -2) {
                this.values.vz.r = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vz.r\n");
            }
        } else if (string.equals("vz_i")) {
            if (this.tokens.ttype == -2) {
                this.values.vz.i = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vz.i\n");
            }
        } else if (string.equals("vz_j")) {
            if (this.tokens.ttype == -2) {
                this.values.vz.j = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vz.j\n");
            }
        } else if (string.equals("vz_k")) {
            if (this.tokens.ttype == -2) {
                this.values.vz.k = this.readNumber();
            } else {
                stringBuffer.append("Bad value: vz.k\n");
            }
        } else if (string.equals("range")) {
            if (this.tokens.ttype == -2) {
                this.values.range = this.readNumber();
            } else {
                stringBuffer.append("Bad value: range\n");
            }
        } else if (string.equals("hifi")) {
            if (this.tokens.ttype == -3) {
                if (this.tokens.sval.equals("T") || this.tokens.sval.equals("t")) {
                    this.values.hifi_p = true;
                } else if (this.tokens.sval.equals("F") || this.tokens.sval.equals("f")) {
                    this.values.hifi_p = false;
                } else {
                    stringBuffer.append("Bad value: hifi\n");
                    this.values.hifi_p = false;
                }
                this.tokens.nextToken();
            }
        } else if (string.equals("parallel")) {
            if (this.tokens.ttype == -3) {
                this.tokens.nextToken();
            }
        } else if (string.equals("version")) {
            if (this.tokens.ttype == -2) {
                this.values.version = this.readNumber();
            } else {
                stringBuffer.append("Bad value: version\n");
            }
        } else if (string.equals("rangeOver")) {
            if (this.tokens.ttype == -2) {
                this.values.rangeOver = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: rangeOver\n");
            }
        } else if (string.equals("colorsCount")) {
            if (this.tokens.ttype == -2) {
                this.values.colorsCount = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: colorsCount");
            }
        } else if (string.equals("interpolate")) {
            if (this.tokens.ttype == -2) {
                this.values.interpolateColors = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: interpolate");
            }
        } else if (string.equals("panels")) {
            if (this.tokens.ttype == -2) {
                this.values.panels = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: panels\n");
            }
        } else if (string.equals("panel_x")) {
            if (this.tokens.ttype == -2) {
                this.values.panel_x = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: panel_x\n");
            }
        } else if (string.equals("panel_y")) {
            if (this.tokens.ttype == -2) {
                this.values.panel_y = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: panel_y\n");
            }
        } else if (string.equals("width")) {
            if (this.tokens.ttype == -2) {
                this.values.pix_width = (int)this.tokens.nval;
                if (this.values.pix_height == 0) {
                    this.values.pix_height = this.values.pix_width;
                }
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: picture width\n");
            }
        } else if (string.equals("height")) {
            if (this.tokens.ttype == -2) {
                this.values.pix_height = (int)this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: picture height\n");
            }
        } else if (string.equals("multwd")) {
            if (this.tokens.ttype == -2) {
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: picture multwd\n");
            }
        } else if (string.equals("multht")) {
            if (this.tokens.ttype == -2) {
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: picture multht\n");
            }
        } else if (string.equals("depth")) {
            if (this.tokens.ttype == -2) {
                this.values.depth = (int)this.tokens.nval;
                if (this.color_cycles_ > 0.0) {
                    this.values.loops_per_color = (double)this.values.depth / (this.color_cycles_ * (double)(this.values.version == 1.4 ? 254 : 255));
                }
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: depth\n");
            }
        } else if (string.equals("id")) {
            if (this.tokens.ttype == -3) {
                this.values.which = this.tokens.sval;
                this.values.which = this.translateWhich(this.values.which);
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: power/id\n");
            }
        } else if (string.equals("ccycles")) {
            if (this.tokens.ttype == -2) {
                this.color_cycles_ = this.tokens.nval;
                if (this.values.depth > 0) {
                    this.values.loops_per_color = (double)this.values.depth / (this.color_cycles_ * (double)(this.values.version == 1.4 ? 254 : 255));
                }
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: color cycles\n");
            }
        } else if (string.equals("loops_per_color")) {
            if (this.tokens.ttype == -2) {
                this.values.loops_per_color = this.tokens.nval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: loops_per_color\n");
            }
        } else if (string.equals("pt_pix")) {
            if (this.tokens.ttype == -2) {
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: points per pixel\n");
            }
        } else if (string.equals("trapPathname")) {
            if (this.tokens.ttype == -3) {
                this.values.trapPathname = this.tokens.sval;
                this.tokens.nextToken();
            } else {
                stringBuffer.append("Bad value: trapPathname\n");
            }
        } else if (string.equals("comment")) {
            stringBuffer.append("  ");
            this.getInternalComment(stringBuffer);
            this.tokens.nextToken();
        } else {
            stringBuffer.append("Unknown field in args record: ").append(string);
        }
    }

    private int readInteger() throws IOException {
        double d = this.tokens.nval;
        this.tokens.nextToken();
        return Double.valueOf(d).intValue();
    }

    private double readNumber() throws IOException {
        double d = this.tokens.nval;
        this.tokens.nextToken();
        if (this.tokens.ttype == -3) {
            String string = "-0123456789";
            if ((this.tokens.sval.indexOf("e") == 0 || this.tokens.sval.indexOf("E") == 0) && string.indexOf(this.tokens.sval.charAt(1)) >= 0) {
                int n = Integer.valueOf(this.tokens.sval.substring(1));
                this.tokens.nextToken();
                return d * Math.pow(10.0, n);
            }
        }
        return d;
    }

    private Fraction readFraction() throws IOException {
        if (this.values.version >= 3.0) {
            if (this.tokens.ttype == -3) {
                return new Fraction(this.readBigInteger(), this.readInteger());
            }
            throw new IOException("Error in JQArgReader.readFraction: prog version=" + this.values.version + " is >= 3 yet have number for numerator!");
        }
        if (this.tokens.ttype == -2) {
            return new Fraction(this.readNumber());
        }
        return new Fraction(this.readBigDecimal());
    }

    private BigDecimal readBigDecimal() throws IOException {
        String string = new String(this.tokens.sval);
        string = string.substring(1);
        this.tokens.nextToken();
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = numberFormatException.getMessage();
            if (string2 == null) {
                string2 = numberFormatException.toString();
            }
            throw new IOException(string2);
        }
    }

    private BigInteger readBigInteger() throws IOException {
        String string = this.tokens.sval;
        string = string.substring(1);
        this.tokens.nextToken();
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = numberFormatException.getMessage();
            if (string2 == null) {
                string2 = numberFormatException.toString();
            }
            throw new IOException(string2);
        }
    }

    private void getInternalComment(StringBuffer stringBuffer) throws IOException {
        boolean bl = false;
        while (this.tokens.ttype != -3 || !this.tokens.sval.equals("end_of_comment")) {
            switch (this.tokens.ttype) {
                case -3: {
                    String string = this.tokens.sval;
                    if (bl && (string.startsWith(",") || string.startsWith(":"))) {
                        stringBuffer.setLength(stringBuffer.length() - 1);
                    }
                    stringBuffer.append(string);
                    bl = false;
                    break;
                }
                case -2: {
                    double d = this.tokens.nval;
                    if (d == Math.ceil(d)) {
                        bl = true;
                        stringBuffer.append((int)d);
                        break;
                    }
                    stringBuffer.append(d);
                    bl = false;
                    break;
                }
                case 10: {
                    stringBuffer.append("\n");
                    bl = false;
                    break;
                }
                case -1: {
                    return;
                }
                default: {
                    bl = false;
                }
            }
            stringBuffer.append(" ");
            this.tokens.nextToken();
        }
    }
}

