/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FractalSpec;

class DrawResults {
    private FractalSpec spec_ = null;
    private Color gray_ = Color.LIGHT_GRAY;
    private int grayAsInt_ = Color.LIGHT_GRAY.getRGB();
    private int divergentColorsCount_;
    private Color[] palette_ = null;
    private int[][] loopCounts_ = null;
    private boolean[] rowsDone_ = null;
    private boolean everFinishedP_ = false;
    private BufferedImage image_ = null;
    private HashMap<Integer, Color> prevCalcColors_ = null;
    private FTCanvas parent_;

    public DrawResults(FractalSpec fractalSpec, Color[] colorArray, boolean[] blArray, FTCanvas fTCanvas) {
        this.spec_ = new FractalSpec(fractalSpec);
        this.palette_ = Arrays.copyOf(colorArray, colorArray.length);
        this.parent_ = fTCanvas;
        this.divergentColorsCount_ = this.palette_.length - 1;
        this.image_ = new BufferedImage(this.spec_.pix_width, this.spec_.pix_height, 2);
        this.loopCounts_ = new int[this.spec_.pix_width][this.spec_.pix_height];
        this.rowsDone_ = blArray;
        for (int i = 0; i < this.spec_.pix_width; ++i) {
            Arrays.fill(this.loopCounts_[i], 0, this.spec_.pix_height, -1);
            for (int j = 0; j < this.spec_.pix_height; ++j) {
                this.image_.setRGB(i, j, this.grayAsInt_);
            }
        }
        this.prevCalcColors_ = new HashMap(this.spec_.pix_width * this.spec_.pix_height / 4);
        this.prevCalcColors_.put(this.spec_.depth, this.getNonDivColor());
    }

    public DrawResults(FractalSpec fractalSpec, Color[] colorArray, boolean[] blArray, BufferedImage bufferedImage, FTCanvas fTCanvas) {
        this.spec_ = new FractalSpec(fractalSpec);
        this.parent_ = fTCanvas;
        this.image_ = bufferedImage;
        this.rowsDone_ = blArray;
        int n = colorArray.length;
        this.palette_ = colorArray;
        if (this.parent_.isReadGIF_p()) {
            this.loopCounts_ = new int[bufferedImage.getWidth()][bufferedImage.getHeight()];
            this.prevCalcColors_ = new HashMap(350);
            for (int i = 0; i < this.palette_.length; ++i) {
                this.prevCalcColors_.put(i, this.palette_[i]);
            }
            this.fillLoopCounts(bufferedImage.getWidth(), bufferedImage.getHeight());
            this.divergentColorsCount_ = this.palette_.length - 1;
        } else {
            this.palette_ = null;
            this.divergentColorsCount_ = this.spec_.colorsCount - 1;
            this.loopCounts_ = null;
            this.prevCalcColors_ = null;
        }
    }

    private void fillLoopCounts(int n, int n2) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = this.image_.getRGB(i, j);
                Integer n4 = (Integer)hashMap.get(n3);
                if (n4 == null) {
                    n4 = this.findColorInGuide(n3);
                    hashMap.put(n3, n4);
                }
                this.loopCounts_[i][j] = n4;
            }
        }
    }

    private int findColorInGuide(int n) {
        for (int i = 0; i < this.palette_.length; ++i) {
            if (n != this.palette_[i].getRGB()) continue;
            return i;
        }
        FTCentral.message("DrawResults.findColorInGuide in creating fake loop counts for a loaded GIF image unexpectedly encountered a color not in the current color set: " + n, true);
        return 255;
    }

    public BufferedImage refreshImage() {
        this.image_ = new BufferedImage(this.spec_.pix_width, this.spec_.pix_height, 2);
        for (int i = 0; i < this.spec_.pix_height; ++i) {
            for (int j = 0; j < this.spec_.pix_width; ++j) {
                int n = this.getLoopCount(j, i);
                this.setPixel(j, i, n);
            }
        }
        return this.image_;
    }

    public int getLoopCount(int n, int n2) {
        return this.loopCounts_[n][n2];
    }

    public int[][] getLoopCounts() {
        return this.loopCounts_;
    }

    public int guide(int n, int n2) {
        return this.loopCounts_[n][n2];
    }

    public void setRowDone(int n) {
        this.rowsDone_[n] = true;
    }

    public boolean isRowDone(int n) {
        return this.rowsDone_[n];
    }

    public boolean isFinished() {
        if (this.everFinishedP_) {
            return true;
        }
        for (int i = 0; i < this.spec_.pix_height; ++i) {
            if (this.rowsDone_[i]) continue;
            return false;
        }
        this.everFinishedP_ = true;
        return true;
    }

    public BufferedImage setPaletteGetImage(Color[] colorArray) {
        this.palette_ = colorArray;
        this.divergentColorsCount_ = this.palette_.length - 1;
        this.refresh();
        return this.image_;
    }

    public BufferedImage getImage() {
        return this.image_;
    }

    private Color getNonDivColor() {
        if (this.palette_ == null) {
            return Color.BLACK;
        }
        return this.palette_[this.palette_.length - 1];
    }

    public Color setPixel(int n, int n2, int n3) {
        this.loopCounts_[n][n2] = n3;
        Color color = this.prevCalcColors_.get(n3);
        if (color == null) {
            if (n3 >= this.spec_.depth) {
                color = this.getNonDivColor();
            } else {
                int n4 = (int)((double)n3 / this.spec_.loops_per_color);
                if (this.spec_.interpolateColors == 0 || this.spec_.loops_per_color == 1.0) {
                    int n5 = n4 % this.divergentColorsCount_;
                    color = this.palette_[n5];
                } else {
                    int n6 = Math.round((float)this.spec_.loops_per_color);
                    n4 = n3 / n6;
                    int n7 = n4 % this.divergentColorsCount_;
                    int n8 = n3 % n6;
                    if (n8 == 0) {
                        color = this.palette_[n7];
                    } else {
                        int n9 = (n4 + 1) % this.divergentColorsCount_;
                        Color color2 = this.palette_[n7];
                        Color color3 = this.palette_[n9];
                        float f = (float)n8 / (float)n6;
                        color = this.interpolate(color2, color3, f);
                    }
                }
            }
            this.prevCalcColors_.put(n3, color);
        }
        this.image_.setRGB(n, n2, color.getRGB());
        if (n == this.spec_.pix_width - 1) {
            this.setRowDone(n2);
        }
        return color;
    }

    public void setPixel(int n, int n2, int n3, Color color) {
        this.loopCounts_[n][n2] = n3;
        this.image_.setRGB(n, n2, color.getRGB());
        if (n == this.spec_.pix_width - 1) {
            this.setRowDone(n2);
        }
    }

    public Color setLine(int n, int n2, int n3, int n4) {
        Color color = this.setPixel(n, n3, n4);
        for (int i = n; i <= n2; ++i) {
            this.setPixel(i, n3, n4, color);
        }
        return color;
    }

    public Color setLine(int n, int n2, int n3, int n4, Color color) {
        for (int i = n; i <= n2; ++i) {
            this.setPixel(i, n3, n4, color);
        }
        return color;
    }

    private void refresh() {
        try {
            HashMap<Integer, Color> hashMap = new HashMap<Integer, Color>(this.spec_.depth / ((int)this.spec_.loops_per_color * this.palette_.length));
            for (int i = 0; i < this.spec_.pix_width; ++i) {
                for (int j = 0; j < this.spec_.pix_height; ++j) {
                    int n = this.loopCounts_[i][j];
                    Color color = (Color)hashMap.get(n);
                    if (color == null) {
                        if (n >= this.spec_.depth) {
                            color = this.getNonDivColor();
                        } else {
                            int n2 = (int)((double)n / this.spec_.loops_per_color);
                            if (this.spec_.interpolateColors == 0 || this.spec_.loops_per_color == 1.0) {
                                var7_8 = n2 % this.divergentColorsCount_;
                                color = this.palette_[var7_8];
                            } else {
                                var7_8 = Math.round((float)this.spec_.loops_per_color);
                                n2 = n / var7_8;
                                int n3 = n2 % this.divergentColorsCount_;
                                int n4 = n % var7_8;
                                if (n4 == 0) {
                                    color = this.palette_[n3];
                                } else {
                                    int n5 = (n2 + 1) % this.divergentColorsCount_;
                                    Color color2 = this.palette_[n3];
                                    Color color3 = this.palette_[n5];
                                    float f = (float)n4 / (float)var7_8;
                                    color = this.interpolate(color2, color3, f);
                                }
                            }
                        }
                        hashMap.put(n, color);
                    }
                    if (color == null) continue;
                    this.image_.setRGB(i, j, color.getRGB());
                    this.prevCalcColors_.put(n, color);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            FTCentral.message("DrawResults.refresh: We don't currently have a count for each pixel. \n  Perhaps you need to finish a drawing or read in a .ftr format picture.", true);
        }
    }

    private Color interpolate(Color color, Color color2, float f) {
        int n;
        int n2 = color.getRed();
        int n3 = color2.getRed();
        int n4 = color.getGreen();
        int n5 = color2.getGreen();
        int n6 = color.getBlue();
        int n7 = color2.getBlue();
        if (this.spec_.interpolateColors == 2) {
            int n8 = Math.round((float)(n3 - n2) * f) + n2;
            int n9 = Math.round((float)(n5 - n4) * f) + n4;
            int n10 = Math.round((float)(n7 - n6) * f) + n6;
            return new Color(n8, n9, n10);
        }
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        Color.RGBtoHSB(n2, n4, n6, fArray);
        Color.RGBtoHSB(n3, n5, n7, fArray2);
        float[] fArray3 = new float[3];
        if (this.spec_.interpolateColors == 1 || this.spec_.interpolateColors == 3) {
            float f2;
            n = this.spec_.interpolateColors == 3 ? 1 : 0;
            float f3 = fArray2[0] - fArray[0];
            f3 = fArray2[0] - fArray[0];
            if (Math.abs(f2) > 0.5f) {
                int n11 = n = n == 0 ? 1 : 0;
            }
            if (n != 0) {
                f3 = f3 >= 0.0f ? (f3 -= 1.0f) : (f3 += 1.0f);
            }
            float f4 = f3 * f + fArray[0];
            if (n != 0) {
                if (f4 > 1.0f) {
                    f4 -= 1.0f;
                } else if (f4 < 0.0f) {
                    f4 += 1.0f;
                }
            }
            fArray3[0] = f4;
            for (int i = 1; i < 3; ++i) {
                fArray3[i] = (fArray2[i] - fArray[i]) * f + fArray[i];
            }
        } else {
            FTCentral.message("DrawResults.interpolate found an unexpected spec_.interpolateColors value: " + this.spec_.interpolateColors, true);
        }
        n = Color.HSBtoRGB(fArray3[0], fArray3[1], fArray3[2]);
        return new Color(n);
    }

    public String getCountsCSV() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.loopCounts_.length;
        int n6 = this.loopCounts_[0].length;
        int n7 = this.spec_.depth;
        for (int i = 0; i < n5; ++i) {
            int[] nArray = this.loopCounts_[i];
            for (int j = 0; j < n6; ++j) {
                n = nArray[j];
                if (n < n2) {
                    n2 = n;
                }
                if (n <= n3 || n >= n7) continue;
                n3 = n;
            }
        }
        int[] nArray = new int[n3 - n2 + 1];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n5; ++i) {
            int[] nArray2 = this.loopCounts_[i];
            for (n = 0; n < n6; ++n) {
                int n8 = nArray2[n];
                if (n8 < n7) {
                    int n9 = n8 - n2;
                    nArray[n9] = nArray[n9] + 1;
                    continue;
                }
                ++n4;
            }
        }
        long l = 0L;
        for (n = 0; n < nArray.length; ++n) {
            l += (long)nArray[n];
        }
        double d = Long.valueOf(l).doubleValue();
        double d2 = Math.pow(10.0, Math.ceil(Math.log10(d)));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            stringBuilder.append(String.valueOf(i + n2) + "," + nArray[i] + "," + this.adjCountPercentPrecision((double)nArray[i] / d, d2) + "\n");
        }
        if (n4 > 0) {
            stringBuilder.append(String.valueOf(n7) + "," + n4 + "," + this.adjCountPercentPrecision((double)n4 / d, d2) + "\n");
        }
        return stringBuilder.toString();
    }

    private double adjCountPercentPrecision(double d, double d2) {
        double d3 = Math.round(d * d2);
        double d4 = d3 * 100.0 / d2;
        return d4;
    }
}

