/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

public class Complex {
    public double r;
    public double i;
    public double j;
    public double k;

    public Complex(double d, double d2) {
        this.r = d;
        this.i = d2;
    }

    public Complex() {
        this.i = 0.0;
        this.r = 0.0;
    }

    public Complex(Complex complex) {
        this.r = complex.r;
        this.i = complex.i;
    }

    public void setR(double d) {
        this.r = d;
    }

    public void setI(double d) {
        this.i = d;
    }

    public String rToString() {
        return String.valueOf(this.r);
    }

    public String iToString() {
        return String.valueOf(this.i);
    }

    public Complex assign_from(Complex complex) {
        this.r = complex.r;
        this.i = complex.i;
        return this;
    }

    public boolean equal_p(Complex complex) {
        return this.r == complex.r && this.i == complex.i;
    }

    public Complex plus(Complex complex) {
        return new Complex(this.r + complex.r, this.i + complex.i);
    }

    public Complex plus_equal(Complex complex) {
        this.r += complex.r;
        this.i += complex.i;
        return this;
    }

    public Complex minus(Complex complex) {
        return new Complex(this.r - complex.r, this.i - complex.i);
    }

    public Complex minus_equal(Complex complex) {
        this.r -= complex.r;
        this.i -= complex.i;
        return this;
    }

    public Complex times(Complex complex) {
        return new Complex(this.r * complex.r - this.i * complex.i, this.r * complex.i + this.i * complex.r);
    }

    public Complex times_scalar_n(double d) {
        this.r *= d;
        this.i *= d;
        return this;
    }

    public Complex times_scalar_n(int n) {
        this.r *= (double)n;
        this.i *= (double)n;
        return this;
    }

    public Complex times_scalar(double d) {
        return new Complex(this.r * d, this.i * d);
    }

    public Complex times_scalar(int n) {
        return new Complex(this.r * (double)n, this.i * (double)n);
    }

    public Complex times_equal(Complex complex) {
        double d = this.r * complex.r - this.i * complex.i;
        double d2 = this.r * complex.i + this.i * complex.r;
        this.r = d;
        this.i = d2;
        return this;
    }

    public Complex toPower(int n) {
        switch (n) {
            case 0: {
                return new Complex(1.0, 0.0);
            }
            case 1: {
                return new Complex(this);
            }
            case 2: {
                return this.times(this);
            }
            case 3: {
                return this.times(this).times(this);
            }
        }
        if (n % 2 == 1) {
            Complex complex = new Complex(this.toPower((n - 1) / 2));
            return complex.times_equal(complex).times_equal(this);
        }
        Complex complex = new Complex(this.toPower(n / 2));
        return complex.times_equal(complex);
    }

    public double dot(Complex complex) {
        return this.r * complex.r + this.i * complex.i;
    }

    public Complex projection_onto(Complex complex) {
        return complex.times_scalar(this.dot(complex));
    }

    public Complex orthogonal_component_to(Complex complex) {
        Complex complex2 = this.minus(this.projection_onto(complex));
        double d = complex2.magnitude();
        if (d < 1.0E-20) {
            return new Complex();
        }
        complex2.normalize_n();
        Complex complex3 = complex2.minus(complex2.projection_onto(complex));
        if (complex3.magnitude() < 0.9) {
            return new Complex();
        }
        if (Math.abs(complex3.r) < 1.0E-15) {
            complex3.r = 0.0;
        }
        if (Math.abs(complex3.i) < 1.0E-15) {
            complex3.i = 0.0;
        }
        if (complex3.magnitude() < 1.0E-15) {
            return new Complex();
        }
        return complex3.normalize_n().times_scalar(d);
    }

    public double magnitude() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public double magnitude_sq() {
        return this.r * this.r + this.i * this.i;
    }

    public Complex normalize_n() {
        double d = this.magnitude();
        this.r /= d;
        this.i /= d;
        return this;
    }

    public boolean normalizePerpendicularTo(Complex complex) {
        if (complex.magnitude() == 0.0) {
            return false;
        }
        if (this.magnitude() == 0.0) {
            return false;
        }
        Complex complex2 = new Complex(this);
        Complex complex3 = new Complex(complex);
        complex3.normalize_n();
        complex2.normalize_n();
        complex2 = complex2.orthogonal_component_to(complex3);
        if (complex2.magnitude() < 1.0E-15) {
            return false;
        }
        complex2.normalize_n();
        this.assign_from(complex2);
        complex.assign_from(complex3);
        return true;
    }

    public static Complex rotate(double d, Complex complex, Complex complex2) {
        double d2;
        double d3;
        double d4;
        double d5 = d * Math.PI / 180.0;
        if (d == 90.0) {
            d4 = 0.0;
            d3 = 1.0;
        } else if (d == 0.0) {
            d4 = 1.0;
            d3 = 0.0;
        } else {
            d4 = Math.cos(d5);
            d3 = Math.sin(d5);
        }
        double d6 = complex.r * d4 + complex2.r * d3;
        if (d6 == -0.0) {
            d6 = 0.0;
        }
        if ((d2 = complex.i * d4 + complex2.i * d3) == -0.0) {
            d2 = 0.0;
        }
        return new Complex(d6, d2);
    }

    public void print(String string) {
        System.out.println(string + " r=" + this.r + " i=" + this.i);
    }

    public String toString() {
        return " r=" + this.r + " i=" + this.i;
    }

    static double atanIndex(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = Math.abs(d3 - d);
        double d6 = d5 == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(d4 - d2) / d5);
        if (d6 < 0.0) {
            d6 += Math.PI;
        }
        if (bl) {
            return 0.984375 * (d6 / Math.PI);
        }
        return 0.984375 * (d6 / Math.PI) + 0.5;
    }

    static double atanIndex(Complex complex, Complex complex2, boolean bl) {
        double d = Math.abs(complex2.r - complex.r);
        double d2 = d == 0.0 ? 1.5707963267948966 : Math.atan(Math.abs(complex2.i - complex.i) / d);
        if (d2 < 0.0) {
            d2 += Math.PI;
        }
        if (bl) {
            return 0.984375 * (d2 / Math.PI);
        }
        return 0.984375 * (d2 / Math.PI) + 0.5;
    }
}

