/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import us.lystad.fractaltop.ColorGuideEditor;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseCkBoxListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.FTCentral;

public class ColorGuideEditorDialog
extends Dialog {
    ColorGuideEditorDialog self_;
    HashMap<String, String> values_;
    JLabel availableColors_;
    JCheckBox sigIsFraction_;
    ColorGuideEditor parent_;
    public String granularity_ = "Granularity";

    public ColorGuideEditorDialog(ColorGuideEditor colorGuideEditor) {
        super(colorGuideEditor, "Cluster, Partition, & Picture Extraction Parameters", true);
        this.addWindowListener(new MyWindowActionListener());
        this.parent_ = colorGuideEditor;
        this.self_ = this;
        this.values_ = new HashMap();
        this.setLayout(new GridLayout(1, 3, 0, 5));
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        this.add(panel);
        this.add(panel2);
        this.add(panel3);
        panel.setLayout(new GridLayout(9, 1, 0, 5));
        panel2.setLayout(new GridLayout(9, 1, 0, 5));
        panel3.setLayout(new GridLayout(9, 1, 0, 5));
        JLabel jLabel = new JLabel(this.granularity_);
        jLabel.addMouseListener(new DocuMouseListener(this.granularity_));
        jLabel.setHorizontalAlignment(0);
        panel.add(jLabel);
        JLabel jLabel2 = new JLabel("Max. Colors");
        jLabel2.addMouseListener(new DocuMouseListener("Max. Colors"));
        jLabel2.setHorizontalAlignment(0);
        panel.add(jLabel2);
        JLabel jLabel3 = new JLabel("Significant #");
        jLabel3.addMouseListener(new DocuMouseListener("Significant #"));
        jLabel3.setHorizontalAlignment(0);
        panel.add(jLabel3);
        JLabel jLabel4 = new JLabel("Minimum Saturation");
        jLabel4.addMouseListener(new DocuMouseListener("Minimum Saturation"));
        jLabel4.setHorizontalAlignment(0);
        panel.add(jLabel4);
        JTextField jTextField = new JTextField();
        jTextField.getDocument().addDocumentListener(new JTextDocumentListener(jTextField, true, "minSaturation"));
        jTextField.setHorizontalAlignment(4);
        panel.add(jTextField);
        JLabel jLabel5 = new JLabel("Hue Cluster Weight");
        jLabel5.addMouseListener(new DocuMouseListener("Hue Cluster Weight"));
        jLabel5.setHorizontalAlignment(0);
        panel.add(jLabel5);
        JTextField jTextField2 = new JTextField();
        jTextField2.getDocument().addDocumentListener(new JTextDocumentListener(jTextField2, true, "hueWeight"));
        jTextField2.setHorizontalAlignment(4);
        panel.add(jTextField2);
        JLabel jLabel6 = new JLabel("Partition Groups");
        jLabel6.addMouseListener(new DocuMouseListener("Partition Groups"));
        jLabel6.setHorizontalAlignment(0);
        panel.add(jLabel6);
        JLabel jLabel7 = new JLabel("");
        panel.add(jLabel7);
        JTextField jTextField3 = new JTextField();
        jTextField3.getDocument().addDocumentListener(new granularityTextLNR(jTextField3));
        jTextField3.setHorizontalAlignment(4);
        panel2.add(jTextField3);
        JTextField jTextField4 = new JTextField();
        jTextField4.getDocument().addDocumentListener(new JTextDocumentListener(jTextField4, true, "maxColors"));
        jTextField4.setHorizontalAlignment(4);
        panel2.add(jTextField4);
        JTextField jTextField5 = new JTextField();
        jTextField5.setHorizontalAlignment(4);
        panel2.add(jTextField5);
        String[] stringArray = new String[]{"None", "HSB", "HBS", "SHB", "SBH", "BHS", "BSH"};
        JLabel jLabel8 = new JLabel("Minimum Brightness");
        jLabel8.addMouseListener(new DocuMouseListener("Minimum Brightness"));
        jLabel8.setHorizontalAlignment(0);
        panel2.add(jLabel8);
        JTextField jTextField6 = new JTextField();
        jTextField6.getDocument().addDocumentListener(new JTextDocumentListener(jTextField6, true, "minBrightness"));
        jTextField6.setHorizontalAlignment(4);
        panel2.add(jTextField6);
        JLabel jLabel9 = new JLabel("Saturation Weight");
        jLabel9.addMouseListener(new DocuMouseListener("Saturation Weight"));
        jLabel9.setHorizontalAlignment(0);
        panel2.add(jLabel9);
        JTextField jTextField7 = new JTextField();
        jTextField7.getDocument().addDocumentListener(new JTextDocumentListener(jTextField7, true, "saturationWeight"));
        jTextField7.setHorizontalAlignment(4);
        panel2.add(jTextField7);
        JTextField jTextField8 = new JTextField("1");
        this.values_.put("partitionGroupCount", "1");
        jTextField8.getDocument().addDocumentListener(new JTextDocumentListener(jTextField8, true, "partitionGroupCount"));
        jTextField8.setHorizontalAlignment(4);
        panel2.add(jTextField8);
        JLabel jLabel10 = new JLabel("");
        panel2.add(jLabel10);
        this.availableColors_ = new JLabel("");
        this.availableColors_.setHorizontalAlignment(0);
        panel3.add(this.availableColors_);
        JLabel jLabel11 = new JLabel("");
        panel3.add(jLabel11);
        this.sigIsFraction_ = new JCheckBox("  Fraction, not count", true);
        this.sigIsFraction_.addMouseListener(new DocuMouseCkBoxListener(this.sigIsFraction_, "Fraction, not count"));
        JTextDocumentListener jTextDocumentListener = new JTextDocumentListener(jTextField5, this.sigIsFraction_, "significantNumber", "sigIsFraction");
        jTextField5.getDocument().addDocumentListener(jTextDocumentListener);
        this.sigIsFraction_.addActionListener(actionEvent -> jTextDocumentListener.validateInputEtc());
        panel3.add(this.sigIsFraction_);
        JLabel jLabel12 = new JLabel("Maximum Brightness");
        jLabel12.addMouseListener(new DocuMouseListener("Maximum Brightness"));
        jLabel12.setHorizontalAlignment(0);
        panel3.add(jLabel12);
        JTextField jTextField9 = new JTextField();
        jTextField9.getDocument().addDocumentListener(new JTextDocumentListener(jTextField9, true, "maxBrightness"));
        jTextField9.setHorizontalAlignment(4);
        panel3.add(jTextField9);
        JLabel jLabel13 = new JLabel("Brightness Weight");
        jLabel13.addMouseListener(new DocuMouseListener("Brightness Weight"));
        jLabel13.setHorizontalAlignment(0);
        panel3.add(jLabel13);
        JTextField jTextField10 = new JTextField();
        jTextField10.getDocument().addDocumentListener(new JTextDocumentListener(jTextField10, true, "brightnessWeight"));
        jTextField10.setHorizontalAlignment(4);
        panel3.add(jTextField10);
        String[] stringArray2 = new String[]{"Hue", "Saturation", "Brightness", "S + B", "H + B", "H + S"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.addActionListener(new PartitionDropDownLNR(jComboBox, "partitionCriterion"));
        jComboBox.addMouseListener(new PartitionDropDownMouseLNR(jComboBox, jComboBox.getMouseListeners(), "partitionCriterion"));
        jComboBox.setSelectedIndex(3);
        panel3.add(jComboBox);
        JButton jButton = new JButton("DONE");
        jButton.setBackground(Color.CYAN);
        jButton.addActionListener(new DoneLNR("DONE"));
        panel3.add(jButton);
        jTextField3.setText("7");
        this.availableColors_.setText(String.valueOf("Possible colors: " + this.findAvailableColors(7)));
        this.availableColors_.addMouseListener(new DocuMouseListener("Possible colors:"));
        jTextField4.setText("1024");
        jTextField5.setText("0.00001");
        jTextField.setText("0.45");
        jTextField6.setText("0.30");
        jTextField9.setText("0.90");
        jTextField2.setText("25000");
        jTextField7.setText("100");
        jTextField10.setText("1");
        this.sigIsFraction_.setSelected(true);
        this.setPreferredSize(new Dimension(500, 150));
        this.setSize(500, 260);
        this.setVisible(false);
    }

    private int findAvailableColors(int n) {
        int n2 = 256 / n + (256 % n > 0 ? 1 : 0);
        return (int)Math.pow(n2, 3.0);
    }

    public double getNeighborhoodSize() {
        String string = this.values_.get("neighborhoodSize");
        if (string == null) {
            return 0.0;
        }
        return Double.valueOf(string);
    }

    public float[] getHSBWeights() {
        float f = Float.valueOf(this.values_.get("hueWeight")).floatValue();
        float f2 = Float.valueOf(this.values_.get("saturationWeight")).floatValue();
        float f3 = Float.valueOf(this.values_.get("brightnessWeight")).floatValue();
        return new float[]{f, f2, f3};
    }

    public int getGranularity() {
        String string = this.values_.get("granularity");
        return Integer.parseInt(string);
    }

    public int getMaxColors() {
        String string = this.values_.get("maxColors");
        return Integer.parseInt(string);
    }

    public double getSignificantNumber() {
        String string = this.values_.get("significantNumber");
        return Double.valueOf(string);
    }

    public boolean getSigIsFraction() {
        String string = this.values_.get("sigIsFraction");
        return Boolean.valueOf(string);
    }

    public boolean getNeighborhoodIsFraction() {
        String string = this.values_.get("nbhoodIsFraction");
        return Boolean.valueOf(string);
    }

    public float getMinSaturation() {
        String string = this.values_.get("minSaturation");
        return Float.parseFloat(string);
    }

    public float getMinBrightness() {
        String string = this.values_.get("minBrightness");
        return Float.parseFloat(string);
    }

    public float getMaxBrightness() {
        String string = this.values_.get("maxBrightness");
        return Float.parseFloat(string);
    }

    public int getPartitionCount() {
        String string = this.values_.get("partitionGroupCount");
        return Integer.parseInt(string);
    }

    public String getPartitionCriterion() {
        return this.values_.get("partitionCriterion");
    }

    public int[] getInitialSort() {
        String string = this.values_.get("initialSort");
        if (string == null) {
            return null;
        }
        switch (string) {
            case "HSB": {
                return new int[]{0, 1, 2};
            }
            case "HBS": {
                return new int[]{0, 2, 1};
            }
            case "SHB": {
                return new int[]{1, 0, 2};
            }
            case "SBH": {
                return new int[]{1, 2, 0};
            }
            case "BHS": {
                return new int[]{2, 1, 0};
            }
            case "BSH": {
                return new int[]{2, 0, 1};
            }
        }
        return null;
    }

    class MyWindowActionListener
    extends WindowAdapter {
        MyWindowActionListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                ColorGuideEditorDialog.this.setVisible(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class JTextDocumentListener
    implements DocumentListener {
        private JTextField jTextField_;
        private boolean intP_;
        private JCheckBox checkBox_;
        private String key0_;
        private String key1_;

        public JTextDocumentListener(JTextField jTextField, boolean bl, String string) {
            this.jTextField_ = jTextField;
            boolean bl2 = bl;
            this.checkBox_ = null;
            this.key0_ = string;
        }

        public JTextDocumentListener(JTextField jTextField, JCheckBox jCheckBox, String string, String string2) {
            this.jTextField_ = jTextField;
            this.checkBox_ = jCheckBox;
            boolean bl = false;
            this.key0_ = string;
            this.key1_ = string2;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateInputEtc();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateInputEtc();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public boolean validateInputEtc() {
            String string = this.jTextField_.getText();
            try {
                if (this.checkBox_ != null) {
                    if (this.checkBox_.isSelected()) {
                        double d = Double.parseDouble(string);
                    } else {
                        int n = Integer.parseInt(string);
                    }
                    ColorGuideEditorDialog.this.values_.put(this.key1_, String.valueOf(this.checkBox_.isSelected()));
                } else if (this.intP_) {
                    int n = Integer.parseInt(string);
                } else {
                    double d = Double.parseDouble(string);
                }
                this.jTextField_.setForeground(Color.BLACK);
                ColorGuideEditorDialog.this.values_.put(this.key0_, string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.jTextField_.setForeground(Color.RED);
                return false;
            }
        }
    }

    class granularityTextLNR
    extends JTextDocumentListener {
        public granularityTextLNR(JTextField jTextField) {
            super(jTextField, true, "granularity");
        }

        @Override
        public boolean validateInputEtc() {
            try {
                if (super.validateInputEtc()) {
                    String string = "granularity";
                    String string2 = ColorGuideEditorDialog.this.values_.get(string);
                    int n = Integer.parseInt(string2);
                    String string3 = "Possible colors: " + ColorGuideEditorDialog.this.findAvailableColors(n);
                    ColorGuideEditorDialog.this.availableColors_.setText(string3);
                    return true;
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("Unexpected error in ColorGuideEditorDialog$granularityTextLNR.validateInputEtc:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
            return false;
        }
    }

    class PartitionDropDownLNR
    implements ActionListener {
        JComboBox comp_;
        String key_;

        public PartitionDropDownLNR(JComboBox jComboBox, String string) {
            this.comp_ = jComboBox;
            this.key_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.comp_.getSelectedItem();
            ColorGuideEditorDialog.this.values_.put(this.key_, string);
        }
    }

    class PartitionDropDownMouseLNR
    extends MouseAdapter {
        MouseListener[] otherListeners_;
        String key_;

        public PartitionDropDownMouseLNR(Component component, MouseListener[] mouseListenerArray, String string) {
            this.otherListeners_ = mouseListenerArray;
            this.key_ = string;
            for (int i = 0; i < this.otherListeners_.length; ++i) {
                component.removeMouseListener(this.otherListeners_[i]);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                for (int i = 0; i < this.otherListeners_.length; ++i) {
                    this.otherListeners_[i].mousePressed(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                for (int i = 0; i < this.otherListeners_.length; ++i) {
                    this.otherListeners_[i].mouseReleased(mouseEvent);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown()) {
                Object object = FTCentral.findDocString(this.key_);
                if (object == null || ((String)object).length() == 0) {
                    object = "\"" + this.key_ + "\" is not documented.";
                }
                JOptionPane.showMessageDialog(mouseEvent.getComponent(), object);
            } else {
                for (int i = 0; i < this.otherListeners_.length; ++i) {
                    this.otherListeners_[i].mouseClicked(mouseEvent);
                }
            }
        }
    }

    class DoneLNR
    extends DocuActionListener {
        public DoneLNR(String string) {
            super(ColorGuideEditorDialog.this.self_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditorDialog.this.self_.setVisible(false);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in FTWindow.seqLNR.  " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    public class RightAlignedComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

