/*
 * Decompiled with CFR 0.152.
 */
package us.lystad.fractaltop;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Node;
import us.lystad.fractaltop.ColorGuideEditorDialog;
import us.lystad.fractaltop.DocuActionListener;
import us.lystad.fractaltop.DocuMouseListener;
import us.lystad.fractaltop.DoubleDialog;
import us.lystad.fractaltop.FTCanvas;
import us.lystad.fractaltop.FTCentral;
import us.lystad.fractaltop.FTFileChooser;
import us.lystad.fractaltop.FTIO;
import us.lystad.fractaltop.FTWindow;
import us.lystad.fractaltop.IntDialog;
import us.lystad.fractaltop.StandardColorGuides;
import us.lystad.fractaltop.TrapFrame;

public class ColorGuideEditor
extends JFrame
implements MouseListener,
MouseMotionListener {
    static FTCentral fTCentral_ = null;
    public static ColorGuideEditor editor_ = null;
    private static FTFileChooser fileChooser_ = null;
    private static FTFileChooser pixFileChooser_ = null;
    static final String clipboardName_ = "clipboard";
    ColorGuideEditorDialog clusterDialog_;
    BufferedImage checkerboardImage_;
    boolean showCheckerboardP_ = true;
    JPanel checkPanel_;
    BufferedImage paletteImage_;
    static final Color PALETTE_NEUTRAL = Color.LIGHT_GRAY;
    static final Color DARK_GREEN = new Color(0, 127, 0);
    static final Color LIGHT_GREEN = new Color(127, 255, 127);
    Color boxColor_ = DARK_GREEN;
    int ptBoxLoopCount_ = -1;
    Color transparentColor_;
    Color[] color_guide_;
    int paletteRows_;
    HashMap<String, ArrayList<Color>> guideStorage_;
    ArrayList<JMenuItem> menuItemsRequiringInterval_;
    Color colorClipboard_ = this.transparentColor_ = new Color(0, 0, 0, 0);
    int windowWidth_ = 578;
    int windowHeight_ = 742;
    int minWindowHeight_ = 442;
    int viewportInitialWidth_ = 503;
    int viewportInitialHeight_ = 628;
    float prevHueAdjust_ = 0.0f;
    float prevSaturationAdjust_ = 0.0f;
    float prevBrighnessAdjust_ = 0.0f;
    int prevTransparencyAdjust_ = 0;
    int prevHowMany_ = 10;
    int prevExpandBy_ = 2;
    EditorImageFilter pictureChoosableFileFilter_;
    EditorImageFilter textPngChoosableFileFilter_;
    private final int colorsPerRow_ = 20;
    private final int colorSquareSize = 22;
    private final int interSquareSize = 3;
    private final int increment = 25;
    private static final int checkSize_ = 4;
    private JButton cancelButton_ = null;
    private JPanel rowNumbersPanel_;
    private JScrollPane scrollPane_;
    private JPanel palettePanel_;
    private TextField colorCountText_;
    private TextField rotateText_;
    private JLabel instructions_;
    private JPanel nonDivColorPanel_;
    private JMenu importsJMenu_;
    private JMenu exportsJMenu_;
    private JMenu storageJMenu_;
    private JMenuItem copyIntToClipboardMI_;
    private JMenuItem copyIntToNameMI_;
    private JMenuItem copyAllToNameMI_;
    private JMenuItem deleteStorageMI_;
    private JMenuItem undoMI_;
    private JMenuItem redoMI_;
    private JMenuItem clearBoxMI_;
    private JMenuItem overwriteClipAtCurMI_;
    private JMenuItem insertClipAtCursorMI_;
    private JMenuItem trapFrameImportMI_;
    private JMenuItem trapFrameExportMI_;
    Stack<UndoRecord> undoStack_ = new Stack();
    Stack<UndoRecord> redoStack_ = new Stack();
    Stack<ClickListener> clickListeners_ = new Stack();
    int cursorPosition_;
    int desiredCursorPosition_;
    boolean cursorVisible_;
    Color cursorColor_;
    Timer blinkerTimer_;
    int intervalStart_;
    int desiredIntervalStart_;
    int intervalEnd_;
    int desiredIntervalEnd_;
    Color intervalColor_;
    int width_ = 503;
    boolean waitingForDouble_ = false;
    int clickCount_ = 0;
    int mouseDownColorIndex_ = -1;
    boolean iveBeenDraggedP_ = false;
    MouseEvent singleClickMouseEvent_ = null;
    IntPoint mousePressedAnchor_;
    int savedIntervalStart_ = -1;
    int savedIntervalEnd_ = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color[] readColorGuideFile(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = fileInputStream.readAllBytes();
            String string = new String(byArray);
            Color[] colorArray = ColorGuideEditor.parseColorGuideString(string);
            return colorArray;
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.readColorGuideFile Error: ", throwable);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    private static Color[] parseColorGuideString(String string) {
        int n = Integer.parseUnsignedInt(string, 0, 4, 10);
        int n2 = string.length() / 8;
        if (n == 1) {
            Color[] colorArray = new Color[n2];
            for (int i = 4; i < string.length() - 1; i += 8) {
                int n3 = Integer.parseUnsignedInt(string, i, i + 8, 16);
                colorArray[i / 8] = new Color(n3, true);
            }
            return colorArray;
        }
        ColorGuideEditor.message("In ColorGuideEditor.parseColorGuideString: Wrong code at beginning of stored color guide String.");
        return null;
    }

    public ColorGuideEditor(FTCentral fTCentral) {
        try {
            fTCentral_ = fTCentral;
            editor_ = this;
            this.setTitle("Color Set Editor");
            this.setSize(this.windowWidth_, this.windowHeight_);
            this.setMaximumSize(new Dimension(this.windowWidth_, this.windowHeight_));
            this.setMinimumSize(new Dimension(this.windowWidth_, this.minWindowHeight_));
            String string = StandardColorGuides.getOldStandard();
            String string2 = StandardColorGuides.getNewStandard();
            String string3 = StandardColorGuides.getPastelRainbow();
            Color[] colorArray = ColorGuideEditor.parseColorGuideString(string);
            Color[] colorArray2 = ColorGuideEditor.parseColorGuideString(string2);
            Color[] colorArray3 = ColorGuideEditor.parseColorGuideString(string3);
            this.guideStorage_ = new HashMap();
            if (colorArray != null) {
                this.guideStorage_.put("Old Standard", new ArrayList<Color>(Arrays.asList(colorArray)));
            }
            if (colorArray2 != null) {
                this.guideStorage_.put("New Standard", new ArrayList<Color>(Arrays.asList(colorArray2)));
            }
            if (colorArray3 != null) {
                this.guideStorage_.put("Pastel Rainbow", new ArrayList<Color>(Arrays.asList(colorArray3)));
            }
            this.color_guide_ = colorArray2;
            int n = this.color_guide_.length - 1;
            this.paletteRows_ = n / 20 + (n % 20 == 0 ? 0 : 1);
            int n2 = Math.max(503, this.viewportInitialWidth_);
            int n3 = Math.max(3 + this.paletteRows_ * 25, this.viewportInitialHeight_);
            this.paletteImage_ = this.createPaletteImage(this.color_guide_, n2, n3);
            this.checkerboardImage_ = new BufferedImage(22, 22, 2);
            Graphics graphics = this.checkerboardImage_.getGraphics();
            ColorGuideEditor.createCheckerboardImage(graphics, 22, 22);
            graphics.dispose();
            this.menuItemsRequiringInterval_ = new ArrayList(30);
            this.pictureChoosableFileFilter_ = new EditorImageFilter("png, jpg, gif");
            this.textPngChoosableFileFilter_ = new EditorImageFilter("text, txt, png, ftr");
            fileChooser_ = new FTFileChooser(this);
            pixFileChooser_ = new FTFileChooser(this, "-pixChooser");
            MyWindowListener myWindowListener = new MyWindowListener();
            this.addWindowListener(myWindowListener);
            this.addWindowStateListener(myWindowListener);
            this.addWindowFocusListener(myWindowListener);
            this.blinkerTimer_ = new Timer(500, new BlinkenActionListener());
            this.blinkerTimer_.stop();
            JMenuBar jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
            this.importsJMenu_ = new JMenu("Import Colors", true);
            JMenuItem jMenuItem = new JMenuItem("Open Color Set File");
            jMenuItem.addActionListener(new readLNR("Import Colors->Open Color Set File"));
            this.importsJMenu_.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Create from Picture");
            jMenuItem2.addActionListener(new guideFromPixLNR("Import Colors->Create from Picture"));
            this.importsJMenu_.add(jMenuItem2);
            this.trapFrameImportMI_ = new JMenuItem("Trap Window");
            this.trapFrameImportMI_.addActionListener(new ImportFromTrapLNR("Import Colors->Trap Window"));
            this.trapFrameImportMI_.setEnabled(false);
            this.importsJMenu_.add(this.trapFrameImportMI_);
            this.importsJMenu_.addSeparator();
            this.exportsJMenu_ = new JMenu("Export Colors", true);
            JMenuItem jMenuItem3 = new JMenuItem("Write Color Set");
            jMenuItem3.addActionListener(new writeLNR("Export Colors->Write Color Set"));
            this.exportsJMenu_.add(jMenuItem3);
            this.trapFrameExportMI_ = new JMenuItem("Trap Window");
            this.trapFrameExportMI_.addActionListener(new ExportToTrapLNR("Export Colors->Trap Window"));
            this.trapFrameExportMI_.setEnabled(false);
            this.exportsJMenu_.add(this.trapFrameExportMI_);
            this.exportsJMenu_.addSeparator();
            String string4 = "Edit";
            JMenu jMenu = new JMenu(string4, true);
            this.undoMI_ = new JMenuItem("    Undo");
            this.undoMI_.addActionListener(new undoLNR("Edit->Undo"));
            this.undoMI_.setEnabled(false);
            jMenu.add(this.undoMI_);
            this.redoMI_ = new JMenuItem("    Redo");
            this.redoMI_.addActionListener(new redoLNR("Edit->Redo"));
            this.redoMI_.setEnabled(false);
            jMenu.add(this.redoMI_);
            jMenu.addSeparator();
            this.overwriteClipAtCurMI_ = new JMenuItem("    Overwrite Clipboardb at Cursor");
            JMenuItem jMenuItem4 = new JMenuItem("    Overwrite <name> at Cursor");
            jMenu.add(this.overwriteClipAtCurMI_);
            jMenu.add(jMenuItem4);
            this.overwriteClipAtCurMI_.addActionListener(new overwriteClipAtCurLNR("Edit->Overwrite Clipboardb at Cursor"));
            jMenuItem4.addActionListener(new overwriteNameAtCurLNR("Edit->Overwrite <name> at Cursor"));
            this.insertClipAtCursorMI_ = new JMenuItem("(L) Insert Clipboard at Cursor");
            JMenuItem jMenuItem5 = new JMenuItem("(L) Insert <name> at Cursor");
            JMenuItem jMenuItem6 = new JMenuItem("(L) Insert New at Cursor");
            jMenu.add(this.insertClipAtCursorMI_);
            jMenu.add(jMenuItem5);
            jMenu.add(jMenuItem6);
            this.insertClipAtCursorMI_.addActionListener(new insertClipboardLNR("Edit->Insert Clipboard at Cursor"));
            jMenuItem5.addActionListener(new insertNameLNR("Edit->Insert <name> at Cursor"));
            jMenuItem6.addActionListener(new InsertNewLNR("Edit->Insert New"));
            jMenu.addSeparator();
            JMenuItem jMenuItem7 = new JMenuItem("     Move Clicked to Cursor, Repeats");
            jMenu.add(jMenuItem7);
            jMenuItem7.addActionListener(new moveClickedToCurLNR("Edit->Move Clicked to Cursor, Repeats"));
            JMenuItem jMenuItem8 = new JMenuItem("(L) Delete Clicked, Repeats");
            jMenu.add(jMenuItem8);
            jMenuItem8.addActionListener(new DeleteClickedLNR("Edit->Delete Clicked, Repeats"));
            jMenu.addSeparator();
            JMenuItem jMenuItem9 = new JMenuItem("    2 click Copy Color, Repeats");
            JMenuItem jMenuItem10 = new JMenuItem("    2 click Swap Colors");
            JMenuItem jMenuItem11 = new JMenuItem("    2 click Rotate");
            JMenuItem jMenuItem12 = new JMenuItem("    Reverse All");
            jMenuItem12.addActionListener(new ReverseAllLNR("Edit->Reverse All"));
            jMenuItem9.addActionListener(new TwoClickCopyLNR("Edit->2 click Copy Color"));
            jMenuItem10.addActionListener(new TwoClickSwapLNR("Edit->2 click Swap Colors"));
            jMenuItem11.addActionListener(new TwoClickRotateLNR("Edit->2 click Rotate"));
            jMenu.add(jMenuItem9);
            jMenu.add(jMenuItem10);
            jMenu.add(jMenuItem11);
            jMenu.add(jMenuItem12);
            JMenu jMenu2 = new JMenu("Interval", true);
            JMenuItem jMenuItem13 = new JMenuItem("    Unset Interval");
            this.menuItemsRequiringInterval_.add(jMenuItem13);
            jMenuItem13.addActionListener(new unsetIntervalLNR("Interval->Unset Interval"));
            jMenu2.add(jMenuItem13);
            JMenuItem jMenuItem14 = new JMenuItem("    2 click Set Interval");
            jMenuItem14.addActionListener(new setInterval2cLNR("Interval->2 click Set Interval"));
            jMenu2.add(jMenuItem14);
            JMenuItem jMenuItem15 = new JMenuItem("    Set Interval to All");
            jMenuItem15.addActionListener(new setIntervalToAllLNR("Interval->Set Interval to All"));
            jMenu2.add(jMenuItem15);
            jMenu2.addSeparator();
            JMenuItem jMenuItem16 = new JMenuItem("    Move Interval to Cursor");
            this.menuItemsRequiringInterval_.add(jMenuItem16);
            jMenuItem16.addActionListener(new MoveIntToCurLNR("Interval->Move Interval to Cursor"));
            jMenu2.add(jMenuItem16);
            JMenuItem jMenuItem17 = new JMenuItem("    Overwrite Copy at Cursor");
            this.menuItemsRequiringInterval_.add(jMenuItem17);
            jMenuItem17.addActionListener(new overwriteAtCurLNR("Interval->Overwrite Copy at Cursor"));
            jMenu2.add(jMenuItem17);
            JMenuItem jMenuItem18 = new JMenuItem("(L) Insert Copy at Cursor");
            this.menuItemsRequiringInterval_.add(jMenuItem18);
            jMenuItem18.addActionListener(new insertIntervalLNR("Interval->Insert Copy at Cursor"));
            jMenu2.add(jMenuItem18);
            jMenu2.addSeparator();
            JMenuItem jMenuItem19 = new JMenuItem("    Adjust Hue...");
            jMenuItem19.addActionListener(new AdjHueLNR("Interval->Adjust Hue..."));
            this.menuItemsRequiringInterval_.add(jMenuItem19);
            jMenu2.add(jMenuItem19);
            JMenuItem jMenuItem20 = new JMenuItem("    Adjust Saturation...");
            jMenuItem20.addActionListener(new AdjSaturationLNR("Interval->Adjust Saturation..."));
            this.menuItemsRequiringInterval_.add(jMenuItem20);
            jMenu2.add(jMenuItem20);
            JMenuItem jMenuItem21 = new JMenuItem("    Adjust Brightness/Value...");
            jMenuItem21.addActionListener(new AdjBrightnessLNR("Interval->Adjust Brightness..."));
            this.menuItemsRequiringInterval_.add(jMenuItem21);
            jMenu2.add(jMenuItem21);
            JMenuItem jMenuItem22 = new JMenuItem("    Adjust Transparency...");
            jMenuItem22.addActionListener(new AdjTransparencyLNR("Interval->Adjust Transparency..."));
            this.menuItemsRequiringInterval_.add(jMenuItem22);
            jMenu2.add(jMenuItem22);
            jMenu2.addSeparator();
            JMenuItem jMenuItem23 = new JMenuItem("    Sort by Hue");
            JMenuItem jMenuItem24 = new JMenuItem("    Sort by Saturation");
            JMenuItem jMenuItem25 = new JMenuItem("    Sort by Brightness");
            jMenu2.add(jMenuItem23);
            jMenu2.add(jMenuItem24);
            jMenu2.add(jMenuItem25);
            this.menuItemsRequiringInterval_.add(jMenuItem23);
            this.menuItemsRequiringInterval_.add(jMenuItem24);
            this.menuItemsRequiringInterval_.add(jMenuItem25);
            jMenuItem23.addActionListener(new sortIntervalByHueLNR("Interval->Sort by Hue"));
            jMenuItem24.addActionListener(new sortIntervalBySatLNR("Interval->Sort by Saturation"));
            jMenuItem25.addActionListener(new sortIntervalByBriLNR("Interval->Sort by Brightness"));
            jMenu2.addSeparator();
            JMenuItem jMenuItem26 = new JMenuItem("    Ramp using RGB");
            JMenuItem jMenuItem27 = new JMenuItem("    Ramp using HSB");
            JMenuItem jMenuItem28 = new JMenuItem("    Ramp using LongH,SB");
            this.menuItemsRequiringInterval_.add(jMenuItem26);
            this.menuItemsRequiringInterval_.add(jMenuItem27);
            this.menuItemsRequiringInterval_.add(jMenuItem28);
            jMenuItem26.addActionListener(new rampRgbLNR("Interval->Ramp using RGB"));
            jMenuItem27.addActionListener(new rampHsbLNR(false, "Interval->Ramp using HSB"));
            jMenuItem28.addActionListener(new rampHsbLNR(true, "Interval->Ramp using LongH,SB"));
            jMenu2.add(jMenuItem26);
            jMenu2.add(jMenuItem27);
            jMenu2.add(jMenuItem28);
            jMenu2.addSeparator();
            JMenuItem jMenuItem29 = new JMenuItem("    Cluster Interval w/ settings");
            this.menuItemsRequiringInterval_.add(jMenuItem29);
            jMenuItem29.addActionListener(new clusterIntervalLNR("Interval->Cluster Interval w/ settings"));
            jMenu2.add(jMenuItem29);
            JMenuItem jMenuItem30 = new JMenuItem("    Partition Interval");
            this.menuItemsRequiringInterval_.add(jMenuItem30);
            jMenuItem30.addActionListener(new PartitionIntLNR(false, "Interval->Partition Interval"));
            jMenu2.add(jMenuItem30);
            JMenuItem jMenuItem31 = new JMenuItem("(L) Partition Interval Sep.");
            this.menuItemsRequiringInterval_.add(jMenuItem31);
            jMenuItem31.addActionListener(new PartitionIntLNR(true, "Interval->Partition Interval Sep"));
            jMenu2.add(jMenuItem31);
            jMenu2.addSeparator();
            JMenuItem jMenuItem32 = new JMenuItem("    Reverse");
            JMenuItem jMenuItem33 = new JMenuItem("    Randomize");
            JMenuItem jMenuItem34 = new JMenuItem("(L) Expand By...");
            JMenuItem jMenuItem35 = new JMenuItem("(L) Delete Interval");
            this.menuItemsRequiringInterval_.add(jMenuItem32);
            this.menuItemsRequiringInterval_.add(jMenuItem33);
            this.menuItemsRequiringInterval_.add(jMenuItem35);
            this.menuItemsRequiringInterval_.add(jMenuItem34);
            jMenuItem32.addActionListener(new ReverseIntLNR("Interval->Reverse"));
            jMenuItem33.addActionListener(new RandomizeIntLNR("Interval->Randomize"));
            jMenuItem34.addActionListener(new ExpandIntervalLNR("Interval->Expand By..."));
            jMenuItem35.addActionListener(new DeleteIntervalLNR("Interval->Delete Interval"));
            jMenu2.add(jMenuItem32);
            jMenu2.add(jMenuItem33);
            jMenu2.add(jMenuItem34);
            jMenu2.add(jMenuItem35);
            JMenu jMenu3 = new JMenu("Settings", true);
            JMenuItem jMenuItem36 = new JMenuItem("Edit Cluster Paramerers");
            jMenuItem36.addActionListener(new showClusterDialogLNR("Settings->Edit Cluster Paramerers"));
            jMenu3.add(jMenuItem36);
            jMenu3.addSeparator();
            this.clearBoxMI_ = new JMenuItem("Clear Point Box");
            JMenuItem jMenuItem37 = new JMenuItem("Toggle Checkerboard");
            this.clearBoxMI_.addActionListener(new clearBoxLNR("Settings->Clear Point Box"));
            jMenuItem37.addActionListener(new checkerboardLNR("Settings->Toggle Checkerboard"));
            jMenu3.add(this.clearBoxMI_);
            jMenu3.add(jMenuItem37);
            jMenu3.addSeparator();
            JMenuItem jMenuItem38 = new JMenuItem("Set Cursor Color");
            JMenuItem jMenuItem39 = new JMenuItem("Set Interval Color");
            JMenuItem jMenuItem40 = new JMenuItem("Set Point Box Color");
            jMenuItem38.addActionListener(new ColorCursorLNR("Settings->Set Cursor Color"));
            jMenuItem39.addActionListener(new ColorIntervalLNR("Settings->Set Interval Color"));
            jMenuItem40.addActionListener(new ColorPtBoxLNR("Settings->Set Point Box Color"));
            jMenu3.add(jMenuItem38);
            jMenu3.add(jMenuItem39);
            jMenu3.add(jMenuItem40);
            this.storageJMenu_ = new JMenu("Storage", true);
            this.copyIntToClipboardMI_ = new JMenuItem("(I)  Copy Interval to Clipboard");
            this.copyIntToNameMI_ = new JMenuItem("(I)  Copy Interval to <name>");
            this.copyAllToNameMI_ = new JMenuItem("     Copy All to <name>");
            this.deleteStorageMI_ = new JMenuItem("     Delete <name>");
            this.storageJMenu_.add(this.copyIntToClipboardMI_);
            this.storageJMenu_.add(this.copyIntToNameMI_);
            this.storageJMenu_.add(this.copyAllToNameMI_);
            this.storageJMenu_.add(this.deleteStorageMI_);
            this.menuItemsRequiringInterval_.add(this.copyIntToClipboardMI_);
            this.menuItemsRequiringInterval_.add(this.copyIntToNameMI_);
            this.copyIntToClipboardMI_.addActionListener(new copyIntToClipboardLNR("Storage->Copy Interval to Clipboard"));
            this.copyIntToNameMI_.addActionListener(new copyIntToNameLNR("Storage->Copy Interval to <name>"));
            this.copyAllToNameMI_.addActionListener(new copyAllToNameLNR("Storage->Copy All to <name>"));
            this.deleteStorageMI_.addActionListener(new deleteStorageLNR("Storage->Delete <name>"));
            int n4 = 128;
            int n5 = System.getProperty("os.name").startsWith("Mac") ? 256 : 512;
            jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(50, n4));
            jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(65, n4));
            jMenuItem29.setAccelerator(KeyStroke.getKeyStroke(66, n4));
            this.copyIntToClipboardMI_.setAccelerator(KeyStroke.getKeyStroke(67, n4));
            jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(68, 256));
            jMenuItem35.setAccelerator(KeyStroke.getKeyStroke(68, n4));
            jMenuItem27.setAccelerator(KeyStroke.getKeyStroke(72, n4));
            jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(73, n4));
            jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(76, n4));
            jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(77, n4));
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n4));
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(80, n4));
            this.redoMI_.setAccelerator(KeyStroke.getKeyStroke(81, n4));
            jMenuItem32.setAccelerator(KeyStroke.getKeyStroke(82, n4));
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, n4));
            this.overwriteClipAtCurMI_.setAccelerator(KeyStroke.getKeyStroke(86, n5));
            this.insertClipAtCursorMI_.setAccelerator(KeyStroke.getKeyStroke(86, n4));
            this.undoMI_.setAccelerator(KeyStroke.getKeyStroke(90, n4));
            JMenu jMenu4 = new JMenu("Help", true);
            JMenuItem jMenuItem41 = new JMenuItem("About Color Editor");
            jMenuItem41.addActionListener(new HelpActionLNR("Help->About Color Editor"));
            jMenu4.add(jMenuItem41);
            jMenuBar.add(this.importsJMenu_);
            jMenuBar.add(this.exportsJMenu_);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(this.storageJMenu_);
            jMenuBar.add(jMenu4);
            this.setLayout(new BorderLayout(0, 0));
            JPanel jPanel = new JPanel();
            this.getContentPane().add((Component)jPanel, "North");
            jPanel.setLayout(new GridLayout(2, 4));
            JLabel jLabel = new JLabel("Non-divergence Color");
            jLabel.setHorizontalAlignment(0);
            jLabel.addMouseListener(new DocuMouseListener("Non-divergence Color"));
            jPanel.add(jLabel);
            JButton jButton = new JButton("Resize Color Set");
            jButton.setHorizontalAlignment(0);
            jButton.addActionListener(new ColorCountButtonLNR("Button:Resize Color Set"));
            jPanel.add(jButton);
            JButton jButton2 = new JButton("Rotate Colors");
            jButton2.setHorizontalAlignment(0);
            jButton2.addActionListener(new RotateButtonLNR("Button:Rotate Colors"));
            jPanel.add(jButton2);
            this.cancelButton_ = new JButton("Cancel action");
            this.cancelButton_.setHorizontalAlignment(0);
            this.cancelButton_.addActionListener(new CancelButtonLNR("Button:Cancel action"));
            this.cancelButton_.setEnabled(false);
            jPanel.add(this.cancelButton_);
            JLayeredPane jLayeredPane = new JLayeredPane();
            jLayeredPane.addMouseListener(new nonDivLNR("Non-divergence Color"));
            this.checkPanel_ = new JPanel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    ColorGuideEditor.createCheckerboardImage(graphics, this.getWidth(), this.getHeight());
                }
            };
            this.checkPanel_.setBounds(0, 0, 140, 26);
            this.checkPanel_.setOpaque(true);
            jLayeredPane.add((Component)this.checkPanel_, JLayeredPane.DEFAULT_LAYER);
            this.nonDivColorPanel_ = new JPanel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.color_guide_.length - 1]);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
            this.nonDivColorPanel_.setBounds(0, 0, 140, 26);
            this.nonDivColorPanel_.setOpaque(false);
            jLayeredPane.add((Component)this.nonDivColorPanel_, JLayeredPane.PALETTE_LAYER);
            jPanel.add(jLayeredPane);
            this.colorCountText_ = new TextField(String.valueOf(this.color_guide_.length - 1));
            this.colorCountText_.addKeyListener(new ColorCountKeyLNR());
            this.colorCountText_.addTextListener(new ColorCountTextLNR());
            jPanel.add(this.colorCountText_);
            this.rotateText_ = new TextField(String.valueOf(1));
            this.rotateText_.addKeyListener(new RotateKeyLNR());
            this.rotateText_.addTextListener(new RotateTextLNR());
            jPanel.add(this.rotateText_);
            this.instructions_ = new JLabel("-");
            this.instructions_.setOpaque(true);
            this.instructions_.setHorizontalAlignment(0);
            jPanel.add(this.instructions_);
            this.palettePanel_ = new JPanel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(PALETTE_NEUTRAL);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.setColor(Color.MAGENTA);
                    int n = ColorGuideEditor.this.paletteRows_ * 25;
                    graphics.drawLine(251, 0, 251, n);
                    for (int i = 3; i < n; i += 50) {
                        graphics.drawLine(126, i, 126, Math.min(i + 22, n));
                        graphics.drawLine(376, i, 376, Math.min(i + 22, n));
                    }
                    if (ColorGuideEditor.this.paletteImage_ != null) {
                        graphics.drawImage(ColorGuideEditor.this.paletteImage_, 0, 0, ColorGuideEditor.this.width_, this.getHeight(), this);
                    }
                    ColorGuideEditor.this.paintBox(graphics);
                    ColorGuideEditor.this.updateCursors(graphics);
                    if (!(ColorGuideEditor.this.colorCountText_.hasFocus() || ColorGuideEditor.this.rotateText_.hasFocus() || this.hasFocus())) {
                        this.requestFocusInWindow();
                    }
                }
            };
            this.palettePanel_.setOpaque(false);
            this.palettePanel_.setBounds(0, 0, this.paletteImage_.getWidth(), this.paletteImage_.getHeight());
            this.palettePanel_.setPreferredSize(new Dimension(this.paletteImage_.getWidth(), this.paletteImage_.getHeight()));
            this.palettePanel_.addMouseListener(this);
            this.palettePanel_.addMouseMotionListener(this);
            this.palettePanel_.addKeyListener(new MyKeyListener());
            this.palettePanel_.setFocusable(true);
            this.rowNumbersPanel_ = new JPanel();
            this.rowNumbersPanel_.setBackground(Color.GREEN);
            this.rowNumbersPanel_.setPreferredSize(new Dimension(40, this.paletteImage_.getHeight()));
            this.scrollPane_ = new JScrollPane(this.palettePanel_, 22, 30);
            this.scrollPane_.setRowHeaderView(this.rowNumbersPanel_);
            this.scrollPane_.setVisible(true);
            this.getContentPane().add((Component)this.scrollPane_, "Center");
            this.labelRows((this.paletteImage_.getHeight() - 3) / 25);
            this.updateStorageJMenu();
            this.clusterDialog_ = new ColorGuideEditorDialog(this);
            this.cursorPosition_ = 0;
            this.desiredCursorPosition_ = 0;
            this.cursorVisible_ = true;
            this.cursorColor_ = Color.YELLOW;
            this.intervalStart_ = -1;
            this.desiredIntervalStart_ = -1;
            this.intervalEnd_ = -1;
            this.desiredIntervalEnd_ = -1;
            this.intervalColor_ = Color.CYAN;
            this.palettePanel_.requestFocus(false);
        }
        catch (Throwable throwable) {
            FTCentral.message("ColorGuideEditor.<init> ERROR: \n    " + FTCentral.getExceptionSynopsis(throwable), true);
        }
    }

    public FTCentral getFTCentral() {
        return fTCentral_;
    }

    private void labelRows(int n) {
        this.rowNumbersPanel_.setLayout(new GridLayout(n, 1));
        for (int i = 0; i < n; ++i) {
            JLabel jLabel = new JLabel();
            this.rowNumbersPanel_.add(jLabel);
            if (i >= this.paletteRows_) continue;
            jLabel.setText(String.valueOf(i * 20));
            jLabel.setHorizontalAlignment(0);
        }
    }

    public static void createCheckerboardImage(Graphics graphics, int n, int n2) {
        try {
            Color[] colorArray = new Color[]{Color.BLACK, Color.WHITE};
            for (int i = 0; i < n2; i += 4) {
                for (int j = 0; j < n; j += 4) {
                    int n3 = (i / 4 + j / 4) % 2;
                    graphics.setColor(colorArray[n3]);
                    graphics.fillRect(j, i, 4, 4);
                }
            }
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.createCheckerboardImage Error: ", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createPaletteImage(Color[] colorArray, int n, int n2) {
        Graphics graphics = null;
        try {
            int n3 = colorArray.length - 1;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            graphics = bufferedImage.getGraphics();
            for (int i = 0; i < this.paletteRows_; ++i) {
                int n4;
                int n5 = 3 + i * 25;
                for (int j = 0; j < 20 && (n4 = i * 20 + j) < n3; ++j) {
                    int n6 = 3 + j * 25;
                    if (this.showCheckerboardP_) {
                        graphics.drawImage(this.checkerboardImage_, n6, n5, editor_);
                    } else {
                        graphics.setColor(PALETTE_NEUTRAL);
                        graphics.fillRect(n6, n5, 22, 22);
                    }
                    graphics.setColor(colorArray[n4]);
                    graphics.fillRect(n6, n5, 22, 22);
                }
            }
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.createPaletteImage Error: ", throwable);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return null;
    }

    public void addToPortMenus(FTWindow fTWindow) {
        JMenuItemWithNumber jMenuItemWithNumber = new JMenuItemWithNumber(fTWindow.frameNumber());
        jMenuItemWithNumber.addActionListener(new ImportLNR(fTWindow));
        JMenuItemWithNumber jMenuItemWithNumber2 = new JMenuItemWithNumber(fTWindow.frameNumber());
        jMenuItemWithNumber2.addActionListener(new ExportLNR(fTWindow));
        this.importsJMenu_.add(jMenuItemWithNumber);
        this.exportsJMenu_.add(jMenuItemWithNumber2);
    }

    public void removeFromPortsMenus(int n) {
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        arrayList.add(this.importsJMenu_);
        arrayList.add(this.exportsJMenu_);
        for (JMenu jMenu : arrayList) {
            int n2 = -1;
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (!(jMenuItem instanceof JMenuItemWithNumber) || ((JMenuItemWithNumber)jMenuItem).getNumber() != n) continue;
                n2 = i;
                break;
            }
            if (n2 >= 0) {
                jMenu.remove(n2);
                continue;
            }
            FTCentral.message("Error in ColorGuideEditor.removeFromPortsMenus - no window " + n + " found in " + jMenu.getText(), true);
        }
    }

    public void addTrapFrameToPortMenus(boolean bl) {
        this.trapFrameImportMI_.setEnabled(bl);
        this.trapFrameExportMI_.setEnabled(bl);
    }

    public void exportColorSet(String string, FTWindow fTWindow) {
        Color[] colorArray = null;
        ArrayList<Color> arrayList = this.guideStorage_.get(string);
        colorArray = arrayList == null ? Arrays.copyOf(this.color_guide_, this.color_guide_.length) : arrayList.toArray(new Color[arrayList.size()]);
        fTWindow.canvas().setColorGuide(colorArray);
    }

    private void setColorGuide(Color[] colorArray, boolean bl, boolean bl2) {
        if (bl) {
            this.clearRedo();
        }
        GuideUndoRecord guideUndoRecord = new GuideUndoRecord(this.color_guide_);
        if (bl2) {
            this.pushUndo(guideUndoRecord);
            this.clearRedo();
        } else {
            this.pushRedo(guideUndoRecord);
        }
        int n = this.color_guide_ == null ? 0 : this.color_guide_.length;
        this.color_guide_ = colorArray;
        this.checkMarkerValidity();
        this.redrawForNewGuide(n);
    }

    private void checkMarkerValidity() {
        if (this.intervalStart_ > this.color_guide_.length - 2 || this.intervalEnd_ > this.color_guide_.length - 2) {
            this.desiredIntervalStart_ = -1;
            this.desiredIntervalEnd_ = -1;
        }
        if (this.cursorPosition_ > this.color_guide_.length - 1) {
            this.desiredCursorPosition_ = 0;
        }
    }

    private void pushUndo(UndoRecord undoRecord) {
        this.undoStack_.push(undoRecord);
        this.undoMI_.setEnabled(true);
        this.palettePanel_.requestFocus(false);
    }

    private void pushRedo(UndoRecord undoRecord) {
        this.redoStack_.push(undoRecord);
        this.redoMI_.setEnabled(true);
    }

    private UndoRecord popUndo() {
        UndoRecord undoRecord = this.undoStack_.pop();
        this.undoMI_.setEnabled(!this.undoStack_.isEmpty());
        return undoRecord;
    }

    private UndoRecord popRedo() {
        UndoRecord undoRecord = this.redoStack_.pop();
        this.redoMI_.setEnabled(!this.redoStack_.isEmpty());
        return undoRecord;
    }

    private void clearRedo() {
        this.redoStack_.clear();
        this.redoMI_.setEnabled(false);
    }

    private void instruction(String string) {
        this.instructions_.setText(string);
        if (string.equals("-") || string.equals("")) {
            this.instructions_.setBackground(Color.LIGHT_GRAY);
            this.cancelButton_.setBackground(Color.LIGHT_GRAY);
            this.cancelButton_.setEnabled(false);
        } else {
            this.instructions_.setBackground(LIGHT_GREEN);
            this.cancelButton_.setBackground(Color.PINK);
            this.cancelButton_.setEnabled(true);
        }
    }

    private IntPoint colRow2UpperLeft(int n, int n2) {
        int n3 = 3 + n2 * 25;
        int n4 = 3 + n * 25;
        return new IntPoint(n4, n3);
    }

    private int point2ColorIndex(Point point) {
        return this.point2ColorIndex(new IntPoint((int)point.getX(), (int)point.getY()));
    }

    private int point2ColorIndex(IntPoint intPoint) {
        int n;
        int n2 = intPoint.getX();
        int n3 = intPoint.getY();
        int n4 = n3 / 25;
        int n5 = n4 * 20 + (n = Math.min(n2 / 25, 19));
        if (n5 < 0 || n5 > this.color_guide_.length) {
            return -1;
        }
        return n5;
    }

    private IntPoint colorIndex2UpperLeft(int n) {
        int n2 = n / 20;
        int n3 = n % 20;
        return this.colRow2UpperLeft(n3, n2);
    }

    private void paintColorIndex(int n, Graphics graphics) {
        IntPoint intPoint = this.colorIndex2UpperLeft(n);
        int n2 = intPoint.getX();
        int n3 = intPoint.getY();
        try {
            if (this.showCheckerboardP_) {
                graphics.drawImage(this.checkerboardImage_, n2, n3, editor_);
            } else {
                graphics.setColor(PALETTE_NEUTRAL);
                graphics.fillRect(n2, n3, 22, 22);
            }
            graphics.setColor(this.color_guide_[n]);
            graphics.fillRect(n2, n3, 22, 22);
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.paintIndex Error: ", throwable);
        }
    }

    public void setBoxIndex(int n) {
        this.ptBoxLoopCount_ = n;
        this.repaint();
    }

    private void paintBox(Graphics graphics) {
        if (this.ptBoxLoopCount_ < 0) {
            this.clearBoxMI_.setEnabled(false);
            return;
        }
        this.clearBoxMI_.setEnabled(true);
        int n = this.ptBoxLoopCount_ % (this.color_guide_.length - 1);
        IntPoint intPoint = this.colorIndex2UpperLeft(n);
        int n2 = intPoint.getX() - 1;
        int n3 = intPoint.getY() - 1;
        int n4 = 23;
        try {
            graphics.setColor(this.boxColor_);
            for (int i = 0; i < 3; ++i) {
                graphics.drawRect(n2 - i, n3 - i, n4 + 2 * i, n4 + 2 * i);
            }
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.paintIndex Error: ", throwable);
        }
    }

    private Color[] getColors(int n, int n2, boolean bl) {
        int n3 = this.color_guide_.length - 1;
        Color[] colorArray = new Color[n2 + (bl ? 1 : 0)];
        for (int i = 0; i < n2; ++i) {
            int n4 = (i + n) % n3;
            colorArray[i] = this.color_guide_[n4];
        }
        if (bl) {
            colorArray[n2] = this.color_guide_[this.color_guide_.length - 1];
        }
        return colorArray;
    }

    private Color[] getColors(int n, int n2, int n3, boolean bl) {
        int n4 = this.color_guide_.length - 1;
        int n5 = n3 - n2 + 1;
        if (n5 <= 0) {
            n5 += this.color_guide_.length - 1;
        }
        Color[] colorArray = new Color[n5 + (bl ? 1 : 0)];
        for (int i = 0; i < n5; ++i) {
            int n6 = (i + n) % n4;
            colorArray[i] = this.color_guide_[n6];
        }
        if (bl) {
            colorArray[n5] = this.color_guide_[this.color_guide_.length - 1];
        }
        return colorArray;
    }

    private Color[] getIntervalColors(boolean bl) {
        if (0 <= this.intervalStart_ && this.intervalStart_ < this.color_guide_.length - 1 && 0 <= this.intervalEnd_ && this.intervalEnd_ < this.color_guide_.length - 1) {
            return this.getColors(this.intervalStart_, this.intervalStart_, this.intervalEnd_, bl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeColors(int n, boolean bl, Color ... colorArray) {
        Graphics graphics = null;
        try {
            int n2 = colorArray.length;
            int n3 = this.color_guide_.length - 1;
            if (n == n3) {
                this.changeNonDivColor(bl, colorArray[0]);
                this.nonDivColorPanel_.repaint();
                return;
            }
            if (bl) {
                Color[] colorArray2 = this.getColors(n, n2, false);
                ColorsUndoRecord colorsUndoRecord = new ColorsUndoRecord(n, colorArray2);
                this.pushUndo(colorsUndoRecord);
                this.clearRedo();
            }
            graphics = this.paletteImage_.getGraphics();
            for (int i = 0; i < n2; ++i) {
                int n4 = (i + n) % n3;
                this.color_guide_[n4] = colorArray[i];
                this.paintColorIndex(n4, graphics);
            }
            this.palettePanel_.repaint();
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.changeColors Error:", throwable);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    private void changeNonDivColor(boolean bl, Color color) {
        Color color2 = this.nonDivColorPanel_.getBackground();
        if (!color2.equals(color)) {
            if (bl) {
                NonDivUndoRecord nonDivUndoRecord = new NonDivUndoRecord(color2, this.color_guide_.length - 1);
                this.pushUndo(nonDivUndoRecord);
            }
            this.color_guide_[this.color_guide_.length - 1] = color;
            this.nonDivColorPanel_.repaint();
        }
    }

    private void rotateColors(int n) {
        int n2 = this.color_guide_.length - 1;
        if ((n = (n % n2 + n2) % n2) == 0) {
            return;
        }
        Color[] colorArray = new Color[this.color_guide_.length];
        for (int i = 0; i < n2; ++i) {
            int n3 = (i + n) % n2;
            colorArray[n3] = this.color_guide_[i];
        }
        colorArray[n2] = this.color_guide_[n2];
        this.setColorGuide(colorArray, true, true);
    }

    private boolean createNewColorGuide(int n) {
        int n2 = this.color_guide_.length - 1;
        Color[] colorArray = new Color[n + 1];
        colorArray[n] = this.color_guide_[n2];
        if (n2 == n) {
            ColorGuideEditor.message("Size is unchanged; there's nothing to do.");
            return false;
        }
        if (n2 > n) {
            for (int i = 0; i < n; ++i) {
                colorArray[i] = this.color_guide_[i];
            }
        } else {
            int n3;
            Color color = new Color(0, 0, 0, 0);
            for (n3 = 0; n3 < n2; ++n3) {
                colorArray[n3] = this.color_guide_[n3];
            }
            for (n3 = n2; n3 < n; ++n3) {
                colorArray[n3] = color;
            }
        }
        this.setColorGuide(colorArray, true, true);
        return true;
    }

    private void redrawForNewGuide(int n) {
        int n2 = this.color_guide_.length - 1;
        int n3 = (n - 1) / 20 + (n % 20 == 0 ? 0 : 1);
        int n4 = this.color_guide_.length - 1;
        this.paletteRows_ = n4 / 20 + (n4 % 20 == 0 ? 0 : 1);
        int n5 = Math.max(503, this.viewportInitialWidth_);
        int n6 = Math.max(3 + this.paletteRows_ * 25, this.viewportInitialHeight_);
        this.paletteImage_ = this.createPaletteImage(this.color_guide_, n5, n6);
        if (this.paletteImage_ == null) {
            this.messagePopup("An error occurred in ColorGuideEditor.redrawForNewGuide.  Couldn't create a new BufferedImage.");
            return;
        }
        this.changeNonDivColor(false, this.color_guide_[n2]);
        this.colorCountText_.setText(String.valueOf(n2));
        if (n3 != this.paletteRows_) {
            this.palettePanel_.setPreferredSize(new Dimension(n5, n6));
            this.palettePanel_.setSize(n5, n6);
            this.rowNumbersPanel_ = new JPanel();
            this.rowNumbersPanel_.setBackground(Color.GREEN);
            this.rowNumbersPanel_.setPreferredSize(new Dimension(40, n6));
            this.scrollPane_.setRowHeaderView(this.rowNumbersPanel_);
            this.labelRows(this.paletteImage_.getHeight() / 25);
            editor_.validate();
        }
        editor_.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.point2ColorIndex(mouseEvent.getPoint());
        if (n > this.color_guide_.length - 1 || n < 0) {
            this.mousePressedAnchor_ = null;
        } else {
            this.mousePressedAnchor_ = new IntPoint(mouseEvent);
            this.savedIntervalStart_ = this.intervalStart_;
            this.savedIntervalEnd_ = this.intervalEnd_;
            this.mouseDownColorIndex_ = n;
        }
    }

    private int distance(IntPoint intPoint, IntPoint intPoint2) {
        int n = Math.abs(intPoint.getX() - intPoint2.getX());
        int n2 = Math.abs(intPoint.getY() - intPoint2.getY());
        return (int)Math.round(Math.sqrt(n * n + n2 * n2));
    }

    private void clearMouseVariables() {
        this.savedIntervalStart_ = -1;
        this.savedIntervalEnd_ = -1;
        this.mousePressedAnchor_ = null;
        this.mouseDownColorIndex_ = -1;
        this.iveBeenDraggedP_ = false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getClickCount() != 1) {
            this.clearMouseVariables();
            return;
        }
        int n = this.point2ColorIndex(mouseEvent.getPoint());
        if (0 > n || n > this.color_guide_.length - 1) {
            this.clearMouseVariables();
            return;
        }
        boolean bl2 = n == this.color_guide_.length - 1;
        boolean bl3 = bl = this.mouseDownColorIndex_ == this.color_guide_.length - 1;
        if (mouseEvent.getButton() == 1) {
            boolean bl4;
            if (!this.clickListeners_.isEmpty()) {
                if (bl2 || bl) {
                    this.desiredIntervalStart_ = this.savedIntervalStart_;
                    this.desiredIntervalEnd_ = this.savedIntervalEnd_;
                    return;
                }
                ClickListener clickListener = this.clickListeners_.pop();
                clickListener.processMouseEvent(mouseEvent, n);
                this.clearMouseVariables();
                return;
            }
            IntPoint intPoint = new IntPoint(mouseEvent);
            int n2 = this.distance(this.mousePressedAnchor_, intPoint);
            boolean bl5 = bl4 = 0 <= this.mouseDownColorIndex_ && this.mouseDownColorIndex_ < this.color_guide_.length - 1 && 0 <= n && n < this.color_guide_.length - 1;
            if (this.iveBeenDraggedP_ && n2 > 12) {
                if (bl4) {
                    this.desiredIntervalStart_ = this.mouseDownColorIndex_;
                    this.desiredIntervalEnd_ = n;
                }
                this.clearMouseVariables();
                return;
            }
            if (bl4 || bl2) {
                this.desiredCursorPosition_ = n;
                this.clearMouseVariables();
            }
        } else if (mouseEvent.getButton() == 3 && !bl2) {
            Color color = this.color_guide_[n];
            if (mouseEvent.isShiftDown()) {
                float[] fArray = new float[3];
                int n3 = color.getRed();
                int n4 = color.getGreen();
                int n5 = color.getBlue();
                int n6 = color.getAlpha();
                Color.RGBtoHSB(n3, n4, n5, fArray);
                String string = "Position=" + n + "\nRed=" + n3 + ", Green=" + n4 + ", Blue=" + n5 + ", Transparency=" + (255 - n6) + "\nHue=" + fArray[0] + ", Saturation=" + fArray[1] + ", Brigtness=" + fArray[2];
                JOptionPane.showMessageDialog(this, string);
            } else {
                String string = "Choose new value for color " + n;
                Color color2 = JColorChooser.showDialog(this, string, color);
                if (color2 != null && !color.equals(color2)) {
                    this.changeColors(n, true, color2);
                    this.clearRedo();
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        int n = this.point2ColorIndex(mouseEvent.getPoint());
        IntPoint intPoint = new IntPoint(mouseEvent);
        if (this.mousePressedAnchor_ == null) {
            this.mousePressedAnchor_ = new IntPoint(mouseEvent);
        }
        int n2 = this.distance(this.mousePressedAnchor_, intPoint);
        boolean bl2 = bl = 0 <= this.mouseDownColorIndex_ && this.mouseDownColorIndex_ < this.color_guide_.length - 1 && 0 <= n && n < this.color_guide_.length - 1;
        if (n2 > 12 && bl) {
            if (!this.clickListeners_.isEmpty()) {
                this.clickListeners_.pop();
                this.instruction("-");
            }
            this.iveBeenDraggedP_ = true;
            this.desiredIntervalStart_ = this.mouseDownColorIndex_;
            this.desiredIntervalEnd_ = n;
        } else {
            this.iveBeenDraggedP_ = false;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private HashMap<Integer, PixColorData> collectPixColorData(BufferedImage bufferedImage, int n, float f, float f2, float f3) {
        if (bufferedImage == null) {
            return null;
        }
        HashMap<Integer, PixColorData> hashMap = new HashMap<Integer, PixColorData>();
        int n2 = 0xFF0000;
        int n3 = 65280;
        int n4 = 255;
        int n5 = n / 2;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n6 = bufferedImage.getRGB(i, j);
                int n7 = ((n6 & n2) >> 16) / n;
                int n8 = ((n6 & n3) >> 8) / n;
                int n9 = (n6 & n4) / n;
                int n10 = (Math.min(n7 * n + n5, 255) << 16) + (Math.min(n8 * n + n5, 255) << 8) + Math.min(n9 * n + n5, 255);
                Color color = new Color(n10);
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                if (fArray[1] < f || fArray[2] < f2 || fArray[2] > f3) continue;
                PixColorData pixColorData = hashMap.get(n10);
                if (pixColorData == null) {
                    pixColorData = new PixColorData(n10, color, fArray);
                    hashMap.put(n10, pixColorData);
                    continue;
                }
                pixColorData.incCount();
            }
        }
        return hashMap;
    }

    private Color[] sortAndSizeColorData(HashMap<Integer, PixColorData> hashMap, int[] nArray, int n, int n2) {
        int n3;
        float[] fArray = this.clusterDialog_.getHSBWeights();
        if (hashMap == null) {
            return null;
        }
        int n4 = (int)(this.clusterDialog_.getSigIsFraction() ? this.clusterDialog_.getSignificantNumber() * (double)n2 : this.clusterDialog_.getSignificantNumber());
        ArrayList<PixColorData> arrayList = new ArrayList<PixColorData>(hashMap.values());
        arrayList.sort((pixColorData, pixColorData2) -> pixColorData2.count - pixColorData.count);
        int n5 = Math.min(n, hashMap.size());
        ArrayList<PixColorData> arrayList2 = new ArrayList<PixColorData>(n5);
        for (n3 = 0; n3 < n5 && arrayList.get((int)n3).count > n4; ++n3) {
            arrayList2.add(arrayList.get(n3));
        }
        arrayList = arrayList2;
        if (nArray != null) {
            arrayList.sort((pixColorData, pixColorData2) -> {
                for (int i = 0; i < nArray.length; ++i) {
                    float f = pixColorData.hsb[nArray[i]] - pixColorData2.hsb[nArray[i]];
                    if ((double)f == 0.0) continue;
                    return (double)f < 0.0 ? -1 : 1;
                }
                return 0;
            });
        }
        if ((arrayList2 = this.birdsOfAFeather(arrayList, n3 = 0, fArray)) != null) {
            arrayList = arrayList2;
        }
        Color[] colorArray = new Color[arrayList.size() + 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            colorArray[i] = arrayList.get((int)i).color;
        }
        colorArray[arrayList.size()] = Color.BLACK;
        return colorArray;
    }

    private ArrayList<PixColorData> birdsOfAFeather(ArrayList<PixColorData> arrayList, int n, float[] fArray) {
        int n2;
        ArrayList<PixColorData> arrayList2 = new ArrayList<PixColorData>(arrayList);
        int n3 = arrayList2.size();
        ArrayList<PixColorData> arrayList3 = new ArrayList<PixColorData>();
        float f = 0.0f;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            f += fArray[n2];
        }
        n2 = 0;
        PixColorData pixColorData = arrayList2.get(n2);
        arrayList3.add(pixColorData);
        while (arrayList3.size() < n3) {
            arrayList2.set(n2, null);
            float f2 = f;
            int n4 = -1;
            for (int i = 1; i < n3; ++i) {
                float f3;
                PixColorData pixColorData2 = arrayList2.get(i);
                if (pixColorData2 == null) continue;
                float f4 = Math.abs(pixColorData.hsb[0] - pixColorData2.hsb[0]);
                if (f4 > 0.5f) {
                    f4 = 1.0f - f4;
                }
                if (!((f3 = f4 * fArray[0] + Math.abs((pixColorData.hsb[1] - pixColorData2.hsb[1]) * fArray[1]) + Math.abs((pixColorData.hsb[2] - pixColorData2.hsb[2]) * fArray[2])) < f2)) continue;
                n4 = i;
                f2 = f3;
            }
            if (n4 == -1) {
                ColorGuideEditor.message("ColorGuideEditor.birdsOfAFeather failed to find a neighboring bird for seekerIndex = " + n2);
                return null;
            }
            n2 = n4;
            pixColorData = arrayList2.get(n2);
            arrayList3.add(pixColorData);
        }
        return arrayList3;
    }

    private BufferedImage file2BufferedImage(File file) {
        if (file == null) {
            return null;
        }
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                BufferedImage bufferedImage = imageReader.read(0);
                BufferedImage bufferedImage2 = new BufferedImage(((Image)bufferedImage).getWidth(editor_), ((Image)bufferedImage).getHeight(editor_), 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
                return bufferedImage2;
            }
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.file2BufferedImage Error: ", throwable);
        }
        return null;
    }

    private static IIOMetadata createMetadata(String string) throws IIOInvalidTreeException {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
        IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(2), null);
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("tEXt");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("tEXtEntry");
        iIOMetadataNode2.setAttribute("keyword", "ColorGuide");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("javax_imageio_png_1.0");
        iIOMetadataNode3.appendChild(iIOMetadataNode);
        iIOMetadata.mergeTree("javax_imageio_png_1.0", iIOMetadataNode3);
        return iIOMetadata;
    }

    public void deleteInterval() {
        try {
            int n = this.intervalEnd_ - this.intervalStart_ + 1;
            int n2 = this.color_guide_.length;
            ArrayList<Color> arrayList = new ArrayList<Color>();
            if (n < 0) {
                for (var4_5 = this.intervalEnd_ + 1; var4_5 < this.intervalStart_; ++var4_5) {
                    arrayList.add(this.color_guide_[var4_5]);
                }
                arrayList.add(this.color_guide_[n2 - 1]);
            } else {
                for (var4_5 = 0; var4_5 < this.intervalStart_; ++var4_5) {
                    arrayList.add(this.color_guide_[var4_5]);
                }
                for (var4_5 = this.intervalEnd_ + 1; var4_5 < this.color_guide_.length; ++var4_5) {
                    arrayList.add(this.color_guide_[var4_5]);
                }
            }
            Color[] colorArray = arrayList.toArray(new Color[arrayList.size()]);
            this.setColorGuide(colorArray, true, true);
            this.desiredIntervalStart_ = -1;
            this.desiredIntervalEnd_ = -1;
        }
        catch (Throwable throwable) {
            ColorGuideEditor.message("ColorGuideEditor.DeleteIntervalLNR Error: ", throwable);
        }
    }

    int[] showConverterValue(ColorToIntConverter colorToIntConverter, ArrayList<Color> arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = colorToIntConverter.getValue(arrayList.get(i));
        }
        return nArray;
    }

    Color[] partitionColors(Color[] colorArray, int n, ColorToIntConverter colorToIntConverter, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        Color color = new Color(127, 127, 127, 0);
        for (int i = 0; i < colorArray.length; ++i) {
            int n7 = colorToIntConverter.getValue(colorArray[i]);
            if (n7 < n5) {
                n5 = n7;
            }
            if (n7 <= n6) continue;
            n6 = n7;
        }
        ArrayList arrayList = new ArrayList();
        int[] nArray = new int[n];
        int n8 = n6 - n5;
        for (n4 = 0; n4 < n; ++n4) {
            arrayList.add(new ArrayList());
            nArray[n4] = n5 + (n4 + 1) * n8 / n;
        }
        block2: for (n4 = 0; n4 < colorArray.length; ++n4) {
            n3 = colorToIntConverter.getValue(colorArray[n4]);
            for (n2 = 0; n2 < n; ++n2) {
                if (n3 > nArray[n2]) continue;
                ((ArrayList)arrayList.get(n2)).add(colorArray[n4]);
                continue block2;
            }
        }
        Color[] colorArray2 = new Color[colorArray.length + (bl ? n - 1 : 0)];
        n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n9 = n - 1 - n2;
            for (Color color2 : (ArrayList)arrayList.get(n2)) {
                colorArray2[n3++] = color2;
            }
            if (!bl || n2 >= n - 1) continue;
            colorArray2[n3++] = color;
        }
        return colorArray2;
    }

    private void insertAtCursor(Color[] colorArray) {
        this.insertAt(colorArray, this.cursorPosition_);
    }

    private void insertAt(Color[] colorArray, int n) {
        if (0 <= n && n < this.color_guide_.length) {
            int n2;
            Color[] colorArray2 = new Color[this.color_guide_.length + colorArray.length];
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                colorArray2[n3++] = this.color_guide_[n2];
            }
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray2[n3++] = colorArray[i];
            }
            while (n2 < this.color_guide_.length) {
                colorArray2[n3++] = this.color_guide_[n2];
                ++n2;
            }
            this.setColorGuide(colorArray2, true, true);
        } else {
            FTCentral.message("ColorGuideEditor.insertAt was given an invalid position: " + n, true);
        }
    }

    private void updateStorageJMenu() {
        ArrayList<String> arrayList = new ArrayList<String>(this.guideStorage_.keySet());
        arrayList.sort(Collator.getInstance());
        this.storageJMenu_.removeAll();
        this.storageJMenu_.add(this.copyIntToClipboardMI_);
        this.storageJMenu_.add(this.copyIntToNameMI_);
        this.storageJMenu_.add(this.copyAllToNameMI_);
        this.storageJMenu_.add(this.deleteStorageMI_);
        this.storageJMenu_.addSeparator();
        for (String string : arrayList) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new StorageJMenuItem());
            this.storageJMenu_.add(jMenuItem);
        }
    }

    private void updateCursors(Graphics graphics) {
        if (this.cursorPosition_ != this.desiredCursorPosition_) {
            if (this.cursorVisible_) {
                this.drawCurser(graphics, this.cursorPosition_, PALETTE_NEUTRAL, true);
            }
            this.cursorPosition_ = this.desiredCursorPosition_;
        }
        if (this.intervalStart_ != this.desiredIntervalStart_) {
            if (!this.cursorVisible_) {
                this.drawCurser(graphics, this.intervalStart_, PALETTE_NEUTRAL, true);
            }
            this.intervalStart_ = this.desiredIntervalStart_;
        }
        if (this.intervalEnd_ != this.desiredIntervalEnd_) {
            if (!this.cursorVisible_) {
                this.drawCurser(graphics, this.intervalEnd_, PALETTE_NEUTRAL, false);
            }
            this.intervalEnd_ = this.desiredIntervalEnd_;
        }
        boolean bl = this.intervalStart_ != -1 && this.intervalEnd_ != -1;
        this.enableJMenuItemsRequiringInterval(bl);
        if (this.cursorVisible_) {
            this.drawCurser(graphics, this.cursorPosition_, this.cursorColor_, true);
            if (bl) {
                if (this.intervalStart_ != this.cursorPosition_) {
                    this.drawCurser(graphics, this.intervalStart_, PALETTE_NEUTRAL, true);
                }
                if (this.intervalEnd_ + 1 != this.cursorPosition_) {
                    this.drawCurser(graphics, this.intervalEnd_, PALETTE_NEUTRAL, false);
                }
            }
        } else {
            this.drawCurser(graphics, this.cursorPosition_, PALETTE_NEUTRAL, true);
            if (bl) {
                this.drawCurser(graphics, this.intervalStart_, this.intervalColor_, true);
                this.drawCurser(graphics, this.intervalEnd_, this.intervalColor_, false);
            }
        }
        this.cursorVisible_ = !this.cursorVisible_;
    }

    private void enableJMenuItemsRequiringInterval(boolean bl) {
        for (JMenuItem jMenuItem : this.menuItemsRequiringInterval_) {
            jMenuItem.setEnabled(bl);
        }
        ArrayList<Color> arrayList = this.guideStorage_.get(clipboardName_);
        boolean bl2 = arrayList != null && arrayList.size() > 0;
        this.overwriteClipAtCurMI_.setEnabled(bl2);
        this.insertClipAtCursorMI_.setEnabled(bl2);
    }

    private void drawCurser(Graphics graphics, int n, Color color, boolean bl) {
        graphics.setColor(color);
        IntPoint intPoint = this.colorIndex2UpperLeft(n);
        int n2 = intPoint.getX();
        int n3 = intPoint.getY();
        if (n >= this.color_guide_.length) {
            return;
        }
        if (n == this.color_guide_.length - 1) {
            int n4;
            int n5;
            int n6 = n3 - 3;
            int n7 = n3 - 1 + 25;
            for (n5 = 1; n5 < 4; ++n5) {
                n4 = n2 - 3 + n5 - 1;
                graphics.drawLine(n4, n6, n4, n7);
            }
            n2 = 3;
            n3 = 3;
            for (n5 = 1; n5 < 4; ++n5) {
                n4 = n2;
                n6 = n3 - n5;
                n7 = n3 + 22 + n5 - 1;
                graphics.drawLine(n4, n6, n2 + 10 - 3 * n5, n6);
                graphics.drawLine(n4, n7, n2 + 10 - 3 * n5, n7);
            }
        } else if (bl) {
            for (int i = 1; i < 4; ++i) {
                int n8 = n2 - i;
                int n9 = n3 - i;
                int n10 = n3 + 22 + i - 1;
                graphics.drawLine(n8, n9, n2 + 10 - 3 * i, n9);
                graphics.drawLine(n8, n9, n8, n10);
                graphics.drawLine(n8, n10, n2 + 10 - 3 * i, n10);
            }
        } else {
            n2 += 25;
            for (int i = 1; i < 4; ++i) {
                int n11 = n2 - 3 + i - 1;
                int n12 = n3 - i;
                int n13 = n3 + 22 + i - 1;
                graphics.drawLine(n2 - 12 + 3 * i, n12, n11, n12);
                graphics.drawLine(n11, n12, n11, n13);
                graphics.drawLine(n2 - 12 + 3 * i, n13, n11, n13);
            }
        }
    }

    private static void message(String string, Throwable throwable) {
        FTCentral.message(string + FTCentral.getExceptionSynopsis(throwable), true);
    }

    private static void message(String string) {
        FTCentral.message(string, false);
    }

    private static void message(String string, boolean bl) {
        FTCentral.message(string, bl);
    }

    private void messagePopup(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public static class EditorImageFilter
    extends FileFilter {
        ArrayList<String> acceptableSuffix_ = new ArrayList();

        public EditorImageFilter(String string) {
            String string2;
            String string3 = ",";
            int n = 0;
            int n2 = -1;
            int n3 = string.length();
            while ((n2 = string.indexOf(string3, n)) >= 0) {
                string2 = string.substring(n, n2);
                this.acceptableSuffix_.add(string2.trim());
                n = Math.min(n2 + 1, n3 - 1);
            }
            if (n < string.length()) {
                string2 = string.substring(n, n3);
                this.acceptableSuffix_.add(string2.trim().toLowerCase());
            }
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            for (String string2 : this.acceptableSuffix_) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.contentString();
        }

        public String toString() {
            return "<FileFilter for " + this.contentString() + ">";
        }

        private String contentString() {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : this.acceptableSuffix_) {
                    stringBuilder.append(string + ", ");
                }
                if (stringBuilder.length() > 2) {
                    stringBuilder.setLength(stringBuilder.length() - 2);
                }
                return stringBuilder.toString();
            }
            catch (Throwable throwable) {
                return "Theoretically impossible Error in ColorGuideEditor.EditorImageFilter.contentString";
            }
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            ColorGuideEditor.this.blinkerTimer_.start();
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            ColorGuideEditor.this.blinkerTimer_.stop();
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            switch (windowEvent.getNewState()) {
                case 207: {
                    ColorGuideEditor.this.blinkerTimer_.start();
                    break;
                }
                case 208: {
                    ColorGuideEditor.this.blinkerTimer_.stop();
                    break;
                }
            }
        }
    }

    class BlinkenActionListener
    implements ActionListener {
        BlinkenActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorGuideEditor.this.palettePanel_.repaint();
            int n = (int)(ColorGuideEditor.this.palettePanel_.getLocationOnScreen().getY() - ColorGuideEditor.this.getLocationOnScreen().getY());
            int n2 = n + ColorGuideEditor.this.paletteImage_.getHeight() + 10;
            int n3 = Math.min(n2, ColorGuideEditor.this.getHeight());
            if (ColorGuideEditor.this.getWidth() != ColorGuideEditor.this.windowWidth_ || ColorGuideEditor.this.getHeight() != n3) {
                ColorGuideEditor.this.setSize(ColorGuideEditor.this.windowWidth_, n3);
            }
        }
    }

    class readLNR
    extends DocuActionListener {
        public readLNR(String string) {
            super(editor_, string);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void leftClickAction() {
            try {
                File file = fileChooser_.getReadFile("png, gif, ftr, text, txt", true);
                if (file != null) {
                    String string = file.getPath();
                    String string2 = string.toLowerCase();
                    if (string2.endsWith(".text")) {
                        Color[] colorArray = ColorGuideEditor.readColorGuideFile(file);
                        if (colorArray != null) {
                            ColorGuideEditor.this.setColorGuide(colorArray, true, true);
                            return;
                        } else {
                            ColorGuideEditor.message("Incorrect color guide data read from " + string + ".");
                        }
                        return;
                    } else if (string2.endsWith(".png") || string2.endsWith(".ftr")) {
                        File file2 = new File(string);
                        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);
                        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                        if (iterator.hasNext()) {
                            ImageReader imageReader = iterator.next();
                            imageReader.setInput(imageInputStream);
                            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                            Node node = iIOMetadata.getAsTree("javax_imageio_png_1.0");
                            String string3 = FTIO.findTextNodeValue(node, "ColorGuide");
                            imageReader.dispose();
                            Color[] colorArray = FTCanvas.stringAsColorGuide(string3);
                            if (colorArray == null) throw new Exception("No valid value was recovered for the color guide.");
                            ColorGuideEditor.this.setColorGuide(colorArray, true, true);
                        } else {
                            ColorGuideEditor.message("No reader found.", true);
                        }
                        imageInputStream.flush();
                        imageInputStream.close();
                        return;
                    } else {
                        ColorGuideEditor.message("Only png, ftr, and text (or txt) files are allowed.", true);
                    }
                    return;
                } else {
                    ColorGuideEditor.message("No color guide file chosen.");
                }
                return;
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.readLNR Error: ", throwable);
            }
        }
    }

    class guideFromPixLNR
    extends DocuActionListener {
        public guideFromPixLNR(String string) {
            super(editor_, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void leftClickAction() {
            block6: {
                int n = ColorGuideEditor.this.clusterDialog_.getMaxColors();
                int[] nArray = ColorGuideEditor.this.clusterDialog_.getInitialSort();
                int n2 = ColorGuideEditor.this.clusterDialog_.getGranularity();
                float f = ColorGuideEditor.this.clusterDialog_.getMinSaturation();
                float f2 = ColorGuideEditor.this.clusterDialog_.getMinBrightness();
                float f3 = ColorGuideEditor.this.clusterDialog_.getMaxBrightness();
                try {
                    File file = pixFileChooser_.getReadFile("png, jpg, jpeg, gif", true);
                    if (file != null) {
                        BufferedImage bufferedImage = ColorGuideEditor.this.file2BufferedImage(file);
                        HashMap<Integer, PixColorData> hashMap = ColorGuideEditor.this.collectPixColorData(bufferedImage, n2, f, f2, f3);
                        if (hashMap != null) {
                            Color[] colorArray = ColorGuideEditor.this.sortAndSizeColorData(hashMap, nArray, n, bufferedImage.getWidth() * bufferedImage.getHeight());
                            ColorGuideEditor.this.setColorGuide(colorArray, true, true);
                        }
                        break block6;
                    }
                    ColorGuideEditor.message("No file chosen.");
                }
                catch (Throwable throwable) {
                    ColorGuideEditor.message("getSelectedFile Error: ", throwable);
                }
            }
        }
    }

    class ImportFromTrapLNR
    extends DocuActionListener {
        public ImportFromTrapLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            TrapFrame trapFrame = fTCentral_.getTrapFrame();
            if (trapFrame == null) {
                FTCentral.message("Trap Frame is not available.", true);
                ColorGuideEditor.this.trapFrameImportMI_.setEnabled(false);
                return;
            }
            Color[] colorArray = trapFrame.getColors();
            ColorGuideEditor.this.setColorGuide(colorArray, true, true);
        }
    }

    class writeLNR
    extends DocuActionListener {
        public writeLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                File file = fileChooser_.getSaveFile("png, text, txt", true);
                if (file == null) {
                    ColorGuideEditor.message("Write aborted.");
                    return;
                }
                Object object = file.getPath();
                String string = ((String)object).toLowerCase();
                if (!(string.endsWith(".text") || string.endsWith(".png") || string.endsWith(".txt"))) {
                    object = (String)object + ".png";
                    file = new File((String)object);
                }
                String string2 = FTCanvas.colorGuideAsString(ColorGuideEditor.this.color_guide_);
                if (string.endsWith(".text")) {
                    FileWriter fileWriter = new FileWriter((String)object);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                } else {
                    IIOMetadata iIOMetadata = ColorGuideEditor.createMetadata(string2);
                    ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
                    FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
                    imageWriter.setOutput(fileImageOutputStream);
                    imageWriter.write(iIOMetadata, new IIOImage(ColorGuideEditor.this.paletteImage_, null, iIOMetadata), null);
                    fileImageOutputStream.close();
                    imageWriter.dispose();
                }
                FTCentral.message("Color set saved to " + (String)object, false);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.writeLNR Error: ", throwable);
            }
        }
    }

    class ExportToTrapLNR
    extends DocuActionListener {
        public ExportToTrapLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            TrapFrame trapFrame = fTCentral_.getTrapFrame();
            if (trapFrame == null) {
                FTCentral.message("Trap Frame is not available.", true);
                ColorGuideEditor.this.trapFrameExportMI_.setEnabled(false);
                return;
            }
            trapFrame.setColors(ColorGuideEditor.this.color_guide_);
        }
    }

    class undoLNR
    extends DocuActionListener {
        public undoLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                if (ColorGuideEditor.this.undoStack_.isEmpty()) {
                    ColorGuideEditor.message("ColorGuideEditor: no previous state saved.");
                    return;
                }
                UndoRecord undoRecord = ColorGuideEditor.this.popUndo();
                if (undoRecord.getStyle() == 1) {
                    ColorGuideEditor.this.setColorGuide(((GuideUndoRecord)undoRecord).getColorGuide(), false, false);
                } else if (undoRecord.getStyle() == 0) {
                    boolean bl;
                    boolean bl2 = false;
                    do {
                        bl = ((ColorsUndoRecord)undoRecord).continueP();
                        int n = ((ColorsUndoRecord)undoRecord).getStartIndex();
                        Color[] colorArray = ((ColorsUndoRecord)undoRecord).getColors();
                        Color[] colorArray2 = ColorGuideEditor.this.getColors(n, colorArray.length, false);
                        ColorsUndoRecord colorsUndoRecord = new ColorsUndoRecord(n, bl2, colorArray2);
                        ColorGuideEditor.this.pushRedo(colorsUndoRecord);
                        ColorGuideEditor.this.changeColors(n, false, colorArray);
                        if (!bl) continue;
                        undoRecord = ColorGuideEditor.this.popUndo();
                        bl2 = true;
                    } while (bl);
                } else if (undoRecord.getStyle() == 2) {
                    NonDivUndoRecord nonDivUndoRecord = (NonDivUndoRecord)undoRecord;
                    Color color = nonDivUndoRecord.getColor();
                    int n = nonDivUndoRecord.getIndex();
                    Color color2 = ColorGuideEditor.this.nonDivColorPanel_.getBackground();
                    int n2 = ColorGuideEditor.this.color_guide_.length - 1;
                    if (n != n2) {
                        ColorGuideEditor.message("ColorGuideEditor.undoLNR - ERROR in NonDivUndoRecord: Saved last color index is " + n + " while current last color index is " + n2);
                    } else {
                        NonDivUndoRecord nonDivUndoRecord2 = new NonDivUndoRecord(color2, n2);
                        ColorGuideEditor.this.pushRedo(nonDivUndoRecord2);
                        ColorGuideEditor.this.color_guide_[n2] = color;
                        editor_.repaint();
                    }
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.undoLNR Error: ", throwable);
            }
        }
    }

    class redoLNR
    extends DocuActionListener {
        public redoLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                if (ColorGuideEditor.this.redoStack_.isEmpty()) {
                    ColorGuideEditor.message("ColorGuideEditor: no redo state saved.");
                    return;
                }
                UndoRecord undoRecord = ColorGuideEditor.this.popRedo();
                if (undoRecord.getStyle() == 1) {
                    ColorGuideEditor.this.setColorGuide(((GuideUndoRecord)undoRecord).getColorGuide(), false, true);
                } else if (undoRecord.getStyle() == 0) {
                    boolean bl;
                    boolean bl2 = false;
                    do {
                        bl = ((ColorsUndoRecord)undoRecord).continueP();
                        int n = ((ColorsUndoRecord)undoRecord).getStartIndex();
                        Color[] colorArray = ((ColorsUndoRecord)undoRecord).getColors();
                        Color[] colorArray2 = ColorGuideEditor.this.getColors(n, colorArray.length, false);
                        ColorsUndoRecord colorsUndoRecord = new ColorsUndoRecord(n, bl2, colorArray2);
                        ColorGuideEditor.this.pushUndo(colorsUndoRecord);
                        ColorGuideEditor.this.changeColors(n, false, colorArray);
                        if (!bl) continue;
                        undoRecord = ColorGuideEditor.this.popRedo();
                        bl2 = true;
                    } while (bl);
                } else if (undoRecord.getStyle() == 2) {
                    NonDivUndoRecord nonDivUndoRecord = (NonDivUndoRecord)undoRecord;
                    Color color = nonDivUndoRecord.getColor();
                    int n = nonDivUndoRecord.getIndex();
                    Color color2 = ColorGuideEditor.this.nonDivColorPanel_.getBackground();
                    int n2 = ColorGuideEditor.this.color_guide_.length - 1;
                    if (n != n2) {
                        ColorGuideEditor.message("ColorGuideEditor.undoLNR - ERROR in NonDivUndoRecord: Saved last color index is " + n + " while current last color index is " + n2);
                    } else {
                        NonDivUndoRecord nonDivUndoRecord2 = new NonDivUndoRecord(color2, n2);
                        ColorGuideEditor.this.pushUndo(nonDivUndoRecord2);
                        ColorGuideEditor.this.color_guide_[n2] = color;
                        ColorGuideEditor.this.nonDivColorPanel_.repaint();
                    }
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.redoLNR Error: ", throwable);
            }
        }
    }

    class overwriteClipAtCurLNR
    extends DocuActionListener {
        public overwriteClipAtCurLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ArrayList<Color> arrayList = ColorGuideEditor.this.guideStorage_.get(ColorGuideEditor.clipboardName_);
                if (arrayList == null || arrayList.size() < 2) {
                    FTCentral.message("ColorGuideEditor.insertClipboardLNR: Clipboard is empty.", false);
                    return;
                }
                Color[] colorArray = arrayList.subList(0, arrayList.size() - 1).toArray(new Color[0]);
                if (colorArray != null) {
                    ColorGuideEditor.this.changeColors(ColorGuideEditor.this.cursorPosition_, true, colorArray);
                } else {
                    FTCentral.message("ColorGuideEditor.overwriteClipAtCurLNR - The clipboard is empty.", false);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.overwriteClipAtCurLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class overwriteNameAtCurLNR
    extends DocuActionListener {
        public overwriteNameAtCurLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to insert at cursor.");
                if (string != null) {
                    ArrayList<Color> arrayList = ColorGuideEditor.this.guideStorage_.get(string);
                    if (arrayList == null || arrayList.size() < 2) {
                        FTCentral.message("ColorGuideEditor.insertClipboardLNR: No storage item named " + string + ".", false);
                        return;
                    }
                    Color[] colorArray = arrayList.subList(0, arrayList.size() - 1).toArray(new Color[0]);
                    if (colorArray != null) {
                        ColorGuideEditor.this.changeColors(ColorGuideEditor.this.cursorPosition_, true, colorArray);
                    } else {
                        FTCentral.message("ColorGuideEditor.overwriteNameAtCurLNR - The clipboard is empty.", true);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.overwriteNameAtCurLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class insertClipboardLNR
    extends DocuActionListener {
        public insertClipboardLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ArrayList<Color> arrayList = ColorGuideEditor.this.guideStorage_.get(ColorGuideEditor.clipboardName_);
                if (arrayList == null || arrayList.size() < 2) {
                    FTCentral.message("ColorGuideEditor.insertClipboardLNR: Clipboard was empty.", false);
                    return;
                }
                Color[] colorArray = arrayList.subList(0, arrayList.size() - 1).toArray(new Color[0]);
                if (colorArray != null) {
                    ColorGuideEditor.this.insertAtCursor(colorArray);
                } else {
                    FTCentral.message("ColorGuideEditor.insertClipboardLNR - The clipboard is empty.", true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.insertClipboardLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class insertNameLNR
    extends DocuActionListener {
        public insertNameLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to insert at cursor.");
                if (string != null) {
                    ArrayList<Color> arrayList = ColorGuideEditor.this.guideStorage_.get(string);
                    if (arrayList == null || arrayList.size() < 2) {
                        FTCentral.message("ColorGuideEditor.insertClipboardLNR: No storage item named " + string + ".", false);
                        return;
                    }
                    Color[] colorArray = arrayList.subList(0, arrayList.size() - 1).toArray(new Color[0]);
                    if (colorArray != null) {
                        ColorGuideEditor.this.insertAtCursor(colorArray);
                    } else {
                        FTCentral.message("ColorGuideEditor.insertNameLNR - The clipboard is empty.", true);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.insertNameLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class InsertNewLNR
    extends DocuActionListener {
        public InsertNewLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                IntDialog intDialog = new IntDialog("Insert How Many?", editor_, String.valueOf(ColorGuideEditor.this.prevHowMany_));
                if (!intDialog.cancelled_P()) {
                    ColorGuideEditor.this.prevHowMany_ = intDialog.getValue();
                    if (ColorGuideEditor.this.prevHowMany_ > 0) {
                        Object[] objectArray = new Color[ColorGuideEditor.this.prevHowMany_];
                        Arrays.fill(objectArray, new Color(0, 0, 0, 0));
                        ColorGuideEditor.this.insertAtCursor((Color[])objectArray);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.insertNameLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class moveClickedToCurLNR
    extends DocuActionListener {
        public moveClickedToCurLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new MoveClickedToCursorClickListener());
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.moveClickedToCurLNR Error: ", throwable);
            }
        }
    }

    class DeleteClickedLNR
    extends DocuActionListener {
        public DeleteClickedLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new DeleteClickedListener());
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.DeleteClickedLNR Error: ", throwable);
            }
        }
    }

    class ReverseAllLNR
    extends DocuActionListener {
        public ReverseAllLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                int n = ColorGuideEditor.this.color_guide_.length - 1;
                int n2 = n - 1;
                Color[] colorArray = new Color[ColorGuideEditor.this.color_guide_.length];
                for (int i = 0; i < n; ++i) {
                    colorArray[n2 - i] = ColorGuideEditor.this.color_guide_[i];
                }
                colorArray[ColorGuideEditor.this.color_guide_.length - 1] = ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.color_guide_.length - 1];
                ColorGuideEditor.this.setColorGuide(colorArray, true, true);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ReverseAllLNR Error: ", throwable);
            }
        }
    }

    class TwoClickCopyLNR
    extends DocuActionListener {
        public TwoClickCopyLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new CopyClickListener());
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.TwoClickSwapLNR Error: ", throwable);
            }
        }
    }

    class TwoClickSwapLNR
    extends DocuActionListener {
        public TwoClickSwapLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new SwapClickListener());
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.TwoClickSwapLNR Error: ", throwable);
            }
        }
    }

    class TwoClickRotateLNR
    extends DocuActionListener {
        public TwoClickRotateLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new TwoClickRotateClickListener());
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.TwoClickRotateLNR Error: ", throwable);
            }
        }
    }

    class unsetIntervalLNR
    extends DocuActionListener {
        public unsetIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.desiredIntervalStart_ = -1;
                ColorGuideEditor.this.desiredIntervalEnd_ = -1;
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.unsetIntervalLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class setInterval2cLNR
    extends DocuActionListener {
        public setInterval2cLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.push(new setIntervalClickListener());
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.setInterval2cLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class setIntervalToAllLNR
    extends DocuActionListener {
        public setIntervalToAllLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.desiredIntervalStart_ = 0;
                ColorGuideEditor.this.desiredIntervalEnd_ = ColorGuideEditor.this.color_guide_.length - 2;
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.setIntervalToAllLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class MoveIntToCurLNR
    extends DocuActionListener {
        public MoveIntToCurLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                int n = ColorGuideEditor.this.color_guide_.length;
                ArrayList<Color> arrayList = new ArrayList<Color>();
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                if (ColorGuideEditor.this.intervalEnd_ < ColorGuideEditor.this.cursorPosition_ && ColorGuideEditor.this.cursorPosition_ < ColorGuideEditor.this.intervalStart_) {
                    int n2;
                    for (n2 = ColorGuideEditor.this.intervalEnd_ + 1; n2 < ColorGuideEditor.this.cursorPosition_; ++n2) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n2]);
                    }
                    for (n2 = 0; n2 < colorArray.length; ++n2) {
                        arrayList.add(colorArray[n2]);
                    }
                    for (n2 = ColorGuideEditor.this.cursorPosition_; n2 < ColorGuideEditor.this.intervalStart_; ++n2) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n2]);
                    }
                    arrayList.add(ColorGuideEditor.this.color_guide_[n - 1]);
                } else if (ColorGuideEditor.this.cursorPosition_ < ColorGuideEditor.this.intervalStart_ && ColorGuideEditor.this.intervalStart_ <= ColorGuideEditor.this.intervalEnd_) {
                    int n3;
                    for (n3 = 0; n3 < ColorGuideEditor.this.cursorPosition_; ++n3) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n3]);
                    }
                    for (n3 = 0; n3 < colorArray.length; ++n3) {
                        arrayList.add(colorArray[n3]);
                    }
                    for (n3 = ColorGuideEditor.this.cursorPosition_; n3 < ColorGuideEditor.this.intervalStart_; ++n3) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n3]);
                    }
                    for (n3 = ColorGuideEditor.this.intervalEnd_ + 1; n3 < n; ++n3) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n3]);
                    }
                    ColorGuideEditor.this.desiredCursorPosition_ = ColorGuideEditor.this.cursorPosition_ + colorArray.length;
                } else if (ColorGuideEditor.this.intervalStart_ < ColorGuideEditor.this.cursorPosition_ && ColorGuideEditor.this.cursorPosition_ < ColorGuideEditor.this.intervalEnd_) {
                    int n4;
                    for (n4 = 0; n4 < ColorGuideEditor.this.intervalStart_; ++n4) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n4]);
                    }
                    int n5 = ColorGuideEditor.this.cursorPosition_ - ColorGuideEditor.this.intervalStart_;
                    if (n5 > n - 1 - ColorGuideEditor.this.intervalEnd_) {
                        n5 = n - 1 - ColorGuideEditor.this.intervalEnd_;
                    }
                    for (n4 = ColorGuideEditor.this.intervalEnd_ + 1; n4 < ColorGuideEditor.this.intervalEnd_ + n5 + 1; ++n4) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n4]);
                    }
                    for (n4 = 0; n4 < colorArray.length; ++n4) {
                        arrayList.add(colorArray[n4]);
                    }
                    for (n4 = ColorGuideEditor.this.intervalEnd_ + n5; n4 < n; ++n4) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n4]);
                    }
                } else if (ColorGuideEditor.this.intervalStart_ <= ColorGuideEditor.this.intervalEnd_ && ColorGuideEditor.this.intervalEnd_ < ColorGuideEditor.this.cursorPosition_) {
                    int n6;
                    for (n6 = 0; n6 < ColorGuideEditor.this.intervalStart_; ++n6) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n6]);
                    }
                    for (n6 = ColorGuideEditor.this.intervalEnd_ + 1; n6 < ColorGuideEditor.this.cursorPosition_; ++n6) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n6]);
                    }
                    for (n6 = 0; n6 < colorArray.length; ++n6) {
                        arrayList.add(colorArray[n6]);
                    }
                    for (n6 = ColorGuideEditor.this.cursorPosition_; n6 < n; ++n6) {
                        arrayList.add(ColorGuideEditor.this.color_guide_[n6]);
                    }
                } else {
                    ColorGuideEditor.message("Sorry, I don't know what you want to do.");
                    return;
                }
                Color[] colorArray2 = arrayList.toArray(new Color[arrayList.size()]);
                ColorGuideEditor.this.setColorGuide(colorArray2, true, true);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.MoveIntToCurLNR Error: ", throwable);
            }
        }
    }

    class overwriteAtCurLNR
    extends DocuActionListener {
        public overwriteAtCurLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                if (colorArray != null) {
                    ColorGuideEditor.this.changeColors(ColorGuideEditor.this.cursorPosition_, true, colorArray);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.overwriteAtCurLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class insertIntervalLNR
    extends DocuActionListener {
        public insertIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                if (colorArray != null) {
                    ColorGuideEditor.this.insertAtCursor(colorArray);
                } else {
                    FTCentral.message("ColorGuideEditor.insertIntervalLNR - There is no interval.", true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.insertIntervalLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class AdjHueLNR
    extends DocuActionListener {
        public AdjHueLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                DoubleDialog doubleDialog = new DoubleDialog("Hue Adjustment (0.0 - 1.0)", editor_, String.valueOf(ColorGuideEditor.this.prevHueAdjust_));
                if (!doubleDialog.cancelled_P()) {
                    ColorGuideEditor.this.prevHueAdjust_ = (float)doubleDialog.getValue();
                    boolean bl = doubleDialog.hasSign_P();
                    Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                    if (colorArray != null) {
                        Color[] colorArray2 = new Color[colorArray.length];
                        float[] fArray = new float[3];
                        for (int i = 0; i < colorArray.length; ++i) {
                            Color color = colorArray[i];
                            int n = color.getRed();
                            int n2 = color.getGreen();
                            int n3 = color.getBlue();
                            int n4 = color.getAlpha();
                            Color.RGBtoHSB(n, n2, n3, fArray);
                            float f = bl ? fArray[0] + ColorGuideEditor.this.prevHueAdjust_ : ColorGuideEditor.this.prevHueAdjust_;
                            f -= (float)((int)f);
                            if ((double)f < 0.0) {
                                f += 1.0f;
                            }
                            Color color2 = Color.getHSBColor(f, fArray[1], fArray[2]);
                            colorArray2[i] = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n4);
                        }
                        ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.AdjHueLNR.leftClickAction Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class AdjSaturationLNR
    extends DocuActionListener {
        public AdjSaturationLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                DoubleDialog doubleDialog = new DoubleDialog("Saturation Adj. (0.0 - 1.0)", editor_, String.valueOf(ColorGuideEditor.this.prevSaturationAdjust_), true);
                if (!doubleDialog.cancelled_P()) {
                    ColorGuideEditor.this.prevSaturationAdjust_ = (float)doubleDialog.getValue();
                    boolean bl = doubleDialog.hasSign_P();
                    boolean bl2 = doubleDialog.hasTimes_P();
                    Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                    if (colorArray != null) {
                        Color[] colorArray2 = new Color[colorArray.length];
                        float[] fArray = new float[3];
                        for (int i = 0; i < colorArray.length; ++i) {
                            float f;
                            Color color = colorArray[i];
                            int n = color.getRed();
                            int n2 = color.getGreen();
                            int n3 = color.getBlue();
                            int n4 = color.getAlpha();
                            Color.RGBtoHSB(n, n2, n3, fArray);
                            float f2 = bl2 ? fArray[1] * ColorGuideEditor.this.prevSaturationAdjust_ : (f = bl ? fArray[1] + ColorGuideEditor.this.prevSaturationAdjust_ : ColorGuideEditor.this.prevSaturationAdjust_);
                            if ((double)f < 0.0) {
                                f = 0.0f;
                            } else if ((double)f > 1.0) {
                                f = 1.0f;
                            }
                            Color color2 = Color.getHSBColor(fArray[0], f, fArray[2]);
                            colorArray2[i] = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n4);
                        }
                        ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.AdjSaturationLNR.leftClickAction Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class AdjBrightnessLNR
    extends DocuActionListener {
        public AdjBrightnessLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                DoubleDialog doubleDialog = new DoubleDialog("Brightness Adj. (0.0 - 1.0)", editor_, String.valueOf(ColorGuideEditor.this.prevBrighnessAdjust_), true);
                if (!doubleDialog.cancelled_P()) {
                    ColorGuideEditor.this.prevBrighnessAdjust_ = (float)doubleDialog.getValue();
                    boolean bl = doubleDialog.hasSign_P();
                    boolean bl2 = doubleDialog.hasTimes_P();
                    Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                    if (colorArray != null) {
                        Color[] colorArray2 = new Color[colorArray.length];
                        float[] fArray = new float[3];
                        for (int i = 0; i < colorArray.length; ++i) {
                            float f;
                            Color color = colorArray[i];
                            int n = color.getRed();
                            int n2 = color.getGreen();
                            int n3 = color.getBlue();
                            int n4 = color.getAlpha();
                            Color.RGBtoHSB(n, n2, n3, fArray);
                            float f2 = bl2 ? fArray[2] * ColorGuideEditor.this.prevBrighnessAdjust_ : (f = bl ? fArray[2] + ColorGuideEditor.this.prevBrighnessAdjust_ : ColorGuideEditor.this.prevBrighnessAdjust_);
                            if ((double)f < 0.0) {
                                f = 0.0f;
                            } else if ((double)f > 1.0) {
                                f = 1.0f;
                            }
                            Color color2 = Color.getHSBColor(fArray[0], fArray[1], f);
                            colorArray2[i] = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n4);
                        }
                        ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.AdjBrightnessLNR.leftClickAction Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class AdjTransparencyLNR
    extends DocuActionListener {
        public AdjTransparencyLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                IntDialog intDialog = new IntDialog("Transparency (0 - 255)", editor_, String.valueOf(ColorGuideEditor.this.prevTransparencyAdjust_));
                if (!intDialog.cancelled_P()) {
                    ColorGuideEditor.this.prevTransparencyAdjust_ = intDialog.getValue();
                    boolean bl = intDialog.hasSign_P();
                    Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                    if (colorArray != null) {
                        Color[] colorArray2 = new Color[colorArray.length];
                        float[] fArray = new float[3];
                        for (int i = 0; i < colorArray.length; ++i) {
                            int n;
                            Color color = colorArray[i];
                            int n2 = color.getRed();
                            int n3 = color.getGreen();
                            int n4 = color.getBlue();
                            int n5 = color.getAlpha();
                            int n6 = n = bl ? n5 - ColorGuideEditor.this.prevTransparencyAdjust_ : 255 - ColorGuideEditor.this.prevTransparencyAdjust_;
                            if (n < 0) {
                                n = 0;
                            } else if (n > 255) {
                                n = 255;
                            }
                            colorArray2[i] = new Color(n2, n3, n4, n);
                        }
                        ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.AdjTransparencyLNR.leftClickAction Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class sortIntervalByHueLNR
    extends DocuActionListener {
        public sortIntervalByHueLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                Arrays.sort(colorArray, new HueComparator());
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray);
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.sortIntervalByHueLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class sortIntervalBySatLNR
    extends DocuActionListener {
        public sortIntervalBySatLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                Arrays.sort(colorArray, new SaturationComparator());
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray);
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.sortIntervalBySatLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class sortIntervalByBriLNR
    extends DocuActionListener {
        public sortIntervalByBriLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                Arrays.sort(colorArray, new BrightnessComparator());
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray);
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.sortIntervalByBriLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class rampRgbLNR
    extends DocuActionListener {
        public rampRgbLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color color = ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.intervalStart_];
                Color color2 = ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.intervalEnd_];
                int n = color.getRed();
                int n2 = color.getGreen();
                int n3 = color.getBlue();
                int n4 = color.getAlpha();
                int n5 = color2.getRed() - n;
                int n6 = color2.getGreen() - n2;
                int n7 = color2.getBlue() - n3;
                int n8 = color2.getAlpha() - n4;
                int n9 = ColorGuideEditor.this.intervalEnd_ - ColorGuideEditor.this.intervalStart_;
                if (ColorGuideEditor.this.intervalEnd_ < ColorGuideEditor.this.intervalStart_) {
                    n9 += ColorGuideEditor.this.color_guide_.length - 1;
                }
                Color[] colorArray = new Color[n9 - 1];
                for (int i = 1; i < n9; ++i) {
                    float f = (float)i / (float)n9;
                    int n10 = Math.round((float)n5 * f) + n;
                    int n11 = Math.round((float)n6 * f) + n2;
                    int n12 = Math.round((float)n7 * f) + n3;
                    int n13 = Math.round((float)n8 * f) + n4;
                    colorArray[i - 1] = new Color(n10, n11, n12, n13);
                }
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_ + 1, true, colorArray);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.rampRgbLNR Error: ", throwable);
            }
        }
    }

    class rampHsbLNR
    extends DocuActionListener {
        boolean converseH_p_;

        public rampHsbLNR(boolean bl, String string) {
            super(editor_, string);
            this.converseH_p_ = bl;
        }

        @Override
        public void leftClickAction() {
            try {
                float f;
                Color color = ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.intervalStart_];
                Color color2 = ColorGuideEditor.this.color_guide_[ColorGuideEditor.this.intervalEnd_];
                boolean bl = this.converseH_p_;
                int n = color.getAlpha();
                int n2 = color2.getAlpha();
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
                float f2 = fArray2[0] - fArray[0];
                f2 = fArray2[0] - fArray[0];
                if (Math.abs(f) > 0.5f) {
                    boolean bl2 = bl = !bl;
                }
                if (bl) {
                    f2 = f2 >= 0.0f ? (f2 -= 1.0f) : (f2 += 1.0f);
                }
                float f3 = fArray2[1] - fArray[1];
                float f4 = fArray2[2] - fArray[2];
                int n3 = n2 - n;
                int n4 = ColorGuideEditor.this.intervalEnd_ - ColorGuideEditor.this.intervalStart_;
                if (ColorGuideEditor.this.intervalEnd_ < ColorGuideEditor.this.intervalStart_) {
                    n4 += ColorGuideEditor.this.color_guide_.length - 1;
                }
                Color[] colorArray = new Color[n4 - 1];
                for (int i = 1; i < n4; ++i) {
                    Color color3;
                    float f5 = (float)i / (float)n4;
                    float f6 = f2 * f5 + fArray[0];
                    if (bl) {
                        if (f6 > 1.0f) {
                            f6 -= 1.0f;
                        } else if (f6 < 0.0f) {
                            f6 += 1.0f;
                        }
                    }
                    float f7 = f3 * f5 + fArray[1];
                    float f8 = f4 * f5 + fArray[2];
                    float f9 = ((float)n3 * f5 + (float)n) / 255.0f;
                    int n5 = Color.HSBtoRGB(f6, f7, f8);
                    Color color4 = new Color(n5, true);
                    int n6 = (int)(f9 * 255.0f);
                    colorArray[i - 1] = color3 = new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), n6);
                }
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_ + 1, true, colorArray);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.rampHsbLNR(" + this.converseH_p_ + ") Error: ", throwable);
            }
        }
    }

    class clusterIntervalLNR
    extends DocuActionListener {
        public clusterIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Serializable serializable;
                if (0 > ColorGuideEditor.this.intervalStart_ || ColorGuideEditor.this.intervalStart_ >= ColorGuideEditor.this.color_guide_.length - 1 || 0 > ColorGuideEditor.this.intervalEnd_ || ColorGuideEditor.this.intervalEnd_ >= ColorGuideEditor.this.color_guide_.length - 1) {
                    throw new RuntimeException("No interval chosen.  This error should not be possible, for the menu item to run clusterIntervalLNR should be disabled.");
                }
                int n = ColorGuideEditor.this.intervalStart_ > 0 ? ColorGuideEditor.this.intervalStart_ - 1 : ColorGuideEditor.this.intervalStart_;
                Color[] colorArray = ColorGuideEditor.this.getColors(n, ColorGuideEditor.this.intervalStart_, ColorGuideEditor.this.intervalEnd_, false);
                Serializable serializable2 = new ArrayList<PixColorData>();
                for (int i = 0; i < colorArray.length; ++i) {
                    serializable = colorArray[i];
                    ((ArrayList)serializable2).add((PixColorData)new PixColorData(((Color)serializable).getRGB(), (Color)serializable, Color.RGBtoHSB(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue(), null)));
                }
                float[] fArray = ColorGuideEditor.this.clusterDialog_.getHSBWeights();
                serializable = ColorGuideEditor.this.birdsOfAFeather((ArrayList<PixColorData>)serializable2, 0, fArray);
                if (serializable != null) {
                    serializable2 = serializable;
                }
                Color[] colorArray2 = new Color[((ArrayList)serializable2).size()];
                for (int i = 0; i < ((ArrayList)serializable2).size(); ++i) {
                    colorArray2[i] = ((PixColorData)((ArrayList)serializable2).get((int)i)).color;
                }
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.clusterIntervalLNR Error: ", throwable);
            }
        }
    }

    class PartitionIntLNR
    extends DocuActionListener {
        boolean separatorsP_;

        public PartitionIntLNR(boolean bl, String string) {
            super(editor_, string);
            this.separatorsP_ = bl;
        }

        int fTOi(float f) {
            return Math.round(f * 500.0f);
        }

        int get1HSB(Color color, int n) {
            float[] fArray = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
            return this.fTOi(fArray[n]);
        }

        int get2HSB(Color color, int n, int n2) {
            float[] fArray = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
            return this.fTOi(fArray[n]) + this.fTOi(fArray[n2]);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                int n = ColorGuideEditor.this.clusterDialog_.getPartitionCount();
                Color[] colorArray2 = ColorGuideEditor.this.clusterDialog_.getPartitionCriterion();
                ColorToIntConverter colorToIntConverter = null;
                switch (colorArray2) {
                    case "Hue": {
                        colorToIntConverter = color -> this.get1HSB(color, 0);
                        break;
                    }
                    case "Saturation": {
                        colorToIntConverter = color -> this.get1HSB(color, 1);
                        break;
                    }
                    case "Brightness": {
                        colorToIntConverter = color -> this.get1HSB(color, 2);
                        break;
                    }
                    case "S + B": {
                        colorToIntConverter = color -> this.get2HSB(color, 1, 2);
                        break;
                    }
                    case "H + B": {
                        colorToIntConverter = color -> this.get2HSB(color, 0, 2);
                        break;
                    }
                    case "H + S": {
                        colorToIntConverter = color -> this.get2HSB(color, 0, 1);
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognized partition criterion.");
                    }
                }
                Color[] colorArray3 = ColorGuideEditor.this.partitionColors(colorArray, n, colorToIntConverter, this.separatorsP_);
                if (this.separatorsP_) {
                    if (ColorGuideEditor.this.intervalStart_ == 0 && ColorGuideEditor.this.intervalEnd_ == ColorGuideEditor.this.color_guide_.length - 1) {
                        ColorGuideEditor.this.setColorGuide(colorArray3, true, true);
                    } else {
                        int n2;
                        Color[] colorArray4 = new Color[ColorGuideEditor.this.color_guide_.length + n - 1];
                        int n3 = 0;
                        for (n2 = 0; n2 < ColorGuideEditor.this.intervalStart_; ++n2) {
                            colorArray4[n3++] = ColorGuideEditor.this.color_guide_[n2];
                        }
                        for (n2 = 0; n2 < colorArray3.length; ++n2) {
                            colorArray4[n3++] = colorArray3[n2];
                        }
                        for (n2 = ColorGuideEditor.this.intervalEnd_ + 1; n2 < ColorGuideEditor.this.color_guide_.length; ++n2) {
                            colorArray4[n3++] = ColorGuideEditor.this.color_guide_[n2];
                        }
                        ColorGuideEditor.this.setColorGuide(colorArray4, true, true);
                    }
                    ColorGuideEditor.this.intervalEnd_ += n - 1;
                } else {
                    ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray3);
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.PartitionIntLNR Error: ", throwable);
            }
        }
    }

    class ReverseIntLNR
    extends DocuActionListener {
        public ReverseIntLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                Color[] colorArray2 = new Color[colorArray.length];
                int n = colorArray.length - 1;
                for (int i = 0; i < colorArray.length; ++i) {
                    colorArray2[i] = colorArray[n - i];
                }
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ReverseIntLNR Error: ", throwable);
            }
        }
    }

    class RandomizeIntLNR
    extends DocuActionListener {
        public RandomizeIntLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                ArrayList<Color> arrayList = new ArrayList<Color>(Arrays.asList(colorArray));
                Color[] colorArray2 = new Color[colorArray.length];
                for (int i = 0; i < colorArray.length; ++i) {
                    int n = (int)((double)arrayList.size() * Math.random());
                    colorArray2[i] = arrayList.get(n);
                    arrayList.remove(n);
                }
                ColorGuideEditor.this.changeColors(ColorGuideEditor.this.intervalStart_, true, colorArray2);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.RandomizeIntLNR Error: ", throwable);
            }
        }
    }

    class ExpandIntervalLNR
    extends DocuActionListener {
        public ExpandIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                IntDialog intDialog = new IntDialog("Insert How Many?", editor_, String.valueOf(ColorGuideEditor.this.prevExpandBy_));
                if (!intDialog.cancelled_P()) {
                    Color[] colorArray = ColorGuideEditor.this.getIntervalColors(false);
                    ColorGuideEditor.this.prevExpandBy_ = intDialog.getValue();
                    if (ColorGuideEditor.this.prevExpandBy_ > 0) {
                        int n;
                        int n2 = (ColorGuideEditor.this.prevExpandBy_ - 1) * colorArray.length;
                        Color[] colorArray2 = new Color[ColorGuideEditor.this.color_guide_.length + n2];
                        int n3 = 0;
                        for (n = 0; n < ColorGuideEditor.this.intervalStart_; ++n) {
                            colorArray2[n3++] = ColorGuideEditor.this.color_guide_[n];
                        }
                        for (n = 0; n < colorArray.length; ++n) {
                            Color color = colorArray[n];
                            for (int i = 0; i < ColorGuideEditor.this.prevExpandBy_; ++i) {
                                colorArray2[n3++] = color;
                            }
                        }
                        n = n3 - 1;
                        for (int i = ColorGuideEditor.this.intervalEnd_ + 1; i < ColorGuideEditor.this.color_guide_.length; ++i) {
                            colorArray2[n3++] = ColorGuideEditor.this.color_guide_[i];
                        }
                        ColorGuideEditor.this.setColorGuide(colorArray2, true, true);
                        ColorGuideEditor.this.desiredIntervalEnd_ = n;
                    }
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ExpandIntervalLNR Error: ", throwable);
            }
        }
    }

    class DeleteIntervalLNR
    extends DocuActionListener {
        public DeleteIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            ColorGuideEditor.this.deleteInterval();
        }
    }

    class showClusterDialogLNR
    extends DocuActionListener {
        public showClusterDialogLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            ColorGuideEditor.this.clusterDialog_.setLocationRelativeTo(ColorGuideEditor.this);
            ColorGuideEditor.this.clusterDialog_.setVisible(true);
        }
    }

    class clearBoxLNR
    extends DocuActionListener {
        public clearBoxLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            ColorGuideEditor.this.setBoxIndex(-1);
        }
    }

    class checkerboardLNR
    extends DocuActionListener {
        public checkerboardLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            ColorGuideEditor.this.showCheckerboardP_ = !ColorGuideEditor.this.showCheckerboardP_;
            ColorGuideEditor.this.checkPanel_.setVisible(ColorGuideEditor.this.showCheckerboardP_);
            int n = Math.max(503, ColorGuideEditor.this.viewportInitialWidth_);
            int n2 = Math.max(3 + ColorGuideEditor.this.paletteRows_ * 25, ColorGuideEditor.this.viewportInitialHeight_);
            ColorGuideEditor.this.paletteImage_ = ColorGuideEditor.this.createPaletteImage(ColorGuideEditor.this.color_guide_, n, n2);
        }
    }

    class ColorCursorLNR
    extends DocuActionListener {
        public ColorCursorLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = "Choose color for CURSOR.";
                Color color = JColorChooser.showDialog(editor_, string, ColorGuideEditor.this.cursorColor_);
                if (color != null && !color.equals(ColorGuideEditor.this.cursorColor_)) {
                    ColorGuideEditor.this.cursorColor_ = color;
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ColorCursorLNR Error: ", throwable);
            }
        }
    }

    class ColorIntervalLNR
    extends DocuActionListener {
        public ColorIntervalLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = "Choose color for INTERVAL.";
                Color color = JColorChooser.showDialog(editor_, string, ColorGuideEditor.this.intervalColor_);
                if (color != null && !color.equals(ColorGuideEditor.this.intervalColor_)) {
                    ColorGuideEditor.this.intervalColor_ = color;
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ColorIntervalLNR Error: ", throwable);
            }
        }
    }

    class ColorPtBoxLNR
    extends DocuActionListener {
        public ColorPtBoxLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = "Choose color for POINT BOX.";
                Color color = JColorChooser.showDialog(editor_, string, ColorGuideEditor.this.boxColor_);
                if (color != null && !color.equals(ColorGuideEditor.this.boxColor_)) {
                    ColorGuideEditor.this.boxColor_ = color;
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.ColorPtBoxLNR Error: ", throwable);
            }
        }
    }

    class copyIntToClipboardLNR
    extends DocuActionListener {
        public copyIntToClipboardLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(true);
                if (colorArray != null) {
                    ColorGuideEditor.this.guideStorage_.put(ColorGuideEditor.clipboardName_, new ArrayList<Color>(Arrays.asList(colorArray)));
                    ColorGuideEditor.this.updateStorageJMenu();
                } else {
                    FTCentral.message("ColorGuideEditor.copyIntToClipboardLNR - There is no interval.", true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.copyIntToClipboardLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class copyIntToNameLNR
    extends DocuActionListener {
        public copyIntToNameLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                Color[] colorArray = ColorGuideEditor.this.getIntervalColors(true);
                if (colorArray != null) {
                    String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to STORE the interval.");
                    if (string != null) {
                        ColorGuideEditor.this.guideStorage_.put(string, new ArrayList<Color>(Arrays.asList(colorArray)));
                        ColorGuideEditor.this.updateStorageJMenu();
                    } else {
                        FTCentral.message("No name chosen for copying interval to storage.", false);
                    }
                } else {
                    FTCentral.message("ColorGuideEditor.copyIntToNameLNR - There is no interval.", true);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.copyIntToNameLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class copyAllToNameLNR
    extends DocuActionListener {
        public copyAllToNameLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to STORE this color set.");
                if (string != null) {
                    ColorGuideEditor.this.guideStorage_.put(string, new ArrayList<Color>(Arrays.asList(ColorGuideEditor.this.color_guide_)));
                    ColorGuideEditor.this.updateStorageJMenu();
                } else {
                    FTCentral.message("No name chosen for copying color set to storage.", false);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.copyAllToNameLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class deleteStorageLNR
    extends DocuActionListener {
        public deleteStorageLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to STORE this color set.");
                if (string != null) {
                    ColorGuideEditor.this.guideStorage_.remove(string);
                    ColorGuideEditor.this.updateStorageJMenu();
                } else {
                    FTCentral.message("No name chosen for delete storage item " + string + ".", false);
                }
            }
            catch (Throwable throwable) {
                FTCentral.message("ColorGuideEditor.copyAllToNameLNR Error:\n" + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    public class HelpActionLNR
    implements ActionListener {
        String key_;

        public HelpActionLNR(String string) {
            this.key_ = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = FTCentral.findDocString(this.key_);
            if (object == null) {
                object = "\"" + this.key_ + "\" is not documented.";
            }
            JOptionPane.showMessageDialog(editor_, object);
        }
    }

    class ColorCountButtonLNR
    extends DocuActionListener {
        public ColorCountButtonLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            String string = ColorGuideEditor.this.colorCountText_.getText();
            try {
                int n = Integer.parseInt(string);
                if (ColorGuideEditor.this.createNewColorGuide(n)) {
                    ColorGuideEditor.this.clearRedo();
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("Invaled integer for new size.");
            }
        }
    }

    class RotateButtonLNR
    extends DocuActionListener {
        public RotateButtonLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                String string = ColorGuideEditor.this.rotateText_.getText();
                int n = Integer.parseInt(string);
                ColorGuideEditor.this.rotateColors(n);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("Invaled integer for rotation.");
            }
        }
    }

    class CancelButtonLNR
    extends DocuActionListener {
        public CancelButtonLNR(String string) {
            super(editor_, string);
        }

        @Override
        public void leftClickAction() {
            try {
                ColorGuideEditor.this.clickListeners_.pop();
                ColorGuideEditor.this.instruction("-");
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.CancelButtonLNR Error: ", throwable);
            }
        }
    }

    class nonDivLNR
    extends MouseAdapter {
        String key_;

        public nonDivLNR(String string) {
            this.key_ = string;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isShiftDown()) {
                    Object object = FTCentral.findDocString(this.key_);
                    if (object == null || ((String)object).length() == 0) {
                        object = "\"" + this.key_ + "\" is not documented.";
                    }
                    JOptionPane.showMessageDialog(mouseEvent.getComponent(), object);
                    return;
                }
                if (!ColorGuideEditor.this.clickListeners_.isEmpty()) {
                    ClickListener clickListener = ColorGuideEditor.this.clickListeners_.peek();
                    if (clickListener instanceof CopyClickListener) {
                        ColorGuideEditor.this.clickListeners_.pop();
                        clickListener.processMouseEvent(mouseEvent, ColorGuideEditor.this.color_guide_.length - 1);
                    }
                    return;
                }
                String string = "Choose new non-divergence color.";
                int n = ColorGuideEditor.this.color_guide_.length - 1;
                Color color = ColorGuideEditor.this.color_guide_[n];
                Color color2 = JColorChooser.showDialog(editor_, string, ColorGuideEditor.this.color_guide_[n]);
                if (color2 != null && !color.equals(color2)) {
                    ColorGuideEditor.this.changeColors(n, true, color2);
                    ColorGuideEditor.this.clearRedo();
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.nonDivLNR ERROR: ", throwable);
            }
        }
    }

    class ColorCountKeyLNR
    extends KeyAdapter {
        ColorCountKeyLNR() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            String string = ColorGuideEditor.this.colorCountText_.getText();
            try {
                int n = Integer.parseInt(string);
                if (keyEvent.getKeyChar() == '\n' && ColorGuideEditor.this.createNewColorGuide(n)) {
                    ColorGuideEditor.this.clearRedo();
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("Invaled integer for new size.");
            }
        }
    }

    public class ColorCountTextLNR
    implements TextListener {
        @Override
        public void textValueChanged(TextEvent textEvent) {
            String string = ColorGuideEditor.this.colorCountText_.getText();
            try {
                int n = Integer.parseInt(string);
                ColorGuideEditor.this.colorCountText_.setForeground(Color.BLACK);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.this.colorCountText_.setForeground(Color.RED);
            }
        }
    }

    class RotateKeyLNR
    extends KeyAdapter {
        RotateKeyLNR() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            TextField textField = (TextField)keyEvent.getSource();
            String string = textField.getText();
            try {
                int n = Integer.parseInt(string);
                if (keyEvent.getKeyChar() == '\n') {
                    ColorGuideEditor.this.rotateColors(n);
                }
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("Invaled integer for rotation.");
            }
        }
    }

    public class RotateTextLNR
    implements TextListener {
        @Override
        public void textValueChanged(TextEvent textEvent) {
            String string = ColorGuideEditor.this.rotateText_.getText();
            try {
                int n = Integer.parseInt(string);
                ColorGuideEditor.this.rotateText_.setForeground(Color.BLACK);
            }
            catch (Throwable throwable) {
                ColorGuideEditor.this.rotateText_.setForeground(Color.RED);
            }
        }
    }

    public class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            boolean bl;
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getModifiersEx();
            boolean bl2 = (n & 0x40) != 0;
            boolean bl3 = (n & 0x80) != 0;
            boolean bl4 = (n & 0x200) != 0;
            boolean bl5 = (n & 0x100) != 0;
            boolean bl6 = bl = (n & 0x2000) != 0;
            if (c == 'S' || c == 's') {
                String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to STORE these colors.");
                if (string != null) {
                    ColorGuideEditor.this.guideStorage_.put(string, new ArrayList<Color>(Arrays.asList(ColorGuideEditor.this.color_guide_)));
                    ColorGuideEditor.this.updateStorageJMenu();
                }
            } else if (c == 'D' || c == 'd') {
                if (!bl3) {
                    if (bl5 || bl4) {
                        ColorGuideEditor.this.clickListeners_.push(new DeleteClickedListener());
                    } else {
                        String string = JOptionPane.showInputDialog(editor_, (Object)"Enter storage name to Delete.");
                        if (string != null && string.trim().length() == 0) {
                            string = null;
                        }
                        if (string != null) {
                            if (ColorGuideEditor.this.guideStorage_.get(string) != null) {
                                ColorGuideEditor.this.guideStorage_.remove(string);
                                ColorGuideEditor.this.updateStorageJMenu();
                            } else {
                                ColorGuideEditor.message("No color set with the name " + string + " was found in storage.", true);
                            }
                        }
                    }
                }
            } else if (c == 'C' || c == 'c') {
                ColorGuideEditor.this.clickListeners_.push(new clipCopyClickListener());
            } else if (c == 'V' || c == 'v' || c == 'P' || c == 'p') {
                ColorGuideEditor.this.clickListeners_.push(new clipPasteClickListener());
            }
        }
    }

    public class JMenuItemWithNumber
    extends JMenuItem {
        int myWindowsNumber;

        public JMenuItemWithNumber(int n) {
            super("Drawing Window " + n);
            this.myWindowsNumber = n;
        }

        public int getNumber() {
            return this.myWindowsNumber;
        }
    }

    class ImportLNR
    implements ActionListener {
        FTWindow myDrawingWindow;

        public ImportLNR(FTWindow fTWindow) {
            this.myDrawingWindow = fTWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.myDrawingWindow.toFront();
                Color[] colorArray = this.myDrawingWindow.canvas().getColorGuide();
                Color[] colorArray2 = Arrays.copyOf(colorArray, colorArray.length);
                ColorGuideEditor.this.setColorGuide(colorArray2, true, true);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in ImportLNR.actionPerformed - Drawing Window " + (Serializable)(this.myDrawingWindow == null ? "NULL" : Integer.valueOf(this.myDrawingWindow.frameNumber())) + "\n    " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    class ExportLNR
    implements ActionListener {
        FTWindow myDrawingWindow_;

        public ExportLNR(FTWindow fTWindow) {
            this.myDrawingWindow_ = fTWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.myDrawingWindow_.toFront();
                Color[] colorArray = Arrays.copyOf(ColorGuideEditor.this.color_guide_, ColorGuideEditor.this.color_guide_.length);
                this.myDrawingWindow_.canvas().setColorGuide(colorArray);
            }
            catch (Throwable throwable) {
                FTCentral.message("Error in ExportLNR.actionPerformed - Drawing Window " + (Serializable)(this.myDrawingWindow_ == null ? "NULL" : Integer.valueOf(this.myDrawingWindow_.frameNumber())) + "\n    " + FTCentral.getExceptionSynopsis(throwable), true);
            }
        }
    }

    static class GuideUndoRecord
    extends UndoRecord {
        private Color[] color_guide_ = null;
        private Stack<UndoRecord> undoStack_ = null;
        private Stack<UndoRecord> redoStack_ = null;

        public GuideUndoRecord(Color[] colorArray) {
            this.color_guide_ = colorArray;
        }

        @Override
        public int getStyle() {
            return 1;
        }

        public Color[] getColorGuide() {
            return this.color_guide_;
        }

        public Stack<UndoRecord> getUndoStack() {
            return this.undoStack_;
        }

        public Stack<UndoRecord> getRedoStack() {
            return this.redoStack_;
        }
    }

    static abstract class UndoRecord {
        public static final int INDEXEDcOLORS = 0;
        public static final int ENTIREgUIDE = 1;
        public static final int NONdIVcOLOR = 2;

        UndoRecord() {
        }

        public abstract int getStyle();
    }

    static class IntPoint {
        int x;
        int y;

        public IntPoint(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public IntPoint(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    static class ColorsUndoRecord
    extends UndoRecord {
        int startIndex = -1;
        boolean doNextP_ = false;
        private Color[] colorList_ = null;

        public ColorsUndoRecord(int n, boolean bl, Color ... colorArray) {
            this.startIndex = n;
            this.doNextP_ = bl;
            this.colorList_ = Arrays.copyOf(colorArray, colorArray.length);
        }

        public ColorsUndoRecord(int n, Color ... colorArray) {
            this.startIndex = n;
            this.colorList_ = Arrays.copyOf(colorArray, colorArray.length);
        }

        @Override
        public int getStyle() {
            return 0;
        }

        public boolean continueP() {
            return this.doNextP_;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public Color[] getColors() {
            return this.colorList_;
        }
    }

    static class NonDivUndoRecord
    extends UndoRecord {
        private Color color_;
        private int index_;

        public NonDivUndoRecord(Color color, int n) {
            this.color_ = color;
            this.index_ = n;
        }

        @Override
        public int getStyle() {
            return 2;
        }

        public Color getColor() {
            return this.color_;
        }

        public int getIndex() {
            return this.index_;
        }
    }

    public abstract class ClickListener {
        int timesCalled_ = 0;
        int callsNeeded_;
        String myName_;
        int[] indices_;
        Color[] colors_;
        String[] ordinals_ = new String[]{"1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th"};
        String[] prompts_;
        ArrayList<Integer> clicksOKwithNonDivIndex_ = new ArrayList();

        public ClickListener(String string, int n, String ... stringArray) {
            this.callsNeeded_ = n;
            this.myName_ = string;
            this.indices_ = new int[n];
            this.colors_ = new Color[n];
            this.prompts_ = stringArray;
            String string2 = this.prompts_ != null && this.prompts_.length > this.timesCalled_ ? this.prompts_[this.timesCalled_] : "Click " + this.ordinals_[this.timesCalled_] + " color/index.";
            ColorGuideEditor.this.instruction(string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processMouseEvent(MouseEvent mouseEvent, int n) {
            if (n < 0 || n > ColorGuideEditor.this.color_guide_.length - (this.clicksOKwithNonDivIndex_.contains(this.timesCalled_) ? 1 : 2)) {
                ColorGuideEditor.message(this.myName_ + " got invalid color index: " + n + " - ABORTING.");
                ColorGuideEditor.this.instruction("-");
                return;
            }
            this.indices_[this.timesCalled_] = n;
            this.colors_[this.timesCalled_] = ColorGuideEditor.this.color_guide_[n];
            ++this.timesCalled_;
            if (this.timesCalled_ < this.callsNeeded_) {
                String string = this.prompts_ != null && this.prompts_.length > this.timesCalled_ ? this.prompts_[this.timesCalled_] : "Click " + this.ordinals_[this.timesCalled_] + " color/index.";
                ColorGuideEditor.this.instruction(string);
                ColorGuideEditor.this.clickListeners_.push(this);
            } else {
                boolean bl = true;
                try {
                    bl = this.processClicks();
                    ColorGuideEditor.this.clearRedo();
                    this.clicksOKwithNonDivIndex_.clear();
                }
                catch (Throwable throwable) {
                    ColorGuideEditor.message(this.myName_ + " Error: ", throwable);
                }
                finally {
                    if (bl) {
                        ColorGuideEditor.this.instruction("-");
                    }
                }
            }
        }

        public void addClickNumberOKwithNonDivIndex(Integer n) {
            this.clicksOKwithNonDivIndex_.add(n);
        }

        abstract boolean processClicks();
    }

    static class PixColorData {
        public int count = 1;
        public int rgb;
        public Color color;
        public float[] hsb;

        public PixColorData(int n, Color color, float[] fArray) {
            this.rgb = n;
            this.color = color;
            this.hsb = fArray;
        }

        public void incCount() {
            ++this.count;
        }
    }

    static interface ColorToIntConverter {
        public int getValue(Color var1);
    }

    private class StorageJMenuItem
    implements ActionListener {
        private StorageJMenuItem() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            ArrayList<Color> arrayList = ColorGuideEditor.this.guideStorage_.get(jMenuItem.getText());
            if (arrayList != null) {
                Color[] colorArray = arrayList.toArray(new Color[0]);
                ColorGuideEditor.this.setColorGuide(colorArray, true, true);
            } else {
                ColorGuideEditor.message("The impossible happened: ColorGuideEditor.StorageJMenuItem didn't find its color set.", true);
            }
        }
    }

    public class clipPasteClickListener
    extends ClickListener {
        public clipPasteClickListener() {
            super("Paste from Color Clipboard", 1, "Pick paste location");
            this.addClickNumberOKwithNonDivIndex(0);
        }

        @Override
        boolean processClicks() {
            ColorGuideEditor.this.changeColors(this.indices_[0], true, ColorGuideEditor.this.colorClipboard_);
            return true;
        }
    }

    public class clipCopyClickListener
    extends ClickListener {
        public clipCopyClickListener() {
            super("Copy to Color Clipboard", 1, "Pick color");
        }

        @Override
        boolean processClicks() {
            ColorGuideEditor.this.colorClipboard_ = this.colors_[0];
            return true;
        }
    }

    public class TwoClickRotateClickListener
    extends ClickListener {
        public TwoClickRotateClickListener() {
            super("2 click rotate", 2, "Pick a position", "Pick its destination");
        }

        @Override
        boolean processClicks() {
            int n = this.indices_[1] - this.indices_[0];
            ColorGuideEditor.this.rotateColors(n);
            return true;
        }
    }

    public class SwapClickListener
    extends ClickListener {
        public SwapClickListener() {
            super("Swap colors", 2, "Pick 1st color", "Pick 2nd color");
        }

        @Override
        boolean processClicks() {
            boolean bl = true;
            boolean bl2 = false;
            ColorsUndoRecord colorsUndoRecord = new ColorsUndoRecord(this.indices_[0], bl, this.colors_[0]);
            ColorsUndoRecord colorsUndoRecord2 = new ColorsUndoRecord(this.indices_[1], !bl, this.colors_[1]);
            ColorGuideEditor.this.pushUndo(colorsUndoRecord2);
            ColorGuideEditor.this.pushUndo(colorsUndoRecord);
            ColorGuideEditor.this.changeColors(this.indices_[0], bl2, this.colors_[1]);
            ColorGuideEditor.this.changeColors(this.indices_[1], bl2, this.colors_[0]);
            return true;
        }
    }

    public class CopyClickListener
    extends ClickListener {
        public CopyClickListener() {
            super("Copy color", 2, "Pick color", "Pick target");
            this.addClickNumberOKwithNonDivIndex(1);
        }

        @Override
        boolean processClicks() {
            ColorsUndoRecord colorsUndoRecord = new ColorsUndoRecord(this.indices_[1], this.colors_[1]);
            ColorGuideEditor.this.pushUndo(colorsUndoRecord);
            ColorGuideEditor.this.changeColors(this.indices_[1], false, this.colors_[0]);
            ColorGuideEditor.this.clickListeners_.push(new CopyClickListener());
            return false;
        }
    }

    public class MoveClickedToCursorClickListener
    extends ClickListener {
        public MoveClickedToCursorClickListener() {
            super("Move Clicked to Cursor", 1, "Click color to move.");
        }

        @Override
        boolean processClicks() {
            Color[] colorArray = new Color[ColorGuideEditor.this.color_guide_.length];
            int n = this.indices_[0];
            int n2 = 0;
            if (ColorGuideEditor.this.cursorPosition_ < n) {
                int n3;
                for (n3 = 0; n3 < ColorGuideEditor.this.cursorPosition_; ++n3) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n3];
                }
                colorArray[n2++] = ColorGuideEditor.this.color_guide_[n];
                for (n3 = ColorGuideEditor.this.cursorPosition_; n3 < n; ++n3) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n3];
                }
                for (n3 = n + 1; n3 < ColorGuideEditor.this.color_guide_.length; ++n3) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n3];
                }
                ColorGuideEditor.this.desiredCursorPosition_ = (ColorGuideEditor.this.cursorPosition_ + 1) % (ColorGuideEditor.this.color_guide_.length - 1);
            } else if (n < ColorGuideEditor.this.cursorPosition_) {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n4];
                }
                for (n4 = n + 1; n4 < ColorGuideEditor.this.cursorPosition_; ++n4) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n4];
                }
                colorArray[n2++] = ColorGuideEditor.this.color_guide_[n];
                for (n4 = ColorGuideEditor.this.cursorPosition_; n4 < ColorGuideEditor.this.color_guide_.length; ++n4) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n4];
                }
            }
            ColorGuideEditor.this.setColorGuide(colorArray, true, true);
            ColorGuideEditor.this.clickListeners_.push(new MoveClickedToCursorClickListener());
            return false;
        }
    }

    public class DeleteClickedListener
    extends ClickListener {
        public DeleteClickedListener() {
            super("Delete Clicked", 1, "Click color to delete");
        }

        @Override
        boolean processClicks() {
            try {
                int n;
                Color[] colorArray = new Color[ColorGuideEditor.this.color_guide_.length - 1];
                int n2 = 0;
                for (n = 0; n < this.indices_[0]; ++n) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n];
                }
                for (n = this.indices_[0] + 1; n < ColorGuideEditor.this.color_guide_.length; ++n) {
                    colorArray[n2++] = ColorGuideEditor.this.color_guide_[n];
                }
                if (ColorGuideEditor.this.intervalEnd_ > colorArray.length - 2) {
                    ColorGuideEditor.this.intervalEnd_ = colorArray.length - 2;
                }
                ColorGuideEditor.this.setColorGuide(colorArray, true, true);
                ColorGuideEditor.this.clickListeners_.push(new DeleteClickedListener());
                return false;
            }
            catch (Throwable throwable) {
                ColorGuideEditor.message("ColorGuideEditor.DeleteClickedLNR Error: ", throwable);
                return true;
            }
        }
    }

    public class BrightnessComparator
    implements Comparator<Color> {
        @Override
        public int compare(Color color, Color color2) {
            float[] fArray;
            float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (fArray2[2] - (fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[2] < 0.0f) {
                return -1;
            }
            if (fArray2[2] - fArray[2] > 0.0f) {
                return 1;
            }
            if (fArray2[0] - fArray[0] < 0.0f) {
                return -1;
            }
            if (fArray2[0] - fArray[0] > 0.0f) {
                return 1;
            }
            if (fArray2[1] - fArray[1] < 0.0f) {
                return -1;
            }
            if (fArray2[1] - fArray[1] > 0.0f) {
                return 1;
            }
            return 0;
        }
    }

    public class SaturationComparator
    implements Comparator<Color> {
        @Override
        public int compare(Color color, Color color2) {
            float[] fArray;
            float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (fArray2[1] - (fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[1] < 0.0f) {
                return -1;
            }
            if (fArray2[1] - fArray[1] > 0.0f) {
                return 1;
            }
            if (fArray2[0] - fArray[0] < 0.0f) {
                return -1;
            }
            if (fArray2[0] - fArray[0] > 0.0f) {
                return 1;
            }
            if (fArray2[2] - fArray[2] < 0.0f) {
                return -1;
            }
            if (fArray2[2] - fArray[2] > 0.0f) {
                return 1;
            }
            return 0;
        }
    }

    public class HueComparator
    implements Comparator<Color> {
        @Override
        public int compare(Color color, Color color2) {
            float[] fArray;
            float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (fArray2[0] - (fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[0] < 0.0f) {
                return -1;
            }
            if (fArray2[0] - fArray[0] > 0.0f) {
                return 1;
            }
            if (fArray2[2] - fArray[2] < 0.0f) {
                return 1;
            }
            if (fArray2[2] - fArray[2] > 0.0f) {
                return -1;
            }
            if (fArray2[1] - fArray[1] < 0.0f) {
                return 1;
            }
            if (fArray2[1] - fArray[1] > 0.0f) {
                return -1;
            }
            return 0;
        }
    }

    public class setIntervalClickListener
    extends ClickListener {
        public setIntervalClickListener() {
            super("Set Interval", 2, "Click internal START", "Click internal END");
        }

        @Override
        boolean processClicks() {
            ColorGuideEditor.this.desiredIntervalStart_ = this.indices_[0];
            ColorGuideEditor.this.desiredIntervalEnd_ = this.indices_[1];
            FTCentral.message("ColorGuideEditor.setIntervalClickListener(1770) desIntSTART <= " + ColorGuideEditor.this.desiredIntervalStart_ + ", desIntEND <= " + ColorGuideEditor.this.desiredIntervalEnd_, false);
            return true;
        }
    }
}

